package javax.media.opengl;

import java.io.*;
import javax.media.opengl.*;
import com.jogamp.gluegen.runtime.*;
import java.nio.*;
import javax.media.opengl.GL4;
import javax.media.opengl.GL3bc;
import javax.media.opengl.GL4bc;

/**
 * <p>
 * Composable pipeline which wraps an underlying {@link GL} implementation,
 * providing error checking after each OpenGL method call. If an error occurs,
 * causes a {@link GLException} to be thrown at exactly the point of failure.
 * </p>
 * <p>
 * Sample code which installs this pipeline:
 * <pre>
 *   gl = drawable.setGL(new DebugGL(drawable.getGL()));
 * </pre>
 * For automatic instantiation see {@link GLPipelineFactory#create(String, Class, GL, Object[])}
 * </p>
 */
public class DebugGL4bc implements javax.media.opengl.GL3bc, javax.media.opengl.GL4, javax.media.opengl.GL4bc{
  public static final boolean DEBUG = jogamp.opengl.Debug.debug("DebugGL4bc");
  public DebugGL4bc(GL4bc downstreamGL4bc)
  {
    if (downstreamGL4bc == null) {
      throw new IllegalArgumentException("null downstreamGL4bc");
    }
    this.downstreamGL4bc = downstreamGL4bc;
    // Fetch GLContext object for better error checking (if possible)
    _context = downstreamGL4bc.getContext();
  }

  @Override
  public final boolean isGL() {
    return true;
  }
  @Override
  public final boolean isGL4bc() {
    return downstreamGL4bc.isGL4bc();
  }
  @Override
  public final boolean isGL4() {
    return downstreamGL4bc.isGL4();
  }
  @Override
  public final boolean isGL3bc() {
    return downstreamGL4bc.isGL3bc();
  }
  @Override
  public final boolean isGL3() {
    return downstreamGL4bc.isGL3();
  }
  @Override
  public final boolean isGL2() {
    return downstreamGL4bc.isGL2();
  }
  @Override
  public final boolean isGLES1() {
    return downstreamGL4bc.isGLES1();
  }
  @Override
  public final boolean isGLES2() {
    return downstreamGL4bc.isGLES2();
  }
  @Override
  public final boolean isGLES3() {
    return downstreamGL4bc.isGLES3();
  }
  @Override
  public final boolean isGL2ES1() {
    return downstreamGL4bc.isGL2ES1();
  }
  @Override
  public final boolean isGL2ES2() {
    return downstreamGL4bc.isGL2ES2();
  }
  @Override
  public final boolean isGL2ES3() {
    return downstreamGL4bc.isGL2ES3();
  }
  @Override
  public final boolean isGL3ES3() {
    return downstreamGL4bc.isGL3ES3();
  }
  @Override
  public final boolean isGL4ES3() {
    return downstreamGL4bc.isGL4ES3();
  }
  @Override
  public final boolean isGL2GL3() {
    return downstreamGL4bc.isGL2GL3();
  }
  @Override
  public final boolean isGLES() {
    return downstreamGL4bc.isGLES();
  }
  @Override
  public final boolean isGL4core() {
    return downstreamGL4bc.isGL4core();
  }
  @Override
  public final boolean isGL3core() {
    return downstreamGL4bc.isGL3core();
  }
  @Override
  public final boolean isGLcore() {
    return downstreamGL4bc.isGLcore();
  }
  @Override
  public final boolean isGLES2Compatible() {
    return downstreamGL4bc.isGLES2Compatible();
  }
  @Override
  public final boolean isGLES3Compatible() {
    return downstreamGL4bc.isGLES3Compatible();
  }
  @Override
  public final javax.media.opengl.GL getGL() {
    return this;
  }
  @Override
  public final javax.media.opengl.GL4bc getGL4bc() {
    if( isGL4bc() ) { return this; }
    throw new GLException("Not a GL4bc implementation");
  }
  @Override
  public final javax.media.opengl.GL4 getGL4() {
    if( isGL4() ) { return this; }
    throw new GLException("Not a GL4 implementation");
  }
  @Override
  public final javax.media.opengl.GL3bc getGL3bc() {
    if( isGL3bc() ) { return this; }
    throw new GLException("Not a GL3bc implementation");
  }
  @Override
  public final javax.media.opengl.GL3 getGL3() {
    if( isGL3() ) { return this; }
    throw new GLException("Not a GL3 implementation");
  }
  @Override
  public final javax.media.opengl.GL2 getGL2() {
    if( isGL2() ) { return this; }
    throw new GLException("Not a GL2 implementation");
  }
  @Override
  public final javax.media.opengl.GLES1 getGLES1() {
    throw new GLException("Not a GLES1 implementation");
  }
  @Override
  public final javax.media.opengl.GLES2 getGLES2() {
    throw new GLException("Not a GLES2 implementation");
  }
  @Override
  public final javax.media.opengl.GLES3 getGLES3() {
    throw new GLException("Not a GLES3 implementation");
  }
  @Override
  public final javax.media.opengl.GL2ES1 getGL2ES1() {
    if( isGL2ES1() ) { return this; }
    throw new GLException("Not a GL2ES1 implementation");
  }
  @Override
  public final javax.media.opengl.GL2ES2 getGL2ES2() {
    if( isGL2ES2() ) { return this; }
    throw new GLException("Not a GL2ES2 implementation");
  }
  @Override
  public final javax.media.opengl.GL2ES3 getGL2ES3() {
    if( isGL2ES3() ) { return this; }
    throw new GLException("Not a GL2ES3 implementation");
  }
  @Override
  public final javax.media.opengl.GL3ES3 getGL3ES3() {
    if( isGL3ES3() ) { return this; }
    throw new GLException("Not a GL3ES3 implementation");
  }
  @Override
  public final javax.media.opengl.GL4ES3 getGL4ES3() {
    if( isGL4ES3() ) { return this; }
    throw new GLException("Not a GL4ES3 implementation");
  }
  @Override
  public final javax.media.opengl.GL2GL3 getGL2GL3() {
    if( isGL2GL3() ) { return this; }
    throw new GLException("Not a GL2GL3 implementation");
  }
  @Override
  public final GL getDownstreamGL() throws GLException {
    return downstreamGL4bc;
  }
  @Override
  public final GLProfile getGLProfile() {
    return downstreamGL4bc.getGLProfile();
  }
  @Override
  public void glGenTextures(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenTextures(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenTextures", arg0, arg1);
    }
  }
  @Override
  public void glGetnCompressedTexImage(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnCompressedTexImage(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetnCompressedTexImage", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRectsv(short[] arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRectsv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glRectsv", arg1, arg3);
    }
  }
  @Override
  public void glRectsv(java.nio.ShortBuffer arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glRectsv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s, <java.nio.ShortBuffer> %s)",
                   "glRectsv", arg0, arg1);
    }
  }
  @Override
  public int glGetDebugMessageLogAMD(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLogAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetDebugMessageLogAMD", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
    return _res;
  }
  @Override
  public void glProgramUniformMatrix3x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x4fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix3x4fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVDPAUUnmapSurfacesNV(int arg0,com.jogamp.common.nio.PointerBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVDPAUUnmapSurfacesNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s)",
                   "glVDPAUUnmapSurfacesNV", arg0, arg1);
    }
  }
  @Override
  public void glFramebufferTexture(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTexture(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTexture", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSamplerParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glSamplerParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDeleteProgramsARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteProgramsARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteProgramsARB", arg0, arg2);
    }
  }
  @Override
  public void glPauseTransformFeedback()
  {
    checkContext();
    downstreamGL4bc.glPauseTransformFeedback();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPauseTransformFeedback");
    }
  }
  @Override
  public void glVertexAttribP3uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP3uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.IntBuffer> %s)",
                   "glVertexAttribP3uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSetFenceNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSetFenceNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glSetFenceNV", arg0, arg1);
    }
  }
  @Override
  public void glTexCoordPointer(javax.media.opengl.GLArrayData arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoordPointer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<javax.media.opengl.GLArrayData> %s)",
                   "glTexCoordPointer", arg0);
    }
  }
  @Override
  public boolean glUnmapBuffer(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glUnmapBuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glUnmapBuffer", arg0);
    }
    return _res;
  }
  @Override
  public void glColor3ub(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3ub(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glColor3ub", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEvalCoord2dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord2dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glEvalCoord2dv", arg0);
    }
  }
  @Override
  public void glGetPathCoordsNV(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPathCoordsNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathCoordsNV", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform1uiEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1uiEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform1uiEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform1i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform1i64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glIsNamedStringARB(int arg0,java.lang.String arg1)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsNamedStringARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glIsNamedStringARB", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glGetTexLevelParameteriv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTexLevelParameteriv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTexLevelParameteriv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetPixelTransformParameterfvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPixelTransformParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPixelTransformParameterfvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib2dvARB(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2dvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib2dvARB", arg0, arg2);
    }
  }
  @Override
  public void glTexCoordP2ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP2ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTexCoordP2ui", arg0, arg1);
    }
  }
  @Override
  public void glCopyTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glCopyTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTexImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glMultiTexCoord2fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexCoord2fv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform4uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform4uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDrawBuffersATI(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDrawBuffersATI(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDrawBuffersATI", arg0, arg1);
    }
  }
  @Override
  public void glDrawElementsInstancedBaseVertexBaseInstance(int arg0,int arg1,int arg2,long arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstancedBaseVertexBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawElementsInstancedBaseVertexBaseInstance", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glWeightusvARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightusvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glWeightusvARB", arg0, arg1);
    }
  }
  @Override
  public void glColorSubTable(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glColorSubTable(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glColorSubTable", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glProgramUniform1i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1i64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform1i64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glRenderbufferStorageMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glRenderbufferStorageMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glRenderbufferStorageMultisampleCoverageNV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glFogf(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glFogf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glFogf", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexEnvfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexEnvfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexEnvfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glPixelMapusv(int arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPixelMapusv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glPixelMapusv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glFrustum(double arg0,double arg1,double arg2,double arg3,double arg4,double arg5)
  {
    checkContext();
    downstreamGL4bc.glFrustum(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glFrustum", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glSecondaryColor3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glSecondaryColor3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformMatrix3x2dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x2dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix3x2dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glInterleavedArrays(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glInterleavedArrays(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glInterleavedArrays", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glColor3f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform4dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glProgramUniform4dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glScissor(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glScissor(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glScissor", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVariantuivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantuivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVariantuivEXT", arg0, arg1);
    }
  }
  @Override
  public void glWeightuivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightuivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glWeightuivARB", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetVertexAttribfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexBufferRange(int arg0,int arg1,int arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glTexBufferRange(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glTexBufferRange", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGenRenderbuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenRenderbuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenRenderbuffers", arg0, arg1);
    }
  }
  @Override
  public void glClear(int arg0)
  {
    checkContext();
    downstreamGL4bc.glClear(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glClear", arg0);
    }
  }
  @Override
  public void glObjectPtrLabel(java.nio.Buffer arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glObjectPtrLabel(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glObjectPtrLabel", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexImage2DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
    checkContext();
    downstreamGL4bc.glTexImage2DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTexImage2DMultisampleCoverageNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glProgramUniform4ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform4ui64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDispatchCompute(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDispatchCompute(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDispatchCompute", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord3sv", arg0);
    }
  }
  @Override
  public void glUniform4ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4ivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform4ivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertex2hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertex2hv", arg1);
    }
  }
  @Override
  public void glMultiTexCoord3iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoord3iv", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribs4hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs4hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribs4hv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib3sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib3sv", arg0, arg1);
    }
  }
  @Override
  public void glPathSubCoordsNV(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glPathSubCoordsNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPathSubCoordsNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexEnvivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexEnvivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexEnvivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glClearDepthf(float arg0)
  {
    checkContext();
    downstreamGL4bc.glClearDepthf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glClearDepthf", arg0);
    }
  }
  @Override
  public void glRasterPos3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glRasterPos3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVariantBooleanvEXT(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVariantBooleanvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetVariantBooleanvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib3svARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3svARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib3svARB", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib2dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib2dv", arg0, arg2);
    }
  }
  @Override
  public void glCallList(int arg0)
  {
    checkContext();
    downstreamGL4bc.glCallList(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCallList", arg0);
    }
  }
  @Override
  public void glVertexAttribL4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4d(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glVertexAttribL4d", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniform1i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform1i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTextureParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTextureParameterIivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDrawBuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawBuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDrawBuffers", arg0, arg2);
    }
  }
  @Override
  public void glGenFencesAPPLE(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenFencesAPPLE(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenFencesAPPLE", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix2x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x4fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix2x4fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glNamedBufferDataEXT(int arg0,long arg1,java.nio.Buffer arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedBufferDataEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glNamedBufferDataEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor4iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glColor4iv", arg0);
    }
  }
  @Override
  public void glGetMaterialiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMaterialiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMaterialiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glIndexub(byte arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexub(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s)",
                   "glIndexub", arg0);
    }
  }
  @Override
  public void glGetMapAttribParameterivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMapAttribParameterivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMapAttribParameterivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glStencilMask(int arg0)
  {
    checkContext();
    downstreamGL4bc.glStencilMask(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glStencilMask", arg0);
    }
  }
  @Override
  public void glMapVertexAttrib2fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,float arg6,float arg7,int arg8,int arg9,float[] arg10,int arg11)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib2fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMapVertexAttrib2fAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg11);
    }
  }
  @Override
  public void glVertex4iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex4iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glVertex4iv", arg0);
    }
  }
  @Override
  public void glMultiDrawArraysIndirectAMD(int arg0,java.nio.Buffer arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawArraysIndirectAMD(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X)",
                   "glMultiDrawArraysIndirectAMD", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetOcclusionQueryivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetOcclusionQueryivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetOcclusionQueryivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramEnvParameter4dARB(int arg0,int arg1,double arg2,double arg3,double arg4,double arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameter4dARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glProgramEnvParameter4dARB", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetObjectParameterivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetObjectParameterivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetObjectParameterivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDrawPixels(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawPixels(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glDrawPixels", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexArrayVertexAttribIFormatEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexAttribIFormatEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexArrayVertexAttribIFormatEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniformMatrix2x3dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix2x3dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glColor3h(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glColor3h", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform2dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniform2dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord4hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord4hv", arg0, arg2);
    }
  }
  @Override
  public void glColor3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glColor3s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMaterialfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMaterialfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMaterialfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glConvolutionParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glConvolutionParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glConvolutionParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix3x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x2fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix3x2fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glStencilFunc(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glStencilFunc(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glStencilFunc", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMatrixLoadfEXT(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoadfEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMatrixLoadfEXT", arg0, arg2);
    }
  }
  @Override
  public int glRenderMode(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glRenderMode(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glRenderMode", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttribs1hv(int arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs1hv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribs1hv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix2fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix2fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniform4iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform4iv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPathTexGenivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathTexGenivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPathTexGenivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor4uiv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4uiv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glColor4uiv", arg0);
    }
  }
  @Override
  public void glMultiTexParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterIivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexParameterIivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDeleteBuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteBuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteBuffers", arg0, arg1);
    }
  }
  @Override
  public void glGetMultiTexEnvfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexEnvfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMultiTexEnvfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glLoadMatrixf(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glLoadMatrixf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glLoadMatrixf", arg0);
    }
  }
  @Override
  public void glGetInteger64v(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetInteger64v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetInteger64v", arg0, arg2);
    }
  }
  @Override
  public void glGetPixelMapuiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPixelMapuiv", arg0, arg2);
    }
  }
  @Override
  public void glGetMultiTexEnvivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexEnvivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMultiTexEnvivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform2ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform2ui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDeleteTransformFeedbacksNV(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteTransformFeedbacksNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteTransformFeedbacksNV", arg0, arg2);
    }
  }
  @Override
  public void glProgramLocalParameter4fARB(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameter4fARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glProgramLocalParameter4fARB", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTexGendv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexGendv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glTexGendv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVariantusvEXT(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantusvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVariantusvEXT", arg0, arg2);
    }
  }
  @Override
  public void glGetPixelMapusv(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapusv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glGetPixelMapusv", arg0, arg1);
    }
  }
  @Override
  public void glGetLocalConstantBooleanvEXT(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetLocalConstantBooleanvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetLocalConstantBooleanvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetConvolutionFilter(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetConvolutionFilter(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetConvolutionFilter", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform2fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform2fvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetUniformuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetUniformuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPathSpacingNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,float arg5,float arg6,int arg7,float[] arg8,int arg9)
  {
    checkContext();
    downstreamGL4bc.glGetPathSpacingNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathSpacingNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg9);
    }
  }
  @Override
  public void glProvokingVertex(int arg0)
  {
    checkContext();
    downstreamGL4bc.glProvokingVertex(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glProvokingVertex", arg0);
    }
  }
  @Override
  public boolean hasGLSL()
  {
    return downstreamGL4bc.hasGLSL();
  }
  @Override
  public void glVertexAttrib1sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib1sv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform3ui64NV(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3ui64NV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glProgramUniform3ui64NV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetPathColorGenfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPathColorGenfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathColorGenfvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniformMatrix2fvARB(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2fvARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix2fvARB", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetProgramPipelineInfoLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramPipelineInfoLog(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetProgramPipelineInfoLog", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexParameterIiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexParameterIiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMapVertexAttrib1dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,java.nio.DoubleBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib1dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMapVertexAttrib1dAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glTexCoord1sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord1sv", arg1);
    }
  }
  @Override
  public void glGetPathMetricRangeNV(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetPathMetricRangeNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathMetricRangeNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4bvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4bvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4bvARB", arg0, arg2);
    }
  }
  @Override
  public void glMaterialfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMaterialfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMaterialfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glClientAttribDefaultEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glClientAttribDefaultEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glClientAttribDefaultEXT", arg0);
    }
  }
  @Override
  public void glTexGend(int arg0,int arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glTexGend(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s)",
                   "glTexGend", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetSamplerParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetSamplerParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertex4fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex4fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glVertex4fv", arg0);
    }
  }
  @Override
  public void glGetTextureParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetTextureParameterfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetPerfMonitorCounterStringAMD(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCounterStringAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetPerfMonitorCounterStringAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glRotated(double arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glRotated(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s)",
                   "glRotated", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRotatef(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glRotatef(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glRotatef", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetObjectParameterfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetObjectParameterfvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetObjectParameterfvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPixelMapfv(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelMapfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glPixelMapfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformMatrix3x4dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix3x4dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDrawElements(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glDrawElements(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glDrawElements", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glNamedProgramLocalParametersI4ivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParametersI4ivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glNamedProgramLocalParametersI4ivEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glViewport(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glViewport(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glViewport", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramLocalParametersI4uivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParametersI4uivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramLocalParametersI4uivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribI2ivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2ivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI2ivEXT", arg0, arg2);
    }
  }
  @Override
  public int getMaxRenderbufferSamples()
  {
    return downstreamGL4bc.getMaxRenderbufferSamples();
  }
  @Override
  public void glBlendEquationSeparatei(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBlendEquationSeparatei(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendEquationSeparatei", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMakeBufferNonResidentNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glMakeBufferNonResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glMakeBufferNonResidentNV", arg0);
    }
  }
  @Override
  public void glGetNamedRenderbufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedRenderbufferParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedRenderbufferParameterivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glNewList(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNewList(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glNewList", arg0, arg1);
    }
  }
  @Override
  public void glIndexi(int arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexi(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIndexi", arg0);
    }
  }
  @Override
  public void glVertexAttrib4Nuiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4Nuiv", arg0, arg2);
    }
  }
  @Override
  public void glGetProgramResourceiv(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,int arg5,java.nio.IntBuffer arg6,java.nio.IntBuffer arg7)
  {
    checkContext();
    downstreamGL4bc.glGetProgramResourceiv(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glGetProgramResourceiv", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glDrawElementsIndirect(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsIndirect(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glDrawElementsIndirect", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetUniformfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetUniformfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetDoublev(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetDoublev(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetDoublev", arg0, arg1);
    }
  }
  @Override
  public void glUniform4fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform4fv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeletePerfMonitorsAMD(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeletePerfMonitorsAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeletePerfMonitorsAMD", arg0, arg2);
    }
  }
  @Override
  public void glProgramEnvParameters4fvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameters4fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramEnvParameters4fvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glNamedStringARB(int arg0,int arg1,java.lang.String arg2,int arg3,java.lang.String arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedStringARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.lang.String> %s, <int> 0x%X, <java.lang.String> %s)",
                   "glNamedStringARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glWeightPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glWeightPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glWeightPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform3i64NV(int arg0,long arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3i64NV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glUniform3i64NV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPathStencilFuncNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glPathStencilFuncNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glPathStencilFuncNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMultiTexLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMultiTexLevelParameterfvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVertexAttribI4uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4uivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI4uivEXT", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexGenfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGenfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexGenfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib4svARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4svARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4svARB", arg0, arg2);
    }
  }
  @Override
  public void glUniformMatrix3fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix3fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVideoCaptureStreamParameterfvNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVideoCaptureStreamParameterfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVideoCaptureStreamParameterfvNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLighti(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glLighti(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glLighti", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glVertex3iv", arg1);
    }
  }
  @Override
  public void glGetMultisamplefv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMultisamplefv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMultisamplefv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetActiveSubroutineUniformName(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,java.nio.ByteBuffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetActiveSubroutineUniformName(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveSubroutineUniformName", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColorTableParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glColorTableParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glColorTableParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformMatrix4fvARB(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4fvARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix4fvARB", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glFlushMappedNamedBufferRangeEXT(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glFlushMappedNamedBufferRangeEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glFlushMappedNamedBufferRangeEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDepthRangef(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glDepthRangef(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glDepthRangef", arg0, arg1);
    }
  }
  @Override
  public void glVertexP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexP3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexP3uiv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform1ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1ui64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform1ui64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glEdgeFlag(boolean arg0)
  {
    checkContext();
    downstreamGL4bc.glEdgeFlag(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<boolean> %s)",
                   "glEdgeFlag", arg0);
    }
  }
  @Override
  public void glRasterPos4iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glRasterPos4iv", arg1);
    }
  }
  @Override
  public void glTexParameteri(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexParameteri(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexParameteri", arg0, arg1, arg2);
    }
  }
  @Override
  public java.nio.ByteBuffer glMapBufferRange(int arg0,long arg1,long arg2,int arg3)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapBufferRange(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <int> 0x%X)",
                   "glMapBufferRange", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public int glGetError()
  {
    checkContext();
    int _res = downstreamGL4bc.glGetError();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glGetError");
    }
    return _res;
  }
  @Override
  public void glGetnMapfv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnMapfv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetnMapfv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glUniform4iARB(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4iARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform4iARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glClearBufferuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glClearBufferuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glClearBufferuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribL3i64NV(int arg0,long arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3i64NV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glVertexAttribL3i64NV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDeleteRenderbuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteRenderbuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteRenderbuffers", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib3hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib3hv", arg0, arg1);
    }
  }
  @Override
  public void glVariantsvEXT(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantsvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVariantsvEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetPathTexGenfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathTexGenfvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathTexGenfvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glRasterPos2fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glRasterPos2fv", arg1);
    }
  }
  @Override
  public void glTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glTexCoord3hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord3hv", arg0);
    }
  }
  @Override
  public void glTexCoord2dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glTexCoord2dv", arg0);
    }
  }
  @Override
  public void glVertex4sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex4sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertex4sv", arg0);
    }
  }
  @Override
  public void glGetUniformfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformfvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetUniformfvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribL2dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttribL2dv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix3x4dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x4dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix3x4dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glTexStorage2D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glTexStorage2D(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexStorage2D", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetProgramEnvParameterIivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterIivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramEnvParameterIivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glClearBufferfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glClearBufferfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glClearBufferfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetnPixelMapfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnPixelMapfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetnPixelMapfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribI4usvEXT(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4usvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribI4usvEXT", arg0, arg2);
    }
  }
  @Override
  public void glDeleteObjectARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDeleteObjectARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDeleteObjectARB", arg0);
    }
  }
  @Override
  public void glTexEnviv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexEnviv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexEnviv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform3d(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glUniform3d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform3i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform3i64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glColorMaterial(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColorMaterial(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glColorMaterial", arg0, arg1);
    }
  }
  @Override
  public void glBlendFuncSeparateINGR(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glBlendFuncSeparateINGR(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendFuncSeparateINGR", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform3iv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform3iv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMatrixPopEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glMatrixPopEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glMatrixPopEXT", arg0);
    }
  }
  @Override
  public void glProgramUniformMatrix3x4fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x4fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix3x4fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVertexAttribI1iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI1iv", arg0, arg2);
    }
  }
  @Override
  public void glNormal3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glNormal3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glNormal3dv", arg0);
    }
  }
  @Override
  public void glGetSeparableFilter(int arg0,int arg1,int arg2,long arg3,long arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glGetSeparableFilter(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glGetSeparableFilter", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTexEnvfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexEnvfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glTexEnvfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEnableVariantClientStateEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEnableVariantClientStateEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEnableVariantClientStateEXT", arg0);
    }
  }
  @Override
  public void glGetProgramStageiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetProgramStageiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramStageiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib1fvARB(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib1fvARB", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribI4usv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4usv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribI4usv", arg0, arg2);
    }
  }
  @Override
  public void glDisableVertexAttribArrayARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDisableVertexAttribArrayARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDisableVertexAttribArrayARB", arg0);
    }
  }
  @Override
  public void glDisableVertexArrayEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDisableVertexArrayEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDisableVertexArrayEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetTexEnvfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexEnvfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetTexEnvfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glConvolutionParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glConvolutionParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glConvolutionParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI1ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI1ui", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform1fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramUniform1fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMapControlPointsNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glMapControlPointsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.Buffer> %s)",
                   "glMapControlPointsNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glShaderStorageBlockBinding(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glShaderStorageBlockBinding(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glShaderStorageBlockBinding", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColorFormatNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glColorFormatNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glColorFormatNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glStencilFillPathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,float[] arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glStencilFillPathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glStencilFillPathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg8);
    }
  }
  @Override
  public int glQueryMatrixxOES(java.nio.IntBuffer arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glQueryMatrixxOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glQueryMatrixxOES", arg0, arg1);
    }
    return _res;
  }
  @Override
  public int glQueryMatrixxOES(int[] arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    int _res = downstreamGL4bc.glQueryMatrixxOES(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glQueryMatrixxOES", arg1, arg3);
    }
    return _res;
  }
  @Override
  public void glProgramUniformMatrix3fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix3fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glTextureBarrierNV()
  {
    checkContext();
    downstreamGL4bc.glTextureBarrierNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glTextureBarrierNV");
    }
  }
  @Override
  public void glVertexAttrib4iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4iv", arg0, arg2);
    }
  }
  @Override
  public void glUniform1d(int arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s)",
                   "glUniform1d", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI2iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI2iv", arg0, arg1);
    }
  }
  @Override
  public void glTextureStorage2DMultisampleEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
    checkContext();
    downstreamGL4bc.glTextureStorage2DMultisampleEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTextureStorage2DMultisampleEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetMultiTexParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMultiTexParameterfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glPathDashArrayNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPathDashArrayNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPathDashArrayNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexParameterIuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexParameterIuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glObjectLabel(int arg0,int arg1,int arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glObjectLabel(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glObjectLabel", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMakeTextureHandleNonResidentNV(long arg0)
  {
    checkContext();
    downstreamGL4bc.glMakeTextureHandleNonResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glMakeTextureHandleNonResidentNV", arg0);
    }
  }
  @Override
  public void glVertexAttribPointerARB(int arg0,int arg1,int arg2,boolean arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribPointerARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexAttribPointerARB", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glMapParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMapParameterfvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMapParameterfvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexArrayVertexAttribBindingEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexAttribBindingEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexArrayVertexAttribBindingEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos2dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glWindowPos2dv", arg0);
    }
  }
  @Override
  public void glTexCoord4bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glTexCoord4bvOES", arg1);
    }
  }
  @Override
  public void glDeletePathsNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDeletePathsNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDeletePathsNV", arg0, arg1);
    }
  }
  @Override
  public void glMatrixMultTransposefEXT(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultTransposefEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMatrixMultTransposefEXT", arg0, arg2);
    }
  }
  @Override
  public void glFlush()
  {
    checkContext();
    downstreamGL4bc.glFlush();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glFlush");
    }
  }
  @Override
  public void glVertexAttrib4NubvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NubvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4NubvARB", arg0, arg2);
    }
  }
  @Override
  public void glCopyTextureSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glCopyTextureSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTextureSubImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetMinmaxParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMinmaxParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMinmaxParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glColor3dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glColor3dv", arg1);
    }
  }
  @Override
  public void glTexCoord1bvOES(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1bvOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glTexCoord1bvOES", arg0);
    }
  }
  @Override
  public void glVertexAttribI3uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3uivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI3uivEXT", arg0, arg1);
    }
  }
  @Override
  public void glUniformMatrix4fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix4fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glNamedFramebufferTexture3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferTexture3DEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferTexture3DEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGenSamplers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenSamplers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenSamplers", arg0, arg1);
    }
  }
  @Override
  public void glGetBooleanIndexedv(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetBooleanIndexedv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetBooleanIndexedv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNamedProgramLocalParameter4dvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameter4dvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glNamedProgramLocalParameter4dvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetNamedStringivARB(int arg0,java.lang.String arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedStringivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedStringivARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniform2ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform2ui64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glNamedProgramLocalParameterI4uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameterI4uivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glNamedProgramLocalParameterI4uivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoordP2uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP2uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoordP2uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetDoubleIndexedvEXT(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetDoubleIndexedvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetDoubleIndexedvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribL4ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4ui64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL4ui64vNV", arg0, arg1);
    }
  }
  @Override
  public void glGetnPolygonStipple(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetnPolygonStipple(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetnPolygonStipple", arg0, arg1);
    }
  }
  @Override
  public void glGetShaderSourceARB(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetShaderSourceARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetShaderSourceARB", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGetDoublei_vEXT(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetDoublei_vEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetDoublei_vEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultiTexCoord1fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexCoord1fv", arg0, arg2);
    }
  }
  @Override
  public void glColorTableParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glColorTableParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glColorTableParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform1fv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform1fv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glNamedProgramLocalParameterI4iEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameterI4iEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedProgramLocalParameterI4iEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertexAttribI3ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3ivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI3ivEXT", arg0, arg1);
    }
  }
  @Override
  public void glMultiDrawArrays(int arg0,int[] arg1,int arg2,int[] arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawArrays(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <int> 0x%X)",
                   "glMultiDrawArrays", arg0, arg2, arg4, arg5);
    }
  }
  @Override
  public void glMultiDrawArrays(int arg0,java.nio.IntBuffer arg1,java.nio.IntBuffer arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawArrays(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <int> 0x%X)",
                   "glMultiDrawArrays", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public int glCheckFramebufferStatus(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glCheckFramebufferStatus(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCheckFramebufferStatus", arg0);
    }
    return _res;
  }
  @Override
  public void glGetIntegerui64i_vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerui64i_vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetIntegerui64i_vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDebugMessageControl(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,boolean arg6)
  {
    checkContext();
    downstreamGL4bc.glDebugMessageControl(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <boolean> %s)",
                   "glDebugMessageControl", arg0, arg1, arg2, arg3, arg5, arg6);
    }
  }
  @Override
  public void glStencilStrokePathNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glStencilStrokePathNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glStencilStrokePathNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix2x4dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x4dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix2x4dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glClearNamedBufferSubDataEXT(int arg0,int arg1,int arg2,int arg3,long arg4,long arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glClearNamedBufferSubDataEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <java.nio.Buffer> %s)",
                   "glClearNamedBufferSubDataEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetHistogram(int arg0,boolean arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetHistogram(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetHistogram", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexCoord4sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord4sv", arg0, arg2);
    }
  }
  @Override
  public void glVDPAUFiniNV()
  {
    checkContext();
    downstreamGL4bc.glVDPAUFiniNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glVDPAUFiniNV");
    }
  }
  @Override
  public void glGetVertexAttribdvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribdvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetVertexAttribdvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPathTexGenNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glPathTexGenNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPathTexGenNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSecondaryColor3hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glSecondaryColor3hv", arg0);
    }
  }
  @Override
  public void glMultiTexCoordP3uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP3uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoordP3uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glNormal3d(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glNormal3d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glNormal3d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glStencilFillPathNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glStencilFillPathNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glStencilFillPathNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetInternalformati64v(int arg0,int arg1,int arg2,int arg3,long[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetInternalformati64v(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetInternalformati64v", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glMatrixMultfEXT(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultfEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMatrixMultfEXT", arg0, arg2);
    }
  }
  @Override
  public void glGetPixelMapfv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPixelMapfv", arg0, arg2);
    }
  }
  @Override
  public void glMatrixMultdEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultdEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMatrixMultdEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetProgramLocalParameterIuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterIuivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramLocalParameterIuivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSamplerParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterIuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glSamplerParameterIuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCullParameterfvEXT(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glCullParameterfvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glCullParameterfvEXT", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexCoord1sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord1sv", arg0, arg1);
    }
  }
  @Override
  public void glTexImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glTexImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glTexBuffer(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexBuffer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexBuffer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos2sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glWindowPos2sv", arg1);
    }
  }
  @Override
  public void glColor3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glColor3fv", arg1);
    }
  }
  @Override
  public int glObjectUnpurgeableAPPLE(int arg0,int arg1,int arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glObjectUnpurgeableAPPLE(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glObjectUnpurgeableAPPLE", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glDebugMessageEnableAMD(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,boolean arg4)
  {
    checkContext();
    downstreamGL4bc.glDebugMessageEnableAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <boolean> %s)",
                   "glDebugMessageEnableAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetAttachedObjectsARB(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetAttachedObjectsARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetAttachedObjectsARB", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGetAttachedObjectsARB(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetAttachedObjectsARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glGetAttachedObjectsARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glIndexdv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexdv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glIndexdv", arg1);
    }
  }
  @Override
  public void glGetProgramInterfaceiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetProgramInterfaceiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramInterfaceiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMultiTexCoordP4uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoordP4uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPixelMapuiv(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapuiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glGetPixelMapuiv", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexAttribIuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMultiTexParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMultiTexParameterivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glFogCoordfv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glFogCoordfv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glFogCoordfv", arg0);
    }
  }
  @Override
  public java.lang.String glGetString(int arg0)
  {
    checkContext();
    java.lang.String _res = downstreamGL4bc.glGetString(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGetString", arg0);
    }
    return _res;
  }
  @Override
  public void glMultiTexCoord2iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoord2iv", arg0, arg1);
    }
  }
  @Override
  public void glGetTexParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameterIiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTexParameterIiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexArrayVertexAttribLFormatEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexAttribLFormatEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexArrayVertexAttribLFormatEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexCoord1dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMultiTexCoord1dv", arg0, arg2);
    }
  }
  @Override
  public void glGetNamedBufferParameterui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetNamedBufferParameterui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetNamedBufferParameterui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetnUniformiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetnUniformiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glUniform4i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform4i64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFogCoordhv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glFogCoordhv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glFogCoordhv", arg0);
    }
  }
  @Override
  public void glGetVertexAttribivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexAttribivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform4fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramUniform4fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glIndexFuncEXT(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexFuncEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glIndexFuncEXT", arg0, arg1);
    }
  }
  @Override
  public void glPassThrough(float arg0)
  {
    checkContext();
    downstreamGL4bc.glPassThrough(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glPassThrough", arg0);
    }
  }
  @Override
  public void glResumeTransformFeedbackNV()
  {
    checkContext();
    downstreamGL4bc.glResumeTransformFeedbackNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glResumeTransformFeedbackNV");
    }
  }
  @Override
  public void glUniform4fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform4fvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCompressedTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,long arg10)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glCompressedTexSubImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glPointParameterfv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glPointParameterfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPointParameterfv", arg0, arg1);
    }
  }
  @Override
  public void glUniform2i64NV(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2i64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glUniform2i64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetQueryIndexediv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetQueryIndexediv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetQueryIndexediv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMap1f(int arg0,float arg1,float arg2,int arg3,int arg4,java.nio.FloatBuffer arg5)
  {
    checkContext();
    downstreamGL4bc.glMap1f(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMap1f", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glLoadTransposeMatrixf(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glLoadTransposeMatrixf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glLoadTransposeMatrixf", arg0);
    }
  }
  @Override
  public void glIndexubv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexubv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glIndexubv", arg0);
    }
  }
  @Override
  public void glVertexAttribI1uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI1uiv", arg0, arg1);
    }
  }
  @Override
  public int glObjectPurgeableAPPLE(int arg0,int arg1,int arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glObjectPurgeableAPPLE(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glObjectPurgeableAPPLE", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glVertexAttrib4dvARB(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4dvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib4dvARB", arg0, arg2);
    }
  }
  @Override
  public void glIndexs(short arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexs(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s)",
                   "glIndexs", arg0);
    }
  }
  @Override
  public void glProgramParameteri(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramParameteri(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramParameteri", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform1f(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glProgramUniform1f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetProgramEnvParameterdvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterdvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetProgramEnvParameterdvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glInvalidateTexImage(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glInvalidateTexImage(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glInvalidateTexImage", arg0, arg1);
    }
  }
  @Override
  public void glScissorIndexedv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glScissorIndexedv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glScissorIndexedv", arg0, arg1);
    }
  }
  @Override
  public void glSecondaryColor3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glSecondaryColor3fv", arg0);
    }
  }
  @Override
  public void glTranslated(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glTranslated(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glTranslated", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos2iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glWindowPos2iv", arg1);
    }
  }
  @Override
  public void glVariantdvEXT(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantdvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVariantdvEXT", arg0, arg2);
    }
  }
  @Override
  public void glFogCoordf(float arg0)
  {
    checkContext();
    downstreamGL4bc.glFogCoordf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glFogCoordf", arg0);
    }
  }
  @Override
  public void glVertexArrayIndexOffsetEXT(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayIndexOffsetEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayIndexOffsetEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glRasterPos3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glRasterPos3f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSecondaryColor3ubv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3ubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glSecondaryColor3ubv", arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix3dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix3dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glProgramUniform3uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform3uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDrawRangeElementsBaseVertex(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glDrawRangeElementsBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X)",
                   "glDrawRangeElementsBaseVertex", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glMap2f(int arg0,float arg1,float arg2,int arg3,int arg4,float arg5,float arg6,int arg7,int arg8,java.nio.FloatBuffer arg9)
  {
    checkContext();
    downstreamGL4bc.glMap2f(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMap2f", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glProgramUniform1i64NV(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1i64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glProgramUniform1i64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3bvOES(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3bvOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glMultiTexCoord3bvOES", arg0, arg2);
    }
  }
  @Override
  public void glGetVariantIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVariantIntegervEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVariantIntegervEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord3sv", arg0, arg2);
    }
  }
  @Override
  public void glIndexfv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glIndexfv", arg1);
    }
  }
  @Override
  public void glVDPAUInitNV(java.nio.Buffer arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVDPAUInitNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <java.nio.Buffer> %s)",
                   "glVDPAUInitNV", arg0, arg1);
    }
  }
  @Override
  public void glSecondaryColor3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glSecondaryColor3sv", arg0);
    }
  }
  @Override
  public void glVertexP4uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexP4uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexP4uiv", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glTexCoord3fv", arg0);
    }
  }
  @Override
  public void glVariantPointerEXT(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glVariantPointerEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVariantPointerEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib1svARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1svARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib1svARB", arg0, arg2);
    }
  }
  @Override
  public void glApplyTextureEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glApplyTextureEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glApplyTextureEXT", arg0);
    }
  }
  @Override
  public void glDetachObjectARB(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDetachObjectARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDetachObjectARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI1iEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1iEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI1iEXT", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoordP1ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP1ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoordP1ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTextureParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTextureParameterivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glShaderOp3EXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glShaderOp3EXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glShaderOp3EXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib3fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib3fv", arg0, arg1);
    }
  }
  @Override
  public void glGetPathCommandsNV(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPathCommandsNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetPathCommandsNV", arg0, arg1);
    }
  }
  @Override
  public void glVertexArrayVertexAttribOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5,int arg6,long arg7)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexAttribOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <long> %s)",
                   "glVertexArrayVertexAttribOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glWeightsvARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightsvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glWeightsvARB", arg0, arg1);
    }
  }
  @Override
  public void glBeginConditionalRender(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBeginConditionalRender(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBeginConditionalRender", arg0, arg1);
    }
  }
  @Override
  public void glCopyMultiTexSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glCopyMultiTexSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyMultiTexSubImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glVertexAttrib4uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4uiv", arg0, arg1);
    }
  }
  @Override
  public void glConvolutionFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glConvolutionFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glConvolutionFilter2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glPauseTransformFeedbackNV()
  {
    checkContext();
    downstreamGL4bc.glPauseTransformFeedbackNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPauseTransformFeedbackNV");
    }
  }
  @Override
  public void glGetnUniformuiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetnUniformuiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix4dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix4dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public int glCheckNamedFramebufferStatusEXT(int arg0,int arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glCheckNamedFramebufferStatusEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glCheckNamedFramebufferStatusEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glDeleteVertexArrays(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteVertexArrays(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteVertexArrays", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform2uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform2uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glNormal3bv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glNormal3bv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glNormal3bv", arg0);
    }
  }
  @Override
  public void glSecondaryColorPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColorPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glSecondaryColorPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribP2uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP2uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.IntBuffer> %s)",
                   "glVertexAttribP2uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetFloatv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetFloatv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetFloatv", arg0, arg1);
    }
  }
  @Override
  public void glGenFramebuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenFramebuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenFramebuffers", arg0, arg1);
    }
  }
  @Override
  public void glFogi(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFogi(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glFogi", arg0, arg1);
    }
  }
  @Override
  public void glGetNamedBufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedBufferParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedBufferParameterivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexWeightPointerEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexWeightPointerEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexWeightPointerEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexParameteriEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameteriEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexParameteriEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetQueryObjectui64v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectui64v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetQueryObjectui64v", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTextureImage2DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
    checkContext();
    downstreamGL4bc.glTextureImage2DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTextureImage2DMultisampleCoverageNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glGetMapControlPointsNV(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glGetMapControlPointsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.Buffer> %s)",
                   "glGetMapControlPointsNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glColor4usv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4usv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glColor4usv", arg0);
    }
  }
  @Override
  public void glBindVertexArray(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBindVertexArray(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBindVertexArray", arg0);
    }
  }
  @Override
  public void glUniform1dv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glUniform1dv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glSecondaryColor3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glSecondaryColor3f", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean isTextureFormatBGRA8888Available()
  {
    return downstreamGL4bc.isTextureFormatBGRA8888Available();
  }
  @Override
  public void glVertexAttribL3ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3ui64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL3ui64vNV", arg0, arg1);
    }
  }
  @Override
  public boolean glIsBufferResidentNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsBufferResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsBufferResidentNV", arg0);
    }
    return _res;
  }
  @Override
  public void glColor3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glColor3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCoverFillPathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glCoverFillPathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glCoverFillPathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg7);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedProgramLocalParameterIuivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttribI4bv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4bv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttribI4bv", arg0, arg2);
    }
  }
  @Override
  public void glPointParameteriv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glPointParameteriv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glPointParameteriv", arg0, arg1);
    }
  }
  @Override
  public void glUniform1iARB(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1iARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glUniform1iARB", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glRasterPos3s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexArrayVertexOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayVertexOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexArrayNormalOffsetEXT(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayNormalOffsetEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayNormalOffsetEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix2x4fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x4fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix2x4fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glUniform2iARB(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2iARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform2iARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCompileShader(int arg0)
  {
    checkContext();
    downstreamGL4bc.glCompileShader(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCompileShader", arg0);
    }
  }
  @Override
  public void glGetBooleani_v(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetBooleani_v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetBooleani_v", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGenFencesNV(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenFencesNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenFencesNV", arg0, arg1);
    }
  }
  @Override
  public void glRectd(double arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glRectd(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s)",
                   "glRectd", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetMultiTexParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterIivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMultiTexParameterIivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRectf(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glRectf(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glRectf", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4NuivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NuivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4NuivARB", arg0, arg2);
    }
  }
  @Override
  public void glVertex3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glVertex3dv", arg0);
    }
  }
  @Override
  public void glNamedFramebufferParameteriEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferParameteriEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferParameteriEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform4uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4uiEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform4uiEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glSecondaryColor3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glSecondaryColor3iv", arg0);
    }
  }
  @Override
  public void glGenTransformFeedbacksNV(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenTransformFeedbacksNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenTransformFeedbacksNV", arg0, arg1);
    }
  }
  @Override
  public void glFogCoordh(short arg0)
  {
    checkContext();
    downstreamGL4bc.glFogCoordh(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s)",
                   "glFogCoordh", arg0);
    }
  }
  @Override
  public void glLineStipple(int arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glLineStipple(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s)",
                   "glLineStipple", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord2iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glTexCoord2iv", arg1);
    }
  }
  @Override
  public void glVertexAttribI4ubvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ubvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttribI4ubvEXT", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord1bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glMultiTexCoord1bvOES", arg0, arg1);
    }
  }
  @Override
  public void glGetQueryiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetQueryiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGenVertexArrays(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenVertexArrays(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenVertexArrays", arg0, arg2);
    }
  }
  @Override
  public void glGetnUniformfv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetnUniformfv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glIndexf(float arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glIndexf", arg0);
    }
  }
  @Override
  public void glGetInfoLogARB(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetInfoLogARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetInfoLogARB", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public boolean glIsImageHandleResidentNV(long arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsImageHandleResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glIsImageHandleResidentNV", arg0);
    }
    return _res;
  }
  @Override
  public void glProgramUniformMatrix4x3dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix4x3dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttribs2hv(int arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs2hv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribs2hv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPatchParameteri(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPatchParameteri(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glPatchParameteri", arg0, arg1);
    }
  }
  @Override
  public void glMatrixIndexuivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexuivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMatrixIndexuivARB", arg0, arg1);
    }
  }
  @Override
  public void glGetDoublei_v(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetDoublei_v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetDoublei_v", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform3ui64NV(int arg0,long arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3ui64NV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glUniform3ui64NV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniform1dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glProgramUniform1dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glTexCoord3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glTexCoord3iv", arg0);
    }
  }
  @Override
  public void glUniformMatrix2x4fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x4fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix2x4fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glBlendFunci(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBlendFunci(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendFunci", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPixelTransformParameterfvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelTransformParameterfvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPixelTransformParameterfvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDepthFunc(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDepthFunc(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDepthFunc", arg0);
    }
  }
  @Override
  public void glNamedFramebufferTextureEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferTextureEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferTextureEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRecti(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRecti(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glRecti", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLightf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glLightf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glLightf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord3d(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glTexCoord3d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGenPerfMonitorsAMD(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenPerfMonitorsAMD(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenPerfMonitorsAMD", arg0, arg1);
    }
  }
  @Override
  public void glDebugMessageInsert(int arg0,int arg1,int arg2,int arg3,int arg4,java.lang.String arg5)
  {
    checkContext();
    downstreamGL4bc.glDebugMessageInsert(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glDebugMessageInsert", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColor4sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glColor4sv", arg0);
    }
  }
  @Override
  public void glGetLightfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetLightfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetLightfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glRects(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glRects(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glRects", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public boolean glAreTexturesResident(int arg0,int[] arg1,int arg2,byte[] arg3,int arg4)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glAreTexturesResident(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glAreTexturesResident", arg0, arg2, arg4);
    }
    return _res;
  }
  @Override
  public void glLightfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glLightfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glLightfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glRasterPos4dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glRasterPos4dv", arg0);
    }
  }
  @Override
  public void glCompressedTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glCompressedTexSubImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glProgramUniformMatrix4x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x2fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix4x2fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetnMapdv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnMapdv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetnMapdv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glSecondaryColor3h(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glSecondaryColor3h", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMatrixLoaddEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoaddEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMatrixLoaddEXT", arg0, arg1);
    }
  }
  @Override
  public void glVertexArrayColorOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayColorOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayColorOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glDeleteTextures(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteTextures(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteTextures", arg0, arg2);
    }
  }
  @Override
  public void glTextureParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTextureParameterIuivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glLogicOp(int arg0)
  {
    checkContext();
    downstreamGL4bc.glLogicOp(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glLogicOp", arg0);
    }
  }
  @Override
  public void glWeightdvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightdvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glWeightdvARB", arg0, arg1);
    }
  }
  @Override
  public void glDisableVertexArrayAttribEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDisableVertexArrayAttribEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDisableVertexArrayAttribEXT", arg0, arg1);
    }
  }
  @Override
  public void glFlushPixelDataRangeNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glFlushPixelDataRangeNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glFlushPixelDataRangeNV", arg0);
    }
  }
  @Override
  public void glProgramUniform3uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3uivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform3uivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glColorP3ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColorP3ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glColorP3ui", arg0, arg1);
    }
  }
  @Override
  public void glTextureRenderbufferEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTextureRenderbufferEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureRenderbufferEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSecondaryColor3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glSecondaryColor3s", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glIsProgram(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsProgram(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsProgram", arg0);
    }
    return _res;
  }
  @Override
  public void glGetIntegerv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetIntegerv", arg0, arg2);
    }
  }
  @Override
  public void glMemoryBarrier(int arg0)
  {
    checkContext();
    downstreamGL4bc.glMemoryBarrier(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glMemoryBarrier", arg0);
    }
  }
  @Override
  public void glCompressedTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glCompressedTexSubImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glUniformui64NV(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glUniformui64NV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glUniformui64NV", arg0, arg1);
    }
  }
  @Override
  public void glNormalP3uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glNormalP3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glNormalP3uiv", arg0, arg2);
    }
  }
  @Override
  public void glNormal3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormal3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glNormal3iv", arg1);
    }
  }
  @Override
  public void glPixelTransformParameteriEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelTransformParameteriEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glPixelTransformParameteriEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformMatrix4x2dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x2dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix4x2dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetTexEnviv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexEnviv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTexEnviv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeleteTransformFeedbacks(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteTransformFeedbacks(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteTransformFeedbacks", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord1d(double arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1d(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s)",
                   "glTexCoord1d", arg0);
    }
  }
  @Override
  public void glStringMarkerGREMEDY(int arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glStringMarkerGREMEDY(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s)",
                   "glStringMarkerGREMEDY", arg0, arg1);
    }
  }
  @Override
  public void glReadPixels(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glReadPixels", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glUniform1fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform1fvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultTransposeMatrixf(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glMultTransposeMatrixf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glMultTransposeMatrixf", arg0);
    }
  }
  @Override
  public void glGetTexParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetTexParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetVariantFloatvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVariantFloatvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetVariantFloatvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramSubroutineParametersuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramSubroutineParametersuivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramSubroutineParametersuivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib4usv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4usv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4usv", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib4usvARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4usvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4usvARB", arg0, arg2);
    }
  }
  @Override
  public void glTextureStorage1D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glTextureStorage1D(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureStorage1D", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glBindVideoCaptureStreamBufferNV(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glBindVideoCaptureStreamBufferNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glBindVideoCaptureStreamBufferNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribP1uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP1uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.IntBuffer> %s)",
                   "glVertexAttribP1uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetQueryObjecti64vEXT(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjecti64vEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetQueryObjecti64vEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEnableClientState(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEnableClientState(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEnableClientState", arg0);
    }
  }
  @Override
  public void glPathSubCommandsNV(int arg0,int arg1,int arg2,int arg3,byte[] arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glPathSubCommandsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPathSubCommandsNV", arg0, arg1, arg2, arg3, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glGetShaderInfoLog(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetShaderInfoLog(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetShaderInfoLog", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glCompressedTextureSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,java.nio.Buffer arg11)
  {
    checkContext();
    downstreamGL4bc.glCompressedTextureSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTextureSubImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }
  }
  @Override
  public void glGetShaderSource(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetShaderSource(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetShaderSource", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribL1d(int arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s)",
                   "glVertexAttribL1d", arg0, arg1);
    }
  }
  @Override
  public void glBindMultiTextureEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBindMultiTextureEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBindMultiTextureEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glClearStencil(int arg0)
  {
    checkContext();
    downstreamGL4bc.glClearStencil(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glClearStencil", arg0);
    }
  }
  @Override
  public void glGetLightiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetLightiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetLightiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glViewportIndexedfv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glViewportIndexedfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glViewportIndexedfv", arg0, arg2);
    }
  }
  @Override
  public void glUniform1ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glUniform1ui", arg0, arg1);
    }
  }
  @Override
  public void glTexGenfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexGenfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glTexGenfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniform2iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2iv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform2iv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexFormatNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexFormatNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexFormatNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCompressedTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTexImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glMultiTexGenivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGenivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexGenivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex3bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glVertex3bvOES", arg1);
    }
  }
  @Override
  public void glProgramUniform1uiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform1uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetUniformdv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformdv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetUniformdv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVariantbvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantbvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVariantbvEXT", arg0, arg1);
    }
  }
  @Override
  public void glPushName(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPushName(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPushName", arg0);
    }
  }
  @Override
  public void glLineWidth(float arg0)
  {
    checkContext();
    downstreamGL4bc.glLineWidth(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glLineWidth", arg0);
    }
  }
  @Override
  public void glUniform3ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform3ui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glFramebufferTexture2D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTexture2D(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTexture2D", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniform3ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3ivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform3ivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glClipPlanef(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glClipPlanef(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glClipPlanef", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform4uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4uivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform4uivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttribParameteriAMD(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribParameteriAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribParameteriAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexBindingDivisor(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexBindingDivisor(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexBindingDivisor", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib2fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib2fv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform3uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3uiEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform3uiEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glShaderSource(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glShaderSource(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <java.nio.IntBuffer> %s)",
                   "glShaderSource", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPrimitiveRestartNV()
  {
    checkContext();
    downstreamGL4bc.glPrimitiveRestartNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPrimitiveRestartNV");
    }
  }
  @Override
  public void glVertexWeighth(short arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexWeighth(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s)",
                   "glVertexWeighth", arg0);
    }
  }
  @Override
  public void glVertexAttribP3ui(int arg0,int arg1,boolean arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP3ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexAttribP3ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4sARB(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4sARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s, <short> %s)",
                   "glVertexAttrib4sARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttribPointer(javax.media.opengl.GLArrayData arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribPointer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<javax.media.opengl.GLArrayData> %s)",
                   "glVertexAttribPointer", arg0);
    }
  }
  @Override
  public void glGetColorTable(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glGetColorTable(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glGetColorTable", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoordP1uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP1uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoordP1uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiDrawElementsIndirect(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawElementsIndirect(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X)",
                   "glMultiDrawElementsIndirect", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glFramebufferTexture1D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTexture1D(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTexture1D", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniformMatrix2x3fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix2x3fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public int glGetDebugMessageLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.IntBuffer arg6,java.nio.ByteBuffer arg7)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLog(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetDebugMessageLog", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
    return _res;
  }
  @Override
  public void glTextureStorage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glTextureStorage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureStorage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetnHistogram(int arg0,boolean arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetnHistogram(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetnHistogram", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexAttrib4Nsv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nsv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4Nsv", arg0, arg2);
    }
  }
  @Override
  public void glProgramEnvParameterI4ivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameterI4ivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramEnvParameterI4ivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribL3d(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glVertexAttribL3d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDrawArraysIndirect(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glDrawArraysIndirect(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glDrawArraysIndirect", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform2ui(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform2ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniformui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniformui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI4sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribI4sv", arg0, arg2);
    }
  }
  @Override
  public void glGetUniformSubroutineuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformSubroutineuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetUniformSubroutineuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetActiveUniformBlockiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformBlockiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetActiveUniformBlockiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public int glGetBoundBuffer(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetBoundBuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGetBoundBuffer", arg0);
    }
    return _res;
  }
  @Override
  public void glGetFenceivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFenceivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetFenceivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNamedCopyBufferSubDataEXT(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedCopyBufferSubDataEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glNamedCopyBufferSubDataEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniformMatrix2x4dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix2x4dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMinSampleShading(float arg0)
  {
    checkContext();
    downstreamGL4bc.glMinSampleShading(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glMinSampleShading", arg0);
    }
  }
  @Override
  public void glGetActiveUniformARB(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6,int[] arg7,int arg8,byte[] arg9,int arg10)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformARB(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetActiveUniformARB", arg0, arg1, arg2, arg4, arg6, arg8, arg10);
    }
  }
  @Override
  public void glGetProgramLocalParameterdvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterdvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetProgramLocalParameterdvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public int getBoundFramebuffer(int arg0)
  {
    return downstreamGL4bc.getBoundFramebuffer(arg0);
  }
  @Override
  public void glPathParameteriNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glPathParameteriNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glPathParameteriNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEndVertexShaderEXT()
  {
    checkContext();
    downstreamGL4bc.glEndVertexShaderEXT();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEndVertexShaderEXT");
    }
  }
  @Override
  public void glVertexAttrib3fARB(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3fARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glVertexAttrib3fARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glEvalPoint2(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalPoint2(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEvalPoint2", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos2dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glRasterPos2dv", arg1);
    }
  }
  @Override
  public void glGetActiveAtomicCounterBufferiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetActiveAtomicCounterBufferiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetActiveAtomicCounterBufferiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex2bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glVertex2bvOES", arg1);
    }
  }
  @Override
  public void glMultiTexCoord1bOES(int arg0,byte arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1bOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <byte> %s)",
                   "glMultiTexCoord1bOES", arg0, arg1);
    }
  }
  @Override
  public void glPrioritizeTextures(int arg0,java.nio.IntBuffer arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPrioritizeTextures(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.FloatBuffer> %s)",
                   "glPrioritizeTextures", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribL2i64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL2i64vNV", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib3fvARB(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib3fvARB", arg0, arg2);
    }
  }
  @Override
  public void glGetNamedFramebufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedFramebufferParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedFramebufferParameterivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glClearColorIi(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glClearColorIi(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glClearColorIi", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCopyMultiTexSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9)
  {
    checkContext();
    downstreamGL4bc.glCopyMultiTexSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyMultiTexSubImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glDebugMessageInsertAMD(int arg0,int arg1,int arg2,int arg3,java.lang.String arg4)
  {
    checkContext();
    downstreamGL4bc.glDebugMessageInsertAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glDebugMessageInsertAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniform3dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glUniform3dv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetUniformi64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformi64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetUniformi64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexCoord2bOES(byte arg0,byte arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2bOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s)",
                   "glTexCoord2bOES", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribL2ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2ui64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL2ui64vNV", arg0, arg1);
    }
  }
  @Override
  public void glTexCoordP2uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP2uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexCoordP2uiv", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribdv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribdv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetVertexAttribdv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniformMatrix3x4fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix3x4fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMultiTexParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexParameterfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMultiTexSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glMultiTexSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexSubImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glTexCoordP1uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP1uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexCoordP1uiv", arg0, arg1);
    }
  }
  @Override
  public void glDisablei(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDisablei(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDisablei", arg0, arg1);
    }
  }
  @Override
  public void glUniformMatrix2dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix2dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4ivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4ivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4ivARB", arg0, arg2);
    }
  }
  @Override
  public void glClearBufferfi(int arg0,int arg1,float arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glClearBufferfi(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <int> 0x%X)",
                   "glClearBufferfi", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord4fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glTexCoord4fv", arg1);
    }
  }
  @Override
  public void glGenerateMultiTexMipmapEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glGenerateMultiTexMipmapEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glGenerateMultiTexMipmapEXT", arg0, arg1);
    }
  }
  @Override
  public void glProgramVertexLimitNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glProgramVertexLimitNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glProgramVertexLimitNV", arg0, arg1);
    }
  }
  @Override
  public void glProgramEnvParameter4dvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameter4dvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glProgramEnvParameter4dvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glInvalidateTexSubImage(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glInvalidateTexSubImage(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glInvalidateTexSubImage", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public int glGetUniformBufferSizeEXT(int arg0,int arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetUniformBufferSizeEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glGetUniformBufferSizeEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glMatrixTranslatefEXT(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glMatrixTranslatefEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glMatrixTranslatefEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetLocalConstantIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetLocalConstantIntegervEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetLocalConstantIntegervEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord2hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord2hv", arg0, arg1);
    }
  }
  @Override
  public int glGetSubroutineIndex(int arg0,int arg1,java.lang.String arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetSubroutineIndex(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glGetSubroutineIndex", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glBindProgramPipeline(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBindProgramPipeline(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBindProgramPipeline", arg0);
    }
  }
  @Override
  public void glGetBufferParameteri64v(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetBufferParameteri64v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetBufferParameteri64v", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTextureParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTextureParameterIivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glEndQuery(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEndQuery(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEndQuery", arg0);
    }
  }
  @Override
  public void glProgramEnvParametersI4uivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParametersI4uivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramEnvParametersI4uivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexP4ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexP4ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexP4ui", arg0, arg1);
    }
  }
  @Override
  public void glBlendFuncSeparate(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glBlendFuncSeparate(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendFuncSeparate", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex4hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex4hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertex4hv", arg0);
    }
  }
  @Override
  public void glProgramUniform4i(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4i(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform4i", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glProgramUniform4d(int arg0,int arg1,double arg2,double arg3,double arg4,double arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4d(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glProgramUniform4d", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexAttribI4ubv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttribI4ubv", arg0, arg1);
    }
  }
  @Override
  public void glGetIntegerui64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetIntegerui64vNV", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform4f(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4f(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glProgramUniform4f", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTexParameterf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glTexParameterf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glTexParameterf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor4fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glColor4fv", arg0);
    }
  }
  @Override
  public void glGetProgramiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetObjectParameterivAPPLE(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetObjectParameterivAPPLE(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetObjectParameterivAPPLE", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetConvolutionParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetConvolutionParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetConvolutionParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glFramebufferRenderbuffer(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glFramebufferRenderbuffer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferRenderbuffer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glInvalidateFramebuffer(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glInvalidateFramebuffer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glInvalidateFramebuffer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFogfv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glFogfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glFogfv", arg0, arg2);
    }
  }
  @Override
  public void glUniformHandleui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformHandleui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniformHandleui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribL4i64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4i64NV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s, <long> %s)",
                   "glVertexAttribL4i64NV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glNormal3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glNormal3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glNormal3sv", arg0);
    }
  }
  @Override
  public void glUniform3fARB(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3fARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glUniform3fARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDrawArraysInstancedBaseInstance(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawArraysInstancedBaseInstance(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawArraysInstancedBaseInstance", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexCoord3dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMultiTexCoord3dv", arg0, arg1);
    }
  }
  @Override
  public void glSeparableFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6,long arg7)
  {
    checkContext();
    downstreamGL4bc.glSeparableFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glSeparableFilter2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glSeparableFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glSeparableFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <java.nio.Buffer> %s)",
                   "glSeparableFilter2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glVertexAttribL4dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttribL4dv", arg0, arg1);
    }
  }
  @Override
  public void glMatrixMode(int arg0)
  {
    checkContext();
    downstreamGL4bc.glMatrixMode(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glMatrixMode", arg0);
    }
  }
  @Override
  public void glProgramUniformMatrix3x2dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix3x2dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public int glGetGraphicsResetStatus()
  {
    checkContext();
    int _res = downstreamGL4bc.glGetGraphicsResetStatus();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glGetGraphicsResetStatus");
    }
    return _res;
  }
  @Override
  public void glGetMapParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMapParameterfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMapParameterfvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetFramebufferAttachmentParameteriv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetFramebufferAttachmentParameteriv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetFramebufferAttachmentParameteriv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetProgramEnvParameterIuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterIuivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramEnvParameterIuivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniform1ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform1ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetCompressedMultiTexImageEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetCompressedMultiTexImageEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetCompressedMultiTexImageEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex2sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertex2sv", arg1);
    }
  }
  @Override
  public void glProgramUniform3i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3i64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform3i64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramBufferParametersIivNV(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramBufferParametersIivNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramBufferParametersIivNV", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glDrawRangeElements(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glDrawRangeElements(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glDrawRangeElements", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public boolean glIsRenderbuffer(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsRenderbuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsRenderbuffer", arg0);
    }
    return _res;
  }
  @Override
  public void glExtractComponentEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glExtractComponentEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glExtractComponentEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribL3i64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL3i64vNV", arg0, arg2);
    }
  }
  @Override
  public void glTexCoord1hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord1hv", arg1);
    }
  }
  @Override
  public void glEdgeFlagv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEdgeFlagv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glEdgeFlagv", arg1);
    }
  }
  @Override
  public void glRasterPos2sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glRasterPos2sv", arg1);
    }
  }
  @Override
  public void glGetFramebufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFramebufferParameterivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetFramebufferParameterivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform1uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform1uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSecondaryColorP3uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColorP3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glSecondaryColorP3uiv", arg0, arg2);
    }
  }
  @Override
  public void glGetTexImage(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTexImage(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glGetTexImage", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib1hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib1hv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform2f(int arg0,int arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s)",
                   "glProgramUniform2f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetMultiTexGenfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexGenfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMultiTexGenfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniform2i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform2i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLightModelfv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glLightModelfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glLightModelfv", arg0, arg2);
    }
  }
  @Override
  public void glMatrixIndexusvARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexusvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMatrixIndexusvARB", arg0, arg2);
    }
  }
  @Override
  public void glTextureMaterialEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTextureMaterialEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTextureMaterialEXT", arg0, arg1);
    }
  }
  @Override
  public void glCallLists(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glCallLists(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCallLists", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSampleMaski(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSampleMaski(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glSampleMaski", arg0, arg1);
    }
  }
  @Override
  public void glProgramBufferParametersfvNV(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramBufferParametersfvNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramBufferParametersfvNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public int glGetProgramResourceLocationIndex(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceLocationIndex(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetProgramResourceLocationIndex", arg0, arg1, arg3);
    }
    return _res;
  }
  @Override
  public void glColor4hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glColor4hv", arg0);
    }
  }
  @Override
  public void glProgramUniform2d(int arg0,int arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s)",
                   "glProgramUniform2d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexP3ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexP3ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexP3ui", arg0, arg1);
    }
  }
  @Override
  public void glEdgeFlagv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glEdgeFlagv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glEdgeFlagv", arg0);
    }
  }
  @Override
  public void glPixelStoref(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPixelStoref(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glPixelStoref", arg0, arg1);
    }
  }
  @Override
  public boolean glIsPBOUnpackBound()
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsPBOUnpackBound();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glIsPBOUnpackBound");
    }
    return _res;
  }
  @Override
  public int glGetUniformLocation(int arg0,java.lang.String arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetUniformLocation(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glGetUniformLocation", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glUniform1ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform1ui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCopyTextureImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glCopyTextureImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTextureImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glSamplerParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glSamplerParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glColor3fv", arg0);
    }
  }
  @Override
  public void glCullParameterfvEXT(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glCullParameterfvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glCullParameterfvEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterdvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterdvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetNamedProgramLocalParameterdvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramEnvParameterI4uivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameterI4uivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramEnvParameterI4uivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFogCoordfv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFogCoordfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glFogCoordfv", arg1);
    }
  }
  @Override
  public void glGenNamesAMD(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGenNamesAMD(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenNamesAMD", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTexGendv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexGendv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetTexGendv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSecondaryColor3ub(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3ub(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glSecondaryColor3ub", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glWindowPos3dv", arg0);
    }
  }
  @Override
  public void glVertexAttribI1ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1ivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI1ivEXT", arg0, arg1);
    }
  }
  @Override
  public void glTexCoordP4uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP4uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexCoordP4uiv", arg0, arg1);
    }
  }
  @Override
  public void glVideoCaptureStreamParameterivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVideoCaptureStreamParameterivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glVideoCaptureStreamParameterivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib4NusvARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NusvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4NusvARB", arg0, arg1);
    }
  }
  @Override
  public int glGetProgramResourceLocationIndex(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceLocationIndex(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetProgramResourceLocationIndex", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glTexCoordP1ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP1ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTexCoordP1ui", arg0, arg1);
    }
  }
  @Override
  public void glPathTexGenNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glPathTexGenNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPathTexGenNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetVertexArrayIntegeri_vEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetVertexArrayIntegeri_vEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexArrayIntegeri_vEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniform4i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform4i64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexEnviEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexEnviEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexEnviEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCompressedMultiTexImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glCompressedMultiTexImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedMultiTexImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glVertexAttribL1ui64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL1ui64vNV", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glMultiTexSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexSubImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glMatrixMultfEXT(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultfEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMatrixMultfEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetPixelMapfv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPixelMapfv", arg0, arg1);
    }
  }
  @Override
  public void glTextureImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glTextureImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTextureImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glGetQueryObjectuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetQueryObjectuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProvokingVertexEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glProvokingVertexEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glProvokingVertexEXT", arg0);
    }
  }
  @Override
  public void glMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexParameterIuivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertex3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertex3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertex3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexArrayRangeAPPLE(int arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayRangeAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexArrayRangeAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glCopyPixels(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glCopyPixels(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyPixels", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetnUniformdv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformdv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetnUniformdv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glLightModeli(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glLightModeli(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glLightModeli", arg0, arg1);
    }
  }
  @Override
  public void glInvalidateSubFramebuffer(int arg0,int arg1,java.nio.IntBuffer arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glInvalidateSubFramebuffer(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glInvalidateSubFramebuffer", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glFogCoordPointer(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glFogCoordPointer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glFogCoordPointer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformui64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniformui64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glUniform2ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform2ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glStencilOpValueAMD(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glStencilOpValueAMD(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glStencilOpValueAMD", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform4i64NV(int arg0,int arg1,long arg2,long arg3,long arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4i64NV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s, <long> %s)",
                   "glProgramUniform4i64NV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGenBuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenBuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenBuffers", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform2i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform2i64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSampleCoverage(float arg0,boolean arg1)
  {
    checkContext();
    downstreamGL4bc.glSampleCoverage(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <boolean> %s)",
                   "glSampleCoverage", arg0, arg1);
    }
  }
  @Override
  public void glWeightPathsNV(int arg0,int arg1,int[] arg2,int arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glWeightPathsNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glWeightPathsNV", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glMap2d(int arg0,double arg1,double arg2,int arg3,int arg4,double arg5,double arg6,int arg7,int arg8,double[] arg9,int arg10)
  {
    checkContext();
    downstreamGL4bc.glMap2d(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glMap2d", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg10);
    }
  }
  @Override
  public void glUniform1fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform1fv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFramebufferTextureFaceEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureFaceEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureFaceEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glNamedProgramLocalParameterI4uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameterI4uiEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedProgramLocalParameterI4uiEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glProgramUniform4ui64NV(int arg0,int arg1,long arg2,long arg3,long arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4ui64NV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s, <long> %s)",
                   "glProgramUniform4ui64NV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glMultiTexCoord1fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexCoord1fv", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord4iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoord4iv", arg0, arg2);
    }
  }
  @Override
  public void glColorTableParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glColorTableParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glColorTableParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexCoord4sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord4sv", arg0);
    }
  }
  @Override
  public void glVertexAttribI4ubv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ubv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttribI4ubv", arg0, arg2);
    }
  }
  @Override
  public void glGetVideoCaptureStreamdvNV(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureStreamdvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetVideoCaptureStreamdvNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetTextureParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTextureParameterivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCompileShaderARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glCompileShaderARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCompileShaderARB", arg0);
    }
  }
  @Override
  public void glVertexAttrib4sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4sv", arg0, arg2);
    }
  }
  @Override
  public void glMapParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMapParameterfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMapParameterfvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexCoord3dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glTexCoord3dv", arg1);
    }
  }
  @Override
  public void glMapVertexAttrib2dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,double arg6,double arg7,int arg8,int arg9,java.nio.DoubleBuffer arg10)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib2dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMapVertexAttrib2dAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glDrawArrays(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawArrays(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawArrays", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI4svEXT(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4svEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribI4svEXT", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform2ui64NV(int arg0,int arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2ui64NV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glProgramUniform2ui64NV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetSamplerParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameterIuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetSamplerParameterIuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib3dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib3dv", arg0, arg2);
    }
  }
  @Override
  public void glGetMultiTexParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMultiTexParameterfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glShaderBinary(int arg0,java.nio.IntBuffer arg1,int arg2,java.nio.Buffer arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glShaderBinary(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glShaderBinary", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGenTransformFeedbacks(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenTransformFeedbacks(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenTransformFeedbacks", arg0, arg1);
    }
  }
  @Override
  public void glPathDashArrayNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPathDashArrayNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPathDashArrayNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMap1d(int arg0,double arg1,double arg2,int arg3,int arg4,double[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glMap1d(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glMap1d", arg0, arg1, arg2, arg3, arg4, arg6);
    }
  }
  @Override
  public void glUniformMatrix4fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix4fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLoadTransposeMatrixd(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glLoadTransposeMatrixd(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glLoadTransposeMatrixd", arg1);
    }
  }
  @Override
  public void glTexCoordP3uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexCoordP3uiv", arg0, arg2);
    }
  }
  @Override
  public void glTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
    checkContext();
    downstreamGL4bc.glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glTexImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glGetMinmaxParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMinmaxParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMinmaxParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glColor3iv", arg0);
    }
  }
  @Override
  public void glMatrixMultTransposefEXT(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultTransposefEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMatrixMultTransposefEXT", arg0, arg1);
    }
  }
  @Override
  public void glMaterialiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMaterialiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMaterialiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEvalCoord1dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord1dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glEvalCoord1dv", arg0);
    }
  }
  @Override
  public void glDeleteProgramPipelines(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteProgramPipelines(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteProgramPipelines", arg0, arg1);
    }
  }
  @Override
  public void glGetProgramivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glStencilFillPathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,java.nio.FloatBuffer arg7)
  {
    checkContext();
    downstreamGL4bc.glStencilFillPathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glStencilFillPathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glProgramUniform1fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramUniform1fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glConvolutionParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glConvolutionParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glConvolutionParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTexEnvfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexEnvfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetTexEnvfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glRasterPos3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glRasterPos3iv", arg1);
    }
  }
  @Override
  public void glProgramUniform3dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniform3dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex2bvOES(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2bvOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glVertex2bvOES", arg0);
    }
  }
  @Override
  public void glGetUniformui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetUniformui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix3fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix3fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glPolygonMode(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPolygonMode(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glPolygonMode", arg0, arg1);
    }
  }
  @Override
  public void glGetNamedProgramivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedProgramivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetActiveAttrib(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glGetActiveAttrib(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveAttrib", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertex2bOES(byte arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2bOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s)",
                   "glVertex2bOES", arg0);
    }
  }
  @Override
  public boolean isExtensionAvailable(java.lang.String arg0)
  {
    return downstreamGL4bc.isExtensionAvailable(arg0);
  }
  @Override
  public void glMultTransposeMatrixd(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMultTransposeMatrixd(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glMultTransposeMatrixd", arg1);
    }
  }
  @Override
  public void glRasterPos2iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glRasterPos2iv", arg0);
    }
  }
  @Override
  public void glClearBufferiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glClearBufferiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glClearBufferiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexEnvfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexEnvfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glTexEnvfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultiTexRenderbufferEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexRenderbufferEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexRenderbufferEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexGeniEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGeniEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexGeniEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramEnvParameterI4uiNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameterI4uiNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramEnvParameterI4uiNV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public long glGetBufferSize(int arg0)
  {
    checkContext();
    long _res = downstreamGL4bc.glGetBufferSize(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGetBufferSize", arg0);
    }
    return _res;
  }
  @Override
  public void glProgramUniformMatrix3x4fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix3x4fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttribI4uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI4uiv", arg0, arg2);
    }
  }
  @Override
  public void glCompressedMultiTexImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glCompressedMultiTexImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedMultiTexImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glTexCoord2sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord2sv", arg1);
    }
  }
  @Override
  public void glVertexP2uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexP2uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexP2uiv", arg0, arg2);
    }
  }
  @Override
  public void glMatrixFrustumEXT(int arg0,double arg1,double arg2,double arg3,double arg4,double arg5,double arg6)
  {
    checkContext();
    downstreamGL4bc.glMatrixFrustumEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glMatrixFrustumEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glFreeMemoryNV(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glFreeMemoryNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glFreeMemoryNV", arg0);
    }
  }
  @Override
  public void glQueryCounter(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glQueryCounter(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glQueryCounter", arg0, arg1);
    }
  }
  @Override
  public void glUniform1iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform1iv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexArrayEdgeFlagOffsetEXT(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayEdgeFlagOffsetEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayEdgeFlagOffsetEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetProgramResourceName(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,byte[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glGetProgramResourceName(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetProgramResourceName", arg0, arg1, arg2, arg3, arg5, arg7);
    }
  }
  @Override
  public void glDeleteSync(long arg0)
  {
    checkContext();
    downstreamGL4bc.glDeleteSync(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glDeleteSync", arg0);
    }
  }
  @Override
  public void glMatrixMultTransposedEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultTransposedEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMatrixMultTransposedEXT", arg0, arg1);
    }
  }
  @Override
  public void glDeleteFencesNV(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteFencesNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteFencesNV", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib4NivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4NivARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib1fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1fvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib1fvARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI3uiEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3uiEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI3uiEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform1ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1ivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform1ivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetUniformfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformfvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetUniformfvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetShaderiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetShaderiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetShaderiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribLFormatNV(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribLFormatNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribLFormatNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex3bvOES(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex3bvOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glVertex3bvOES", arg0);
    }
  }
  @Override
  public void glTexImage3DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
    checkContext();
    downstreamGL4bc.glTexImage3DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTexImage3DMultisampleCoverageNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glProgramLocalParameter4dvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameter4dvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glProgramLocalParameter4dvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPathTexGenfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPathTexGenfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathTexGenfvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glRasterPos2fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glRasterPos2fv", arg0);
    }
  }
  @Override
  public void glVariantbvEXT(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantbvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVariantbvEXT", arg0, arg2);
    }
  }
  @Override
  public void glDispatchComputeIndirect(long arg0)
  {
    checkContext();
    downstreamGL4bc.glDispatchComputeIndirect(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glDispatchComputeIndirect", arg0);
    }
  }
  @Override
  public void glMultiTexParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexParameterivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetProgramLocalParameterIivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterIivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramLocalParameterIivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexCoord1bOES(byte arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1bOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s)",
                   "glTexCoord1bOES", arg0);
    }
  }
  @Override
  public void glNamedProgramLocalParametersI4uivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParametersI4uivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glNamedProgramLocalParametersI4uivEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVertexAttribL1i64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL1i64vNV", arg0, arg2);
    }
  }
  @Override
  public void glClearBufferfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glClearBufferfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glClearBufferfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetnPixelMapfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetnPixelMapfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetnPixelMapfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeleteOcclusionQueriesNV(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteOcclusionQueriesNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteOcclusionQueriesNV", arg0, arg1);
    }
  }
  @Override
  public void glColor4us(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4us(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glColor4us", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniform1ui64NV(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1ui64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glProgramUniform1ui64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI4ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI4ivEXT", arg0, arg1);
    }
  }
  @Override
  public void glColorP3uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glColorP3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glColorP3uiv", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribI4iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI4iv", arg0, arg2);
    }
  }
  @Override
  public void glPathSubCommandsNV(int arg0,int arg1,int arg2,int arg3,java.nio.ByteBuffer arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glPathSubCommandsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPathSubCommandsNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glUniformMatrix4fvARB(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix4fvARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMapParameterivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMapParameterivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMapParameterivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord3hv", arg0, arg2);
    }
  }
  @Override
  public void glColor4ub(byte arg0,byte arg1,byte arg2,byte arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4ub(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s, <byte> %s)",
                   "glColor4ub", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex2iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glVertex2iv", arg1);
    }
  }
  @Override
  public boolean glIsFramebuffer(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsFramebuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsFramebuffer", arg0);
    }
    return _res;
  }
  @Override
  public void glGetnMapfv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnMapfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetnMapfv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTextureImage3DMultisampleCoverageNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,boolean arg8)
  {
    checkContext();
    downstreamGL4bc.glTextureImage3DMultisampleCoverageNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTextureImage3DMultisampleCoverageNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glColor4ui(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glColor4ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexGendvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGendvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glMultiTexGendvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMultiDrawElementsIndirectAMD(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawElementsIndirectAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X)",
                   "glMultiDrawElementsIndirectAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetPathColorGenivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathColorGenivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPathColorGenivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glWindowPos3s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4Niv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Niv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4Niv", arg0, arg1);
    }
  }
  @Override
  public void glOrtho(double arg0,double arg1,double arg2,double arg3,double arg4,double arg5)
  {
    checkContext();
    downstreamGL4bc.glOrtho(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glOrtho", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glLightiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glLightiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glLightiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform4fv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform4fv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetSamplerParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameterIiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetSamplerParameterIiv", arg0, arg1, arg2);
    }
  }
  @Override
  public java.lang.Object getPlatformGLExtensions()
  {
    return downstreamGL4bc.getPlatformGLExtensions();
  }
  @Override
  public void glProgramEnvParameters4fvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameters4fvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramEnvParameters4fvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetUniformfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetUniformfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEnablei(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnablei(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnablei", arg0, arg1);
    }
  }
  @Override
  public void glGenOcclusionQueriesNV(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenOcclusionQueriesNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenOcclusionQueriesNV", arg0, arg1);
    }
  }
  @Override
  public void glGetMultisamplefv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultisamplefv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMultisamplefv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glWeightivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glWeightivARB", arg0, arg1);
    }
  }
  @Override
  public void glGetnMapiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnMapiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetnMapiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVideoCaptureStreamParameterfvNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVideoCaptureStreamParameterfvNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glVideoCaptureStreamParameterfvNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttribL2ui64NV(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2ui64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glVertexAttribL2ui64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMatrixLoadTransposedEXT(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoadTransposedEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMatrixLoadTransposedEXT", arg0, arg2);
    }
  }
  @Override
  public void glClipPlane(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glClipPlane(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glClipPlane", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexAttribiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPathStringNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glPathStringNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPathStringNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix3fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix3fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetMultiTexLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMultiTexLevelParameterfvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glCopyColorTable(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glCopyColorTable(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyColorTable", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexGenfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGenfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexGenfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetHistogramParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetHistogramParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetHistogramParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glEvalCoord1f(float arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord1f(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glEvalCoord1f", arg0);
    }
  }
  @Override
  public void glGetVertexAttribLdv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribLdv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetVertexAttribLdv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glFramebufferDrawBuffersEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glFramebufferDrawBuffersEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glFramebufferDrawBuffersEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix2x3dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix2x3dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glIndexFormatNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexFormatNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIndexFormatNV", arg0, arg1);
    }
  }
  @Override
  public void glGetObjectParameterfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetObjectParameterfvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetObjectParameterfvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTextureParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetTextureParameterfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPerfMonitorCounterInfoAMD(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCounterInfoAMD(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetPerfMonitorCounterInfoAMD", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord1i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoord1i", arg0, arg1);
    }
  }
  @Override
  public void glVertex4fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex4fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glVertex4fv", arg1);
    }
  }
  @Override
  public void glDeleteLists(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteLists(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDeleteLists", arg0, arg1);
    }
  }
  @Override
  public void glGetQueryObjecti64v(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjecti64v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetQueryObjecti64v", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMaterialfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMaterialfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMaterialfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexAttribLi64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribLi64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetVertexAttribLi64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib2hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib2hv", arg0, arg1);
    }
  }
  @Override
  public void glVDPAUMapSurfacesNV(int arg0,com.jogamp.common.nio.PointerBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVDPAUMapSurfacesNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s)",
                   "glVDPAUMapSurfacesNV", arg0, arg1);
    }
  }
  @Override
  public void glMapGrid1f(int arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glMapGrid1f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glMapGrid1f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCopyConvolutionFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glCopyConvolutionFilter2D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyConvolutionFilter2D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glUniform2iv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform2iv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMaterialf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glMaterialf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glMaterialf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMapGrid1d(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glMapGrid1d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glMapGrid1d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetClipPlane(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetClipPlane(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetClipPlane", arg0, arg1);
    }
  }
  @Override
  public void glSecondaryColorFormatNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColorFormatNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glSecondaryColorFormatNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPixelMapusv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapusv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glGetPixelMapusv", arg0, arg2);
    }
  }
  @Override
  public void glPointParameteri(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPointParameteri(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glPointParameteri", arg0, arg1);
    }
  }
  @Override
  public void glBindTexture(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindTexture(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindTexture", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribLPointer(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribLPointer(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexAttribLPointer", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glSetLocalConstantEXT(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSetLocalConstantEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glSetLocalConstantEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribL1dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttribL1dv", arg0, arg2);
    }
  }
  @Override
  public void glGetQueryObjectiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetQueryObjectiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform2fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform2fvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDrawElementsInstancedBaseInstance(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstancedBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X)",
                   "glDrawElementsInstancedBaseInstance", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexArrayRangeNV(int arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayRangeNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexArrayRangeNV", arg0, arg1);
    }
  }
  @Override
  public void glBlendFuncSeparatei(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glBlendFuncSeparatei(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendFuncSeparatei", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glClearDepth(double arg0)
  {
    checkContext();
    downstreamGL4bc.glClearDepth(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s)",
                   "glClearDepth", arg0);
    }
  }
  @Override
  public void glProgramUniform3ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform3ui64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glBindFragDataLocationIndexed(int arg0,int arg1,int arg2,java.lang.String arg3)
  {
    checkContext();
    downstreamGL4bc.glBindFragDataLocationIndexed(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glBindFragDataLocationIndexed", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glBeginVertexShaderEXT()
  {
    checkContext();
    downstreamGL4bc.glBeginVertexShaderEXT();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glBeginVertexShaderEXT");
    }
  }
  @Override
  public void glGetPathMetricRangeNV(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetPathMetricRangeNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathMetricRangeNV", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glUniform2uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform2uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPathColorGenfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathColorGenfvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathColorGenfvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformMatrix2fvARB(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix2fvARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPixelTransformParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPixelTransformParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPixelTransformParameterivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetObjectPtrLabel(java.nio.Buffer arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetObjectPtrLabel(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetObjectPtrLabel", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetCompressedTexImage(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glGetCompressedTexImage(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glGetCompressedTexImage", arg0, arg1, arg2);
    }
  }
  @Override
  public void glBindFramebuffer(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindFramebuffer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindFramebuffer", arg0, arg1);
    }
  }
  @Override
  public void glFramebufferTextureLayerEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureLayerEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureLayerEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetPathSpacingNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,float arg5,float arg6,int arg7,java.nio.FloatBuffer arg8)
  {
    checkContext();
    downstreamGL4bc.glGetPathSpacingNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathSpacingNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glGetMapParameterivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMapParameterivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMapParameterivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetNamedStringARB(int arg0,java.lang.String arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedStringARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetNamedStringARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetVideoCaptureStreamivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureStreamivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVideoCaptureStreamivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramLocalParameterI4uivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameterI4uivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramLocalParameterI4uivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix3x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x2fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix3x2fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetBooleani_v(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetBooleani_v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetBooleani_v", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetMaterialfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMaterialfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMaterialfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform4uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform4uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetnPixelMapusv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetnPixelMapusv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glGetnPixelMapusv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glStencilOp(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glStencilOp(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glStencilOp", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribP4uiv(int arg0,int arg1,boolean arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP4uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.IntBuffer> %s)",
                   "glVertexAttribP4uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDeleteNamesAMD(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glDeleteNamesAMD(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteNamesAMD", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetMultiTexEnvfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexEnvfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMultiTexEnvfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSecondaryColor3uiv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glSecondaryColor3uiv", arg1);
    }
  }
  @Override
  public void glLoadMatrixf(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glLoadMatrixf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glLoadMatrixf", arg1);
    }
  }
  @Override
  public void glMultiTexCoord1bvOES(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1bvOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glMultiTexCoord1bvOES", arg0, arg2);
    }
  }
  @Override
  public void glGetQueryObjectui64vEXT(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectui64vEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetQueryObjectui64vEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCompileShaderIncludeARB(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glCompileShaderIncludeARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <java.nio.IntBuffer> %s)",
                   "glCompileShaderIncludeARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribI4ubvEXT(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ubvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttribI4ubvEXT", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix2fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix2fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVertexArrayBindVertexBufferEXT(int arg0,int arg1,int arg2,long arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayBindVertexBufferEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X)",
                   "glVertexArrayBindVertexBufferEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetInternalformativ(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetInternalformativ(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetInternalformativ", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public long glFenceSync(int arg0,int arg1)
  {
    checkContext();
    long _res = downstreamGL4bc.glFenceSync(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glFenceSync", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glMatrixLoadfEXT(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoadfEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMatrixLoadfEXT", arg0, arg1);
    }
  }
  @Override
  public long glGetTextureHandleNV(int arg0)
  {
    checkContext();
    long _res = downstreamGL4bc.glGetTextureHandleNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGetTextureHandleNV", arg0);
    }
    return _res;
  }
  @Override
  public void glUniform4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4d(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glUniform4d", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glBindVertexBuffer(int arg0,int arg1,long arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glBindVertexBuffer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X)",
                   "glBindVertexBuffer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetProgramSubroutineParameteruivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramSubroutineParameteruivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramSubroutineParameteruivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedProgramLocalParameterIivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetActiveSubroutineUniformiv(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetActiveSubroutineUniformiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetActiveSubroutineUniformiv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGenProgramsARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenProgramsARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenProgramsARB", arg0, arg2);
    }
  }
  @Override
  public void glEndOcclusionQueryNV()
  {
    checkContext();
    downstreamGL4bc.glEndOcclusionQueryNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEndOcclusionQueryNV");
    }
  }
  @Override
  public void glGetMultiTexGenivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexGenivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMultiTexGenivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glSecondaryColor3dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glSecondaryColor3dv", arg1);
    }
  }
  @Override
  public void glMakeBufferResidentNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMakeBufferResidentNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glMakeBufferResidentNV", arg0, arg1);
    }
  }
  @Override
  public void glTextureImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glTextureImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTextureImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
    checkContext();
    downstreamGL4bc.glTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexSubImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glMapVertexAttrib2fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,float arg6,float arg7,int arg8,int arg9,java.nio.FloatBuffer arg10)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib2fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMapVertexAttrib2fAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glGetMinmaxParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMinmaxParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMinmaxParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor4dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glColor4dv", arg1);
    }
  }
  @Override
  public void glVertexAttrib4hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4hv", arg0, arg2);
    }
  }
  @Override
  public void glNormal3b(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glNormal3b(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glNormal3b", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramLocalParametersI4ivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParametersI4ivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramLocalParametersI4ivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGenProgramPipelines(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenProgramPipelines(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenProgramPipelines", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI4bv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4bv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttribI4bv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix2x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x4fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix2x4fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glSetInvariantEXT(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSetInvariantEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glSetInvariantEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColorP4uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glColorP4uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glColorP4uiv", arg0, arg1);
    }
  }
  @Override
  public void glLoadName(int arg0)
  {
    checkContext();
    downstreamGL4bc.glLoadName(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glLoadName", arg0);
    }
  }
  @Override
  public void glConvolutionParameterf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glConvolutionParameterf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glConvolutionParameterf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMakeTextureHandleResidentNV(long arg0)
  {
    checkContext();
    downstreamGL4bc.glMakeTextureHandleResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glMakeTextureHandleResidentNV", arg0);
    }
  }
  @Override
  public void glGetActiveUniformName(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformName(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetActiveUniformName", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public boolean glIsProgramPipeline(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsProgramPipeline(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsProgramPipeline", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttrib1dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib1dv", arg0, arg1);
    }
  }
  @Override
  public void glPixelMapusv(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelMapusv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glPixelMapusv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord4hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord4hv", arg0);
    }
  }
  @Override
  public void glGetPathCommandsNV(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathCommandsNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetPathCommandsNV", arg0, arg2);
    }
  }
  @Override
  public void glGetVertexAttribfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetVertexAttribfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord1dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glTexCoord1dv", arg0);
    }
  }
  @Override
  public void glWindowPos3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glWindowPos3f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexAttribIuivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIuivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexAttribIuivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVDPAUGetSurfaceivNV(long arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glVDPAUGetSurfaceivNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glVDPAUGetSurfaceivNV", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public void glVDPAUGetSurfaceivNV(long arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glVDPAUGetSurfaceivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glVDPAUGetSurfaceivNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniform4fARB(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4fARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glUniform4fARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4uivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4uivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4uivARB", arg0, arg2);
    }
  }
  @Override
  public void glUniform2i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform2i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform2d(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glUniform2d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetnPixelMapuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetnPixelMapuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetnPixelMapuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform2f(int arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glUniform2f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNormal3bv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormal3bv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glNormal3bv", arg1);
    }
  }
  @Override
  public void glBegin(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBegin(arg0);
    insideBeginEndPair = true;
    // NOTE: can't check glGetError(); it's not allowed inside glBegin/glEnd pair
  }
  @Override
  public void glMultiTexCoord2fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexCoord2fv", arg0, arg2);
    }
  }
  @Override
  public int glGetUniformLocationARB(int arg0,java.lang.String arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetUniformLocationARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glGetUniformLocationARB", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glVertexArrayTexCoordOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayTexCoordOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayTexCoordOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetFramebufferParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetFramebufferParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetFramebufferParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public java.lang.Object getExtension(java.lang.String arg0)
  {
    return downstreamGL4bc.getExtension(arg0);
  }
  @Override
  public void glVertexAttribI2uivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2uivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI2uivEXT", arg0, arg2);
    }
  }
  @Override
  public void glVertex3hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertex3hv", arg1);
    }
  }
  @Override
  public void glGetPixelTransformParameterfvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPixelTransformParameterfvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPixelTransformParameterfvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribPointer(int arg0,int arg1,int arg2,boolean arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribPointer(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <long> %s)",
                   "glVertexAttribPointer", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVideoCaptureStreamParameterdvNV(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVideoCaptureStreamParameterdvNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glVideoCaptureStreamParameterdvNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetMapiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMapiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMapiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glSecondaryColor3ubv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3ubv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glSecondaryColor3ubv", arg0);
    }
  }
  @Override
  public void glVertexAttrib2fARB(int arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2fARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glVertexAttrib2fARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformHandleui64NV(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glUniformHandleui64NV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glUniformHandleui64NV", arg0, arg1);
    }
  }
  @Override
  public void glDrawElementsBaseVertex(int arg0,int arg1,int arg2,long arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsBaseVertex(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X)",
                   "glDrawElementsBaseVertex", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexSubImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glMultiTexCoord3bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glMultiTexCoord3bvOES", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexEnvfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexEnvfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexEnvfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribI3uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI3uiv", arg0, arg2);
    }
  }
  @Override
  public void glGetMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMultiTexParameterIuivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribLFormat(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribLFormat(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribLFormat", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSamplerParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glSamplerParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4Nusv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nusv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4Nusv", arg0, arg2);
    }
  }
  @Override
  public void glGetTextureParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTextureParameterIuivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glEnableVertexArrayAttribEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnableVertexArrayAttribEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnableVertexArrayAttribEXT", arg0, arg1);
    }
  }
  @Override
  public void glDeleteVertexShaderEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDeleteVertexShaderEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDeleteVertexShaderEXT", arg0);
    }
  }
  @Override
  public void glEnd()
  {
    checkContext();
    downstreamGL4bc.glEnd();
    insideBeginEndPair = false;
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEnd");
    }
  }
  @Override
  public void glGetProgramPipelineiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramPipelineiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramPipelineiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix3x4fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x4fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix3x4fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glMultiTexCoord3i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoord3i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexSubImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glVertexAttribIPointerEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribIPointerEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexAttribIPointerEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetPathCoordsNV(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathCoordsNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathCoordsNV", arg0, arg2);
    }
  }
  @Override
  public void glGetUniformiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetUniformiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord1iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoord1iv", arg0, arg1);
    }
  }
  @Override
  public void glMatrixRotatedEXT(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glMatrixRotatedEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glMatrixRotatedEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glIndexubv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glIndexubv", arg1);
    }
  }
  @Override
  public void glArrayElement(int arg0)
  {
    checkContext();
    downstreamGL4bc.glArrayElement(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glArrayElement", arg0);
    }
  }
  @Override
  public void glVertexAttribI3iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI3iv", arg0, arg1);
    }
  }
  @Override
  public void glShaderSourceARB(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glShaderSourceARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <java.nio.IntBuffer> %s)",
                   "glShaderSourceARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform4ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform4ui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEvalMesh2(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glEvalMesh2(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glEvalMesh2", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glDeleteFencesAPPLE(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteFencesAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteFencesAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glPixelDataRangeNV(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelDataRangeNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPixelDataRangeNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNormal3hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormal3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glNormal3hv", arg1);
    }
  }
  @Override
  public void glEvalMesh1(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glEvalMesh1(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glEvalMesh1", arg0, arg1, arg2);
    }
  }
  @Override
  public void glBindImageTexture(int arg0,int arg1,int arg2,boolean arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glBindImageTexture(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBindImageTexture", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertexAttribIFormat(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribIFormat(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribIFormat", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPointeri_vEXT(int arg0,int arg1,com.jogamp.common.nio.PointerBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPointeri_vEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s)",
                   "glGetPointeri_vEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord2dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMultiTexCoord2dv", arg0, arg2);
    }
  }
  @Override
  public void glVertex2dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glVertex2dv", arg0);
    }
  }
  @Override
  public void glBindSampler(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindSampler(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindSampler", arg0, arg1);
    }
  }
  @Override
  public void glProgramBufferParametersfvNV(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramBufferParametersfvNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramBufferParametersfvNV", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glLightModelfv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glLightModelfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glLightModelfv", arg0, arg1);
    }
  }
  @Override
  public void glCompressedMultiTexSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glCompressedMultiTexSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedMultiTexSubImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glClampColor(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glClampColor(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glClampColor", arg0, arg1);
    }
  }
  @Override
  public void glPathParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPathParameterivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glPathParameterivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetUniformivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetUniformivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMultiTexGenfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexGenfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMultiTexGenfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLightModelf(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glLightModelf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glLightModelf", arg0, arg1);
    }
  }
  @Override
  public int glGenPathsNV(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glGenPathsNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGenPathsNV", arg0);
    }
    return _res;
  }
  @Override
  public void glGetMapParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMapParameterfvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMapParameterfvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord4iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glTexCoord4iv", arg0);
    }
  }
  @Override
  public void glIndexsv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexsv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glIndexsv", arg0);
    }
  }
  @Override
  public void glTexCoord2s(short arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2s(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s)",
                   "glTexCoord2s", arg0, arg1);
    }
  }
  @Override
  public void glFogfv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glFogfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glFogfv", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribL4i64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL4i64vNV", arg0, arg2);
    }
  }
  @Override
  public void glGetMapdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMapdv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetMapdv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glColor3sv", arg0);
    }
  }
  @Override
  public void glFlushVertexArrayRangeNV()
  {
    checkContext();
    downstreamGL4bc.glFlushVertexArrayRangeNV();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glFlushVertexArrayRangeNV");
    }
  }
  @Override
  public void glTexCoord2d(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glTexCoord2d", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord2sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord2sv", arg0, arg2);
    }
  }
  @Override
  public void glScissorArrayv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glScissorArrayv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glScissorArrayv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord2f(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glTexCoord2f", arg0, arg1);
    }
  }
  @Override
  public void glPNTrianglesfATI(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPNTrianglesfATI(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glPNTrianglesfATI", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord2h(short arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2h(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s)",
                   "glTexCoord2h", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord1hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord1hv", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord2i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTexCoord2i", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glRasterPos3dv", arg0);
    }
  }
  @Override
  public void glViewportIndexedf(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glViewportIndexedf(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glViewportIndexedf", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4NsvARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NsvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4NsvARB", arg0, arg1);
    }
  }
  @Override
  public void glNormalPointer(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glNormalPointer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glNormalPointer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI3i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI3i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glShaderOp1EXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glShaderOp1EXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glShaderOp1EXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord4fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glTexCoord4fv", arg0);
    }
  }
  @Override
  public void glVertexAttribI3iEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3iEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI3iEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPixelStorei(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPixelStorei(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glPixelStorei", arg0, arg1);
    }
  }
  @Override
  public void glTexGeniv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexGeniv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexGeniv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformSubroutinesuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformSubroutinesuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniformSubroutinesuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform4dv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glUniform4dv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCopyBufferSubData(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glCopyBufferSubData(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glCopyBufferSubData", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetnPolygonStipple(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetnPolygonStipple(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetnPolygonStipple", arg0, arg2);
    }
  }
  @Override
  public void glTextureBufferEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureBufferEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureBufferEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glNamedProgramLocalParameterI4ivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameterI4ivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glNamedProgramLocalParameterI4ivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetActiveSubroutineName(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,java.nio.ByteBuffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetActiveSubroutineName(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveSubroutineName", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColor4fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glColor4fv", arg1);
    }
  }
  @Override
  public void glUniformMatrix3dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix3dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public boolean glIsEnabledi(int arg0,int arg1)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsEnabledi(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIsEnabledi", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glGetIntegerIndexedv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerIndexedv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetIntegerIndexedv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeleteSamplers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteSamplers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteSamplers", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib1dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1dvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib1dvARB", arg0, arg1);
    }
  }
  @Override
  public void glObjectLabel(int arg0,int arg1,int arg2,byte[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glObjectLabel(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glObjectLabel", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glSwizzleEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glSwizzleEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glSwizzleEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTexCoord4bvOES(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4bvOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glTexCoord4bvOES", arg0);
    }
  }
  @Override
  public void glReadnPixels(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glReadnPixels(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glReadnPixels", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glGetBufferParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetBufferParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetBufferParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCoverStrokePathNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glCoverStrokePathNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glCoverStrokePathNV", arg0, arg1);
    }
  }
  @Override
  public void glPixelTransformParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPixelTransformParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glPixelTransformParameterivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glIndexPointer(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glIndexPointer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glIndexPointer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord1bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glTexCoord1bvOES", arg1);
    }
  }
  @Override
  public void glDrawBuffer(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDrawBuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDrawBuffer", arg0);
    }
  }
  @Override
  public void glTexCoord2hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord2hv", arg1);
    }
  }
  @Override
  public void glVertexAttrib4NubvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NubvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4NubvARB", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexParameterfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix3x4fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x4fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix3x4fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetBooleanIndexedv(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetBooleanIndexedv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetBooleanIndexedv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertex3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glVertex3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glVertex3f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTextureSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glTextureSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTextureSubImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glMultiTexCoordP4ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP4ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoordP4ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glHistogram(int arg0,int arg1,int arg2,boolean arg3)
  {
    checkContext();
    downstreamGL4bc.glHistogram(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glHistogram", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPrimitiveRestartIndexNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPrimitiveRestartIndexNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPrimitiveRestartIndexNV", arg0);
    }
  }
  @Override
  public void glVertexAttrib2svARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2svARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib2svARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI1i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI1i", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix4x2dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix4x2dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glCopyTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glCopyTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTexSubImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glColor3uiv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3uiv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glColor3uiv", arg0);
    }
  }
  @Override
  public void glTextureParameteriEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureParameteriEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureParameteriEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib3fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3fvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib3fvARB", arg0, arg1);
    }
  }
  @Override
  public int glCreateShaderObjectARB(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glCreateShaderObjectARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCreateShaderObjectARB", arg0);
    }
    return _res;
  }
  @Override
  public void glFogiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glFogiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glFogiv", arg0, arg1);
    }
  }
  @Override
  public void glUniformMatrix2x3fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x3fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix2x3fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPixelMapuiv(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelMapuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glPixelMapuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexWeighthv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexWeighthv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertexWeighthv", arg0);
    }
  }
  @Override
  public void glWindowPos3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glWindowPos3iv", arg1);
    }
  }
  @Override
  public void glMultiTexCoord4bOES(int arg0,byte arg1,byte arg2,byte arg3,byte arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4bOES(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <byte> %s, <byte> %s, <byte> %s, <byte> %s)",
                   "glMultiTexCoord4bOES", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glResumeTransformFeedback()
  {
    checkContext();
    downstreamGL4bc.glResumeTransformFeedback();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glResumeTransformFeedback");
    }
  }
  @Override
  public void glCopyTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glCopyTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTexSubImage1D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTexCoordPointer(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoordPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glTexCoordPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPathParameterivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathParameterivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPathParameterivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFinishTextureSUNX()
  {
    checkContext();
    downstreamGL4bc.glFinishTextureSUNX();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glFinishTextureSUNX");
    }
  }
  @Override
  public void glVertexAttribI1uiEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1uiEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI1uiEXT", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix2dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix2dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glProgramLocalParameterI4ivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameterI4ivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramLocalParameterI4ivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glVertex3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glVertex3s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramEnvParameter4fARB(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameter4fARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glProgramEnvParameter4fARB", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glCompressedTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glCompressedTexImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glTexCoord3bOES(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3bOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glTexCoord3bOES", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEnableClientStateIndexedEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnableClientStateIndexedEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnableClientStateIndexedEXT", arg0, arg1);
    }
  }
  @Override
  public void glEnableIndexed(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnableIndexed(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnableIndexed", arg0, arg1);
    }
  }
  @Override
  public void glGetUniformIndices(int arg0,int arg1,java.lang.String[] arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformIndices(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <java.nio.IntBuffer> %s)",
                   "glGetUniformIndices", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPolygonOffset(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPolygonOffset(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glPolygonOffset", arg0, arg1);
    }
  }
  @Override
  public void glMatrixOrthoEXT(int arg0,double arg1,double arg2,double arg3,double arg4,double arg5,double arg6)
  {
    checkContext();
    downstreamGL4bc.glMatrixOrthoEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glMatrixOrthoEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertex3h(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glVertex3h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glVertex3h", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib2fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib2fv", arg0, arg1);
    }
  }
  @Override
  public void glSamplerParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterIiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glSamplerParameterIiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glClipPlanef(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glClipPlanef(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glClipPlanef", arg0, arg1);
    }
  }
  @Override
  public void glVariantivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVariantivEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetRenderbufferParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetRenderbufferParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetRenderbufferParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex4dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glVertex4dv", arg1);
    }
  }
  @Override
  public void glUniformMatrix4x3dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x3dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix4x3dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLightModeliv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glLightModeliv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glLightModeliv", arg0, arg1);
    }
  }
  @Override
  public void glClearBufferSubData(int arg0,int arg1,long arg2,long arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glClearBufferSubData(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glClearBufferSubData", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glPopMatrix()
  {
    checkContext();
    downstreamGL4bc.glPopMatrix();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPopMatrix");
    }
  }
  @Override
  public void glTexGenfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexGenfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glTexGenfv", arg0, arg1, arg2);
    }
  }
  @Override
  public long glVDPAURegisterOutputSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterOutputSurfaceNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glVDPAURegisterOutputSurfaceNV", arg0, arg1, arg2, arg4);
    }
    return _res;
  }
  @Override
  public void glViewportIndexedfv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glViewportIndexedfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glViewportIndexedfv", arg0, arg1);
    }
  }
  @Override
  public void glFramebufferTextureFaceARB(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureFaceARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureFaceARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glLoadMatrixd(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glLoadMatrixd(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glLoadMatrixd", arg1);
    }
  }
  @Override
  public void glScalef(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glScalef(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glScalef", arg0, arg1, arg2);
    }
  }
  @Override
  public void glStencilClearTagEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glStencilClearTagEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glStencilClearTagEXT", arg0, arg1);
    }
  }
  @Override
  public void glTexRenderbufferNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexRenderbufferNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTexRenderbufferNV", arg0, arg1);
    }
  }
  @Override
  public void glVDPAUSurfaceAccessNV(long arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVDPAUSurfaceAccessNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X)",
                   "glVDPAUSurfaceAccessNV", arg0, arg1);
    }
  }
  @Override
  public void glCompressedTexImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glCompressedTexImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glGetPerfMonitorGroupStringAMD(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorGroupStringAMD(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetPerfMonitorGroupStringAMD", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord1iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glTexCoord1iv", arg1);
    }
  }
  @Override
  public void glVertexAttrib3s(int arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3s(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s)",
                   "glVertexAttrib3s", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetTextureLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTextureLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTextureLevelParameterivEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttribs3hv(int arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs3hv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribs3hv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetOcclusionQueryuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetOcclusionQueryuivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetOcclusionQueryuivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI2ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI2ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEdgeFlagPointer(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glEdgeFlagPointer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glEdgeFlagPointer", arg0, arg1);
    }
  }
  @Override
  public void glGetVariantFloatvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVariantFloatvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetVariantFloatvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTexParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetTexParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMinmax(int arg0,boolean arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMinmax(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetMinmax", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramEnvParameterI4iNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameterI4iNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramEnvParameterI4iNV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetBufferSubData(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetBufferSubData(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <java.nio.Buffer> %s)",
                   "glGetBufferSubData", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord3h(int arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3h(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s)",
                   "glMultiTexCoord3h", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4dARB(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4dARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glVertexAttrib4dARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultTransposeMatrixf(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMultTransposeMatrixf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glMultTransposeMatrixf", arg1);
    }
  }
  @Override
  public boolean glIsPointInStrokePathNV(int arg0,float arg1,float arg2)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsPointInStrokePathNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glIsPointInStrokePathNV", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glUniform1fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform1fvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniformHandleui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformHandleui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniformHandleui64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib3h(int arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3h(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s)",
                   "glVertexAttrib3h", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glFlushMappedBufferRange(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glFlushMappedBufferRange(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glFlushMappedBufferRange", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean isNPOTTextureAvailable()
  {
    return downstreamGL4bc.isNPOTTextureAvailable();
  }
  @Override
  public void glDeleteQueries(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteQueries(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteQueries", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexAttribIiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3s(int arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3s(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s)",
                   "glMultiTexCoord3s", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSecondaryColor3usv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3usv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glSecondaryColor3usv", arg1);
    }
  }
  @Override
  public void glCompressedTextureSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glCompressedTextureSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTextureSubImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glProgramUniform1uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1uivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform1uivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniform3iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3iv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform3iv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetnColorTable(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnColorTable(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetnColorTable", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glBindTransformFeedback(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindTransformFeedback(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindTransformFeedback", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix4x2fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x2fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix4x2fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public int glGenVertexShadersEXT(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glGenVertexShadersEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGenVertexShadersEXT", arg0);
    }
    return _res;
  }
  @Override
  public void glGetProgramInfoLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramInfoLog(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetProgramInfoLog", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribIFormatNV(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribIFormatNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribIFormatNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCopyPathNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glCopyPathNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glCopyPathNV", arg0, arg1);
    }
  }
  @Override
  public void glCopyImageSubDataNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,int arg11,int arg12,int arg13,int arg14)
  {
    checkContext();
    downstreamGL4bc.glCopyImageSubDataNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyImageSubDataNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }
  }
  @Override
  public boolean glIsPointInFillPathNV(int arg0,int arg1,float arg2,float arg3)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsPointInFillPathNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s)",
                   "glIsPointInFillPathNV", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public void glUniformMatrix2x4fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix2x4fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib1s(int arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1s(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s)",
                   "glVertexAttrib1s", arg0, arg1);
    }
  }
  @Override
  public void glGetTransformFeedbackVarying(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glGetTransformFeedbackVarying(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetTransformFeedbackVarying", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glPixelTransformParameterfvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPixelTransformParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPixelTransformParameterfvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMakeImageHandleResidentNV(long arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMakeImageHandleResidentNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X)",
                   "glMakeImageHandleResidentNV", arg0, arg1);
    }
  }
  @Override
  public boolean glIsTransformFeedback(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsTransformFeedback(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsTransformFeedback", arg0);
    }
    return _res;
  }
  @Override
  public void glProgramUniform1iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform1iv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultMatrixd(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glMultMatrixd(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glMultMatrixd", arg0);
    }
  }
  @Override
  public void glGetLocalConstantBooleanvEXT(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetLocalConstantBooleanvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetLocalConstantBooleanvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetInteger64i_v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetInteger64i_v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetInteger64i_v", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glIsQuery(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsQuery(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsQuery", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttribFormatNV(int arg0,int arg1,int arg2,boolean arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribFormatNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexAttribFormatNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glFogCoorddv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFogCoorddv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glFogCoorddv", arg1);
    }
  }
  @Override
  public void glVertex3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertex3sv", arg1);
    }
  }
  @Override
  public void glGetLightfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetLightfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetLightfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetVertexArrayIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexArrayIntegervEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexArrayIntegervEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetColorTableParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetColorTableParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetColorTableParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glLightfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glLightfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glLightfv", arg0, arg1, arg3);
    }
  }
  @Override
  public boolean glIsEnabledIndexed(int arg0,int arg1)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsEnabledIndexed(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIsEnabledIndexed", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glBlendFuncIndexedAMD(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBlendFuncIndexedAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendFuncIndexedAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramEnvParametersI4ivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParametersI4ivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramEnvParametersI4ivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib1h(int arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1h(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s)",
                   "glVertexAttrib1h", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib4bvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4bvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4bvARB", arg0, arg1);
    }
  }
  @Override
  public void glColorPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glColorPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glColorPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRasterPos3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glRasterPos3sv", arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix4dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix4dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glFramebufferReadBufferEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFramebufferReadBufferEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glFramebufferReadBufferEXT", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord1f(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glMultiTexCoord1f", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix2x4fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix2x4fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void setSwapInterval(int arg0)
  {
    downstreamGL4bc.setSwapInterval(arg0);
  }
  @Override
  public void glMultiTexGendEXT(int arg0,int arg1,int arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGendEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <double> %s)",
                   "glMultiTexGendEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glFinishFenceNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glFinishFenceNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glFinishFenceNV", arg0);
    }
  }
  @Override
  public void glVertexAttribI2uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI2uiv", arg0, arg1);
    }
  }
  @Override
  public void glIndexiv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexiv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glIndexiv", arg0);
    }
  }
  @Override
  public void glUniform3uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform3uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetnUniformfv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformfv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetnUniformfv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib3dARB(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3dARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glVertexAttrib3dARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMateriali(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMateriali(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMateriali", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPointParameterf(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPointParameterf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glPointParameterf", arg0, arg1);
    }
  }
  @Override
  public void glBlendEquation(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBlendEquation(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBlendEquation", arg0);
    }
  }
  @Override
  public void glGetNamedFramebufferAttachmentParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedFramebufferAttachmentParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedFramebufferAttachmentParameterivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniform3d(int arg0,int arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3d(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glProgramUniform3d", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib3sARB(int arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3sARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s)",
                   "glVertexAttrib3sARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetVariantBooleanvEXT(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVariantBooleanvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetVariantBooleanvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramLocalParameterI4uiNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameterI4uiNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramLocalParameterI4uiNV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glUniform2dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glUniform2dv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glBeginVideoCaptureNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBeginVideoCaptureNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBeginVideoCaptureNV", arg0);
    }
  }
  @Override
  public boolean glIsPathNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsPathNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsPathNV", arg0);
    }
    return _res;
  }
  @Override
  public void glConvolutionFilter1D(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glConvolutionFilter1D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glConvolutionFilter1D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetVideoCaptureivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVideoCaptureivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib3dvARB(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3dvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib3dvARB", arg0, arg2);
    }
  }
  @Override
  public void glDepthRangeArrayv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glDepthRangeArrayv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glDepthRangeArrayv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetFloatv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFloatv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetFloatv", arg0, arg2);
    }
  }
  @Override
  public void glSelectPerfMonitorCountersAMD(int arg0,boolean arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glSelectPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glSelectPerfMonitorCountersAMD", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glProgramUniform4iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform4iv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexParameterfEXT(int arg0,int arg1,int arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterfEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glMultiTexParameterfEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public boolean isFunctionAvailable(java.lang.String arg0)
  {
    return downstreamGL4bc.isFunctionAvailable(arg0);
  }
  @Override
  public void glVertexAttrib4dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib4dv", arg0, arg2);
    }
  }
  @Override
  public void glCoverFillPathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,java.nio.FloatBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glCoverFillPathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glCoverFillPathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glWindowPos3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glWindowPos3sv", arg0);
    }
  }
  @Override
  public void glReadBuffer(int arg0)
  {
    checkContext();
    downstreamGL4bc.glReadBuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glReadBuffer", arg0);
    }
  }
  @Override
  public java.nio.ByteBuffer glMapNamedBufferEXT(int arg0,int arg1)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapNamedBufferEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glMapNamedBufferEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glGenQueries(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenQueries(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenQueries", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform2uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2uivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform2uivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glTexCoord4dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glTexCoord4dv", arg1);
    }
  }
  @Override
  public void glTexImage2DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5)
  {
    checkContext();
    downstreamGL4bc.glTexImage2DMultisample(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTexImage2DMultisample", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexAttrib3fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib3fv", arg0, arg2);
    }
  }
  @Override
  public void glGetInvariantIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetInvariantIntegervEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetInvariantIntegervEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribIPointer(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribIPointer(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexAttribIPointer", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glBlendEquationSeparate(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBlendEquationSeparate(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBlendEquationSeparate", arg0, arg1);
    }
  }
  @Override
  public void glGetTexParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTexParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3f(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glMultiTexCoord3f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glTexCoord3fv", arg1);
    }
  }
  @Override
  public void glObjectPtrLabel(java.nio.Buffer arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glObjectPtrLabel(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glObjectPtrLabel", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCurrentPaletteMatrix(int arg0)
  {
    checkContext();
    downstreamGL4bc.glCurrentPaletteMatrix(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCurrentPaletteMatrix", arg0);
    }
  }
  @Override
  public void glVertexAttrib3f(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glVertexAttrib3f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetTexParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameterIuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTexParameterIuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexAttribIivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexAttribIivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTexGeniv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexGeniv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTexGeniv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform2i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform2i64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glNamedProgramStringEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramStringEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glNamedProgramStringEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetMultiTexLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMultiTexLevelParameterivEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public int glBindParameterEXT(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glBindParameterEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBindParameterEXT", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttribI1uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1uivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI1uivEXT", arg0, arg1);
    }
  }
  @Override
  public void glBindBuffer(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindBuffer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindBuffer", arg0, arg1);
    }
  }
  @Override
  public void glGetPerfMonitorCountersAMD(int arg0,java.nio.IntBuffer arg1,java.nio.IntBuffer arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPerfMonitorCountersAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glInitNames()
  {
    checkContext();
    downstreamGL4bc.glInitNames();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glInitNames");
    }
  }
  @Override
  public void glGetVertexAttribLui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribLui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetVertexAttribLui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord4dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMultiTexCoord4dv", arg0, arg1);
    }
  }
  @Override
  public void glSecondaryColor3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glSecondaryColor3fv", arg1);
    }
  }
  @Override
  public void glVertexAttribL3dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttribL3dv", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribP2ui(int arg0,int arg1,boolean arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP2ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexAttribP2ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDisableVariantClientStateEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDisableVariantClientStateEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDisableVariantClientStateEXT", arg0);
    }
  }
  @Override
  public boolean glIsBuffer(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsBuffer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsBuffer", arg0);
    }
    return _res;
  }
  @Override
  public void glProgramBufferParametersIuivNV(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramBufferParametersIuivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramBufferParametersIuivNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexCoord1h(int arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1h(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s)",
                   "glMultiTexCoord1h", arg0, arg1);
    }
  }
  @Override
  public void glIndexfv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexfv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glIndexfv", arg0);
    }
  }
  @Override
  public void glVertexAttribL2d(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glVertexAttribL2d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetActiveUniform(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniform(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveUniform", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glMap2f(int arg0,float arg1,float arg2,int arg3,int arg4,float arg5,float arg6,int arg7,int arg8,float[] arg9,int arg10)
  {
    checkContext();
    downstreamGL4bc.glMap2f(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMap2f", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg10);
    }
  }
  @Override
  public void glDeleteFramebuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteFramebuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteFramebuffers", arg0, arg2);
    }
  }
  @Override
  public void glColor3usv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3usv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glColor3usv", arg0);
    }
  }
  @Override
  public void glRasterPos4sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glRasterPos4sv", arg0);
    }
  }
  @Override
  public void glUniform2ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2ivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform2ivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeleteShader(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDeleteShader(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDeleteShader", arg0);
    }
  }
  @Override
  public void glGetBufferParameterui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetBufferParameterui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetBufferParameterui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEnable(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEnable(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEnable", arg0);
    }
  }
  @Override
  public void glGetMultiTexGendvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexGendvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetMultiTexGendvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib1f(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glVertexAttrib1f", arg0, arg1);
    }
  }
  @Override
  public void glPointParameterfv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glPointParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glPointParameterfv", arg0, arg2);
    }
  }
  @Override
  public void glConvolutionParameteri(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glConvolutionParameteri(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glConvolutionParameteri", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform4fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramUniform4fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDrawElementsInstancedBaseVertex(int arg0,int arg1,int arg2,long arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstancedBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X, <int> 0x%X)",
                   "glDrawElementsInstancedBaseVertex", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glDrawElementsInstanced(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstanced(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glDrawElementsInstanced", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glPathFogGenNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPathFogGenNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPathFogGenNV", arg0);
    }
  }
  @Override
  public void glTexCoord4i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexCoord4i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColorTable(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glColorTable(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glColorTable", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glUniform4fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform4fvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDrawTransformFeedbackStream(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawTransformFeedbackStream(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawTransformFeedbackStream", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib2sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib2sv", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord4h(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4h(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glTexCoord4h", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public long glVDPAURegisterVideoSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterVideoSurfaceNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVDPAURegisterVideoSurfaceNV", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public int glGetDebugMessageLogAMD(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5,int[] arg6,int arg7,int[] arg8,int arg9,byte[] arg10,int arg11)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLogAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetDebugMessageLogAMD", arg0, arg1, arg3, arg5, arg7, arg9, arg11);
    }
    return _res;
  }
  @Override
  public void glTexCoord4f(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glTexCoord4f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetIntegeri_v(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetIntegeri_v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetIntegeri_v", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord4d(double arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s)",
                   "glTexCoord4d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord1s(int arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1s(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s)",
                   "glMultiTexCoord1s", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform2i64NV(int arg0,int arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2i64NV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glProgramUniform2i64NV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPixelMapuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPixelMapuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glPixelMapuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCullParameterdvEXT(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glCullParameterdvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glCullParameterdvEXT", arg0, arg2);
    }
  }
  @Override
  public void glColor3hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glColor3hv", arg0);
    }
  }
  @Override
  public void glGetActiveUniformBlockName(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformBlockName(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveUniformBlockName", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glWindowPos3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glWindowPos3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformBufferEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glUniformBufferEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniformBufferEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetObjectLabel(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetObjectLabel(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetObjectLabel", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public void glMap1f(int arg0,float arg1,float arg2,int arg3,int arg4,float[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glMap1f(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMap1f", arg0, arg1, arg2, arg3, arg4, arg6);
    }
  }
  @Override
  public void glTexCoord4s(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4s(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glTexCoord4s", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLoadTransposeMatrixf(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glLoadTransposeMatrixf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glLoadTransposeMatrixf", arg1);
    }
  }
  @Override
  public void glNamedRenderbufferStorageMultisampleEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedRenderbufferStorageMultisampleEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedRenderbufferStorageMultisampleEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public int glGetDebugMessageLog(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5,int[] arg6,int arg7,int[] arg8,int arg9,int[] arg10,int arg11,byte[] arg12,int arg13)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetDebugMessageLog(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetDebugMessageLog", arg0, arg1, arg3, arg5, arg7, arg9, arg11, arg13);
    }
    return _res;
  }
  @Override
  public void glVertexAttribL3ui64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL3ui64vNV", arg0, arg2);
    }
  }
  @Override
  public void glEvalPoint1(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalPoint1(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEvalPoint1", arg0);
    }
  }
  @Override
  public void glVertexAttribL2i64NV(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2i64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glVertexAttribL2i64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glClearColorIui(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glClearColorIui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glClearColorIui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glNormal3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormal3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glNormal3sv", arg1);
    }
  }
  @Override
  public void glClearBufferiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glClearBufferiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glClearBufferiv", arg0, arg1, arg3);
    }
  }
  @Override
  public int glGetUniformBlockIndex(int arg0,java.lang.String arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetUniformBlockIndex(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glGetUniformBlockIndex", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glRasterPos2iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glRasterPos2iv", arg1);
    }
  }
  @Override
  public void glVertexAttribI4bvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4bvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttribI4bvEXT", arg0, arg1);
    }
  }
  @Override
  public void glMatrixMultdEXT(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultdEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMatrixMultdEXT", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix2x4dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix2x4dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4NivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4NivARB", arg0, arg2);
    }
  }
  @Override
  public void glDeleteFencesNV(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteFencesNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteFencesNV", arg0, arg1);
    }
  }
  @Override
  public void glVertex2sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertex2sv", arg0);
    }
  }
  @Override
  public void glUniform1iv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform1iv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetQueryObjectui64v(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectui64v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetQueryObjectui64v", arg0, arg1, arg3);
    }
  }
  @Override
  public float glGetPathLengthNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    float _res = downstreamGL4bc.glGetPathLengthNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glGetPathLengthNV", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glVertexP2uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexP2uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexP2uiv", arg0, arg1);
    }
  }
  @Override
  public void glVertex3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glVertex3fv", arg1);
    }
  }
  @Override
  public void glGetVertexAttribdvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribdvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetVertexAttribdvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetShaderPrecisionFormat(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetShaderPrecisionFormat(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetShaderPrecisionFormat", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGetShaderPrecisionFormat(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetShaderPrecisionFormat(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glGetShaderPrecisionFormat", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribI4uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI4uiv", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord4bOES(byte arg0,byte arg1,byte arg2,byte arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4bOES(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s, <byte> %s)",
                   "glTexCoord4bOES", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord1hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord1hv", arg0);
    }
  }
  @Override
  public void glTexCoord3bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glTexCoord3bvOES", arg1);
    }
  }
  @Override
  public void glRasterPos2sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glRasterPos2sv", arg0);
    }
  }
  @Override
  public void glIndexdv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexdv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glIndexdv", arg0);
    }
  }
  @Override
  public void glPathCommandsNV(int arg0,int arg1,java.nio.ByteBuffer arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glPathCommandsNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPathCommandsNV", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glWindowPos3d(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glWindowPos3d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMultisamplefvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultisamplefvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMultisamplefvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetActiveUniformARB(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4,java.nio.IntBuffer arg5,java.nio.ByteBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformARB(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveUniformARB", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertexAttrib1hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib1hv", arg0, arg1);
    }
  }
  @Override
  public void glGetProgramivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeleteProgramPipelines(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteProgramPipelines(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteProgramPipelines", arg0, arg2);
    }
  }
  @Override
  public void glRasterPos4fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glRasterPos4fv", arg1);
    }
  }
  @Override
  public void glMaterialiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMaterialiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMaterialiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix2x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x3fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix2x3fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glCompressedTexImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTexImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public boolean glTestFenceNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glTestFenceNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glTestFenceNV", arg0);
    }
    return _res;
  }
  @Override
  public void glProgramParameteriARB(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramParameteriARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramParameteriARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetNamedProgramivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedProgramivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTextureSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glTextureSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTextureSubImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glMatrixIndexusvARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexusvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMatrixIndexusvARB", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord4fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexCoord4fv", arg0, arg1);
    }
  }
  @Override
  public void glUniformMatrix3x2fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x2fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix3x2fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor4bv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4bv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glColor4bv", arg1);
    }
  }
  @Override
  public void glSyncTextureINTEL(int arg0)
  {
    checkContext();
    downstreamGL4bc.glSyncTextureINTEL(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glSyncTextureINTEL", arg0);
    }
  }
  @Override
  public void glColor4hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glColor4hv", arg1);
    }
  }
  @Override
  public void glBeginQuery(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBeginQuery(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBeginQuery", arg0, arg1);
    }
  }
  @Override
  public void glTessellationFactorAMD(float arg0)
  {
    checkContext();
    downstreamGL4bc.glTessellationFactorAMD(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glTessellationFactorAMD", arg0);
    }
  }
  @Override
  public void glRasterPos3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glRasterPos3iv", arg0);
    }
  }
  @Override
  public boolean glIsVertexArray(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsVertexArray(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsVertexArray", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttribI4iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI4iv", arg0, arg1);
    }
  }
  @Override
  public void glGetShaderInfoLog(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetShaderInfoLog(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetShaderInfoLog", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glColor3dv", arg0);
    }
  }
  @Override
  public void glColorP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glColorP3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glColorP3uiv", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib2sARB(int arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2sARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s)",
                   "glVertexAttrib2sARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI4ivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI4ivEXT", arg0, arg2);
    }
  }
  @Override
  public boolean glIsVariantEnabledEXT(int arg0,int arg1)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsVariantEnabledEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIsVariantEnabledEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glPathParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPathParameterfvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPathParameterfvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glStencilStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,float[] arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glStencilStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glStencilStrokePathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg8);
    }
  }
  @Override
  public void glGetShaderSource(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetShaderSource(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetShaderSource", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glVertex2iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glVertex2iv", arg0);
    }
  }
  @Override
  public void glVertexAttrib4fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib4fv", arg0, arg2);
    }
  }
  @Override
  public void glSetMultisamplefvAMD(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glSetMultisamplefvAMD(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glSetMultisamplefvAMD", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTextureStorage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glTextureStorage2D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureStorage2D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexAttribL1i64NV(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1i64NV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glVertexAttribL1i64NV", arg0, arg1);
    }
  }
  @Override
  public void glWindowPos2dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glWindowPos2dv", arg1);
    }
  }
  @Override
  public void glMapParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMapParameterivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMapParameterivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniformMatrix4x2fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix4x2fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glPixelTransferf(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPixelTransferf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glPixelTransferf", arg0, arg1);
    }
  }
  @Override
  public void glGetDoublei_vEXT(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetDoublei_vEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetDoublei_vEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribL3ui64NV(int arg0,long arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3ui64NV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glVertexAttribL3ui64NV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetShaderiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetShaderiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetShaderiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glClearIndex(float arg0)
  {
    checkContext();
    downstreamGL4bc.glClearIndex(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glClearIndex", arg0);
    }
  }
  @Override
  public void glUniform1ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1ivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform1ivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultiTexCoord2hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord2hv", arg0, arg2);
    }
  }
  @Override
  public void glGetNamedBufferParameterui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedBufferParameterui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetNamedBufferParameterui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDeleteOcclusionQueriesNV(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteOcclusionQueriesNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteOcclusionQueriesNV", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribI3ui(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI3ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCompressedTexImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTexImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glNamedProgramLocalParameter4dvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameter4dvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glNamedProgramLocalParameter4dvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex4hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex4hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertex4hv", arg1);
    }
  }
  @Override
  public void glTexImage3DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
    checkContext();
    downstreamGL4bc.glTexImage3DMultisample(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTexImage3DMultisample", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glUniform4i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform4i64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPatchParameterfv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glPatchParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glPatchParameterfv", arg0, arg2);
    }
  }
  @Override
  public void glFramebufferTexture3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTexture3D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTexture3D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetDoubleIndexedvEXT(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetDoubleIndexedvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetDoubleIndexedvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib4ubv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4ubv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4ubv", arg0, arg2);
    }
  }
  @Override
  public void glNamedProgramLocalParametersI4uivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParametersI4uivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glNamedProgramLocalParametersI4uivEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glBeginQueryIndexed(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBeginQueryIndexed(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBeginQueryIndexed", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoordPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glTexCoordPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexCoordPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetProgramLocalParameterIivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterIivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramLocalParameterIivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexParameterivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public boolean glIsEnabled(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsEnabled(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsEnabled", arg0);
    }
    return _res;
  }
  @Override
  public void glWriteMaskEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glWriteMaskEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glWriteMaskEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glProgramUniformMatrix4x3fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x3fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix4x3fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glNamedFramebufferRenderbufferEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferRenderbufferEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferRenderbufferEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramLocalParameters4fvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glNormalPointer(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glNormalPointer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glNormalPointer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexArrayIntegeri_vEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexArrayIntegeri_vEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexArrayIntegeri_vEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix4fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix4fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glStencilMaskSeparate(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glStencilMaskSeparate(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glStencilMaskSeparate", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glMultiTexImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glVertexAttrib4Nsv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nsv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4Nsv", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI4sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribI4sv", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexParameterIuivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetQueryObjectuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetQueryObjectuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4Nubv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4Nubv", arg0, arg1);
    }
  }
  @Override
  public void glNormal3dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormal3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glNormal3dv", arg1);
    }
  }
  @Override
  public void glSampleMaskIndexedNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSampleMaskIndexedNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glSampleMaskIndexedNV", arg0, arg1);
    }
  }
  @Override
  public void glTexStorage3DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
    checkContext();
    downstreamGL4bc.glTexStorage3DMultisample(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTexStorage3DMultisample", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glUniform1ui64NV(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1ui64NV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glUniform1ui64NV", arg0, arg1);
    }
  }
  @Override
  public void glVertexP2ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexP2ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexP2ui", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform3i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3i(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform3i", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glSamplerParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glSamplerParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glWeightbvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightbvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glWeightbvARB", arg0, arg2);
    }
  }
  @Override
  public void glSecondaryColor3bv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3bv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glSecondaryColor3bv", arg1);
    }
  }
  @Override
  public void glVideoCaptureStreamParameterivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVideoCaptureStreamParameterivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVideoCaptureStreamParameterivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoordP4uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexCoordP4uiv", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribI1ivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1ivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI1ivEXT", arg0, arg2);
    }
  }
  @Override
  public void glEvalCoord1d(double arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord1d(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s)",
                   "glEvalCoord1d", arg0);
    }
  }
  @Override
  public void glGenNamesAMD(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGenNamesAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenNamesAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramEnvParameterI4uivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameterI4uivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramEnvParameterI4uivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPushClientAttribDefaultEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPushClientAttribDefaultEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPushClientAttribDefaultEXT", arg0);
    }
  }
  @Override
  public void glGenTransformFeedbacks(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenTransformFeedbacks(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenTransformFeedbacks", arg0, arg2);
    }
  }
  @Override
  public void glShaderBinary(int arg0,int[] arg1,int arg2,int arg3,java.nio.Buffer arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glShaderBinary(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glShaderBinary", arg0, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColor4ubv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4ubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glColor4ubv", arg1);
    }
  }
  @Override
  public void glVertexAttrib4usvARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4usvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4usvARB", arg0, arg1);
    }
  }
  @Override
  public void glGetSamplerParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameterIuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetSamplerParameterIuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUnmapTexture2DINTEL(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glUnmapTexture2DINTEL(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glUnmapTexture2DINTEL", arg0, arg1);
    }
  }
  @Override
  public void glPixelMapfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPixelMapfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPixelMapfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform2fARB(int arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2fARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glUniform2fARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetSynciv(long arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetSynciv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glGetSynciv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetSynciv(long arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetSynciv(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetSynciv", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public void glGetTextureImageEXT(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetTextureImageEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetTextureImageEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColor3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glColor3iv", arg1);
    }
  }
  @Override
  public void glCompressedMultiTexImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glCompressedMultiTexImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedMultiTexImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glColorMaskIndexed(int arg0,boolean arg1,boolean arg2,boolean arg3,boolean arg4)
  {
    checkContext();
    downstreamGL4bc.glColorMaskIndexed(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <boolean> %s, <boolean> %s, <boolean> %s)",
                   "glColorMaskIndexed", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glTexCoordP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTexCoordP3uiv", arg0, arg1);
    }
  }
  @Override
  public void glTextureView(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glTextureView(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureView", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glFrameTerminatorGREMEDY()
  {
    checkContext();
    downstreamGL4bc.glFrameTerminatorGREMEDY();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glFrameTerminatorGREMEDY");
    }
  }
  @Override
  public void glUniform3fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform3fvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGenBuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenBuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenBuffers", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix3x4dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x4dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix3x4dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultMatrixf(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glMultMatrixf(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glMultMatrixf", arg0);
    }
  }
  @Override
  public void glVertexAttribL2dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttribL2dv", arg0, arg1);
    }
  }
  @Override
  public void glPathColorGenNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glPathColorGenNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPathColorGenNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public boolean glIsTextureHandleResidentNV(long arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsTextureHandleResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glIsTextureHandleResidentNV", arg0);
    }
    return _res;
  }
  @Override
  public void glDrawTextureNV(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,float arg6,float arg7,float arg8,float arg9,float arg10)
  {
    checkContext();
    downstreamGL4bc.glDrawTextureNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glDrawTextureNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glInvalidateSubFramebuffer(int arg0,int arg1,int[] arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glInvalidateSubFramebuffer(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glInvalidateSubFramebuffer", arg0, arg1, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public int getSwapInterval()
  {
    return downstreamGL4bc.getSwapInterval();
  }
  @Override
  public void glMultiTexCoord2bOES(int arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2bOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <byte> %s, <byte> %s)",
                   "glMultiTexCoord2bOES", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTextureLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetTextureLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetTextureLevelParameterfvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glNamedProgramLocalParameter4fvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameter4fvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glNamedProgramLocalParameter4fvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetTextureParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTextureParameterivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public int glCreateProgram()
  {
    checkContext();
    int _res = downstreamGL4bc.glCreateProgram();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glCreateProgram");
    }
    return _res;
  }
  @Override
  public void glNormalFormatNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormalFormatNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glNormalFormatNV", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord4iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoord4iv", arg0, arg1);
    }
  }
  @Override
  public void glPolygonStipple(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPolygonStipple(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glPolygonStipple", arg1);
    }
  }
  @Override
  public void glTexCoord2dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glTexCoord2dv", arg1);
    }
  }
  @Override
  public long glImportSyncEXT(int arg0,long arg1,int arg2)
  {
    checkContext();
    long _res = downstreamGL4bc.glImportSyncEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <int> 0x%X)",
                   "glImportSyncEXT", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glBlitFramebuffer(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9)
  {
    checkContext();
    downstreamGL4bc.glBlitFramebuffer(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlitFramebuffer", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glViewportArrayv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glViewportArrayv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glViewportArrayv", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glIsFenceNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsFenceNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsFenceNV", arg0);
    }
    return _res;
  }
  @Override
  public void glFinishFenceAPPLE(int arg0)
  {
    checkContext();
    downstreamGL4bc.glFinishFenceAPPLE(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glFinishFenceAPPLE", arg0);
    }
  }
  @Override
  public void glClearColor(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glClearColor(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glClearColor", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMatrixIndexPointer(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMatrixIndexPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix4x3fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x3fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix4x3fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterfvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetNamedProgramLocalParameterfvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttribL2i64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2i64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL2i64vNV", arg0, arg1);
    }
  }
  @Override
  public void glGetnPixelMapuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnPixelMapuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetnPixelMapuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public boolean glIsOcclusionQueryNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsOcclusionQueryNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsOcclusionQueryNV", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttribI4iEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4iEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI4iEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetVideoCaptureStreamfvNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureStreamfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetVideoCaptureStreamfvNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4uivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4uivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4uivARB", arg0, arg1);
    }
  }
  @Override
  public void glTexCoordP4ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP4ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTexCoordP4ui", arg0, arg1);
    }
  }
  @Override
  public void glSecondaryColorP3ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColorP3ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glSecondaryColorP3ui", arg0, arg1);
    }
  }
  @Override
  public void glUniformMatrix3x4dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x4dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix3x4dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetVertexAttribIuivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIuivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexAttribIuivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public int glGenSymbolsEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    int _res = downstreamGL4bc.glGenSymbolsEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glGenSymbolsEXT", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public void glFramebufferTextureARB(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPerfMonitorGroupsAMD(java.nio.IntBuffer arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorGroupsAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPerfMonitorGroupsAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPerfMonitorGroupsAMD(int[] arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorGroupsAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPerfMonitorGroupsAMD", arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib4Nbv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nbv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4Nbv", arg0, arg1);
    }
  }
  @Override
  public void glUniformui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniformui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetMultiTexGenivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexGenivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMultiTexGenivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor4s(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4s(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glColor4s", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetActiveSubroutineUniformiv(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetActiveSubroutineUniformiv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetActiveSubroutineUniformiv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glGenProgramsARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenProgramsARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenProgramsARB", arg0, arg1);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterIivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedProgramLocalParameterIivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColorTable(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glColorTable(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glColorTable", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColor4i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glColor4i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor4h(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4h(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glColor4h", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDrawElementsInstanced(int arg0,int arg1,int arg2,long arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstanced(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X)",
                   "glDrawElementsInstanced", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetProgramSubroutineParameteruivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramSubroutineParameteruivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramSubroutineParameteruivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDrawElementsInstancedBaseVertex(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstancedBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X)",
                   "glDrawElementsInstancedBaseVertex", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glColor4f(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glColor4f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColorP4uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glColorP4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glColorP4uiv", arg0, arg2);
    }
  }
  @Override
  public void glGenProgramPipelines(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenProgramPipelines(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenProgramPipelines", arg0, arg2);
    }
  }
  @Override
  public void glColor4d(double arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s)",
                   "glColor4d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramLocalParametersI4ivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParametersI4ivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramLocalParametersI4ivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetDoublev(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetDoublev(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetDoublev", arg0, arg2);
    }
  }
  @Override
  public void glColor4b(byte arg0,byte arg1,byte arg2,byte arg3)
  {
    checkContext();
    downstreamGL4bc.glColor4b(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s, <byte> %s)",
                   "glColor4b", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glWeightubvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightubvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glWeightubvARB", arg0, arg2);
    }
  }
  @Override
  public void glGetMinmaxParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMinmaxParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMinmaxParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib4usv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4usv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4usv", arg0, arg2);
    }
  }
  @Override
  public void glConvolutionFilter1D(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glConvolutionFilter1D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glConvolutionFilter1D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glUseProgramStages(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glUseProgramStages(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUseProgramStages", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNormalP3ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormalP3ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glNormalP3ui", arg0, arg1);
    }
  }
  @Override
  public void glGetProgramPipelineiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramPipelineiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramPipelineiv", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glIsVBOElementArrayBound()
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsVBOElementArrayBound();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glIsVBOElementArrayBound");
    }
    return _res;
  }
  @Override
  public void glCompressedMultiTexSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glCompressedMultiTexSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedMultiTexSubImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glGetTextureParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterIuivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTextureParameterIuivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoordPointerEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordPointerEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexCoordPointerEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glShaderSourceARB(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glShaderSourceARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <[I>, <int> 0x%X)",
                   "glShaderSourceARB", arg0, arg1, arg4);
    }
  }
  @Override
  public void glVertexAttribI3iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI3iv", arg0, arg2);
    }
  }
  @Override
  public void glGetVertexArrayPointervEXT(int arg0,int arg1,com.jogamp.common.nio.PointerBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexArrayPointervEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s)",
                   "glGetVertexArrayPointervEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glUnmapNamedBufferEXT(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glUnmapNamedBufferEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glUnmapNamedBufferEXT", arg0);
    }
    return _res;
  }
  @Override
  public void glProgramUniform2dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glProgramUniform2dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix3x2fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x2fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix3x2fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glUniformMatrix2x3dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x3dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix2x3dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glInsertComponentEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glInsertComponentEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glInsertComponentEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glInterpolatePathsNV(int arg0,int arg1,int arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glInterpolatePathsNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glInterpolatePathsNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetUniformiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetUniformiv", arg0, arg1, arg3);
    }
  }
  @Override
  public int glGetHandleARB(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetHandleARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGetHandleARB", arg0);
    }
    return _res;
  }
  @Override
  public void glMultiTexCoord1iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoord1iv", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexCoord3fv", arg0, arg2);
    }
  }
  @Override
  public void glFramebufferTextureLayerARB(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureLayerARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureLayerARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniform3ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform3ui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribs2hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs2hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribs2hv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMapiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMapiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMapiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor3us(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3us(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glColor3us", arg0, arg1, arg2);
    }
  }
  @Override
  public void glActiveStencilFaceEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glActiveStencilFaceEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glActiveStencilFaceEXT", arg0);
    }
  }
  @Override
  public void glGetClipPlanef(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetClipPlanef(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetClipPlanef", arg0, arg1);
    }
  }
  @Override
  public void glPrimitiveRestartIndex(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPrimitiveRestartIndex(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPrimitiveRestartIndex", arg0);
    }
  }
  @Override
  public void glVertexAttribI2uivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2uivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI2uivEXT", arg0, arg1);
    }
  }
  @Override
  public void glDepthRange(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glDepthRange(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glDepthRange", arg0, arg1);
    }
  }
  @Override
  public void glGetFramebufferParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFramebufferParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetFramebufferParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribIPointer(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribIPointer(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexAttribIPointer", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMapVertexAttrib1dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,double[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib1dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glMapVertexAttrib1dAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg7);
    }
  }
  @Override
  public void glGetMultiTexParameterIuivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterIuivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMultiTexParameterIuivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glColor4sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glColor4sv", arg1);
    }
  }
  @Override
  public void glVertexAttribI3uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI3uiv", arg0, arg1);
    }
  }
  @Override
  public void glListBase(int arg0)
  {
    checkContext();
    downstreamGL4bc.glListBase(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glListBase", arg0);
    }
  }
  @Override
  public void glGetQueryObjecti64vEXT(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjecti64vEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetQueryObjecti64vEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexGendv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexGendv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glTexGendv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPopName()
  {
    checkContext();
    downstreamGL4bc.glPopName();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPopName");
    }
  }
  @Override
  public void glTransformFeedbackVaryings(int arg0,int arg1,java.lang.String[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTransformFeedbackVaryings(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <int> 0x%X)",
                   "glTransformFeedbackVaryings", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCompressedTextureImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glCompressedTextureImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTextureImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glSecondaryColor3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glSecondaryColor3sv", arg1);
    }
  }
  @Override
  public void glUniformMatrix2fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix2fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetProgramEnvParameterfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterfvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetProgramEnvParameterfvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib1svARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1svARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib1svARB", arg0, arg1);
    }
  }
  @Override
  public void glFramebufferDrawBuffersEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glFramebufferDrawBuffersEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glFramebufferDrawBuffersEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetHistogramParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetHistogramParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetHistogramParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTextureBufferRangeEXT(int arg0,int arg1,int arg2,int arg3,long arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glTextureBufferRangeEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glTextureBufferRangeEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetQueryObjectiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetQueryObjectiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWeightsvARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightsvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glWeightsvARB", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform4dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniform4dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMatrixPushEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glMatrixPushEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glMatrixPushEXT", arg0);
    }
  }
  @Override
  public void glUniform3fv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform3fv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDeleteProgram(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDeleteProgram(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDeleteProgram", arg0);
    }
  }
  @Override
  public void glVDPAUUnregisterSurfaceNV(long arg0)
  {
    checkContext();
    downstreamGL4bc.glVDPAUUnregisterSurfaceNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glVDPAUUnregisterSurfaceNV", arg0);
    }
  }
  @Override
  public void glUniform2iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform2iv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetFloatIndexedvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetFloatIndexedvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetFloatIndexedvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetFloati_vEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFloati_vEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetFloati_vEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glBufferAddressRangeNV(int arg0,int arg1,long arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glBufferAddressRangeNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glBufferAddressRangeNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGenOcclusionQueriesNV(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenOcclusionQueriesNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenOcclusionQueriesNV", arg0, arg2);
    }
  }
  @Override
  public void glBindFragDataLocation(int arg0,int arg1,java.lang.String arg2)
  {
    checkContext();
    downstreamGL4bc.glBindFragDataLocation(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glBindFragDataLocation", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetSamplerParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameterIiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetSamplerParameterIiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib1dARB(int arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1dARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s)",
                   "glVertexAttrib1dARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib4Niv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Niv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4Niv", arg0, arg2);
    }
  }
  @Override
  public void glLightiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glLightiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glLightiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCompressedTextureImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,java.nio.Buffer arg9)
  {
    checkContext();
    downstreamGL4bc.glCompressedTextureImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTextureImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public int glCreateShaderProgramv(int arg0,int arg1,java.lang.String[] arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glCreateShaderProgramv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>)",
                   "glCreateShaderProgramv", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glProgramUniform3i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform3i64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribL3i64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3i64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL3i64vNV", arg0, arg1);
    }
  }
  @Override
  public void glGetPathColorGenivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPathColorGenivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPathColorGenivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glColor4usv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4usv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glColor4usv", arg1);
    }
  }
  @Override
  public void glBeginConditionalRenderNVX(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBeginConditionalRenderNVX(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBeginConditionalRenderNVX", arg0);
    }
  }
  @Override
  public void glColorPointer(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glColorPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glColorPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMatrixTranslatedEXT(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glMatrixTranslatedEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glMatrixTranslatedEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib2dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib2dv", arg0, arg1);
    }
  }
  @Override
  public void glPathParameterfNV(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glPathParameterfNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glPathParameterfNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform3i64NV(int arg0,int arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3i64NV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s, <long> %s, <long> %s)",
                   "glProgramUniform3i64NV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glBeginOcclusionQueryNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBeginOcclusionQueryNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBeginOcclusionQueryNV", arg0);
    }
  }
  @Override
  public void glVertexAttrib4NubARB(int arg0,byte arg1,byte arg2,byte arg3,byte arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NubARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <byte> %s, <byte> %s, <byte> %s, <byte> %s)",
                   "glVertexAttrib4NubARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniformHandleui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniformHandleui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniformHandleui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetInvariantBooleanvEXT(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetInvariantBooleanvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetInvariantBooleanvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexAttribiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexAttribiv", arg0, arg1, arg3);
    }
  }
  @Override
  public int getDefaultDrawFramebuffer()
  {
    return downstreamGL4bc.getDefaultDrawFramebuffer();
  }
  @Override
  public void glGetnMapiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnMapiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetnMapiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glWeightivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glWeightivARB", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribP4uiv(int arg0,int arg1,boolean arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP4uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[I>, <int> 0x%X)",
                   "glVertexAttribP4uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDeleteNamesAMD(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteNamesAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteNamesAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEdgeFlagPointer(int arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glEdgeFlagPointer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s)",
                   "glEdgeFlagPointer", arg0, arg1);
    }
  }
  @Override
  public void glUniform4uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform4uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFogCoordhv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFogCoordhv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glFogCoordhv", arg1);
    }
  }
  @Override
  public void glEvalCoord2dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord2dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glEvalCoord2dv", arg1);
    }
  }
  @Override
  public void glSamplerParameterf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glSamplerParameterf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetSamplerParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetSamplerParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetIntegerui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerui64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetIntegerui64vNV", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glRasterPos3fv", arg0);
    }
  }
  @Override
  public void glGetVideoCaptureStreamivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureStreamivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVideoCaptureStreamivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramLocalParameterI4uivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameterI4uivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramLocalParameterI4uivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetMapParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMapParameterivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMapParameterivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTextureStorage3DMultisampleEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
    checkContext();
    downstreamGL4bc.glTextureStorage3DMultisampleEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTextureStorage3DMultisampleEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public int glGetProgramResourceLocation(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceLocation(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetProgramResourceLocation", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glGetInternalformativ(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetInternalformativ(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetInternalformativ", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetInfoLogARB(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetInfoLogARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetInfoLogARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCompileShaderIncludeARB(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glCompileShaderIncludeARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <[I>, <int> 0x%X)",
                   "glCompileShaderIncludeARB", arg0, arg1, arg4);
    }
  }
  @Override
  public void glGetPixelMapfv(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glGetPixelMapfv", arg0, arg1);
    }
  }
  @Override
  public void glGetMapfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMapfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMapfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetBufferParameteri64v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetBufferParameteri64v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetBufferParameteri64v", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTexLevelParameterfv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTexLevelParameterfv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetTexLevelParameterfv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetMinmax(int arg0,boolean arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMinmax(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glGetMinmax", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glSecondaryColor3uiv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3uiv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glSecondaryColor3uiv", arg0);
    }
  }
  @Override
  public void glLockArraysEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glLockArraysEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glLockArraysEXT", arg0, arg1);
    }
  }
  @Override
  public long glGetImageHandleNV(int arg0,int arg1,boolean arg2,int arg3,int arg4)
  {
    checkContext();
    long _res = downstreamGL4bc.glGetImageHandleNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X)",
                   "glGetImageHandleNV", arg0, arg1, arg2, arg3, arg4);
    }
    return _res;
  }
  @Override
  public void glMakeNamedBufferNonResidentNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glMakeNamedBufferNonResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glMakeNamedBufferNonResidentNV", arg0);
    }
  }
  @Override
  public void glPushDebugGroup(int arg0,int arg1,int arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glPushDebugGroup(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glPushDebugGroup", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform2fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform2fv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformMatrix3x2dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix3x2dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetProgramLocalParameterfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterfvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetProgramLocalParameterfvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPathDashArrayNV(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPathDashArrayNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathDashArrayNV", arg0, arg1);
    }
  }
  @Override
  public void glColor3b(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3b(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glColor3b", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glAreTexturesResident(int arg0,java.nio.IntBuffer arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glAreTexturesResident(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glAreTexturesResident", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glVertex4bOES(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glVertex4bOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glVertex4bOES", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetPixelTransformParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPixelTransformParameterivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPixelTransformParameterivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetUniformi64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformi64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetUniformi64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib2dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2dvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib2dvARB", arg0, arg1);
    }
  }
  @Override
  public void glUniform2uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform2uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribL2ui64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL2ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL2ui64vNV", arg0, arg2);
    }
  }
  @Override
  public void glBufferParameteri(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBufferParameteri(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBufferParameteri", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEndTransformFeedback()
  {
    checkContext();
    downstreamGL4bc.glEndTransformFeedback();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEndTransformFeedback");
    }
  }
  @Override
  public void glVertex2fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glVertex2fv", arg0);
    }
  }
  @Override
  public void glGetHistogramParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetHistogramParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetHistogramParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord3sv", arg0, arg1);
    }
  }
  @Override
  public void glGetActiveUniformsiv(int arg0,int arg1,java.nio.IntBuffer arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformsiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetActiveUniformsiv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetActiveUniformsiv(int arg0,int arg1,int[] arg2,int arg3,int arg4,int[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformsiv(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetActiveUniformsiv", arg0, arg1, arg3, arg4, arg6);
    }
  }
  @Override
  public void glGetLocalConstantFloatvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetLocalConstantFloatvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetLocalConstantFloatvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glWindowPos3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glWindowPos3iv", arg0);
    }
  }
  @Override
  public void glGetFloati_v(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFloati_v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetFloati_v", arg0, arg1, arg2);
    }
  }
  @Override
  public void glRenderbufferStorage(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRenderbufferStorage(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glRenderbufferStorage", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord4sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord4sv", arg0, arg1);
    }
  }
  @Override
  public void glGetnTexImage(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetnTexImage(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetnTexImage", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glEndQueryIndexed(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEndQueryIndexed(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEndQueryIndexed", arg0, arg1);
    }
  }
  @Override
  public void glTextureParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glTextureParameterfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glBeginTransformFeedback(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBeginTransformFeedback(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBeginTransformFeedback", arg0);
    }
  }
  @Override
  public void glCopyTextureSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9)
  {
    checkContext();
    downstreamGL4bc.glCopyTextureSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTextureSubImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glSecondaryColor3hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glSecondaryColor3hv", arg1);
    }
  }
  @Override
  public void glGetPathMetricsNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glGetPathMetricsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathMetricsNV", arg0, arg1, arg2, arg3, arg4, arg5, arg7);
    }
  }
  @Override
  public void glProgramUniform2fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramUniform2fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDisableIndexed(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDisableIndexed(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDisableIndexed", arg0, arg1);
    }
  }
  @Override
  public void glEndConditionalRenderNVX()
  {
    checkContext();
    downstreamGL4bc.glEndConditionalRenderNVX();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEndConditionalRenderNVX");
    }
  }
  @Override
  public void glHintPGI(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glHintPGI(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glHintPGI", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribL4dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttribL4dv", arg0, arg2);
    }
  }
  @Override
  public void glProgramLocalParameterI4ivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameterI4ivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramLocalParameterI4ivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDrawTransformFeedbackNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDrawTransformFeedbackNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDrawTransformFeedbackNV", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord3dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMultiTexCoord3dv", arg0, arg2);
    }
  }
  @Override
  public void glShaderOp2EXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glShaderOp2EXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glShaderOp2EXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix3x2dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x2dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix3x2dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glGetPathParameterivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPathParameterivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPathParameterivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexStorage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glTexStorage3D(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexStorage3D", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glHint(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glHint(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glHint", arg0, arg1);
    }
  }
  @Override
  public void glResetMinmax(int arg0)
  {
    checkContext();
    downstreamGL4bc.glResetMinmax(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glResetMinmax", arg0);
    }
  }
  @Override
  public void glMultiTexCoord1sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord1sv", arg0, arg2);
    }
  }
  @Override
  public void glPixelTransferi(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPixelTransferi(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glPixelTransferi", arg0, arg1);
    }
  }
  @Override
  public boolean glIsList(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsList(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsList", arg0);
    }
    return _res;
  }
  @Override
  public void glVertexAttribI4uiEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4uiEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI4uiEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glWindowPos2sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glWindowPos2sv", arg0);
    }
  }
  @Override
  public void glNamedFramebufferTexture1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferTexture1DEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferTexture1DEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glDisable(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDisable(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDisable", arg0);
    }
  }
  @Override
  public void glVertexWeightfEXT(float arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexWeightfEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glVertexWeightfEXT", arg0);
    }
  }
  @Override
  public boolean glIsNameAMD(int arg0,int arg1)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsNameAMD(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIsNameAMD", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glVariantfvEXT(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantfvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVariantfvEXT", arg0, arg1);
    }
  }
  @Override
  public boolean glIsVBOArrayBound()
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsVBOArrayBound();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glIsVBOArrayBound");
    }
    return _res;
  }
  @Override
  public void glFogiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glFogiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glFogiv", arg0, arg2);
    }
  }
  @Override
  public void glOrthof(float arg0,float arg1,float arg2,float arg3,float arg4,float arg5)
  {
    checkContext();
    downstreamGL4bc.glOrthof(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glOrthof", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glMakeNamedBufferResidentNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMakeNamedBufferResidentNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glMakeNamedBufferResidentNV", arg0, arg1);
    }
  }
  @Override
  public void glVertex3bOES(byte arg0,byte arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3bOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s)",
                   "glVertex3bOES", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord3d(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glMultiTexCoord3d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib3d(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glVertexAttrib3d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor3uiv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glColor3uiv", arg1);
    }
  }
  @Override
  public void glProgramUniform4ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4ui64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform4ui64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glPrioritizeTextures(int arg0,int[] arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glPrioritizeTextures(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPrioritizeTextures", arg0, arg2, arg4);
    }
  }
  @Override
  public void glNamedProgramLocalParameter4dEXT(int arg0,int arg1,int arg2,double arg3,double arg4,double arg5,double arg6)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameter4dEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glNamedProgramLocalParameter4dEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetVertexAttribdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribdv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetVertexAttribdv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexWeightfvEXT(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexWeightfvEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glVertexWeightfvEXT", arg0);
    }
  }
  @Override
  public void glTexCoord1fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glTexCoord1fv", arg0);
    }
  }
  @Override
  public void glLightModeliv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glLightModeliv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glLightModeliv", arg0, arg2);
    }
  }
  @Override
  public long glCreateSyncFromCLeventARB(long arg0,long arg1,int arg2)
  {
    checkContext();
    long _res = downstreamGL4bc.glCreateSyncFromCLeventARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <long> %s, <int> 0x%X)",
                   "glCreateSyncFromCLeventARB", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glVertexAttrib1fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib1fv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform1i64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform1i64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix2dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix2dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glFramebufferTextureLayer(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureLayer(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureLayer", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public int glGetProgramResourceIndex(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceIndex(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetProgramResourceIndex", arg0, arg1, arg3);
    }
    return _res;
  }
  @Override
  public void glGetActiveSubroutineUniformName(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,byte[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glGetActiveSubroutineUniformName(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetActiveSubroutineUniformName", arg0, arg1, arg2, arg3, arg5, arg7);
    }
  }
  @Override
  public void glGetRenderbufferParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetRenderbufferParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetRenderbufferParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform1i64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1i64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform1i64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCopyMultiTexImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glCopyMultiTexImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyMultiTexImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glFrustumf(float arg0,float arg1,float arg2,float arg3,float arg4,float arg5)
  {
    checkContext();
    downstreamGL4bc.glFrustumf(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glFrustumf", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glUniform3dv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glUniform3dv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniformBlockBinding(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glUniformBlockBinding(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniformBlockBinding", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPixelZoom(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPixelZoom(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glPixelZoom", arg0, arg1);
    }
  }
  @Override
  public long glVDPAURegisterOutputSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterOutputSurfaceNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVDPAURegisterOutputSurfaceNV", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public void glProgramUniform4ui(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4ui(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform4ui", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glNamedRenderbufferStorageMultisampleCoverageEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glNamedRenderbufferStorageMultisampleCoverageEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedRenderbufferStorageMultisampleCoverageEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTexStorage1D(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexStorage1D(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexStorage1D", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glTexParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glDrawTransformFeedbackInstanced(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawTransformFeedbackInstanced(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawTransformFeedbackInstanced", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetUniformIndices(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetUniformIndices(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <[I>, <int> 0x%X)",
                   "glGetUniformIndices", arg0, arg1, arg4);
    }
  }
  @Override
  public void glVertexArraySecondaryColorOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexArraySecondaryColorOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArraySecondaryColorOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glWindowPos3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glWindowPos3fv", arg0);
    }
  }
  @Override
  public void glVariantivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVariantivEXT", arg0, arg2);
    }
  }
  @Override
  public void glSamplerParameterIiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterIiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glSamplerParameterIiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexAttribfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribfvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetVertexAttribfvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib1d(int arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s)",
                   "glVertexAttrib1d", arg0, arg1);
    }
  }
  @Override
  public void glProgramEnvParameter4dvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameter4dvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glProgramEnvParameter4dvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttribBinding(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribBinding(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexAttribBinding", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib2fvARB(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib2fvARB", arg0, arg2);
    }
  }
  @Override
  public boolean glIsTexture(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsTexture(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsTexture", arg0);
    }
    return _res;
  }
  @Override
  public void glMultiTexBufferEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexBufferEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexBufferEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glFogCoordPointer(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glFogCoordPointer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glFogCoordPointer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glBitmap(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,byte[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s, <[B>, <int> 0x%X)",
                   "glBitmap", arg0, arg1, arg2, arg3, arg4, arg5, arg7);
    }
  }
  @Override
  public void glTexCoord2bvOES(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2bvOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glTexCoord2bvOES", arg0);
    }
  }
  @Override
  public void glTexCoord4iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glTexCoord4iv", arg1);
    }
  }
  @Override
  public void glEvalCoord2fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glEvalCoord2fv", arg1);
    }
  }
  @Override
  public void glCopyMultiTexSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glCopyMultiTexSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyMultiTexSubImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glAttachObjectARB(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glAttachObjectARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glAttachObjectARB", arg0, arg1);
    }
  }
  @Override
  public void glScissorArrayv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glScissorArrayv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glScissorArrayv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform4i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4i(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform4i", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttribI4usv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4usv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribI4usv", arg0, arg1);
    }
  }
  @Override
  public void glUniform4f(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4f(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glUniform4f", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glRasterPos2dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glRasterPos2dv", arg0);
    }
  }
  @Override
  public void glPathStencilDepthOffsetNV(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glPathStencilDepthOffsetNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glPathStencilDepthOffsetNV", arg0, arg1);
    }
  }
  @Override
  public void glDeleteFencesAPPLE(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteFencesAPPLE(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteFencesAPPLE", arg0, arg2);
    }
  }
  @Override
  public void glUniformMatrix2x4dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2x4dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix2x4dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetMapAttribParameterfvNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMapAttribParameterfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMapAttribParameterfvNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCopyColorSubTable(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glCopyColorSubTable(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyColorSubTable", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glStencilOpSeparate(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glStencilOpSeparate(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glStencilOpSeparate", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetUniformivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetUniformivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTexImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glMultiTexCoord4bvOES(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4bvOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glMultiTexCoord4bvOES", arg0, arg2);
    }
  }
  @Override
  public void glGetProgramLocalParameterdvARB(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterdvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetProgramLocalParameterdvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPathParameterivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPathParameterivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glPathParameterivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4bv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4bv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4bv", arg0, arg2);
    }
  }
  @Override
  public void glNamedProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glNamedProgramLocalParameters4fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiDrawArraysIndirect(int arg0,java.nio.Buffer arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawArraysIndirect(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X)",
                   "glMultiDrawArraysIndirect", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexArrayFogCoordOffsetEXT(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayFogCoordOffsetEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayFogCoordOffsetEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetBufferParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetBufferParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetBufferParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPushMatrix()
  {
    checkContext();
    downstreamGL4bc.glPushMatrix();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPushMatrix");
    }
  }
  @Override
  public void glVertexArrayVertexAttribIOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexAttribIOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayVertexAttribIOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glDeleteSamplers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteSamplers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteSamplers", arg0, arg1);
    }
  }
  @Override
  public void glGetIntegerIndexedv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerIndexedv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetIntegerIndexedv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glBlendEquationIndexedAMD(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBlendEquationIndexedAMD(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBlendEquationIndexedAMD", arg0, arg1);
    }
  }
  @Override
  public void glGetInteger64v(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetInteger64v(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetInteger64v", arg0, arg1);
    }
  }
  @Override
  public void glPushClientAttrib(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPushClientAttrib(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPushClientAttrib", arg0);
    }
  }
  @Override
  public void glUniform2ui64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform2ui64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4NbvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NbvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4NbvARB", arg0, arg2);
    }
  }
  @Override
  public java.lang.String glGetStringi(int arg0,int arg1)
  {
    checkContext();
    java.lang.String _res = downstreamGL4bc.glGetStringi(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glGetStringi", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glProgramUniformMatrix2x3fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix2x3fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix4x2fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix4x2fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glPixelTransformParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelTransformParameterivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glPixelTransformParameterivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniformSubroutinesuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniformSubroutinesuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniformSubroutinesuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetBooleanv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetBooleanv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetBooleanv", arg0, arg1);
    }
  }
  @Override
  public void glTexGeniv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexGeniv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexGeniv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVariantsvEXT(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantsvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVariantsvEXT", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib3hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib3hv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform3f(int arg0,int arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3f(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glProgramUniform3f", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glEdgeFlagFormatNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEdgeFlagFormatNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEdgeFlagFormatNV", arg0);
    }
  }
  @Override
  public void glGetConvolutionParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetConvolutionParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetConvolutionParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexCoord3hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord3hv", arg1);
    }
  }
  @Override
  public void glVertex4bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex4bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glVertex4bvOES", arg1);
    }
  }
  @Override
  public void glVertex4sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex4sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertex4sv", arg1);
    }
  }
  @Override
  public int glGenLists(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glGenLists(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glGenLists", arg0);
    }
    return _res;
  }
  @Override
  public void glMultiTexCoord1d(int arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s)",
                   "glMultiTexCoord1d", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI4usvEXT(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4usvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribI4usvEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetShaderSourceARB(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.ByteBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetShaderSourceARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetShaderSourceARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetUniformdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetUniformdv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetUniformdv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNamedProgramLocalParameterI4ivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameterI4ivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glNamedProgramLocalParameterI4ivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribL4ui64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4ui64NV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s, <long> %s)",
                   "glVertexAttribL4ui64NV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetVertexAttribIivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVertexAttribIivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetColorTableParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetColorTableParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetColorTableParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribPointer(int arg0,int arg1,int arg2,boolean arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribPointer(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexAttribPointer", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glUniformMatrix3fvARB(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3fvARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix3fvARB", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetTexParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameterIuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTexParameterIuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTexParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTexParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramLocalParameter4fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameter4fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramLocalParameter4fvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform4ui64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4ui64NV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s, <long> %s)",
                   "glUniform4ui64NV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glFinishObjectAPPLE(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFinishObjectAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glFinishObjectAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glGetnConvolutionFilter(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnConvolutionFilter(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetnConvolutionFilter", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetInvariantIntegervEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetInvariantIntegervEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetInvariantIntegervEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform2uiEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2uiEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform2uiEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPerfMonitorCountersAMD(int arg0,int[] arg1,int arg2,int[] arg3,int arg4,int arg5,int[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPerfMonitorCountersAMD", arg0, arg2, arg4, arg5, arg7);
    }
  }
  @Override
  public void glEnableVertexAttribArray(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEnableVertexAttribArray(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEnableVertexAttribArray", arg0);
    }
  }
  @Override
  public void glGetnMapdv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnMapdv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetnMapdv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetMultiTexLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMultiTexLevelParameterivEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glCompressedTextureImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glCompressedTextureImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTextureImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glVertexAttribI1uivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1uivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI1uivEXT", arg0, arg2);
    }
  }
  @Override
  public void glMatrixLoaddEXT(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoaddEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMatrixLoaddEXT", arg0, arg2);
    }
  }
  @Override
  public void glTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glTexSubImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glWeightdvARB(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightdvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glWeightdvARB", arg0, arg2);
    }
  }
  @Override
  public void glVertexPointer(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDrawElementsBaseVertex(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsBaseVertex(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glDrawElementsBaseVertex", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetTexGeniv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexGeniv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTexGeniv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSelectPerfMonitorCountersAMD(int arg0,boolean arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glSelectPerfMonitorCountersAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glSelectPerfMonitorCountersAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glCoverStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,java.nio.FloatBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glCoverStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glCoverStrokePathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetVideoCaptureivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetVideoCaptureivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,long arg8)
  {
    checkContext();
    downstreamGL4bc.glTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glTexSubImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glRasterPos4s(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4s(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glRasterPos4s", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGenQueries(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenQueries(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenQueries", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform2uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2uivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform2uivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetInvariantFloatvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetInvariantFloatvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetInvariantFloatvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4svARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4svARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4svARB", arg0, arg1);
    }
  }
  @Override
  public void glNamedFramebufferTextureLayerEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferTextureLayerEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferTextureLayerEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glRasterPos4i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glRasterPos4i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix4x2dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix4x2dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glBindBufferBase(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBindBufferBase(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBindBufferBase", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColorMask(boolean arg0,boolean arg1,boolean arg2,boolean arg3)
  {
    checkContext();
    downstreamGL4bc.glColorMask(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<boolean> %s, <boolean> %s, <boolean> %s, <boolean> %s)",
                   "glColorMask", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRasterPos4f(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glRasterPos4f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform3ui(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform3ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRasterPos4d(double arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s)",
                   "glRasterPos4d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniform4iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4iv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform4iv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,long arg10)
  {
    checkContext();
    downstreamGL4bc.glTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glTexSubImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glGetnSeparableFilter(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4,int arg5,java.nio.Buffer arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glGetnSeparableFilter(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <java.nio.Buffer> %s, <java.nio.Buffer> %s)",
                   "glGetnSeparableFilter", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glGetIntegeri_v(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetIntegeri_v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetIntegeri_v", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetProgramStringARB(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramStringARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetProgramStringARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glAlphaFunc(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glAlphaFunc(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glAlphaFunc", arg0, arg1);
    }
  }
  @Override
  public long glVDPAURegisterVideoSurfaceNV(java.nio.Buffer arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    long _res = downstreamGL4bc.glVDPAURegisterVideoSurfaceNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glVDPAURegisterVideoSurfaceNV", arg0, arg1, arg2, arg4);
    }
    return _res;
  }
  @Override
  public void glMultiTexCoord4hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord4hv", arg0, arg1);
    }
  }
  @Override
  public void glUniform(javax.media.opengl.GLUniformData arg0)
  {
    checkContext();
    downstreamGL4bc.glUniform(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<javax.media.opengl.GLUniformData> %s)",
                   "glUniform", arg0);
    }
  }
  @Override
  public void glNamedFramebufferTextureFaceEXT(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedFramebufferTextureFaceEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedFramebufferTextureFaceEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix4x3dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x3dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix4x3dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glColor3ubv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3ubv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glColor3ubv", arg0);
    }
  }
  @Override
  public void glMatrixScaledEXT(int arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glMatrixScaledEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s)",
                   "glMatrixScaledEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform3i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform3i64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glReleaseShaderCompiler()
  {
    checkContext();
    downstreamGL4bc.glReleaseShaderCompiler();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glReleaseShaderCompiler");
    }
  }
  @Override
  public void glScaled(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glScaled(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glScaled", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribs1hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs1hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribs1hv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCullFace(int arg0)
  {
    checkContext();
    downstreamGL4bc.glCullFace(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCullFace", arg0);
    }
  }
  @Override
  public void glVertexAttribP1ui(int arg0,int arg1,boolean arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP1ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexAttribP1ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPixelMapuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelMapuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glPixelMapuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean glIsPBOPackBound()
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsPBOPackBound();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glIsPBOPackBound");
    }
    return _res;
  }
  @Override
  public void glColor3bv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor3bv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glColor3bv", arg0);
    }
  }
  @Override
  public void glBlendEquationSeparateIndexedAMD(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glBlendEquationSeparateIndexedAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendEquationSeparateIndexedAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex3dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glVertex3dv", arg1);
    }
  }
  @Override
  public void glProgramBufferParametersIuivNV(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramBufferParametersIuivNV(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramBufferParametersIuivNV", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVariantubvEXT(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantubvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVariantubvEXT", arg0, arg2);
    }
  }
  @Override
  public void glGetTexGenfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetTexGenfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetTexGenfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glIndexMask(int arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexMask(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIndexMask", arg0);
    }
  }
  @Override
  public void glFramebufferDrawBufferEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFramebufferDrawBufferEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glFramebufferDrawBufferEXT", arg0, arg1);
    }
  }
  @Override
  public void glVariantusvEXT(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantusvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVariantusvEXT", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos2s(short arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2s(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s)",
                   "glRasterPos2s", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos4dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glRasterPos4dv", arg1);
    }
  }
  @Override
  public void glEvalCoord1fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord1fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glEvalCoord1fv", arg0);
    }
  }
  @Override
  public void glRasterPos2i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glRasterPos2i", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib4ubvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4ubvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4ubvARB", arg0, arg1);
    }
  }
  @Override
  public void glGetDoublei_v(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetDoublei_v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetDoublei_v", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean hasBasicFBOSupport()
  {
    return downstreamGL4bc.hasBasicFBOSupport();
  }
  @Override
  public void glProgramUniform1dv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniform1dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDeleteFramebuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteFramebuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteFramebuffers", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform1ui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniform1ui64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform2ivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2ivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform2ivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib1sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib1sv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform3fv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramUniform3fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public int glVideoCaptureNV(int arg0,int[] arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    int _res = downstreamGL4bc.glVideoCaptureNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glVideoCaptureNV", arg0, arg2, arg4);
    }
    return _res;
  }
  @Override
  public void glMultiTexCoordP3ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP3ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoordP3ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCopyTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glCopyTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTexImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glMatrixLoadTransposefEXT(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoadTransposefEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMatrixLoadTransposefEXT", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord1sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord1sv", arg0);
    }
  }
  @Override
  public void glGetProgramBinary(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetProgramBinary(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s, <java.nio.Buffer> %s)",
                   "glGetProgramBinary", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetProgramBinary(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glGetProgramBinary(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetProgramBinary", arg0, arg1, arg3, arg5, arg6);
    }
  }
  @Override
  public void glRasterPos2f(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glRasterPos2f", arg0, arg1);
    }
  }
  @Override
  public void glRasterPos2d(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos2d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glRasterPos2d", arg0, arg1);
    }
  }
  @Override
  public void glFeedbackBuffer(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glFeedbackBuffer(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glFeedbackBuffer", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform3iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform3iv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor3ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glColor3ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform1uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1uivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform1uivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix4dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix4dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPerfMonitorCounterStringAMD(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCounterStringAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetPerfMonitorCounterStringAMD", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public void glSamplerParameteri(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameteri(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glSamplerParameteri", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDrawElementsInstancedBaseInstance(int arg0,int arg1,int arg2,long arg3,int arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstancedBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <int> 0x%X, <int> 0x%X)",
                   "glDrawElementsInstancedBaseInstance", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glDeleteQueries(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteQueries(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteQueries", arg0, arg2);
    }
  }
  @Override
  public void glGetVertexAttribIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexAttribIiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPopClientAttrib()
  {
    checkContext();
    downstreamGL4bc.glPopClientAttrib();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPopClientAttrib");
    }
  }
  @Override
  public void glLinkProgramARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glLinkProgramARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glLinkProgramARB", arg0);
    }
  }
  @Override
  public void glTexCoord3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord3sv", arg1);
    }
  }
  @Override
  public void glVertex2hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex2hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertex2hv", arg0);
    }
  }
  @Override
  public void glNormalPointer(javax.media.opengl.GLArrayData arg0)
  {
    checkContext();
    downstreamGL4bc.glNormalPointer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<javax.media.opengl.GLArrayData> %s)",
                   "glNormalPointer", arg0);
    }
  }
  @Override
  public void glGetCompressedTexImage(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetCompressedTexImage(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetCompressedTexImage", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos2fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glWindowPos2fv", arg1);
    }
  }
  @Override
  public void glVertexAttribs4hv(int arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs4hv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttribs4hv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib3sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib3sv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix4x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x3fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix4x3fvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramEnvParameter4fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameter4fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramEnvParameter4fvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform1dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform1dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glUniform1dv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSecondaryColor3b(byte arg0,byte arg1,byte arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3b(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<byte> %s, <byte> %s, <byte> %s)",
                   "glSecondaryColor3b", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4fvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib4fvARB", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord2fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glTexCoord2fv", arg1);
    }
  }
  @Override
  public void glVertexAttrib3svARB(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3svARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib3svARB", arg0, arg1);
    }
  }
  @Override
  public void glEnableVertexAttribArrayARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEnableVertexAttribArrayARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEnableVertexAttribArrayARB", arg0);
    }
  }
  @Override
  public void glGetOcclusionQueryuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetOcclusionQueryuivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetOcclusionQueryuivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetTextureLevelParameterivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetTextureLevelParameterivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTextureLevelParameterivEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glGetInternalformati64v(int arg0,int arg1,int arg2,int arg3,java.nio.LongBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetInternalformati64v(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetInternalformati64v", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glEnableVertexArrayEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnableVertexArrayEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnableVertexArrayEXT", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord1iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glTexCoord1iv", arg0);
    }
  }
  @Override
  public void glFramebufferTextureEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glFramebufferTextureEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glFramebufferTextureEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glClientActiveTexture(int arg0)
  {
    checkContext();
    downstreamGL4bc.glClientActiveTexture(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glClientActiveTexture", arg0);
    }
  }
  @Override
  public void glMatrixScalefEXT(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glMatrixScalefEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glMatrixScalefEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glResetHistogram(int arg0)
  {
    checkContext();
    downstreamGL4bc.glResetHistogram(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glResetHistogram", arg0);
    }
  }
  @Override
  public void glGetPathParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPathParameterfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathParameterfvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultiTexImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
    checkContext();
    downstreamGL4bc.glMultiTexImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glVertexArrayVertexAttribFormatEXT(int arg0,int arg1,int arg2,int arg3,boolean arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexAttribFormatEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexArrayVertexAttribFormatEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glIndexiv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glIndexiv", arg1);
    }
  }
  @Override
  public void glVertexAttribI2uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI2uiv", arg0, arg2);
    }
  }
  @Override
  public void glBindBufferRange(int arg0,int arg1,int arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glBindBufferRange(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s, <long> %s)",
                   "glBindBufferRange", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib1fARB(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1fARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glVertexAttrib1fARB", arg0, arg1);
    }
  }
  @Override
  public void glGetIntegerui64i_vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerui64i_vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetIntegerui64i_vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4dvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib4dvARB", arg0, arg1);
    }
  }
  @Override
  public void glGetNamedFramebufferAttachmentParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedFramebufferAttachmentParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedFramebufferAttachmentParameterivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glNormal3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glNormal3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glNormal3fv", arg1);
    }
  }
  @Override
  public void glMultiTexCoord1dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMultiTexCoord1dv", arg0, arg1);
    }
  }
  @Override
  public void glProgramLocalParameter4dARB(int arg0,int arg1,double arg2,double arg3,double arg4,double arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameter4dARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glProgramLocalParameter4dARB", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glClearAccum(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glClearAccum(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glClearAccum", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniform2ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2ui64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform2ui64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetPolygonStipple(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPolygonStipple(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glGetPolygonStipple", arg1);
    }
  }
  @Override
  public void glUniform3uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform3uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribL4ui64vNV(int arg0,long[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4ui64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[J>, <int> 0x%X)",
                   "glVertexAttribL4ui64vNV", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexCoord2bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glMultiTexCoord2bvOES", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix3dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix3dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniform1iv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1iv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform1iv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glTransformPathNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glTransformPathNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glTransformPathNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glBlendColor(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glBlendColor(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glBlendColor", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glWeightfvARB(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightfvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glWeightfvARB", arg0, arg2);
    }
  }
  @Override
  public void glVertex3d(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glVertex3d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glVertex3d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMatrixIndexubvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexubvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glMatrixIndexubvARB", arg0, arg1);
    }
  }
  @Override
  public void glCopyImageSubData(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,int arg11,int arg12,int arg13,int arg14)
  {
    checkContext();
    downstreamGL4bc.glCopyImageSubData(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyImageSubData", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }
  }
  @Override
  public int getDefaultReadBuffer()
  {
    return downstreamGL4bc.getDefaultReadBuffer();
  }
  @Override
  public void glVertexAttribLPointer(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribLPointer(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVertexAttribLPointer", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetProgramPipelineInfoLog(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetProgramPipelineInfoLog(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetProgramPipelineInfoLog", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGetProgramEnvParameterdvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterdvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetProgramEnvParameterdvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramEnvParametersI4ivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParametersI4ivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramEnvParametersI4ivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVariantdvEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantdvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVariantdvEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexArrayIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexArrayIntegervEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexArrayIntegervEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetColorTableParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetColorTableParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetColorTableParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glPixelMapusv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelMapusv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glPixelMapusv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWeightusvARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightusvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glWeightusvARB", arg0, arg2);
    }
  }
  @Override
  public void glMapVertexAttrib1fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,java.nio.FloatBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib1fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMapVertexAttrib1fAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glLoadIdentity()
  {
    checkContext();
    downstreamGL4bc.glLoadIdentity();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glLoadIdentity");
    }
  }
  @Override
  public int glGetFragDataLocation(int arg0,java.lang.String arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetFragDataLocation(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glGetFragDataLocation", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glGetProgramLocalParameterfvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterfvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetProgramLocalParameterfvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTextureStorageSparseAMD(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glTextureStorageSparseAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTextureStorageSparseAMD", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glUniform2fv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glUniform2fv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexArrayVertexBindingDivisorEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayVertexBindingDivisorEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexArrayVertexBindingDivisorEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDeleteTransformFeedbacksNV(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteTransformFeedbacksNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteTransformFeedbacksNV", arg0, arg1);
    }
  }
  @Override
  public void glGetMultiTexEnvivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexEnvivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMultiTexEnvivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetTransformFeedbackVarying(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6,int[] arg7,int arg8,byte[] arg9,int arg10)
  {
    checkContext();
    downstreamGL4bc.glGetTransformFeedbackVarying(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetTransformFeedbackVarying", arg0, arg1, arg2, arg4, arg6, arg8, arg10);
    }
  }
  @Override
  public void glGetPixelMapuiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapuiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetPixelMapuiv", arg0, arg1);
    }
  }
  @Override
  public void glCompressedTexSubImage1D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexSubImage1D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTexSubImage1D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glMatrixIndexubvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexubvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glMatrixIndexubvARB", arg0, arg2);
    }
  }
  @Override
  public void glGetHistogramParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetHistogramParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetHistogramParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexParameterIiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexParameterIiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glFinish()
  {
    checkContext();
    downstreamGL4bc.glFinish();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glFinish");
    }
  }
  @Override
  public void glVertex2fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glVertex2fv", arg1);
    }
  }
  @Override
  public void glCoverFillPathNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glCoverFillPathNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glCoverFillPathNV", arg0, arg1);
    }
  }
  @Override
  public void glEvalMapsNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalMapsNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEvalMapsNV", arg0, arg1);
    }
  }
  @Override
  public void glVideoCaptureStreamParameterdvNV(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVideoCaptureStreamParameterdvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVideoCaptureStreamParameterdvNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glBindProgramARB(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindProgramARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindProgramARB", arg0, arg1);
    }
  }
  @Override
  public void glColor3usv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3usv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glColor3usv", arg1);
    }
  }
  @Override
  public void glRasterPos4sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glRasterPos4sv", arg1);
    }
  }
  @Override
  public void glGetPathDashArrayNV(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathDashArrayNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetPathDashArrayNV", arg0, arg2);
    }
  }
  @Override
  public void glDetachShader(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDetachShader(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDetachShader", arg0, arg1);
    }
  }
  @Override
  public void glGetUniformuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetUniformuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glScissorIndexed(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glScissorIndexed(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glScissorIndexed", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glRasterPos3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glRasterPos3fv", arg1);
    }
  }
  @Override
  public void glConvolutionParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glConvolutionParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glConvolutionParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glBindTransformFeedbackNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindTransformFeedbackNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindTransformFeedbackNV", arg0, arg1);
    }
  }
  @Override
  public void glGetSamplerParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetSamplerParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib2sv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2sv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib2sv", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform3ui(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3ui(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glProgramUniform3ui", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public boolean glIsProgramARB(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsProgramARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsProgramARB", arg0);
    }
    return _res;
  }
  @Override
  public void glCompressedTexSubImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexSubImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTexSubImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glGetObjectParameterivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetObjectParameterivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetObjectParameterivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTexLevelParameterfv(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexLevelParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetTexLevelParameterfv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDeleteBuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteBuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteBuffers", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexParameterIivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glColor4uiv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glColor4uiv", arg1);
    }
  }
  @Override
  public void glGetPathTexGenivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetPathTexGenivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPathTexGenivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetMapfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMapfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMapfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glColor3hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glColor3hv", arg1);
    }
  }
  @Override
  public void glReadPixels(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glReadPixels(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glReadPixels", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glPathGlyphsNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,java.nio.Buffer arg6,int arg7,int arg8,float arg9)
  {
    checkContext();
    downstreamGL4bc.glPathGlyphsNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glPathGlyphsNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glUniform4iv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform4iv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetPolygonStipple(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glGetPolygonStipple(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glGetPolygonStipple", arg0);
    }
  }
  @Override
  public void glMultiTexCoord2bvOES(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2bvOES(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glMultiTexCoord2bvOES", arg0, arg2);
    }
  }
  @Override
  public void glPNTrianglesiATI(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glPNTrianglesiATI(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glPNTrianglesiATI", arg0, arg1);
    }
  }
  @Override
  public void glNormal3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glNormal3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glNormal3f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor4dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glColor4dv", arg0);
    }
  }
  @Override
  public void glDeletePerfMonitorsAMD(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeletePerfMonitorsAMD(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeletePerfMonitorsAMD", arg0, arg1);
    }
  }
  @Override
  public void glGetPerfMonitorGroupStringAMD(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorGroupStringAMD(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetPerfMonitorGroupStringAMD", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGetProgramResourceiv(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,int arg6,int[] arg7,int arg8,int[] arg9,int arg10)
  {
    checkContext();
    downstreamGL4bc.glGetProgramResourceiv(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramResourceiv", arg0, arg1, arg2, arg3, arg5, arg6, arg8, arg10);
    }
  }
  @Override
  public void glVertexAttrib4Nuiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nuiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4Nuiv", arg0, arg1);
    }
  }
  @Override
  public void glDisableClientState(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDisableClientState(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDisableClientState", arg0);
    }
  }
  @Override
  public void glInvalidateBufferData(int arg0)
  {
    checkContext();
    downstreamGL4bc.glInvalidateBufferData(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glInvalidateBufferData", arg0);
    }
  }
  @Override
  public void glBindVideoCaptureStreamTextureNV(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glBindVideoCaptureStreamTextureNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBindVideoCaptureStreamTextureNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertex3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glVertex3iv", arg0);
    }
  }
  @Override
  public void glInvalidateBufferSubData(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glInvalidateBufferSubData(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glInvalidateBufferSubData", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiDrawElementsBaseVertex(int arg0,java.nio.IntBuffer arg1,int arg2,com.jogamp.common.nio.PointerBuffer arg3,int arg4,java.nio.IntBuffer arg5)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawElementsBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiDrawElementsBaseVertex", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glWindowPos3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glWindowPos3sv", arg1);
    }
  }
  @Override
  public void glUniform4ui(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4ui(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform4ui", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glSecondaryColor3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glSecondaryColor3dv", arg0);
    }
  }
  @Override
  public void glVertexAttribI4uivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4uivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI4uivEXT", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribL4i64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL4i64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL4i64vNV", arg0, arg1);
    }
  }
  @Override
  public void glSelectBuffer(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glSelectBuffer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glSelectBuffer", arg0, arg1);
    }
  }
  @Override
  public void glDrawTransformFeedback(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDrawTransformFeedback(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDrawTransformFeedback", arg0, arg1);
    }
  }
  @Override
  public void glBitmap(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s, <long> %s)",
                   "glBitmap", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertexAttribFormat(int arg0,int arg1,int arg2,boolean arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribFormat(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexAttribFormat", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniformMatrix2fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix2fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix2fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetProgramEnvParameterfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterfvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetProgramEnvParameterfvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetSamplerParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetSamplerParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetSamplerParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public int glBindMaterialParameterEXT(int arg0,int arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glBindMaterialParameterEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindMaterialParameterEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glMultiTexGenfEXT(int arg0,int arg1,int arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGenfEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glMultiTexGenfEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetFloatIndexedvEXT(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetFloatIndexedvEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetFloatIndexedvEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetFloati_vEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetFloati_vEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetFloati_vEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform4ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform4ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform4ui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetNamedRenderbufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetNamedRenderbufferParameterivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedRenderbufferParameterivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEvalCoord2f(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord2f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glEvalCoord2f", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib1dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttrib1dv", arg0, arg2);
    }
  }
  @Override
  public void glUniform3fv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform3fv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI2ivEXT(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2ivEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI2ivEXT", arg0, arg1);
    }
  }
  @Override
  public void glGetProgramInfoLog(int arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetProgramInfoLog(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetProgramInfoLog", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glProgramLocalParametersI4uivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParametersI4uivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramLocalParametersI4uivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glNamedProgramLocalParametersI4ivEXT(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParametersI4ivEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glNamedProgramLocalParametersI4ivEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glEvalCoord2d(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord2d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glEvalCoord2d", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord1dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glTexCoord1dv", arg1);
    }
  }
  @Override
  public void glBeginPerfMonitorAMD(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBeginPerfMonitorAMD(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBeginPerfMonitorAMD", arg0);
    }
  }
  @Override
  public void glVariantubvEXT(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVariantubvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVariantubvEXT", arg0, arg1);
    }
  }
  @Override
  public void glNormal3h(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glNormal3h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glNormal3h", arg0, arg1, arg2);
    }
  }
  @Override
  public void glActiveShaderProgram(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glActiveShaderProgram(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glActiveShaderProgram", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI2uiEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2uiEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI2uiEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTexLevelParameteriv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexLevelParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTexLevelParameteriv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glNormal3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glNormal3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glNormal3s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVariantPointerEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glVariantPointerEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glVariantPointerEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetClipPlanef(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetClipPlanef(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetClipPlanef", arg0, arg2);
    }
  }
  @Override
  public java.nio.ByteBuffer glMapBuffer(int arg0,int arg1)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapBuffer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glMapBuffer", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glVertexAttrib4ubvARB(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4ubvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4ubvARB", arg0, arg2);
    }
  }
  @Override
  public void glSecondaryColorPointer(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColorPointer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glSecondaryColorPointer", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertex3sv", arg0);
    }
  }
  @Override
  public void glWindowPos2s(short arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2s(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s)",
                   "glWindowPos2s", arg0, arg1);
    }
  }
  @Override
  public void glGetActiveUniform(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6,int[] arg7,int arg8,byte[] arg9,int arg10)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniform(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetActiveUniform", arg0, arg1, arg2, arg4, arg6, arg8, arg10);
    }
  }
  @Override
  public void glConvolutionFilter2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glConvolutionFilter2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glConvolutionFilter2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glDrawBuffersATI(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawBuffersATI(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDrawBuffersATI", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform4uiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform4uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glRasterPos3sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos3sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glRasterPos3sv", arg0);
    }
  }
  @Override
  public void glDeleteProgramsARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteProgramsARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteProgramsARB", arg0, arg1);
    }
  }
  @Override
  public void glWindowPos2i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glWindowPos2i", arg0, arg1);
    }
  }
  @Override
  public void glWindowPos2d(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glWindowPos2d", arg0, arg1);
    }
  }
  @Override
  public void glWindowPos2f(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glWindowPos2f", arg0, arg1);
    }
  }
  @Override
  public void glVertexWeightPointerEXT(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexWeightPointerEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexWeightPointerEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform3f(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glUniform3f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor3ubv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3ubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glColor3ubv", arg1);
    }
  }
  @Override
  public void glGenTextures(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenTextures(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenTextures", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexCoord3fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glMultiTexCoord3fv", arg0, arg1);
    }
  }
  @Override
  public void glGetObjectLabel(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetObjectLabel(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetObjectLabel", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public int getDefaultReadFramebuffer()
  {
    return downstreamGL4bc.getDefaultReadFramebuffer();
  }
  @Override
  public void glProgramUniformMatrix3x2fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix3x2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix3x2fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexArrayParameteriAPPLE(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayParameteriAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexArrayParameteriAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glGetActiveUniformBlockName(int arg0,int arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformBlockName(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetActiveUniformBlockName", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public void glVertexAttribP3uiv(int arg0,int arg1,boolean arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP3uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[I>, <int> 0x%X)",
                   "glVertexAttribP3uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttribP4ui(int arg0,int arg1,boolean arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP4ui(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X)",
                   "glVertexAttribP4ui", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glColor3bv(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3bv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glColor3bv", arg1);
    }
  }
  @Override
  public void glMinmax(int arg0,int arg1,boolean arg2)
  {
    checkContext();
    downstreamGL4bc.glMinmax(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glMinmax", arg0, arg1, arg2);
    }
  }
  @Override
  public void glEnableVertexAttribAPPLE(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnableVertexAttribAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnableVertexAttribAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glDisableClientStateIndexedEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDisableClientStateIndexedEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDisableClientStateIndexedEXT", arg0, arg1);
    }
  }
  @Override
  public void glGenFencesAPPLE(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenFencesAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenFencesAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glCompressedTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTexSubImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glDrawBuffers(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDrawBuffers(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDrawBuffers", arg0, arg1);
    }
  }
  @Override
  public void glMatrixLoadTransposedEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoadTransposedEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMatrixLoadTransposedEXT", arg0, arg1);
    }
  }
  @Override
  public void glClipPlane(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glClipPlane(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glClipPlane", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribs3hv(int arg0,int arg1,java.nio.ShortBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribs3hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttribs3hv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTextureParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterIivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTextureParameterIivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetOcclusionQueryivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetOcclusionQueryivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetOcclusionQueryivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexCoordFormatNV(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoordFormatNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexCoordFormatNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glFrontFace(int arg0)
  {
    checkContext();
    downstreamGL4bc.glFrontFace(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glFrontFace", arg0);
    }
  }
  @Override
  public void glNamedProgramLocalParameter4fEXT(int arg0,int arg1,int arg2,float arg3,float arg4,float arg5,float arg6)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameter4fEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glNamedProgramLocalParameter4fEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glVertex4iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glVertex4iv", arg1);
    }
  }
  @Override
  public void glGetMapAttribParameterivNV(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMapAttribParameterivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMapAttribParameterivNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetMaterialiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMaterialiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMaterialiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glColor4iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glColor4iv", arg1);
    }
  }
  @Override
  public void glMultiTexSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,java.nio.Buffer arg11)
  {
    checkContext();
    downstreamGL4bc.glMultiTexSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexSubImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }
  }
  @Override
  public void glUseProgramObjectARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glUseProgramObjectARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glUseProgramObjectARB", arg0);
    }
  }
  @Override
  public void glBindAttribLocation(int arg0,int arg1,java.lang.String arg2)
  {
    checkContext();
    downstreamGL4bc.glBindAttribLocation(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glBindAttribLocation", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetClipPlane(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetClipPlane(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetClipPlane", arg0, arg2);
    }
  }
  @Override
  public void glUniformMatrix4x3fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix4x3fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterfvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterfvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetNamedProgramLocalParameterfvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform1fARB(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1fARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glUniform1fARB", arg0, arg1);
    }
  }
  @Override
  public void glUniform1f(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glUniform1f", arg0, arg1);
    }
  }
  @Override
  public void glSecondaryColor3usv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3usv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glSecondaryColor3usv", arg0);
    }
  }
  @Override
  public void glGenRenderbuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenRenderbuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenRenderbuffers", arg0, arg2);
    }
  }
  @Override
  public void glWeightuivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glWeightuivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glWeightuivARB", arg0, arg2);
    }
  }
  @Override
  public void glViewportArrayv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glViewportArrayv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glViewportArrayv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVariantuivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVariantuivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVariantuivEXT", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribL1dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttribL1dv", arg0, arg1);
    }
  }
  @Override
  public void glAttachShader(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glAttachShader(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glAttachShader", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI2iEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2iEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI2iEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexEnvivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexEnvivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexEnvivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix2x3dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x3dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix2x3dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glGetVertexAttribLdv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribLdv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetVertexAttribLdv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVideoCaptureStreamfvNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureStreamfvNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetVideoCaptureStreamfvNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDepthMask(boolean arg0)
  {
    checkContext();
    downstreamGL4bc.glDepthMask(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<boolean> %s)",
                   "glDepthMask", arg0);
    }
  }
  @Override
  public void glMultiTexCoord3iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoord3iv", arg0, arg1);
    }
  }
  @Override
  public void glDrawRangeElementsBaseVertex(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glDrawRangeElementsBaseVertex(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glDrawRangeElementsBaseVertex", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glUniform4ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4ivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform4ivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNamedProgramLocalParameter4fvEXT(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameter4fvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glNamedProgramLocalParameter4fvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMultiTexCoordP2uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP2uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoordP2uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTextureLevelParameterfvEXT(int arg0,int arg1,int arg2,int arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTextureLevelParameterfvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetTextureLevelParameterfvEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetBooleanv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGetBooleanv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetBooleanv", arg0, arg2);
    }
  }
  @Override
  public void glMultiDrawElements(int arg0,java.nio.IntBuffer arg1,int arg2,com.jogamp.common.nio.PointerBuffer arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiDrawElements(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s, <int> 0x%X)",
                   "glMultiDrawElements", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glNamedProgramLocalParameterI4uivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameterI4uivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glNamedProgramLocalParameterI4uivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetNamedStringivARB(int arg0,java.lang.String arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedStringivARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetNamedStringivARB", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glPathColorGenNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glPathColorGenNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPathColorGenNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glPathCoordsNV(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glPathCoordsNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glPathCoordsNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex4bvOES(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex4bvOES(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glVertex4bvOES", arg0);
    }
  }
  @Override
  public void glMultMatrixf(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMultMatrixf(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glMultMatrixf", arg1);
    }
  }
  @Override
  public void glWeightPathsNV(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glWeightPathsNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.FloatBuffer> %s)",
                   "glWeightPathsNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttribI2i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI2i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttribI3ivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3ivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI3ivEXT", arg0, arg2);
    }
  }
  @Override
  public void glDrawRangeElements(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glDrawRangeElements(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glDrawRangeElements", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGetActiveSubroutineName(int arg0,int arg1,int arg2,int arg3,int[] arg4,int arg5,byte[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glGetActiveSubroutineName(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetActiveSubroutineName", arg0, arg1, arg2, arg3, arg5, arg7);
    }
  }
  @Override
  public void glTexEnvf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glTexEnvf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glTexEnvf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoordP3ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP3ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glTexCoordP3ui", arg0, arg1);
    }
  }
  @Override
  public void glProgramLocalParameter4dvARB(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameter4dvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glProgramLocalParameter4dvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPopDebugGroup()
  {
    checkContext();
    downstreamGL4bc.glPopDebugGroup();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPopDebugGroup");
    }
  }
  @Override
  public void glDepthBoundsEXT(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glDepthBoundsEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glDepthBoundsEXT", arg0, arg1);
    }
  }
  @Override
  public void glPixelTransformParameterfEXT(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelTransformParameterfEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glPixelTransformParameterfEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTexImage(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetTexImage(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetTexImage", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glPixelMapfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glPixelMapfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPixelMapfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord1i(int arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1i(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glTexCoord1i", arg0);
    }
  }
  @Override
  public void glTexParameterIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexParameterIuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexParameterIuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultiTexGendvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGendvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMultiTexGendvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetPolygonStipple(long arg0)
  {
    checkContext();
    downstreamGL4bc.glGetPolygonStipple(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glGetPolygonStipple", arg0);
    }
  }
  @Override
  public void glUniform3fvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glUniform3fvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGenSamplers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenSamplers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenSamplers", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib4NbvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NbvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4NbvARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribI3uivEXT(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI3uivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI3uivEXT", arg0, arg2);
    }
  }
  @Override
  public void glGetInteger64i_v(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetInteger64i_v(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetInteger64i_v", arg0, arg1, arg3);
    }
  }
  @Override
  public void glUniform1i64NV(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1i64NV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glUniform1i64NV", arg0, arg1);
    }
  }
  @Override
  public void glDebugMessageEnableAMD(int arg0,int arg1,int arg2,int[] arg3,int arg4,boolean arg5)
  {
    checkContext();
    downstreamGL4bc.glDebugMessageEnableAMD(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <boolean> %s)",
                   "glDebugMessageEnableAMD", arg0, arg1, arg2, arg4, arg5);
    }
  }
  @Override
  public void glFogCoordFormatNV(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glFogCoordFormatNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glFogCoordFormatNV", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform3dv(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glProgramUniform3dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glEndVideoCaptureNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEndVideoCaptureNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEndVideoCaptureNV", arg0);
    }
  }
  @Override
  public void glFlushVertexArrayRangeAPPLE(int arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glFlushVertexArrayRangeAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s)",
                   "glFlushVertexArrayRangeAPPLE", arg0, arg1);
    }
  }
  @Override
  public void glCompressedTextureSubImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,java.nio.Buffer arg7)
  {
    checkContext();
    downstreamGL4bc.glCompressedTextureSubImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedTextureSubImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glVertexAttrib2svARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2svARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib2svARB", arg0, arg2);
    }
  }
  @Override
  public int glCreateProgramObjectARB()
  {
    checkContext();
    int _res = downstreamGL4bc.glCreateProgramObjectARB();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glCreateProgramObjectARB");
    }
    return _res;
  }
  @Override
  public void glTextureRangeAPPLE(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTextureRangeAPPLE(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTextureRangeAPPLE", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSetFenceAPPLE(int arg0)
  {
    checkContext();
    downstreamGL4bc.glSetFenceAPPLE(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glSetFenceAPPLE", arg0);
    }
  }
  @Override
  public void glGetTexParameterIiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexParameterIiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTexParameterIiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetPerfMonitorCounterDataAMD(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCounterDataAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glGetPerfMonitorCounterDataAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetPerfMonitorCounterDataAMD(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetPerfMonitorCounterDataAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetPerfMonitorCounterDataAMD", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public void glMultiTexCoord2iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoord2iv", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribI4i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4i(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI4i", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glEvalCoord1dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord1dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glEvalCoord1dv", arg1);
    }
  }
  @Override
  public void glClearBufferData(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glClearBufferData(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glClearBufferData", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4bv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4bv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4bv", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribIuiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribIuiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexAttribIuiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetMultiTexParameterivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetMultiTexParameterivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord4bvOES(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glMultiTexCoord4bvOES", arg0, arg1);
    }
  }
  @Override
  public void glTexGenf(int arg0,int arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glTexGenf(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s)",
                   "glTexGenf", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetProgramInterfaceiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramInterfaceiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramInterfaceiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoordP4uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP4uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexCoordP4uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix4fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix4fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glSecondaryColor3us(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3us(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glSecondaryColor3us", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformHandleui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformHandleui64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniformHandleui64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glMatrixMultTransposedEXT(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixMultTransposedEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMatrixMultTransposedEXT", arg0, arg2);
    }
  }
  @Override
  public void glProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glProgramLocalParameters4fvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexWeighthv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexWeighthv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glVertexWeighthv", arg1);
    }
  }
  @Override
  public void glMakeImageHandleNonResidentNV(long arg0)
  {
    checkContext();
    downstreamGL4bc.glMakeImageHandleNonResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glMakeImageHandleNonResidentNV", arg0);
    }
  }
  @Override
  public void glTexCoord2bvOES(byte[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2bvOES(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[B>, <int> 0x%X)",
                   "glTexCoord2bvOES", arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix4x3fv(int arg0,int arg1,int arg2,boolean arg3,java.nio.FloatBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glProgramUniformMatrix4x3fv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glTexCoord3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexCoord3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDebugMessageControl(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4,boolean arg5)
  {
    checkContext();
    downstreamGL4bc.glDebugMessageControl(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <boolean> %s)",
                   "glDebugMessageControl", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glBitmap(int arg0,int arg1,float arg2,float arg3,float arg4,float arg5,java.nio.ByteBuffer arg6)
  {
    checkContext();
    downstreamGL4bc.glBitmap(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s, <java.nio.ByteBuffer> %s)",
                   "glBitmap", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glSamplerParameterIuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSamplerParameterIuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glSamplerParameterIuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCopyTextureImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glCopyTextureImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTextureImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glGetProgramLocalParameterIuivNV(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramLocalParameterIuivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetProgramLocalParameterIuivNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultTransposeMatrixd(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glMultTransposeMatrixd(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glMultTransposeMatrixd", arg0);
    }
  }
  @Override
  public void glUnlockArraysEXT()
  {
    checkContext();
    downstreamGL4bc.glUnlockArraysEXT();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glUnlockArraysEXT");
    }
  }
  @Override
  public void glMultiTexCoordP3uiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glMultiTexCoordP3uiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMap2d(int arg0,double arg1,double arg2,int arg3,int arg4,double arg5,double arg6,int arg7,int arg8,java.nio.DoubleBuffer arg9)
  {
    checkContext();
    downstreamGL4bc.glMap2d(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMap2d", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glCopyTexSubImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glCopyTexSubImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTexSubImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glVertexAttrib4NsvARB(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NsvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib4NsvARB", arg0, arg2);
    }
  }
  @Override
  public void glVertexArrayMultiTexCoordOffsetEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,long arg6)
  {
    checkContext();
    downstreamGL4bc.glVertexArrayMultiTexCoordOffsetEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glVertexArrayMultiTexCoordOffsetEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGetColorTable(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetColorTable(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetColorTable", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord3bOES(int arg0,byte arg1,byte arg2,byte arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3bOES(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <byte> %s, <byte> %s, <byte> %s)",
                   "glMultiTexCoord3bOES", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniformMatrix4x2fv(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x2fv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix4x2fv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetVideoCaptureStreamdvNV(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetVideoCaptureStreamdvNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetVideoCaptureStreamdvNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glDeleteRenderbuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteRenderbuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteRenderbuffers", arg0, arg2);
    }
  }
  @Override
  public void glUniform3iv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform3iv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexEnviv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glTexEnviv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexEnviv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glPatchParameterfv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glPatchParameterfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glPatchParameterfv", arg0, arg1);
    }
  }
  @Override
  public void glDrawArraysIndirect(int arg0,java.nio.Buffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDrawArraysIndirect(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.Buffer> %s)",
                   "glDrawArraysIndirect", arg0, arg1);
    }
  }
  @Override
  public void glGetProgramEnvParameterIivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterIivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramEnvParameterIivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glCopyTextureSubImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glCopyTextureSubImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyTextureSubImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glMultiTexImage1DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,java.nio.Buffer arg8)
  {
    checkContext();
    downstreamGL4bc.glMultiTexImage1DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glMultiTexImage1DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public boolean glPointAlongPathNV(int arg0,int arg1,int arg2,float arg3,float[] arg4,int arg5,float[] arg6,int arg7,float[] arg8,int arg9,float[] arg10,int arg11)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glPointAlongPathNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s, <[F>, <int> 0x%X, <[F>, <int> 0x%X, <[F>, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPointAlongPathNV", arg0, arg1, arg2, arg3, arg5, arg7, arg9, arg11);
    }
    return _res;
  }
  @Override
  public boolean glPointAlongPathNV(int arg0,int arg1,int arg2,float arg3,java.nio.FloatBuffer arg4,java.nio.FloatBuffer arg5,java.nio.FloatBuffer arg6,java.nio.FloatBuffer arg7)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glPointAlongPathNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s, <java.nio.FloatBuffer> %s, <java.nio.FloatBuffer> %s, <java.nio.FloatBuffer> %s, <java.nio.FloatBuffer> %s)",
                   "glPointAlongPathNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
    return _res;
  }
  @Override
  public void glMap1d(int arg0,double arg1,double arg2,int arg3,int arg4,java.nio.DoubleBuffer arg5)
  {
    checkContext();
    downstreamGL4bc.glMap1d(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glMap1d", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public boolean glTestFenceAPPLE(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glTestFenceAPPLE(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glTestFenceAPPLE", arg0);
    }
    return _res;
  }
  @Override
  public void glPathParameterfvNV(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glPathParameterfvNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glPathParameterfvNV", arg0, arg1, arg3);
    }
  }
  @Override
  public boolean glIsNamedBufferResidentNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsNamedBufferResidentNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsNamedBufferResidentNV", arg0);
    }
    return _res;
  }
  @Override
  public int glVideoCaptureNV(int arg0,java.nio.IntBuffer arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glVideoCaptureNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.LongBuffer> %s)",
                   "glVideoCaptureNV", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glLoadTransposeMatrixd(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glLoadTransposeMatrixd(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glLoadTransposeMatrixd", arg0);
    }
  }
  @Override
  public void glRasterPos4iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glRasterPos4iv", arg0);
    }
  }
  @Override
  public void glVertexP3uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexP3uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexP3uiv", arg0, arg2);
    }
  }
  @Override
  public boolean glIsShader(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsShader(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsShader", arg0);
    }
    return _res;
  }
  @Override
  public void glColorTableParameteriv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glColorTableParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glColorTableParameteriv", arg0, arg1, arg3);
    }
  }
  @Override
  public int glGetProgramResourceIndex(int arg0,int arg1,java.nio.ByteBuffer arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceIndex(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glGetProgramResourceIndex", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glGetBufferParameterui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetBufferParameterui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetBufferParameterui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glColorMaski(int arg0,boolean arg1,boolean arg2,boolean arg3,boolean arg4)
  {
    checkContext();
    downstreamGL4bc.glColorMaski(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <boolean> %s, <boolean> %s, <boolean> %s)",
                   "glColorMaski", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4fv(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib4fv", arg0, arg1);
    }
  }
  @Override
  public void glSetMultisamplefvAMD(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glSetMultisamplefvAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glSetMultisamplefvAMD", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetVertexAttribLui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribLui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetVertexAttribLui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glClearBufferuiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glClearBufferuiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glClearBufferuiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColor3d(double arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glColor3d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s)",
                   "glColor3d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord3dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glTexCoord3dv", arg0);
    }
  }
  @Override
  public void glMapVertexAttrib2dAPPLE(int arg0,int arg1,double arg2,double arg3,int arg4,int arg5,double arg6,double arg7,int arg8,int arg9,double[] arg10,int arg11)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib2dAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glMapVertexAttrib2dAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg11);
    }
  }
  @Override
  public void glTexCoord2hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord2hv", arg0);
    }
  }
  @Override
  public void glVertexPointer(javax.media.opengl.GLArrayData arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexPointer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<javax.media.opengl.GLArrayData> %s)",
                   "glVertexPointer", arg0);
    }
  }
  @Override
  public void glStencilStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,java.nio.FloatBuffer arg7)
  {
    checkContext();
    downstreamGL4bc.glStencilStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glStencilStrokePathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glVertexAttrib3dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib3dv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix2x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x3fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix2x3fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glRasterPos4fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glRasterPos4fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glRasterPos4fv", arg0);
    }
  }
  @Override
  public void glUniform2i64vNV(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2i64vNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glUniform2i64vNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNormal3hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glNormal3hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glNormal3hv", arg0);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterdvEXT(int arg0,int arg1,int arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterdvEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetNamedProgramLocalParameterdvEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetMultisamplefvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetMultisamplefvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetMultisamplefvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glRenderbufferStorageMultisample(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glRenderbufferStorageMultisample(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glRenderbufferStorageMultisample", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniformui64NV(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformui64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glProgramUniformui64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTexGendv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexGendv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glGetTexGendv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glWindowPos3dv(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glWindowPos3dv", arg1);
    }
  }
  @Override
  public void glDrawArraysInstanced(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glDrawArraysInstanced(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawArraysInstanced", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public int glBindTextureUnitParameterEXT(int arg0,int arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glBindTextureUnitParameterEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindTextureUnitParameterEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public int glGetSubroutineUniformLocation(int arg0,int arg1,java.lang.String arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetSubroutineUniformLocation(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.lang.String> %s)",
                   "glGetSubroutineUniformLocation", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glUniformMatrix3x2fv(int arg0,int arg1,boolean arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3x2fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glUniformMatrix3x2fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttribI2iv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI2iv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI2iv", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib4iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4iv", arg0, arg1);
    }
  }
  @Override
  public void glTextureNormalEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glTextureNormalEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glTextureNormalEXT", arg0);
    }
  }
  @Override
  public void glTextureImage2DMultisampleNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,boolean arg6)
  {
    checkContext();
    downstreamGL4bc.glTextureImage2DMultisampleNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTextureImage2DMultisampleNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glMultiTexCoord4fv(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4fv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMultiTexCoord4fv", arg0, arg2);
    }
  }
  @Override
  public void glPathGlyphRangeNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,int arg6,int arg7,float arg8)
  {
    checkContext();
    downstreamGL4bc.glPathGlyphRangeNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glPathGlyphRangeNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glNamedRenderbufferStorageEXT(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedRenderbufferStorageEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNamedRenderbufferStorageEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glIndexsv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexsv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glIndexsv", arg1);
    }
  }
  @Override
  public long glGetUniformOffsetEXT(int arg0,int arg1)
  {
    checkContext();
    long _res = downstreamGL4bc.glGetUniformOffsetEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glGetUniformOffsetEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glVertexAttrib4fARB(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4fARB(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glVertexAttrib4fARB", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttribI1iv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttribI1iv", arg0, arg1);
    }
  }
  @Override
  public void glCompressedTexImage2D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,long arg7)
  {
    checkContext();
    downstreamGL4bc.glCompressedTexImage2D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glCompressedTexImage2D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public void glGetnUniformdv(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformdv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetnUniformdv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glVertex3fv", arg0);
    }
  }
  @Override
  public void glColor3sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColor3sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glColor3sv", arg1);
    }
  }
  @Override
  public void glColorP4ui(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glColorP4ui(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glColorP4ui", arg0, arg1);
    }
  }
  @Override
  public void glStencilFuncSeparate(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glStencilFuncSeparate(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glStencilFuncSeparate", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetCompressedTextureImageEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetCompressedTextureImageEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetCompressedTextureImageEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord2sv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord2sv", arg0, arg1);
    }
  }
  @Override
  public void glPushAttrib(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPushAttrib(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPushAttrib", arg0);
    }
  }
  @Override
  public void glMultiTexCoord1hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord1hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glMultiTexCoord1hv", arg0, arg2);
    }
  }
  @Override
  public void glGetProgramStageiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetProgramStageiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramStageiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glWeightfvARB(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightfvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glWeightfvARB", arg0, arg1);
    }
  }
  @Override
  public void glBindVertexShaderEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glBindVertexShaderEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glBindVertexShaderEXT", arg0);
    }
  }
  @Override
  public void glBlendFuncSeparateIndexedAMD(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glBlendFuncSeparateIndexedAMD(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBlendFuncSeparateIndexedAMD", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glLinkProgram(int arg0)
  {
    checkContext();
    downstreamGL4bc.glLinkProgram(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glLinkProgram", arg0);
    }
  }
  @Override
  public void glPushDebugGroup(int arg0,int arg1,int arg2,byte[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glPushDebugGroup(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glPushDebugGroup", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public boolean glIsVertexAttribEnabledAPPLE(int arg0,int arg1)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsVertexAttribEnabledAPPLE(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIsVertexAttribEnabledAPPLE", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glTexCoord3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glTexCoord3iv", arg1);
    }
  }
  @Override
  public void glVertex3hv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex3hv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glVertex3hv", arg0);
    }
  }
  @Override
  public void glMatrixIndexuivARB(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixIndexuivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glMatrixIndexuivARB", arg0, arg2);
    }
  }
  @Override
  public void glTransformPathNV(int arg0,int arg1,int arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glTransformPathNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glTransformPathNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetMultiTexGendvEXT(int arg0,int arg1,int arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexGendvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glGetMultiTexGendvEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord4dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glMultiTexCoord4dv", arg0, arg2);
    }
  }
  @Override
  public void glMapVertexAttrib1fAPPLE(int arg0,int arg1,float arg2,float arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glMapVertexAttrib1fAPPLE(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glMapVertexAttrib1fAPPLE", arg0, arg1, arg2, arg3, arg4, arg5, arg7);
    }
  }
  @Override
  public void glPolygonStipple(long arg0)
  {
    checkContext();
    downstreamGL4bc.glPolygonStipple(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glPolygonStipple", arg0);
    }
  }
  @Override
  public void glVertexAttribL3dv(int arg0,double[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL3dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[D>, <int> 0x%X)",
                   "glVertexAttribL3dv", arg0, arg2);
    }
  }
  @Override
  public void glGetObjectPtrLabel(java.nio.Buffer arg0,int arg1,int[] arg2,int arg3,byte[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetObjectPtrLabel(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.Buffer> %s, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetObjectPtrLabel", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGenPerfMonitorsAMD(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenPerfMonitorsAMD(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenPerfMonitorsAMD", arg0, arg2);
    }
  }
  @Override
  public void glDisableVertexAttribArray(int arg0)
  {
    checkContext();
    downstreamGL4bc.glDisableVertexAttribArray(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glDisableVertexAttribArray", arg0);
    }
  }
  @Override
  public void glGetAttachedShaders(int arg0,int arg1,int[] arg2,int arg3,int[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glGetAttachedShaders(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetAttachedShaders", arg0, arg1, arg3, arg5);
    }
  }
  @Override
  public void glGetAttachedShaders(int arg0,int arg1,java.nio.IntBuffer arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetAttachedShaders(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glGetAttachedShaders", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDrawElements(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glDrawElements(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glDrawElements", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMapGrid2f(int arg0,float arg1,float arg2,int arg3,float arg4,float arg5)
  {
    checkContext();
    downstreamGL4bc.glMapGrid2f(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <int> 0x%X, <float> %s, <float> %s)",
                   "glMapGrid2f", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexAttrib4Nusv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nusv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4Nusv", arg0, arg1);
    }
  }
  @Override
  public void glVertexBlendARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glVertexBlendARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glVertexBlendARB", arg0);
    }
  }
  @Override
  public void glGetMultiTexParameterIivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexParameterIivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetMultiTexParameterIivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniform2i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2i64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform2i64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glVertexAttrib4NuivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4NuivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4NuivARB", arg0, arg1);
    }
  }
  @Override
  public int glCreateShader(int arg0)
  {
    checkContext();
    int _res = downstreamGL4bc.glCreateShader(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glCreateShader", arg0);
    }
    return _res;
  }
  @Override
  public void glCullParameterdvEXT(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glCullParameterdvEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glCullParameterdvEXT", arg0, arg1);
    }
  }
  @Override
  public void glGenFencesNV(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenFencesNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenFencesNV", arg0, arg2);
    }
  }
  @Override
  public int glGetFragDataIndex(int arg0,java.lang.String arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetFragDataIndex(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glGetFragDataIndex", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glDisableClientStateiEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glDisableClientStateiEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glDisableClientStateiEXT", arg0, arg1);
    }
  }
  @Override
  public boolean glIsSync(long arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsSync(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glIsSync", arg0);
    }
    return _res;
  }
  @Override
  public void glDrawElementsIndirect(int arg0,int arg1,java.nio.Buffer arg2)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsIndirect(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glDrawElementsIndirect", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4Nub(int arg0,byte arg1,byte arg2,byte arg3,byte arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nub(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <byte> %s, <byte> %s, <byte> %s, <byte> %s)",
                   "glVertexAttrib4Nub", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetNamedStringARB(int arg0,java.lang.String arg1,int arg2,int[] arg3,int arg4,byte[] arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glGetNamedStringARB(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s, <int> 0x%X, <[I>, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetNamedStringARB", arg0, arg1, arg2, arg4, arg6);
    }
  }
  @Override
  public javax.media.opengl.GL getRootGL()
  {
    return downstreamGL4bc.getRootGL();
  }
  @Override
  public void glVertexAttribI4ui(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI4ui(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertexAttribI4ui", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public int glGetProgramResourceLocation(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetProgramResourceLocation(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetProgramResourceLocation", arg0, arg1, arg3);
    }
    return _res;
  }
  @Override
  public void glBufferData(int arg0,long arg1,java.nio.Buffer arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glBufferData(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glBufferData", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glUniform2ui64NV(int arg0,long arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform2ui64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s)",
                   "glUniform2ui64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetQueryiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetQueryiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGenVertexArrays(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGenVertexArrays(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGenVertexArrays", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformui64vNV(int arg0,int arg1,int arg2,java.nio.LongBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glProgramUniformui64vNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord2iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glTexCoord2iv", arg0);
    }
  }
  @Override
  public void glNormal3fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glNormal3fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glNormal3fv", arg0);
    }
  }
  @Override
  public void glTexStorageSparseAMD(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glTexStorageSparseAMD(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexStorageSparseAMD", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glGenTransformFeedbacksNV(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenTransformFeedbacksNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenTransformFeedbacksNV", arg0, arg2);
    }
  }
  @Override
  public void glMapGrid2d(int arg0,double arg1,double arg2,int arg3,double arg4,double arg5)
  {
    checkContext();
    downstreamGL4bc.glMapGrid2d(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <int> 0x%X, <double> %s, <double> %s)",
                   "glMapGrid2d", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glSecondaryColor3iv(int[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3iv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X)",
                   "glSecondaryColor3iv", arg1);
    }
  }
  @Override
  public void glVertexAttribL1ui64NV(int arg0,long arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1ui64NV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s)",
                   "glVertexAttribL1ui64NV", arg0, arg1);
    }
  }
  @Override
  public void glValidateProgramARB(int arg0)
  {
    checkContext();
    downstreamGL4bc.glValidateProgramARB(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glValidateProgramARB", arg0);
    }
  }
  @Override
  public void glVertexAttrib4dv(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4dv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib4dv", arg0, arg1);
    }
  }
  @Override
  public void glGetTexEnviv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexEnviv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetTexEnviv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glCopyMultiTexImage2DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8)
  {
    checkContext();
    downstreamGL4bc.glCopyMultiTexImage2DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyMultiTexImage2DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }
  }
  @Override
  public void glNormal3iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glNormal3iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glNormal3iv", arg0);
    }
  }
  @Override
  public void glNormalP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glNormalP3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glNormalP3uiv", arg0, arg1);
    }
  }
  @Override
  public void glTexStorage2DMultisample(int arg0,int arg1,int arg2,int arg3,int arg4,boolean arg5)
  {
    checkContext();
    downstreamGL4bc.glTexStorage2DMultisample(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTexStorage2DMultisample", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glAccum(int arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glAccum(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s)",
                   "glAccum", arg0, arg1);
    }
  }
  @Override
  public void glDrawPixels(int arg0,int arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glDrawPixels(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glDrawPixels", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glTexCoord2fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glTexCoord2fv", arg0);
    }
  }
  @Override
  public void glTexCoord4dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glTexCoord4dv", arg0);
    }
  }
  @Override
  public void glEndPerfMonitorAMD(int arg0)
  {
    checkContext();
    downstreamGL4bc.glEndPerfMonitorAMD(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glEndPerfMonitorAMD", arg0);
    }
  }
  @Override
  public void glVertexAttrib4fvARB(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4fvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glVertexAttrib4fvARB", arg0, arg2);
    }
  }
  @Override
  public void glProgramSubroutineParametersuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramSubroutineParametersuivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramSubroutineParametersuivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform2dv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform2dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glUniform2dv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glProgramUniform4i64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4i64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform4i64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetInvariantBooleanvEXT(int arg0,int arg1,byte[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetInvariantBooleanvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[B>, <int> 0x%X)",
                   "glGetInvariantBooleanvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib4hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glVertexAttrib4hv", arg0, arg1);
    }
  }
  @Override
  public void glVDPAUIsSurfaceNV(long arg0)
  {
    checkContext();
    downstreamGL4bc.glVDPAUIsSurfaceNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s)",
                   "glVDPAUIsSurfaceNV", arg0);
    }
  }
  @Override
  public void glGetPathParameterfvNV(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetPathParameterfvNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetPathParameterfvNV", arg0, arg1, arg2);
    }
  }
  @Override
  public int glGetAttribLocation(int arg0,java.lang.String arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glGetAttribLocation(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glGetAttribLocation", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glVertexAttribL1ui64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1ui64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL1ui64vNV", arg0, arg1);
    }
  }
  @Override
  public void glDeleteTransformFeedbacks(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glDeleteTransformFeedbacks(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glDeleteTransformFeedbacks", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib3dvARB(int arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib3dvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glVertexAttrib3dvARB", arg0, arg1);
    }
  }
  @Override
  public void glDepthRangeArrayv(int arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glDepthRangeArrayv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glDepthRangeArrayv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetConvolutionFilter(int arg0,int arg1,int arg2,long arg3)
  {
    checkContext();
    downstreamGL4bc.glGetConvolutionFilter(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glGetConvolutionFilter", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glCopyConvolutionFilter1D(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glCopyConvolutionFilter1D(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glCopyConvolutionFilter1D", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glDeleteTextures(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteTextures(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteTextures", arg0, arg1);
    }
  }
  @Override
  public void glTextureParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterIuivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glTextureParameterIuivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord4hv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord4hv", arg1);
    }
  }
  @Override
  public void glMultiTexCoord2d(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glMultiTexCoord2d", arg0, arg1, arg2);
    }
  }
  @Override
  public boolean hasFullFBOSupport()
  {
    return downstreamGL4bc.hasFullFBOSupport();
  }
  @Override
  public void glProgramEnvParameter4fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParameter4fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramEnvParameter4fvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glMultiTexCoord2f(int arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glMultiTexCoord2f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniformMatrix4x3fvEXT(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x3fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix4x3fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glGetIntegerv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetIntegerv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetIntegerv", arg0, arg1);
    }
  }
  @Override
  public void glUniform1ui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1ui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glUniform1ui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glWindowPos2fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glWindowPos2fv", arg0);
    }
  }
  @Override
  public void glBufferSubData(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glBufferSubData(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <java.nio.Buffer> %s)",
                   "glBufferSubData", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord2i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoord2i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNormal3i(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glNormal3i(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glNormal3i", arg0, arg1, arg2);
    }
  }
  @Override
  public void glDrawTransformFeedbackStreamInstanced(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glDrawTransformFeedbackStreamInstanced(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawTransformFeedbackStreamInstanced", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glMultiTexCoord2h(int arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s)",
                   "glMultiTexCoord2h", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform3uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3uivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform3uivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTextureParameterfEXT(int arg0,int arg1,int arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterfEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glTextureParameterfEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glFogCoorddv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glFogCoorddv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glFogCoorddv", arg0);
    }
  }
  @Override
  public void glWindowPos2iv(java.nio.IntBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glWindowPos2iv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s)",
                   "glWindowPos2iv", arg0);
    }
  }
  @Override
  public void glPathCoverDepthFuncNV(int arg0)
  {
    checkContext();
    downstreamGL4bc.glPathCoverDepthFuncNV(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glPathCoverDepthFuncNV", arg0);
    }
  }
  @Override
  public void glScissorIndexedv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glScissorIndexedv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glScissorIndexedv", arg0, arg2);
    }
  }
  @Override
  public void glMultiTexCoord2s(int arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord2s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s)",
                   "glMultiTexCoord2s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetTexGenfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTexGenfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetTexGenfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glRectfv(float[] arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRectfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glRectfv", arg1, arg3);
    }
  }
  @Override
  public void glRectfv(java.nio.FloatBuffer arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glRectfv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s, <java.nio.FloatBuffer> %s)",
                   "glRectfv", arg0, arg1);
    }
  }
  @Override
  public void glPointSize(float arg0)
  {
    checkContext();
    downstreamGL4bc.glPointSize(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glPointSize", arg0);
    }
  }
  @Override
  public void glMatrixLoadTransposefEXT(int arg0,float[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMatrixLoadTransposefEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[F>, <int> 0x%X)",
                   "glMatrixLoadTransposefEXT", arg0, arg2);
    }
  }
  @Override
  public void glProgramUniform3fv(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3fv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramUniform3fv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetVariantIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVariantIntegervEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVariantIntegervEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glValidateProgramPipeline(int arg0)
  {
    checkContext();
    downstreamGL4bc.glValidateProgramPipeline(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glValidateProgramPipeline", arg0);
    }
  }
  @Override
  public void glMultMatrixd(double[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glMultMatrixd(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X)",
                   "glMultMatrixd", arg1);
    }
  }
  @Override
  public void glProgramUniform3uiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform3uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glEvalCoord1fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord1fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glEvalCoord1fv", arg1);
    }
  }
  @Override
  public void glGetMultiTexImageEXT(int arg0,int arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetMultiTexImageEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetMultiTexImageEXT", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glVertexAttribL1i64vNV(int arg0,java.nio.LongBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribL1i64vNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glVertexAttribL1i64vNV", arg0, arg1);
    }
  }
  @Override
  public void glUniform1i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glUniform1i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glUniform1i", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribivARB(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribivARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetVertexAttribivARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetnPixelMapusv(int arg0,int arg1,short[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnPixelMapusv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[S>, <int> 0x%X)",
                   "glGetnPixelMapusv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glVertexAttrib2s(int arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s)",
                   "glVertexAttrib2s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetnUniformiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetnUniformiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glProgramUniformMatrix4dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix4dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glProgramBinary(int arg0,int arg1,java.nio.Buffer arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramBinary(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X)",
                   "glProgramBinary", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib2h(int arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s)",
                   "glVertexAttrib2h", arg0, arg1, arg2);
    }
  }
  @Override
  public long glGetTextureSamplerHandleNV(int arg0,int arg1)
  {
    checkContext();
    long _res = downstreamGL4bc.glGetTextureSamplerHandleNV(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glGetTextureSamplerHandleNV", arg0, arg1);
    }
    return _res;
  }
  @Override
  public void glVertexAttribI1uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribI1uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttribI1uiv", arg0, arg2);
    }
  }
  @Override
  public java.nio.ByteBuffer glAllocateMemoryNV(int arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glAllocateMemoryNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s)",
                   "glAllocateMemoryNV", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public void glMultiTexCoord4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4d(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glMultiTexCoord4d", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib2d(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2d(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glVertexAttrib2d", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord4f(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4f(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glMultiTexCoord4f", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib2f(int arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s)",
                   "glVertexAttrib2f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexCoord4h(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4h(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s, <short> %s)",
                   "glMultiTexCoord4h", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetQueryIndexediv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryIndexediv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetQueryIndexediv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glEndList()
  {
    checkContext();
    downstreamGL4bc.glEndList();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEndList");
    }
  }
  @Override
  public void glMultiTexCoord4i(int arg0,int arg1,int arg2,int arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4i(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoord4i", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glIndexMaterialEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glIndexMaterialEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glIndexMaterialEXT", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib4Nbv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nbv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4Nbv", arg0, arg2);
    }
  }
  @Override
  public void glGetNamedBufferParameterivEXT(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetNamedBufferParameterivEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedBufferParameterivEXT", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexEnvfEXT(int arg0,int arg1,int arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glMultiTexEnvfEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <float> %s)",
                   "glMultiTexEnvfEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGenFramebuffers(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glGenFramebuffers(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glGenFramebuffers", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttribP2uiv(int arg0,int arg1,boolean arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribP2uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[I>, <int> 0x%X)",
                   "glVertexAttribP2uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glRectdv(double[] arg0,int arg1,double[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRectdv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[D>, <int> 0x%X, <[D>, <int> 0x%X)",
                   "glRectdv", arg1, arg3);
    }
  }
  @Override
  public void glRectdv(java.nio.DoubleBuffer arg0,java.nio.DoubleBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glRectdv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s, <java.nio.DoubleBuffer> %s)",
                   "glRectdv", arg0, arg1);
    }
  }
  @Override
  public void glMultiTexCoord4s(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord4s(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s, <short> %s)",
                   "glMultiTexCoord4s", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glCoverStrokePathInstancedNV(int arg0,int arg1,java.nio.Buffer arg2,int arg3,int arg4,int arg5,float[] arg6,int arg7)
  {
    checkContext();
    downstreamGL4bc.glCoverStrokePathInstancedNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glCoverStrokePathInstancedNV", arg0, arg1, arg2, arg3, arg4, arg5, arg7);
    }
  }
  @Override
  public void glPointParameteriv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glPointParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glPointParameteriv", arg0, arg2);
    }
  }
  @Override
  public void glGetNamedProgramLocalParameterIuivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramLocalParameterIuivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetNamedProgramLocalParameterIuivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glWeightubvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightubvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glWeightubvARB", arg0, arg1);
    }
  }
  @Override
  public void glGetInvariantFloatvEXT(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetInvariantFloatvEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetInvariantFloatvEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glBindRenderbuffer(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBindRenderbuffer(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindRenderbuffer", arg0, arg1);
    }
  }
  @Override
  public void glEndConditionalRender()
  {
    checkContext();
    downstreamGL4bc.glEndConditionalRender();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glEndConditionalRender");
    }
  }
  @Override
  public void glGetnMinmax(int arg0,boolean arg1,int arg2,int arg3,int arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetnMinmax(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetnMinmax", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glTextureParameterivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glTextureParameterivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glTextureParameterivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glEnableClientStateiEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glEnableClientStateiEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glEnableClientStateiEXT", arg0, arg1);
    }
  }
  @Override
  public void glProgramLocalParameter4fvARB(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramLocalParameter4fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glProgramLocalParameter4fvARB", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetUniformui64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetUniformui64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetUniformui64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glWaitSync(long arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glWaitSync(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X, <long> %s)",
                   "glWaitSync", arg0, arg1, arg2);
    }
  }
  @Override
  public void glShadeModel(int arg0)
  {
    checkContext();
    downstreamGL4bc.glShadeModel(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glShadeModel", arg0);
    }
  }
  @Override
  public void glUniformMatrix3fvARB(int arg0,int arg1,boolean arg2,java.nio.FloatBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3fvARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.FloatBuffer> %s)",
                   "glUniformMatrix3fvARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexP4uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexP4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexP4uiv", arg0, arg2);
    }
  }
  @Override
  public void glVertexAttrib2hv(int arg0,short[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2hv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[S>, <int> 0x%X)",
                   "glVertexAttrib2hv", arg0, arg2);
    }
  }
  @Override
  public int glClientWaitSync(long arg0,int arg1,long arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glClientWaitSync(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<long> %s, <int> 0x%X, <long> %s)",
                   "glClientWaitSync", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glUniform3i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform3i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetActiveUniformName(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.ByteBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glGetActiveUniformName(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.ByteBuffer> %s)",
                   "glGetActiveUniformName", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glGetColorTableParameterfv(int arg0,int arg1,float[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetColorTableParameterfv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetColorTableParameterfv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glInterleavedArrays(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glInterleavedArrays(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glInterleavedArrays", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramUniform2uiv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform2uiv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glDeleteVertexArrays(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteVertexArrays(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glDeleteVertexArrays", arg0, arg1);
    }
  }
  @Override
  public void glUniform4i64NV(int arg0,long arg1,long arg2,long arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glUniform4i64NV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <long> %s, <long> %s)",
                   "glUniform4i64NV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glDeleteNamedStringARB(int arg0,java.lang.String arg1)
  {
    checkContext();
    downstreamGL4bc.glDeleteNamedStringARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.lang.String> %s)",
                   "glDeleteNamedStringARB", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib1sARB(int arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib1sARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s)",
                   "glVertexAttrib1sARB", arg0, arg1);
    }
  }
  @Override
  public void glColorSubTable(int arg0,int arg1,int arg2,int arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glColorSubTable(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glColorSubTable", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glDrawElementsInstancedBaseVertexBaseInstance(int arg0,int arg1,int arg2,java.nio.Buffer arg3,int arg4,int arg5,int arg6)
  {
    checkContext();
    downstreamGL4bc.glDrawElementsInstancedBaseVertexBaseInstance(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glDrawElementsInstancedBaseVertexBaseInstance", arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }
  }
  @Override
  public void glTessellationModeAMD(int arg0)
  {
    checkContext();
    downstreamGL4bc.glTessellationModeAMD(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glTessellationModeAMD", arg0);
    }
  }
  @Override
  public void glGetnUniformuiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetnUniformuiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetnUniformuiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetPixelMapusv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glGetPixelMapusv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glGetPixelMapusv", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib4uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glVertexAttrib4uiv", arg0, arg2);
    }
  }
  @Override
  public void glGetNamedProgramStringEXT(int arg0,int arg1,int arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedProgramStringEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glGetNamedProgramStringEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetTextureParameterIivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetTextureParameterIivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetTextureParameterIivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetLocalConstantIntegervEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetLocalConstantIntegervEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetLocalConstantIntegervEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glIndexd(double arg0)
  {
    checkContext();
    downstreamGL4bc.glIndexd(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s)",
                   "glIndexd", arg0);
    }
  }
  @Override
  public void glGetQueryObjectui64vEXT(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjectui64vEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetQueryObjectui64vEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetConvolutionParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetConvolutionParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetConvolutionParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glColorPointer(javax.media.opengl.GLArrayData arg0)
  {
    checkContext();
    downstreamGL4bc.glColorPointer(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<javax.media.opengl.GLArrayData> %s)",
                   "glColorPointer", arg0);
    }
  }
  @Override
  public void glGetHistogram(int arg0,boolean arg1,int arg2,int arg3,long arg4)
  {
    checkContext();
    downstreamGL4bc.glGetHistogram(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <boolean> %s, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glGetHistogram", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glTextureLightEXT(int arg0)
  {
    checkContext();
    downstreamGL4bc.glTextureLightEXT(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glTextureLightEXT", arg0);
    }
  }
  @Override
  public void glGetProgramiv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramiv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetObjectParameterivAPPLE(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetObjectParameterivAPPLE(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetObjectParameterivAPPLE", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glTextureImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,java.nio.Buffer arg10)
  {
    checkContext();
    downstreamGL4bc.glTextureImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glTextureImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }
  }
  @Override
  public void glTexGeni(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexGeni(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexGeni", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex4s(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glVertex4s(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glVertex4s", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glPolygonStipple(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glPolygonStipple(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glPolygonStipple", arg0);
    }
  }
  @Override
  public void glProgramEnvParametersI4uivNV(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramEnvParametersI4uivNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramEnvParametersI4uivNV", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoordP2uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP2uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexCoordP2uiv", arg0, arg2);
    }
  }
  @Override
  public void glColor4ubv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glColor4ubv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glColor4ubv", arg0);
    }
  }
  @Override
  public void glProgramUniformHandleui64NV(int arg0,int arg1,long arg2)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformHandleui64NV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <long> %s)",
                   "glProgramUniformHandleui64NV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord3f(float arg0,float arg1,float arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3f(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s)",
                   "glTexCoord3f", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex4d(double arg0,double arg1,double arg2,double arg3)
  {
    checkContext();
    downstreamGL4bc.glVertex4d(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s, <double> %s, <double> %s)",
                   "glVertex4d", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glLoadMatrixd(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glLoadMatrixd(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glLoadMatrixd", arg0);
    }
  }
  @Override
  public void glVertex4f(float arg0,float arg1,float arg2,float arg3)
  {
    checkContext();
    downstreamGL4bc.glVertex4f(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s, <float> %s, <float> %s)",
                   "glVertex4f", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexImage3D(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,long arg9)
  {
    checkContext();
    downstreamGL4bc.glTexImage3D(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <long> %s)",
                   "glTexImage3D", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }
  }
  @Override
  public void glGetVertexArrayPointeri_vEXT(int arg0,int arg1,int arg2,com.jogamp.common.nio.PointerBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexArrayPointeri_vEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <com.jogamp.common.nio.PointerBuffer> %s)",
                   "glGetVertexArrayPointeri_vEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex4h(short arg0,short arg1,short arg2,short arg3)
  {
    checkContext();
    downstreamGL4bc.glVertex4h(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s, <short> %s)",
                   "glVertex4h", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex4i(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glVertex4i(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glVertex4i", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4ivARB(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4ivARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glVertexAttrib4ivARB", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniformMatrix4x2fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x2fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix4x2fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVertex4dv(java.nio.DoubleBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glVertex4dv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.DoubleBuffer> %s)",
                   "glVertex4dv", arg0);
    }
  }
  @Override
  public void glMultiTexCoord3hv(int arg0,java.nio.ShortBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoord3hv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ShortBuffer> %s)",
                   "glMultiTexCoord3hv", arg0, arg1);
    }
  }
  @Override
  public void glUniformMatrix4x3dv(int arg0,int arg1,boolean arg2,double[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix4x3dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glUniformMatrix4x3dv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glActiveTexture(int arg0)
  {
    checkContext();
    downstreamGL4bc.glActiveTexture(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glActiveTexture", arg0);
    }
  }
  @Override
  public int glBindTexGenParameterEXT(int arg0,int arg1,int arg2)
  {
    checkContext();
    int _res = downstreamGL4bc.glBindTexGenParameterEXT(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glBindTexGenParameterEXT", arg0, arg1, arg2);
    }
    return _res;
  }
  @Override
  public void glProgramUniformMatrix2x3fv(int arg0,int arg1,int arg2,boolean arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2x3fv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[F>, <int> 0x%X)",
                   "glProgramUniformMatrix2x3fv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glTexCoordP1uiv(int arg0,int[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoordP1uiv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[I>, <int> 0x%X)",
                   "glTexCoordP1uiv", arg0, arg2);
    }
  }
  @Override
  public void glBlendEquationi(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBlendEquationi(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBlendEquationi", arg0, arg1);
    }
  }
  @Override
  public void glRectiv(int[] arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glRectiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glRectiv", arg1, arg3);
    }
  }
  @Override
  public void glRectiv(java.nio.IntBuffer arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glRectiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glRectiv", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform3ui64vNV(int arg0,int arg1,int arg2,long[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform3ui64vNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glProgramUniform3ui64vNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix4x2dv(int arg0,int arg1,int arg2,boolean arg3,double[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix4x2dv(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <[D>, <int> 0x%X)",
                   "glProgramUniformMatrix4x2dv", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glUniform3iARB(int arg0,int arg1,int arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform3iARB(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glUniform3iARB", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glSecondaryColorP3uiv(int arg0,java.nio.IntBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColorP3uiv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glSecondaryColorP3uiv", arg0, arg1);
    }
  }
  @Override
  public void glUniform1uiv(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glUniform1uiv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glUniform1uiv", arg0, arg1, arg3);
    }
  }
  @Override
  public void glBlendFunc(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glBlendFunc(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBlendFunc", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttribPointerARB(int arg0,int arg1,int arg2,boolean arg3,int arg4,long arg5)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribPointerARB(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <int> 0x%X, <long> %s)",
                   "glVertexAttribPointerARB", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glClearNamedBufferDataEXT(int arg0,int arg1,int arg2,int arg3,java.nio.Buffer arg4)
  {
    checkContext();
    downstreamGL4bc.glClearNamedBufferDataEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glClearNamedBufferDataEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glWeightbvARB(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glWeightbvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glWeightbvARB", arg0, arg1);
    }
  }
  @Override
  public void glPopAttrib()
  {
    checkContext();
    downstreamGL4bc.glPopAttrib();
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s()",
                   "glPopAttrib");
    }
  }
  @Override
  public void glVertexAttribDivisor(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttribDivisor(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertexAttribDivisor", arg0, arg1);
    }
  }
  @Override
  public void glGetFramebufferParameterivEXT(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetFramebufferParameterivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glGetFramebufferParameterivEXT", arg0, arg1, arg3);
    }
  }
  @Override
  public void glSecondaryColor3bv(java.nio.ByteBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3bv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ByteBuffer> %s)",
                   "glSecondaryColor3bv", arg0);
    }
  }
  @Override
  public void glCompressedMultiTexSubImage3DEXT(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,int arg7,int arg8,int arg9,int arg10,java.nio.Buffer arg11)
  {
    checkContext();
    downstreamGL4bc.glCompressedMultiTexSubImage3DEXT(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s)",
                   "glCompressedMultiTexSubImage3DEXT", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }
  }
  @Override
  public boolean glIsFenceAPPLE(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsFenceAPPLE(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X)",
                   "glIsFenceAPPLE", arg0);
    }
    return _res;
  }
  @Override
  public void glNamedBufferSubDataEXT(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glNamedBufferSubDataEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <java.nio.Buffer> %s)",
                   "glNamedBufferSubDataEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertex2i(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2i(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glVertex2i", arg0, arg1);
    }
  }
  @Override
  public void glGetQueryObjecti64v(int arg0,int arg1,java.nio.LongBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetQueryObjecti64v(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.LongBuffer> %s)",
                   "glGetQueryObjecti64v", arg0, arg1, arg2);
    }
  }
  @Override
  public void glNamedProgramLocalParameters4fvEXT(int arg0,int arg1,int arg2,int arg3,float[] arg4,int arg5)
  {
    checkContext();
    downstreamGL4bc.glNamedProgramLocalParameters4fvEXT(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glNamedProgramLocalParameters4fvEXT", arg0, arg1, arg2, arg3, arg5);
    }
  }
  @Override
  public void glVertex2s(short arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2s(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s)",
                   "glVertex2s", arg0, arg1);
    }
  }
  @Override
  public void glGetVertexAttribLi64vNV(int arg0,int arg1,long[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribLi64vNV(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[J>, <int> 0x%X)",
                   "glGetVertexAttribLi64vNV", arg0, arg1, arg3);
    }
  }
  @Override
  public void glTexEnvi(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glTexEnvi(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glTexEnvi", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetMapAttribParameterfvNV(int arg0,int arg1,int arg2,float[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glGetMapAttribParameterfvNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[F>, <int> 0x%X)",
                   "glGetMapAttribParameterfvNV", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glGetProgramEnvParameterIuivNV(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetProgramEnvParameterIuivNV(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetProgramEnvParameterIuivNV", arg0, arg1, arg2);
    }
  }
  @Override
  public void glGetFramebufferAttachmentParameteriv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetFramebufferAttachmentParameteriv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetFramebufferAttachmentParameteriv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glVertexAttrib4h(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4h(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s, <short> %s)",
                   "glVertexAttrib4h", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4f(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4f(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glVertexAttrib4f", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glProgramUniformMatrix2dv(int arg0,int arg1,int arg2,boolean arg3,java.nio.DoubleBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniformMatrix2dv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glProgramUniformMatrix2dv", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4d(int arg0,double arg1,double arg2,double arg3,double arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4d(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s, <double> %s, <double> %s)",
                   "glVertexAttrib4d", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glTexCoord1f(float arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord1f(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s)",
                   "glTexCoord1f", arg0);
    }
  }
  @Override
  public void glVertex2f(float arg0,float arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2f(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<float> %s, <float> %s)",
                   "glVertex2f", arg0, arg1);
    }
  }
  @Override
  public void glVertex2h(short arg0,short arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2h(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s)",
                   "glVertex2h", arg0, arg1);
    }
  }
  @Override
  public void glInvalidateFramebuffer(int arg0,int arg1,int[] arg2,int arg3)
  {
    checkContext();
    downstreamGL4bc.glInvalidateFramebuffer(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glInvalidateFramebuffer", arg0, arg1, arg3);
    }
  }
  @Override
  public void glGetConvolutionParameteriv(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetConvolutionParameteriv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glGetConvolutionParameteriv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertex2d(double arg0,double arg1)
  {
    checkContext();
    downstreamGL4bc.glVertex2d(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<double> %s, <double> %s)",
                   "glVertex2d", arg0, arg1);
    }
  }
  @Override
  public void glVertexAttrib2fvARB(int arg0,java.nio.FloatBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2fvARB(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glVertexAttrib2fvARB", arg0, arg1);
    }
  }
  @Override
  public void glTexCoord2sv(java.nio.ShortBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glTexCoord2sv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.ShortBuffer> %s)",
                   "glTexCoord2sv", arg0);
    }
  }
  @Override
  public void glDepthRangeIndexed(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glDepthRangeIndexed(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glDepthRangeIndexed", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib4s(int arg0,short arg1,short arg2,short arg3,short arg4)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4s(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <short> %s, <short> %s, <short> %s, <short> %s)",
                   "glVertexAttrib4s", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glMultiTexCoordP2ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glMultiTexCoordP2ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glMultiTexCoordP2ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glProgramBufferParametersIivNV(int arg0,int arg1,int arg2,int arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramBufferParametersIivNV(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramBufferParametersIivNV", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glVertexAttrib4Nubv(int arg0,byte[] arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4Nubv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <[B>, <int> 0x%X)",
                   "glVertexAttrib4Nubv", arg0, arg2);
    }
  }
  @Override
  public java.nio.ByteBuffer glMapNamedBufferRangeEXT(int arg0,long arg1,long arg2,int arg3)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapNamedBufferRangeEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <int> 0x%X)",
                   "glMapNamedBufferRangeEXT", arg0, arg1, arg2, arg3);
    }
    return _res;
  }
  @Override
  public void glEvalCoord2fv(java.nio.FloatBuffer arg0)
  {
    checkContext();
    downstreamGL4bc.glEvalCoord2fv(arg0);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<java.nio.FloatBuffer> %s)",
                   "glEvalCoord2fv", arg0);
    }
  }
  @Override
  public void glGetNamedBufferSubDataEXT(int arg0,long arg1,long arg2,java.nio.Buffer arg3)
  {
    checkContext();
    downstreamGL4bc.glGetNamedBufferSubDataEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <long> %s, <long> %s, <java.nio.Buffer> %s)",
                   "glGetNamedBufferSubDataEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glGetSeparableFilter(int arg0,int arg1,int arg2,java.nio.Buffer arg3,java.nio.Buffer arg4,java.nio.Buffer arg5)
  {
    checkContext();
    downstreamGL4bc.glGetSeparableFilter(arg0,arg1,arg2,arg3,arg4,arg5);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.Buffer> %s, <java.nio.Buffer> %s, <java.nio.Buffer> %s)",
                   "glGetSeparableFilter", arg0, arg1, arg2, arg3, arg4, arg5);
    }
  }
  @Override
  public void glGenerateTextureMipmapEXT(int arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glGenerateTextureMipmapEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glGenerateTextureMipmapEXT", arg0, arg1);
    }
  }
  @Override
  public void glProgramUniform1uiv(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform1uiv(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glProgramUniform1uiv", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glTextureImage3DMultisampleNV(int arg0,int arg1,int arg2,int arg3,int arg4,int arg5,int arg6,boolean arg7)
  {
    checkContext();
    downstreamGL4bc.glTextureImage3DMultisampleNV(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <int> 0x%X, <boolean> %s)",
                   "glTextureImage3DMultisampleNV", arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }
  }
  @Override
  public java.nio.ByteBuffer glMapTexture2DINTEL(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3,java.nio.IntBuffer arg4)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapTexture2DINTEL(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s, <java.nio.IntBuffer> %s)",
                   "glMapTexture2DINTEL", arg0, arg1, arg2, arg3, arg4);
    }
    return _res;
  }
  @Override
  public java.nio.ByteBuffer glMapTexture2DINTEL(int arg0,int arg1,int arg2,int[] arg3,int arg4,int[] arg5,int arg6)
  {
    checkContext();
    java.nio.ByteBuffer _res = downstreamGL4bc.glMapTexture2DINTEL(arg0,arg1,arg2,arg3,arg4,arg5,arg6);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMapTexture2DINTEL", arg0, arg1, arg2, arg4, arg6);
    }
    return _res;
  }
  @Override
  public void glMatrixRotatefEXT(int arg0,float arg1,float arg2,float arg3,float arg4)
  {
    checkContext();
    downstreamGL4bc.glMatrixRotatefEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <float> %s, <float> %s, <float> %s, <float> %s)",
                   "glMatrixRotatefEXT", arg0, arg1, arg2, arg3, arg4);
    }
  }
  @Override
  public void glUniformMatrix3dv(int arg0,int arg1,boolean arg2,java.nio.DoubleBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glUniformMatrix3dv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <boolean> %s, <java.nio.DoubleBuffer> %s)",
                   "glUniformMatrix3dv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexParameterfv(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glTexParameterfv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glTexParameterfv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glVertexAttrib2dARB(int arg0,double arg1,double arg2)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib2dARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <double> %s, <double> %s)",
                   "glVertexAttrib2dARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glMultiTexGenivEXT(int arg0,int arg1,int arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glMultiTexGenivEXT(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <[I>, <int> 0x%X)",
                   "glMultiTexGenivEXT", arg0, arg1, arg2, arg4);
    }
  }
  @Override
  public void glProgramUniform2iv(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform2iv(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform2iv", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord3s(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3s(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glTexCoord3s", arg0, arg1, arg2);
    }
  }
  @Override
  public void glSecondaryColor3ui(int arg0,int arg1,int arg2)
  {
    checkContext();
    downstreamGL4bc.glSecondaryColor3ui(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X)",
                   "glSecondaryColor3ui", arg0, arg1, arg2);
    }
  }
  @Override
  public void glShaderSource(int arg0,int arg1,java.lang.String[] arg2,int[] arg3,int arg4)
  {
    checkContext();
    downstreamGL4bc.glShaderSource(arg0,arg1,arg2,arg3,arg4);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <[Ljava.lang.String;>, <[I>, <int> 0x%X)",
                   "glShaderSource", arg0, arg1, arg4);
    }
  }
  @Override
  public void glGetVertexAttribfvARB(int arg0,int arg1,java.nio.FloatBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glGetVertexAttribfvARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.FloatBuffer> %s)",
                   "glGetVertexAttribfvARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glTexCoord3h(short arg0,short arg1,short arg2)
  {
    checkContext();
    downstreamGL4bc.glTexCoord3h(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<short> %s, <short> %s, <short> %s)",
                   "glTexCoord3h", arg0, arg1, arg2);
    }
  }
  @Override
  public javax.media.opengl.GLContext getContext()
  {
    return downstreamGL4bc.getContext();
  }
  @Override
  public void glProgramUniform4uivEXT(int arg0,int arg1,int arg2,java.nio.IntBuffer arg3)
  {
    checkContext();
    downstreamGL4bc.glProgramUniform4uivEXT(arg0,arg1,arg2,arg3);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glProgramUniform4uivEXT", arg0, arg1, arg2, arg3);
    }
  }
  @Override
  public void glTexCoord4sv(short[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glTexCoord4sv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[S>, <int> 0x%X)",
                   "glTexCoord4sv", arg1);
    }
  }
  @Override
  public void glUniform3ivARB(int arg0,int arg1,java.nio.IntBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform3ivARB(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.IntBuffer> %s)",
                   "glUniform3ivARB", arg0, arg1, arg2);
    }
  }
  @Override
  public void glUniform4dv(int arg0,int arg1,java.nio.DoubleBuffer arg2)
  {
    checkContext();
    downstreamGL4bc.glUniform4dv(arg0,arg1,arg2);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X, <java.nio.DoubleBuffer> %s)",
                   "glUniform4dv", arg0, arg1, arg2);
    }
  }
  @Override
  public void glWindowPos3fv(float[] arg0,int arg1)
  {
    checkContext();
    downstreamGL4bc.glWindowPos3fv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<[F>, <int> 0x%X)",
                   "glWindowPos3fv", arg1);
    }
  }
  @Override
  public void glVertexAttrib4ubv(int arg0,java.nio.ByteBuffer arg1)
  {
    checkContext();
    downstreamGL4bc.glVertexAttrib4ubv(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <java.nio.ByteBuffer> %s)",
                   "glVertexAttrib4ubv", arg0, arg1);
    }
  }
  @Override
  public int glBindLightParameterEXT(int arg0,int arg1)
  {
    checkContext();
    int _res = downstreamGL4bc.glBindLightParameterEXT(arg0,arg1);
    final int err = checkGLError();
    if (err != GL_NO_ERROR) {
      writeGLError(err, "%s(<int> 0x%X, <int> 0x%X)",
                   "glBindLightParameterEXT", arg0, arg1);
    }
    return _res;
  }
  @Override
  public boolean glIsTransformFeedbackNV(int arg0)
  {
    checkContext();
    boolean _res = downstreamGL4bc.glIsTransf