// escher web sketch:
//
// Copyright 1996, 1997, 1998 by Wes Hardaker and the University of
// Lausanne, Switzerland.  All rights reserved.
//
// Permission to use, copy, modify, and distribute this software and
// its documentation for any purpose and without fee is hereby granted
// for non commerical use, provided that both the above copyright
// notice and this permission notice appear unmodified and intact.
//
// Questions regarding pricing for commerical usage should be sent to
// escher@sphysdec1.unil.ch.
//

import java.awt.*;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class p1 extends ehex {
   int real_height;
   boolean editPatternAngle=false;

 public p1(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p1";
 }

 public void setsize(int sz) {
   real_height = sz;
   super.setsize(sz);
 }

 public void set_angle(int ang) {
   angsin = Math.sin(ang * 3.1415 / 180);
   angcos = Math.cos(ang * 3.1415 / 180);
   height = (int) Math.round(((double) real_height)*angsin);
   dheight = height*2;
   after_ResizeIt();
 }
   
 public void ResizeItX(int sz) {
	 setSizeX(sz);
   after_ResizeIt();
 }

 public void ResizeItY(int sz) {
	 setSizeY(sz);
   after_ResizeIt();
 }

	public void setSizeX(int sx) {
		width = sx;
		dwidth = width*2;
	}
	
	public void setSizeY(int sy) {
		height = (int) Math.round(((double) sy)*angsin);
		dheight = height*2;
		real_height = sy;
	}

 public void setPatternSize() {
	int ty = (int) Math.round(((double) patSy)/angsin);
	if (ty<2) ty=2;
	setSizeY(ty/2);

  int tx = patSx-((int) Math.round(((double)dheight)/angsin*angcos)); 
	if (tx<2) tx=2;
	setSizeX(tx/2);
 }


/*
 public void after_ResizeIt() {
 	if (!editAngle) super.after_ResizeIt();	
 }
*/

 
 public Dimension minCellSize() {
	return new Dimension(40, 20);
 }

 public void draw_frame_inside(Graphics g) {
 }


 public void enterEditPattern(JToggleButton buttonToRelease) {
	 if (!editPatternAngle) {
		super.enterEditPattern(buttonToRelease);
		angsin = Math.sin(60.0*Math.PI/180.0);
		angcos = Math.cos(60.0*Math.PI/180.0);
	 }
 }
 
 public boolean isModeEditPattern() {
	 return editPatternAngle || super.isModeEditPattern();
 }

 public void leaveEditPattern() {
	editPatternAngle=false;
	super.leaveEditPattern();
 }
 
 public void mouseDown(Event evt, int x, int y) {
	if (editPatternAngle) {}
	else super.mouseDown(evt, x, y);
 }


 public void mouseUp(Event evt, int x, int y) {
	if (editPatternSize) {
		editPatternSize=false;
		editPatternAngle=true;
		buttonToRelease.setText("Set angle");
		repaint();
	}
	else if (editPatternAngle) {
		editPatternAngle=false;
		setDrawState(drawStateBeforeModCell);
		after_ResizeIt();
		buttonToRelease.setSelected(false);
		buttonToRelease.setText("Modify cell");
		repaint();
	}
	else super.mouseUp(evt, x, y);
 }
 
 

 	public void mouseMove(Event evt, int x, int y) {
 		if (editPatternAngle) {
			double angle;
			int off=x-patOx-dwidth;
			if (off>=0) 
				angle = 180.0*Math.atan(((double)patSy)/off)/Math.PI;
			else
				angle = (180.0*Math.atan(((double)-off)/patSy)/Math.PI)+90.0;
			if (angle>179) angle=179;
			if (angle<1) angle=1;
			angsin = Math.sin(angle*Math.PI/180.0);
			angcos = Math.cos(angle*Math.PI/180.0);
			repaint();
 		}
 		else super.mouseMove(evt, x, y);
 	}

 

	public void mouseDrag(Event evt, int x, int y) {
		if (editPatternAngle) {}
	 	else super.mouseDrag(evt, x, y);
	} 
 
 
 
 public int[] translate_points(int x, int y) {
   int a[] = new int[17];
   a[0] = 2;
   a[1] = x;
   a[2] = y;
   return a;
 }

 

}

class p2 extends p1 {
 public p2(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p2";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(((int) Math.round(((double)dheight)/angsin*angcos)),
              dheight,dwidth,0);
/*
   g.drawLine(dwidth+((int) Math.round(((double)dheight)/angsin*angcos)),
      dheight*2,dwidth*2,dheight);
*/      
 }
   
 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 4;
   a[3] = dwidth - x + ((int) Math.round(((double)dheight)/angsin*angcos));
   a[4] = dheight-y;//-1;
   return a;
 }
 public int[] get_angles() {
   int a[] = new int[3];
   a[0] = 2;
   a[1] = 0;
   a[2] = 180;
   return a;
 }
}
