// escher web sketch:
//
// Copyright 1996, 1997, 1998 by Wes Hardaker and the University of
// Lausanne, Switzerland.  All rights reserved.
//
// Permission to use, copy, modify, and distribute this software and
// its documentation for any purpose and without fee is hereby granted
// for non commerical use, provided that both the above copyright
// notice and this permission notice appear unmodified and intact.
//
// Questions regarding pricing for commerical usage should be sent to
// escher@sphysdec1.unil.ch.
//

import java.awt.*;
import java.net.*;
import java.io.*;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.ImageObserver;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class esquare implements ButtonPainter {
   int width, dwidth, height, dheight;
   Image img, undoImg, undoResizeImg;
   //Image fullImg;
   Graphics gr;
   etool tool;
   JPanel toolchest;
   //Scrollbar scrbar;
   boolean drawpattern = true;
   String name="p4";
   boolean editPattern = false;
   int patOx, patOy, patSx, patSy;
   JToggleButton buttonToRelease;
   JButton undoButton;
   int undo_patOx, undo_patOy, undo_patSx, undo_patSy;
   int undo_width, undo_dwidth, undo_height, undo_dheight;
   boolean undoWasBgBrightChange=false;
   JComponent cards;
   boolean isUndoAvailable=false;
   boolean recenterCell=true;
   boolean editPatternSize=false;
   boolean drawStateBeforeModCell; 
   

 public esquare(int sz, JPanel pnl, JComponent cards) {
   name="p4";
   toolchest = pnl;
   this.cards=cards;
   setsize(sz);
 }

 public void centerCell() {
  patOx=(getWidth()-dwidth)/2; patOy=(getHeight()-dheight)/2;
  recenterCell=false;
 }
 
 public int getWidth() {
 	return cards.getWidth();
 }
 
 public int getHeight() {
 	return cards.getHeight();
 }
 
 public void repaint() {
 	cards.repaint();
 }
 
 Dimension size() {
 	return cards.size();
 }
 
 
 public void setDrawState(boolean b) {
   drawpattern = b;
 }



	public void enterEditPattern(JToggleButton buttonToRelease) {
		editPattern=true;
		img=null;
		gr=null;

		drawStateBeforeModCell=drawpattern;
		setDrawState(false);
		repaint();

		buttonToRelease.setText("Place origin");
		this.buttonToRelease=buttonToRelease;
	}

	public void leaveEditPattern() {
		buttonToRelease.setText("Modify cell");
		buttonToRelease.setSelected(false);
		editPattern=false;
		editPatternSize=false;
		tool.setSize(width,height);
	}
   
	public boolean isModeEditPattern() {
		return editPattern || editPatternSize;
	}

	
	public void setUndoButton(JButton b) {
		undoButton=b;
	}

 public void setTool(etool newtool) {
   tool = newtool;
   tool.setCanvas(this);
   tool.setSize(width,height);
   tool.populate_panel();
 }

 public Image getImage() {
   return img;
 }
   
 public etool getTool() {
   return tool;
 }

 public void ResizeIt(int sz) {
   setsize(sz);
   after_ResizeIt();
 }

 public void after_ResizeIt() {
   tool.setSize(width,height);
   setupImage();
 }

 public void setupImage() {
 	 img = new BufferedImage(dwidth,dheight, BufferedImage.TYPE_INT_RGB);
 	 undoImg = new BufferedImage(dwidth,dheight, BufferedImage.TYPE_INT_RGB);
 	 //fullImg = new BufferedImage(getWidth(),getHeight(), BufferedImage.TYPE_INT_RGB);
 	 
   if (img != null) {
   	 gr = img.getGraphics();
     gr.setColor(Color.white);
     gr.clearRect(0,0,dwidth,dheight);
     gr.setColor(Color.black);
     erase();
   }
 	}

 public void setsize(int sz) {
   width = sz;
   dwidth = sz*2;
   height = sz;
   dheight = sz*2;
 }
   
   
 public Dimension minCellSize() {
 	return new Dimension(20, 20);
 }
   
   
 // return max patern size, *not* max image size */
 public Dimension getSize() {
   return new Dimension(dwidth,dheight);
 }

 public void erase() {
	if (gr==null) setupImage();
  gr.setColor(tool.bkgColor);
 	gr.fillRect(0,0,img.getWidth(null),img.getHeight(null));
  gr.setColor(Color.black);
  repaint();
  
  
  //Graphics fg = fullImg.getGraphics();
  //fg.setColor(tool.bkgColor);
 	//fg.fillRect(0,0,fullImg.getWidth(null),fullImg.getHeight(null));
  
 }

 public Dimension map(int x, int y) {
   x = x%dwidth;
   y = y%dheight;
   return new Dimension(((x >= 0) ? x : x+dwidth),((y >= 0) ? y : y+dheight));
 }

 

 public int[] translate_points(int x, int y) {
   int a[] = new int[17];
   a[0] = 8;
   a[1] = a[4] = x;
   a[2] = a[5] = y;
   a[3] = a[8] = dheight-y;//-1;
   a[6] = a[7] = dwidth-x;//-1;
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[9];
   a[0] = 4;
   a[1] = 0;
   a[2] = 270;
   a[3] = 90;
   a[4] = 180;
   return a;
 }
   
 public void draw_frame(Graphics g) {
 	 g.drawLine(0,0,dwidth,0);
   g.drawLine(0,0,0,dheight);
   g.drawLine(0,dheight,dwidth,dheight);
   g.drawLine(dwidth,0,dwidth,dheight);

/*
 	 g.drawLine(dwidth,dheight,dwidth*2,dheight);
   g.drawLine(dwidth,dheight,dwidth,dheight*2);
   g.drawLine(dwidth,dheight*2,dwidth*2,dheight*2);
   g.drawLine(dwidth*2,dheight,dwidth*2,dheight*2);
*/   
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(width,0,width,height);
   g.drawLine(0,height,width,height);

/*   
   g.drawLine(width*3,dheight,width*3,height*3);
   g.drawLine(dwidth,height*3,width*3,height*3);
*/   
 }
   
 public void draw_diagram(Graphics g) {
   if (drawpattern) {
     draw_frame(g);
     Color c = Color.red;
     c = c.darker();
     g.setColor(c);
     draw_frame_inside(g);
   } 
 }

 /*
	public void paintButton(Graphics g, Dimension d) {
		draw_diagram(g, d.width, d.height);   
	}
*/
 
 public void paintButton(Graphics g, int sx, int sy) {
    int old_width=width, old_dwidth=dwidth, old_height=height, old_dheight=dheight;
    
    
    setsize(sy/5);

    
    
    FontMetrics fontMetrics = g.getFontMetrics();
    g.drawString(name, 
    (sx-fontMetrics.stringWidth(name))/2		, 
		sy-((sy-getSize().height-fontMetrics.getAscent())/2)		);
    
    //g.translate(-dwidth, -dheight);
    g.translate((sx-getSize().width)/2, sy/6);

    
    draw_frame(g);
    Color c = Color.red;
    c = c.darker();
    g.setColor(c);
    draw_frame_inside(g);
    width=old_width;
		dwidth=old_dwidth;
		height=old_height;
		dheight=old_dheight;
 }
 
 
   // Flicker standard fix:

 private Image offScreenImage;
 private Dimension offScreenSize;
 private Graphics offScreenGraphics;

 public final synchronized void update (Graphics g) {
 	Dimension d = size();
   if ((offScreenImage == null) || (d.width != offScreenSize.width) ||  (d.height != offScreenSize.height)) {
     offScreenImage = new BufferedImage(d.width,d.height, BufferedImage.TYPE_INT_RGB);
     offScreenSize = d;
     offScreenGraphics = offScreenImage.getGraphics();
   }
   paint(offScreenGraphics);
   g.drawImage(offScreenImage, 0, 0, null);
   
   
//   g.drawLine(0, 0, this.getWidth(), this.getHeight());
//   g.drawRect(0, 0, this.getWidth()-1, this.getHeight()-1);
//   System.out.println("update "+this.getWidth()+" "+this.getHeight());
   
   
 }

 public int getOffset() {
   return 0;
 }

 public void sendImage(DataOutputStream os) {
   int [] pixels = new int [dwidth*dheight];
   PixelGrabber pg = new PixelGrabber(img, 0, 0, dwidth, dheight, pixels, 0, 
                                      dwidth);
   try {
     pg.grabPixels();
   } catch (InterruptedException e) {
     System.out.println("system error grabbing pixels from image");
     return;
   }
   if ((pg.status() & ImageObserver.ABORT) != 0) {
     System.out.println("system error grabbing pixels from image (aborted)");
     return;
   }
   // write it out
   try {
     os.writeBytes( "width=" + Integer.toString(dwidth) );
     os.writeBytes( "\nheight=" + Integer.toString(dheight) );
     os.writeBytes( "\noffset=" + Integer.toString(getOffset()) );
     os.writeBytes( "\nname=" + name );
     os.writeBytes( "\ndata=" );
     for( int i=0; i<dheight; i++) {
       for( int j=0; j<dwidth; j++) {
         os.writeBytes( Integer.toString(pixels[j+i*dwidth]) );
         if( j+1 == dwidth )
           os.write( '\n' );
         else
           os.write( ',' );
       }
     }
/* ** Old version used with client-server implementation
     os.writeInt(dwidth);
     os.writeInt(dheight);
     os.writeInt(getOffset());
     os.writeInt(name.length());
     os.writeChars(name);
     for (int i = 0; i < dwidth; i++) {
       for (int j=0; j < dheight; j++) {
         os.writeInt(pixels[i+j*dwidth]);
       }
     }
*/
   } catch (java.io.IOException e) {
     e.printStackTrace();
   }
 }
   
 public void paint(Graphics g) {
 	if (recenterCell) centerCell();
 	Dimension d = size();
 	 
  g.setColor(Color.black);
  int i,j;
  if (img == null)
  {
   	g.setColor(tool.bkgColor);
		g.fillRect(0, 0, d.width, d.height);
		g.setColor(Color.black);
  }
  else {
   	int mx=patOx%dwidth;
   	if (mx!=0) mx=mx-dwidth;
   	int my=patOy%dheight;
   	if (my!=0) my=my-dheight;
   	for (j=my; j < (d.height+dheight); j = j + dheight) {
    	for (i=mx; i < (d.width+dwidth); i = i + dwidth) {
    		g.drawImage(img,i,j,null);
    	}
    }
  }
  
  //paintDebugFrames(g);
  
  g.translate(patOx, patOy);
  draw_diagram(g);
  g.translate(-patOx, -patOy);
 }



 public void paintDebugFrames(Graphics g) {
	 if (dwidth<20 || dheight<20) return;
	 Dimension d = size();
	 int mx=patOx%dwidth;
	 if (mx!=0) mx=mx-dwidth;
	 int my=patOy%dheight;
	 if (my!=0) my=my-dheight;
	 for (int j=my; j < (d.height+dheight); j = j + dheight) {
		 for (int i=mx; i < (d.width+dwidth); i = i + dwidth) {
 			 g.setColor(Color.lightGray);
			 g.drawRect(i, j, dwidth, dheight);
			 g.setColor(Color.black);
		 }
	 }
 }



 public void setUndoPoint() {
 	 //System.out.println("esquare.setundopoint "+undoImg);
 	 isUndoAvailable=true;
 	 undoButton.setEnabled(true);
 	 if (undoImg==null || img==null) setupImage();
   undoImg.getGraphics().drawImage(img,0,0,null);
   undoResizeImg=null;
   undoWasBgBrightChange=false;
 }

 public void Undo() {
 	 Undo(false);
 }

 public void Undo(boolean canUndoAgain) {
 	isUndoAvailable=canUndoAgain;
 	undoButton.setEnabled(canUndoAgain);
	if (undoImg==null || img==null) setupImage();

	if (undoResizeImg!=null)
  	undoSize();
  else
  	gr.drawImage(undoImg,0,0,null);
  undoResizeImg=null;
  repaint();
}

 
 public void recordUndoSize() {
  
 	//System.out.println("esquare.recordundosize "+dwidth+" "+dheight);
 	
 	undo_patOx=patOx;
  undo_patOy=patOy;
 	undo_patSx=patSx;
  undo_patSy=patSy;
  undo_width=width;
  undo_dwidth=dwidth;
  undo_height=height;
  undo_dheight=dheight;
	
  if (undoImg==null || img==null) setupImage();
 	
  undoResizeImg = new BufferedImage(dwidth, dheight, BufferedImage.TYPE_INT_RGB);
  undoResizeImg.getGraphics().drawImage(img,0,0,null);
	undoButton.setEnabled(true);
	isUndoAvailable=true;
}
 
 public void undoSize() {
 	patOx=undo_patOx;
 	patOy=undo_patOy;
 	patSx=undo_patSx;
 	patSy=undo_patSy;
 	width=undo_width;
 	dwidth=undo_dwidth;
 	height=undo_height;
 	dheight=undo_dheight;

 	//System.out.println("esquare.undoSize "+dwidth+" "+dheight);

	img = new BufferedImage(dwidth, dheight, BufferedImage.TYPE_INT_RGB);
	undoImg = new BufferedImage(dwidth,dheight, BufferedImage.TYPE_INT_RGB);
  gr = img.getGraphics();
  gr.drawImage(undoResizeImg,0,0,null);
  gr.setColor(Color.black);
  
	if (buttonToRelease!=null && buttonToRelease.isSelected()) {
		leaveEditPattern();
	}
	tool.setSize(width,height);
 }
 
 
 
 
 
 public void mouseDown(Event evt, int x, int y) {
   if (editPattern || editPatternSize) {}
   else {
    setUndoPoint();
   	tool.mouseDown(evt, x-patOx, y-patOy, gr);
		repaint();
   }
 }


 public void mouseUp(Event evt, int x, int y) {
	if (editPatternSize) {
		editPatternSize=false;
		setDrawState(drawStateBeforeModCell);
		after_ResizeIt();
		buttonToRelease.setSelected(false);
		buttonToRelease.setText("Modify cell");
		repaint();
	}
	else if (editPattern) {
		editPattern=false;
		editPatternSize=true;
		setCellSize(x, y);
		buttonToRelease.setText("Set cell size");
		repaint();
	}
  else {
  	tool.mouseUp(evt, x-patOx, y-patOy, gr);
		repaint();
  } 
 }


 public void mouseDrag(Event evt, int x, int y) {
	if (editPattern || editPatternSize) {}
  else {
		tool.mouseDrag(evt, x-patOx, y-patOy, gr);
		repaint();
  } 
 }
 
 public void mouseMove(Event evt, int x, int y) {
	if (editPattern) {
		setDrawState(true);
		setCellOrigin(x, y);
	  repaint();
	}
	if (editPatternSize) {
		setCellSize(x, y);
		repaint();
	}
 	else tool.mouseMove(evt, x, y, null);
 }
 
 
 
 public void setCellOrigin(int x, int y) {
	patOx=x;
  patOy=y;
  patSx=minCellSize().width;
  patSy=minCellSize().height;
  setPatternSize();
 }
 
 public void setCellSize(int x, int y) {
	patSx=x-patOx;
	patSy=y-patOy;
	if (patSx<minCellSize().width) patSx=minCellSize().width;
	if (patSy<minCellSize().height) patSy=minCellSize().height;
	setPatternSize();
 }
 
 
 public void setPatternSize() {
	setsize((patSx>patSy?patSx:patSy)/2);
 }
 
 

}

class p4mm extends esquare {
 public p4mm(int sz, JPanel pnl, JComponent cards) {
   super(sz,  pnl, cards);
   name="p4mm";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(width,0,width,height);
   g.drawLine(0,0,width,height);

//   g.drawLine(width*3,dheight,width*3,height*3);
//   g.drawLine(dwidth,dheight,width*3,height*3);
 }

 public int[] get_angles() {
   int a[] = super.get_angles();
   a[0] = 8;
   a[5] = 360;
   a[6] = 720;
   a[7] = 450;
   a[8] = 630;
   return a;
 }
   
 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 16;
   a[9] = a[16] = dwidth-x;//-1;
   a[10] = a[13] = y;
   a[11] = a[14] = x;
   a[12] = a[15] = dheight-y;//-1;
   return a;
 }
}

class p4gm extends esquare {
 public p4gm(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p4gm";
 }

 public void draw_frame_inside(Graphics g) {
//   g.drawLine(dwidth,height*3,width*3,dheight);
   g.drawLine(0,height,width,0);
 }

 public int[] get_angles() {
   int a[] = super.get_angles();
   a[0] = 8;
   a[5] = 450;
   a[6] = 720;
   a[7] = 360;
   a[8] = 810;
   return a;
 }

 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 16;
   a[9] = a[14] = y+height;
   a[10] = a[11] = x+width;
   a[12] = a[15] = height-y;
   a[13] = a[16] = width-x;
   return a;
 }
}
