// escher web sketch:
//
// Copyright 1996, 1997, 1998 by Wes Hardaker and the University of
// Lausanne, Switzerland.  All rights reserved.
//
// Permission to use, copy, modify, and distribute this software and
// its documentation for any purpose and without fee is hereby granted
// for non commerical use, provided that both the above copyright
// notice and this permission notice appear unmodified and intact.
//
// Questions regarding pricing for commerical usage should be sent to
// escher@sphysdec1.unil.ch.
//

import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;


import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.*;
import java.applet.*;
import java.io.*;

import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
 
public
class escher extends JApplet {
   escherCards cards;
   Image ballimg;
   JPanel toolchest;
   //imagepanel selected;
   JCheckBox checkbox;
   int serverPort = 6886;
   String serverName;
   public boolean standAlone = false;
   String params[][] = new String[16][2];
   JToggleButton editCellButton;
   JButton undoButton;
   public JFrame mainFrame;

   
   
	  public static void main(String[] args) {
		  escher e = new escher();
		  e.standAlone=true;
	    e.setParameter("Server","escher.epfl.ch");
	    e.mainFrame = Console.run(e, "Escher Web Sketch", 800, 600);
		}
   
   

   public void setParameter(String s, String v) {
     for(int i=0; i<params.length; i++)
       if (params[i][0] == null) {
         params[i][0] = s;
         params[i][1] = v;
         return;
       }
   }

   public String getParameter(String s) {
     if (!standAlone)
       return super.getParameter(s);
     for(int i=0; i<params.length; i++)
       if (params[i][0] != null && s.equals(params[i][0]))
         return params[i][1];
     return null;
   }

   public URL getCodeBase() {
     if (!standAlone)
       return super.getCodeBase();
     URL u;
     try {
       u = new URL("file:" + System.getProperty("user.dir") + "/");
       return u;
     }
     catch (java.net.MalformedURLException e) {
       System.out.println("malformed URL" + e);
     }
     return null;
   }

   
   
 
   
 public void init() {
   String portparm = getParameter("Port");
   if (portparm != null) {
     serverPort = Integer.parseInt(portparm);
   }
   serverName = getParameter("Server");
   
   JPanel p = new JPanel();
   
   if (!standAlone) {
  	mainFrame = new JFrame("Escher Web Sketch");
  	mainFrame.setSize(800, 600);
  	mainFrame.setVisible(true);
   	
   	my_init(mainFrame.getContentPane());
   	
		if ("true".equals(getParameter("mini"))) {
			setContentPane(new JPanel() {
				{
					setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
					addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent e) {
							mainFrame.setVisible(true);
							mainFrame.toFront();
						}
					});
				}
				public void paint(Graphics g) {
					new ImageIcon(getClass().getResource("/applet-mini.png")).paintIcon(this, g, 0, 0);
				}
			});
		}
		else {
	   	Label waitLabel = new Label("Refresh page to restart applet...");
	   	getContentPane().add("Center", waitLabel);
		}
   	
   	
   }
   else {
   	my_init(getContentPane());
   }
 }
   	
	public void showUp() {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				mainFrame.setVisible(true);
				mainFrame.toFront();
			}
		});
	}
   	
   	
 public void my_init(Container mainPanel) {
 	 int sz = 40; 
   int sx, sy;

   String ssx = getParameter("SizeX");
   String ssy = getParameter("SizeY");
   if (ssx!=null) sx=Integer.parseInt(ssx); else sx=800;
   if (ssy!=null) sy=Integer.parseInt(ssy); else sy=600;

   toolchest = new JPanel();
   cards = new escherCards();
   
   mainPanel.setLayout(new BorderLayout());
   JPanel p1 = new JPanel();
   p1.setLayout(new GridLayout(2,8));
   JPanel ctools = new JPanel();
   // create canvas buttons
   esquare todo[] = { new p1(sz, ctools, cards), new p2(sz, ctools, cards),
                      new erect(sz, ctools, cards),
                      new pg(sz, ctools, cards), new cm(sz, ctools, cards),
                      new p2mm(sz, ctools, cards), new p2mg(sz, ctools, cards),
                      new p2gg(sz, ctools, cards), new c2mm(sz, ctools, cards),
                      new esquare(sz, ctools, cards), new p4mm(sz, ctools, cards),
                      new p4gm(sz, ctools, cards), new ehex(sz, ctools, cards),
                      new p3m1(sz, ctools, cards), new p31m(sz, ctools, cards),
                      new p6(sz, ctools, cards), new p6mm(sz, ctools, cards)};




   ButtonGroup group1 = new ButtonGroup();
   ToolButton[] cellButtons = new ToolButton[todo.length];
   for(int i=0; i<todo.length; i++) {
     cellButtons[i] = new ToolButton(todo[i], cellNotify);
     group1.add(cellButtons[i]);
		 //cellButtons[i].setPreferredSize(new Dimension(30, 30));
		 p1.add(cellButtons[i]);
   }
   
   JPanel p2 = new JPanel();
   p2.setLayout(new BorderLayout());
   p2.add("North",new Label(""));
   p2.add("South",checkbox = new JCheckBox("draw cell", null, true));
   checkbox.addItemListener(checkBoxNotify);
   p1.add(p2);
   
   
   JPanel p3 = new JPanel();
   FlowLayout fl = new FlowLayout(); 
   p3.setLayout(fl);
   fl.setAlignment(FlowLayout.LEFT);
   
   MediaTracker tracker = new MediaTracker(this);
   Toolkit tool = Toolkit.getDefaultToolkit();
   Image img = null;
   try {
   	URL uu = getClass().getResource("sphere/redball.gif");
   	if (uu==null) uu = new URL(getCodeBase(),"redball.gif");
   	
   	img = tool.getImage(uu);
   	
//   	img = tool.getImage(new URL(getCodeBase(),"redball.gif"));
   } catch (java.net.MalformedURLException e) {
     System.out.println("malformed url");
   }
   tracker.addImage(img,0);
   try {
     tracker.waitForAll();
   } catch (java.lang.InterruptedException e) {
     System.out.println("InterruptedException");
   }
   etool tools[] = { new etool(toolchest), new linetool(toolchest),
                     new drawtool(toolchest), new boxtool(toolchest),
                     new filledboxtool(toolchest),
                     new imagetool(getCodeBase(), img, toolchest) };
   
   ButtonGroup group2 = new ButtonGroup();
   ToolButton[] toolButtons = new ToolButton[tools.length];
   for(int i=0; i < tools.length; i++) {
     toolButtons[i] = new ToolButton(tools[i], toolNotify);
     group2.add(toolButtons[i]);
		 toolButtons[i].setPreferredSize(new Dimension(30, 30));
		 p3.add(toolButtons[i]);
   }
   
   p3.add(new Label("   "));
   JButton b;   
   editCellButton=new JToggleButton("Modify cell");
   editCellButton.addActionListener(buttonNotify);
   p3.add(editCellButton);
   b=new JButton("Erase");
   b.addActionListener(buttonNotify);
   p3.add(b);
   undoButton=new JButton("Undo");
   undoButton.addActionListener(buttonNotify);
   p3.add(undoButton);
   undoButton.setEnabled(false);
   b=new JButton("Submit");
   b.addActionListener(buttonNotify);
   p3.add(b);
   b=new JButton("Save...");
   b.addActionListener(buttonNotify);
   p3.add(b);



   for(int i=0; i<todo.length; i++)
   	todo[i].setUndoButton(undoButton);
  
	 cards.setType(todo[todo.length-1]);
	 cards.setTool(tools[0]);
	 toolButtons[0].setSelected(true);
	 cellButtons[todo.length-1].setSelected(true);
   
   mainPanel.add("North",p1);
   mainPanel.add("South",p3);
   mainPanel.add("East", toolchest);
   mainPanel.add("Center",cards);
   mainPanel.validate();
 }






	ButtonReceiver toolNotify = new ButtonReceiver() {
	 	public void select(Object selected) {
	 		//System.out.println("escher.select (etool) "+selected);
			cards.setTool((etool)selected);
	 	}
	};
	
	  
	ButtonReceiver cellNotify = new ButtonReceiver() {
	 	public void select(Object selected) {
	 		//System.out.println("escher.select (esquare) "+selected);
			cards.setType((esquare)selected);

			checkbox.setSelected(((esquare)selected).drawpattern);
			
	 	}
	};
 
	ItemListener checkBoxNotify = new ItemListener() {
		public void itemStateChanged(ItemEvent e) {
			((esquare) cards.getType()).setDrawState(checkbox.isSelected());
			((esquare) cards.getType()).repaint();
		}
	};

	
	ActionListener buttonNotify = new ActionListener() {
		public void actionPerformed(ActionEvent event){
			 String arg = ((AbstractButton)event.getSource()).getText();
			 if ("Erase".equals(arg)) {
		     ((esquare) cards.getType()).setUndoPoint();
		     ((esquare) cards.getType()).erase();
		   } else if ("Undo".equals(arg)) {
		     ( (esquare) cards.getType()).Undo();
			 } else if (editCellButton.getText().equals(arg)) {
			   	if (((esquare)cards.getType()).isModeEditPattern()) {
						((esquare)cards.getType()).leaveEditPattern();
			   	}
					else {
			      ((esquare) cards.getType()).recordUndoSize();
			      //((esquare) cards.getType()).setUndoPoint();
						((esquare) cards.getType()).erase();
						editCellButton.setSelected(true);
						((esquare)cards.getType()).enterEditPattern(editCellButton);
					}
		   } else if ("Submit".equals(arg)) {
		   	
		   	
		     int result = -1;
		     URL url;
		     URLConnection urlConn;
		     DataOutputStream printout;
		     DataInputStream input;
		     // URL of CGI-Bin script
		     try {
		       
		     	URL codeBase = standAlone?new URL("http://escher.epfl.ch/escher/"):getCodeBase();
		     	
		     	 url = new URL(codeBase,"submit.cgi");
		       // URL connection channel
		       urlConn = url.openConnection();
		       // Let the run-time system know that we want input.
		       urlConn.setDoInput( true );
		       // Let the run-time system know that we want to do output.
		       urlConn.setDoOutput( true );
		       // No caching, we want the real thing.
		       urlConn.setUseCaches( false );
		       // Specify the content type.
		       urlConn.setRequestProperty( "Content-Type", "x-www-form-urlencoded" );
		       // Send POST output.
		       printout = new DataOutputStream( urlConn.getOutputStream() );
		       ((esquare) cards.getType()).sendImage(printout);
		       printout.flush();
		       printout.close();
		       // Get response data.
		       input = new DataInputStream( urlConn.getInputStream() );
		       String str;
		       result = 0;
		       //AbstractButton b = ((AbstractButton)event.getSource());
		       //b.setText(".");
		       while( null != ((str = input.readLine())) ) {
		       	//b.setText(b.getText()+".");
		       	System.out.println( str );
		         if( str.equalsIgnoreCase("saved") )
		           result = 1;
		         else if( str.equalsIgnoreCase("empty") )
		           result = 10;
		       }
		       //b.setText("Submit");

		       input.close();
		     }
		     catch (MalformedURLException e) {
		       System.out.println("malformed URL" + e);
		     }
		     catch (IOException e) {
		       System.err.println("Error POSTing image (" + e.getMessage() + ").");
		     }
		     if (!standAlone) {
		       try {
		         if (result == 1)
		           getAppletContext().showDocument(new URL(getCodeBase(),"scanSaved.cgi"));
		         else if (result == 10)
		           getAppletContext().showDocument(new URL(getCodeBase(),"error.cgi?title=Empty+Image+Submitted&text=You+submitted+a+blank+image+!"));
	           	 //getAppletContext().showDocument(new URL(getCodeBase(),"empty.html"));
		         else if (result == 0)
		           //getAppletContext().showDocument(new URL(getCodeBase(),"noConnect.html"));
		         	 getAppletContext().showDocument(new URL(getCodeBase(),"error.cgi?title=Server+Down&text=I+am+sorry,+but+I+could+not+connect+to+the+server+to+submit+your+image.+It+must+be+down.++Try+again+later."));
		         else
		           //getAppletContext().showDocument( new URL(getCodeBase(),"noPOST.html"));
		           getAppletContext().showDocument(new URL(getCodeBase(),"error.cgi?title=Error&text=Unexpected error !"));
		       } catch (MalformedURLException e) {
		         System.out.println("malformed url");
		       }
		     }
		     else {
					JOptionPane.showMessageDialog(mainFrame, "Your image was submitted. To see it go to : http://escher.epfl.ch/escher/scanSaved.cgi");
		     }
		   } else if ("Save...".equals(arg)) {
		   	esquare e = ((esquare) cards.getType());
		   	saveImage.show(e.dwidth, e.dheight);
		   }		   
		}
	}; 
	 
	ActionListener saveNotify = new ActionListener() {
		public void actionPerformed(ActionEvent event){
	   	esquare e = ((esquare) cards.getType());
			BufferedImage img1 = (BufferedImage)e.img; 
			BufferedImage img = new BufferedImage(saveImage.respx, saveImage.respy, BufferedImage.TYPE_INT_RGB);
			
			if (img1!=null) {
				Graphics g = img.getGraphics();
				for (int j=0, k=0; j<saveImage.respy;j+=e.dheight, k++) {
					for (int i=((e.getOffset()*k)%e.dwidth)-e.dwidth; i<saveImage.respx;i+=e.dwidth) {
						g.drawImage(img1, i, j, null);
					}
				}
			}
			
			
			if (!standAlone) {
				try {
					URL u = new URL("http://escher.epfl.ch/servlet/escher/Output.png");
					URLConnection con = u.openConnection();
					con.setDoOutput(true);
					OutputStream out = con.getOutputStream();
					ImageIO.write(img, "PNG", out);
					BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
					while (true) {
						String s = in.readLine();
						if (s==null) break;
						//System.out.println(s);
						if (s.equals("ok")) {
							getAppletContext().showDocument(new URL("http://escher.epfl.ch/servlet/escher/Output.png"), "_blank");
						}
					}
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
			else {
				JFileChooser chooser = new JFileChooser();
				FileFilter filter = new FileFilter() {
					public boolean accept(File f) {
				    if (f.isDirectory()) return true;
				    String extension = getExtension(f);
				    if (extension!=null && extension.equals("png")) return true;
				    return false;
					}
					public String getExtension(File f) {
		        String ext = null;
		        String s = f.getName();
		        int i = s.lastIndexOf('.');
		        if (i > 0 &&  i < s.length() - 1) {
		            ext = s.substring(i+1).toLowerCase();
		        }
		        return ext;
					}
					public String getDescription() {
						return "PNG Images";
					}
				};
		    chooser.setFileFilter(filter);
		    int returnVal = chooser.showSaveDialog(mainFrame);
		    if(returnVal == JFileChooser.APPROVE_OPTION) {
					try {
						File f = chooser.getSelectedFile();
						if (f.getName().indexOf(".png")==-1 && f.getName().indexOf(".PNG")==-1 ) {
							f=new File(f.toString()+".png");
						}
						ImageIO.write(img, "PNG", f);
					} catch (IOException ex) {
						ex.printStackTrace();
					}
		    }
			}
		}
	};

	SaveImage saveImage = new SaveImage(0, 0, saveNotify);


 
   // Flicker standard fix:

 private Image offScreenImage;
 private Dimension offScreenSize;
 private Graphics offScreenGraphics;

 public final synchronized void update (Graphics g) {
   Dimension d = size();
   if ((offScreenImage == null) || (d.width != offScreenSize.width) ||  (d.height != offScreenSize.height)) {
     offScreenImage = createImage(d.width, d.height);
     offScreenSize = d;
     offScreenGraphics = offScreenImage.getGraphics();
   }
   paint(offScreenGraphics);
   g.drawImage(offScreenImage, 0, 0, null);
 }
}   

class escherWait extends Canvas {

   escher save;
   JPanel panel;
   
 public escherWait(escher ap, JPanel p) {
   save = ap;
   panel =p;
 }
     
 public void paint(Graphics g) {
   Dimension d = size();
   g.setColor(Color.black);
   g.drawString("Please wait, loading...",d.width/4,d.height/2);
   save.my_init(panel);
   g.drawString("Refresh page to reload",d.width/4,d.height/2);
 }

 public Dimension minimumSize() {
   return new Dimension(100,100);
 }

 public Dimension preferredSize() {
   return new Dimension(100,100);
 }

}
   
   
   

 
   
class escherCards extends JComponent implements MouseListener, MouseMotionListener {
	esquare type;

	public escherCards() {
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	public esquare getType() {
		return type;
	}

	public void setType(esquare newtype) {
		if (type!=null) {
			etool oldmode = type.getTool();
			type = newtype;
			type.setTool(oldmode);
		}
		else {
			type = newtype;
		}
		
		type.undoButton.setEnabled(type.isUndoAvailable);
		repaint();
	}

	public void setTool(etool newtool) {
   if (type.getTool()!=null)
   	 newtool.importParams(type.getTool());
   type.setTool(newtool);
	}



	public void paint(Graphics g) {
		type.paint(g);
	}

	public void update(Graphics g) {
		type.update(g);
	}

	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}

	public void mousePressed(MouseEvent e) {
		type.mouseDown(null, e.getX(), e.getY());
		repaint();
	}
	public void mouseReleased(MouseEvent e) {
		type.mouseUp(null, e.getX(), e.getY());
		repaint();
	}
	public void mouseDragged(MouseEvent e) {
		type.mouseDrag(null, e.getX(), e.getY());
		repaint();
	}
	public void mouseMoved(MouseEvent e) {
		type.mouseMove(null, e.getX(), e.getY());
//		repaint();
	}
}

