// escher web sketch:
//
// Copyright 1996, 1997, 1998 by Wes Hardaker and the University of
// Lausanne, Switzerland.  All rights reserved.
//
// Permission to use, copy, modify, and distribute this software and
// its documentation for any purpose and without fee is hereby granted
// for non commerical use, provided that both the above copyright
// notice and this permission notice appear unmodified and intact.
//
// Questions regarding pricing for commerical usage should be sent to
// escher@sphysdec1.unil.ch.
//

import java.awt.*;

import javax.swing.JComponent;
import javax.swing.JPanel;

class erect extends esquare {
   //Scrollbar scrbar2;

 public erect(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="pm";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(width,0,width,dheight);
//   g.drawLine(width*3,dheight,width*3,dheight*2);
 }
   
 public void setsize(int sz) {
   width = ((int) Math.round(sz*1.5));
   dwidth = width*2;
   height = sz;
   dheight = height*2;
 }

 public Dimension minCellSize() {
	return new Dimension(30, 20);
 }


 public void setsize(int sx, int sy) {
	width = sx;
	dwidth = width*2;
	height = sy;
	dheight = height*2;
 }


 public void ResizeItX(int sz) {
   width = sz;
   dwidth = width*2;
   after_ResizeIt();
 }

 public void ResizeItY(int sz) {
   height = sz;
   dheight = height*2;
   after_ResizeIt();
 }

 public int[] translate_points(int x, int y) {
   int a[] = new int[17];
   a[0] = 4;
   a[1] = x;
   a[2] = a[4] = y;
   a[3] = dwidth-x;//-1; //dwidth-xt-1+x-xt;//dwidth-x-1;
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[3];
   a[0] = 2;
   a[1] = 0;
   a[2] = 360;
   return a;
 }

 public void setPatternSize() {
	setsize(patSx/2, patSy/2);
 }

 
/*   
 public void populate_panel() {
   toolchest.removeAll();
   toolchest.setLayout(new GridLayout(1,2));
   JPanel p = new JPanel();
   p.setLayout(new BorderLayout());
   p.add("North",new Label("W"));
   p.add("Center",
         scrbar = new Scrollbar(Scrollbar.VERTICAL, width, 5, 1, 100));
   toolchest.add("North",p);

   p = new JPanel();
   p.setLayout(new BorderLayout());
   p.add("North",new Label("H"));
   p.add("Center",
         scrbar2 = new Scrollbar(Scrollbar.VERTICAL, height, 5, 1, 100));
   toolchest.add("South", p);

   toolchest.validate();
   toolchest.repaint();
 }

 
 public void populate_panel_horiz() {
   toolchest.removeAll();
   toolchest.setLayout(new FlowLayout());
   toolchest.add(new Label("Width"));
   toolchest.add(scrbar = new Scrollbar(Scrollbar.HORIZONTAL, width, 1, 1, 100));
   toolchest.add(new Label("Height"));
   toolchest.add(scrbar2 = new Scrollbar(Scrollbar.HORIZONTAL, height, 1, 1, 100));

   toolchest.validate();
   toolchest.repaint();
 }
 
 
 
 public boolean handleMyEvent(Event event) {
   if (event.target == scrbar2) {
     switch (event.id) {
       case Event.SCROLL_ABSOLUTE:
       case Event.SCROLL_LINE_DOWN:
       case Event.SCROLL_LINE_UP:
       case Event.SCROLL_PAGE_DOWN:
       case Event.SCROLL_PAGE_UP:
         ResizeItY(((Integer) event.arg).intValue());
         return true;
     }
   } else if (event.target == scrbar) {
     switch (event.id) {
       case Event.SCROLL_ABSOLUTE:
       case Event.SCROLL_LINE_DOWN:
       case Event.SCROLL_LINE_UP:
       case Event.SCROLL_PAGE_DOWN:
       case Event.SCROLL_PAGE_UP:
         ResizeItX(((Integer) event.arg).intValue());
         return true;
     }
   }
   return false;
 }
*/
 
}

class p2gg extends erect {
 public p2gg(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p2gg";
 }

 public int[] translate_points(int x, int y) {
   int a[] = new int[17];
   a[0] = 8;
   a[1] = x;
   a[2] = y;
   a[3] = (x+width);
   a[4] = height - y;
   a[5] = width - x;
   a[6] = (y+height);
   a[7] = dwidth-x;//-1;
   a[8] = dheight-y;//-1;
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[5];
   a[0] = 4;
   a[1] = 0;
   a[2] = 720;
   a[3] = 360;
   a[4] = 180;
   return a;
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(width,0,width,height);
   g.drawLine(0,height,width,height);
//   g.drawLine(width*3,dheight,width*3,height*3);
//   g.drawLine(dwidth,height*3,width*3,height*3);
 }
}

class pg extends erect {
 public pg(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="pg";
 }

 public void draw_frame_inside(Graphics g) {
//   g.drawLine(dwidth,height*3,dwidth*2,height*3);
   g.drawLine(0,height,dwidth,height);
 }
   
 public int[] translate_points(int x, int y) {
   int a[] = new int[17];
   a[0] = 4;
   a[1] = x;
   a[2] = y;
   a[3] = dwidth-x;//-1;
   a[4] = y + height;
   return a;
 }
}

class cm extends erect {
 public cm(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="cm";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(width,0,width,height);
   g.drawLine(0,height,width,height);
//   g.drawLine(width*3,dheight,width*3,height*3);
//   g.drawLine(dwidth,height*3,width*3,height*3);
 }
   
 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 8;
   a[5] = x+width;
   a[6] = a[8] = y+height;
   a[7] = width-x;
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[5];
   a[0] = 4;
   a[1] = 0;
   a[2] = 360;
   a[3] = 0;
   a[4] = 360;
   return a;
 }
}

class p2mm extends erect {
 public p2mm(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p2mm";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(0,height,width,height);
   g.drawLine(width,0,width,height);
//   g.drawLine(dwidth,height*3,width*3,height*3);
//   g.drawLine(width*3,dheight,width*3,height*3);
 }
   
 public int[] translate_points(int x, int y) { 
   int a[] = super.translate_points(x,y);
   a[0] = 8;
   a[5] = a[3];
   a[6] = a[8] = dheight-y;//-1;
   a[7] = x;
   return a;
 }
 public int[] get_angles() {
   int a[] = new int[5];
   a[0] = 4;
   a[1] = 0;
   a[2] = 360;
   a[3] = 180;
   a[4] = 720;
   return a;
 }
}

class p2mg extends erect {
 public p2mg(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p2mg";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine((int) Math.round(width*0.5),0,
              (int) Math.round(width*0.5), dheight);
//   g.drawLine((int) Math.round(width*2.5),dheight,
//      (int) Math.round(width*2.5), dheight*2);
 }
   
 public int[] translate_points(int x, int y) {
   int a[] = new int[17];
   a[0] = 8;
   a[1] = x;
   a[2] = a[6] = y;
   a[3] = dwidth-x-1;
   a[4] = a[8] = dheight-y;//-1;
   a[5] = width-x;
   a[7] = width+x;
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[5];
   a[0] = 4;
   a[1] = 0;
   a[2] = 180;
   a[3] = 360;
   a[4] = 720;
   return a;
 }
}

class c2mm extends cm {
 public c2mm(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="c2mm";
 }

 public void draw_frame_inside(Graphics g) {
//   g.drawLine(width*3,dheight,dwidth,height*3);
   g.drawLine(width,0,0,height);
 }
   
 public int[] translate_points(int x, int y) { 
   int a[] = super.translate_points(x,y);
   a[0] = 16;
   a[9] = a[3];
   a[10] = a[12] = dheight-y;//-1;
   a[11] = x;
   a[13] = a[7];
   a[14] = a[16] = height-y;
   a[15] = a[5];
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[9];
   a[0] = 8;
   a[1] = 0;
   a[2] = 360;
   a[3] = 0;
   a[4] = 360;
   a[5] = 180;
   a[6] = 720;
   a[7] = 180;
   a[8] = 720;
   return a;
 }
}
