// escher web sketch:
//
// Copyright 1996, 1997, 1998 by Wes Hardaker and the University of
// Lausanne, Switzerland.  All rights reserved.
//
// Permission to use, copy, modify, and distribute this software and
// its documentation for any purpose and without fee is hereby granted
// for non commerical use, provided that both the above copyright
// notice and this permission notice appear unmodified and intact.
//
// Questions regarding pricing for commerical usage should be sent to
// escher@sphysdec1.unil.ch.
//

import java.awt.*;

import javax.swing.JComponent;
import javax.swing.JPanel;

class ehex extends esquare {

   double angsin = Math.sin(60.0*Math.PI/180.0);
   double angcos = Math.cos(60.0*Math.PI/180.0);
   double undo_angsin, undo_angcos; 

 public ehex(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p3";
 }

 public void recordUndoSize() {
 	undo_angsin=angsin;
 	undo_angcos=angcos;
 	super.recordUndoSize();
 }
 
 public void undoSize() {
 	angsin=undo_angsin;
 	angcos=undo_angcos;
 	super.undoSize();
 }

 	public void paintButton(Graphics g, int sx, int sy) {
		double old_angsin=angsin, old_angcos=angcos;
		angsin = Math.sin(60.0*Math.PI/180.0);
		angcos = Math.cos(60.0*Math.PI/180.0);
		super.paintButton(g, sx, sy);
		angsin=old_angsin;
		angcos=old_angcos;
 	}



 public void setsize(int sz) {
   if (angsin == 0 && angcos == 0) {
     angsin = Math.sin(60.0*Math.PI/180.0);
     angcos = Math.cos(60.0*Math.PI/180.0);
   }
   width = sz;
   dwidth = width*2;
   height = (int) Math.round(((double) sz)*angsin);
   dheight = height*2;
 }


 public Dimension minCellSize() {
	return new Dimension(20, 30);
 }


 public int getOffset() {
   return ((int) Math.round(((double)dheight)/angsin*angcos));
 }
   
 public void paint(Graphics g) {

 	if (recenterCell) centerCell();
	
 	Dimension d = size();

 	
 	int ox = getWidth()/4-dwidth;
 	int oy = getHeight()/4-dheight;
 	
	 //g.translate(ox, oy);	
 	
 	
 	g.setColor(Color.black);
   int i,j;
   int n;
   boolean evenrow;


/*   
   if (img == null)
     setupImage();
   g.drawImage(img,0,0,null);
   int offset = ((int) Math.round(((double)dheight)/angsin*angcos)); 


   //g.copyArea(0,0,dwidth,dheight,dwidth,0);


   
   for (n=0, j=0; j < d.height; j = j + dheight, n++) {
        for (i = - dwidth + (n*offset)%dwidth;
             i < (d.width+dwidth); i = i + dwidth) {
       g.copyArea(0,0,dwidth,dheight,i,j);
     }
   }
*/





   if (img == null)
	 //setupImage();
	 {
		g.setColor(tool.bkgColor);
		//g.setColor(Color.white);
		g.fillRect(0, 0, d.width, d.height);
		g.setColor(Color.black);
	 }
   
   else {
    int offset = ((int) Math.round(((double)dheight)/angsin*angcos)); 
   	n=-patOy/dheight;
   	int mx=patOx%dwidth;
   	if (mx!=0) mx=mx-dwidth;
   	int my=patOy%dheight;
   	if (my!=0) {my=my-dheight; n--;}
//    g.drawImage(img,patOx,patOy,null);
   	
   	for (j=my; j < (d.height+dheight); j = j + dheight, n++) {
    	for (i=(mx-dwidth + (n*offset)%dwidth); i < (d.width+dwidth); i = i + dwidth) {
//        g.copyArea(patOx,patOy,dwidth,dheight,i-patOx,j-patOy);
    		
    		
    		g.drawImage(img,i,j,null);
    	}
    }
    




    
/*   	
   	
		g.drawImage(img, (patOx%dwidth), (patOy%dheight), null);
		g.drawImage(img, (patOx%dwidth)-dwidth, (patOy%dheight), null);
		g.drawImage(img, (patOx%dwidth), (patOy%dheight)-dheight, null);
		g.drawImage(img, (patOx%dwidth)-dwidth, (patOy%dheight)-dheight, null);


	for (i=0; i < d.width; i = i + dwidth) {
	  for (j=0; j < d.height; j = j + dheight) {
		g.copyArea(0,0,dwidth,dheight,i,j);
	  }
	}
*/
   }



   //paintDebugFrames(g);
   
   g.translate(patOx, patOy);
   draw_diagram(g);
   g.translate(-patOx, -patOy);
   




/*
   Color bg = getBackground();
   g.setColor(bg);
   g.draw3DRect(0, 0, d.width - 1, d.height - 1, false);
   g.draw3DRect(1, 1, d.width - 3, d.height - 3, false);
   g.draw3DRect(2, 2, d.width - 5, d.height - 5, false);
*/

	 //g.translate(-ox, -oy);	
 
 }


public void paintDebugFrames(Graphics g) {
	if (dwidth<20 || dheight<20) return;
	
	Dimension d = size();
	int offset = ((int) Math.round(((double)dheight)/angsin*angcos)); 
	int n=-patOy/dheight;
	int mx=patOx%dwidth;
	if (mx!=0) mx=mx-dwidth;
	int my=patOy%dheight;
	if (my!=0) {my=my-dheight; n--;}

	for (int j=my; j < (d.height+dheight); j = j + dheight, n++) {
		for (int i=(mx-dwidth + (n*offset)%dwidth); i < (d.width+dwidth); i = i + dwidth) {
			g.setColor(Color.lightGray);
			g.drawRect(i, j, dwidth, dheight);
			g.setColor(Color.black);
		}
	}
}



 // return max patern size, *not* max image size */
 public Dimension getSize() {
   return new Dimension((int) Math.round(dwidth*(2+angcos)/2),dheight);
 }

 public void draw_frame(Graphics g) {
   int offset = ((int) Math.round(((double)dheight)/angsin*angcos)); 
   g.drawLine(0,0,dwidth,0);
   g.drawLine(dwidth,0,dwidth+offset,dheight);
   g.drawLine(offset,dheight,dwidth+offset,dheight);
   g.drawLine(offset,dheight,0,0);
/*
   g.drawLine(dwidth,dheight,dwidth*2,dheight);
   g.drawLine(dwidth*2,dheight,dwidth*2+offset,dheight*2);
   g.drawLine(dwidth+offset,dheight*2,dwidth*2+offset,dheight*2);
   g.drawLine(dwidth+offset,dheight*2,dwidth,dheight);
*/   
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(dwidth,0,dwidth,2*dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight,
              dwidth,2*dheight/3);
   g.drawLine(dwidth,0,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);


/*
   g.drawLine(dwidth*2,dheight,dwidth*2,5*dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight*2,
              dwidth*2,5*dheight/3);
   g.drawLine(dwidth*2,dheight,
              ((int) Math.round(dwidth*(1+angcos))),4*dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight*2,
              ((int) Math.round(dwidth*(1+angcos))),4*dheight/3);
*/   
 }

 
 public void setPatternSize() {
  int tx = patSx-((int) Math.round(((double)dheight)/angsin*angcos)); 
  int ty = (int) Math.round(((double) patSy)/angsin);
  setsize((tx>ty?tx:ty)/2);
 }
 
 
 public int[] translate_points(int x, int y) {
   int a[] = new int[25];
   a[0] = 6;
   a[1] = x;
   a[2] = y;
   a[3] = (int) Math.round(dwidth-(x*angcos)-(y*angsin));
   a[4] = (int) Math.round((x*angsin) - (y*angcos));
   a[5] = (int) Math.round(width-(x*angcos)+(y*angsin));
   a[6] = (int) Math.round(dheight-(y*angcos)-(x*angsin));
   return a;
 }

 public int[] get_angles() {
   int a[] = new int[13];
   a[0] = 3;
   a[1] = 0;
   a[2] = 240;
   a[3] = 120;
   return a;
 }
   
 public Dimension map(int x, int y) {
   int yt = y%dheight;
   if (yt < 0)
     yt = dheight+yt;
   x = x - (int) Math.round(((double)dheight)/
                            angsin*angcos*( (int) Math.round((y-yt)/dheight) ));
   x = x%dwidth;
   
   //System.out.println(getOffset()+" "+x+" "+y+" "+((int) Math.round((y-yt)/dheight) ));
   
   return new Dimension(((x >= 0) ? x : x+dwidth),yt);
 }
}

class p3m1 extends ehex {

 public p3m1(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p3m1";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,
              dheight,dwidth, 2*dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3,
              dwidth, 2*dheight/3);
/*
   g.drawLine(((int) Math.round(dwidth*(1+angcos))),
      dheight*2,dwidth*2, 5*dheight/3);
g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight*2,
      ((int) Math.round(dwidth*(1+angcos))),4*dheight/3);
g.drawLine(((int) Math.round(dwidth*(1+angcos))),4*dheight/3,
      dwidth*2, 5*dheight/3);
*/ 
 }

 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 12;
   a[7] = (int) Math.round((x*angcos) + y*angsin);
   a[8] = (int) Math.round(-(y*angcos) + x*angsin);
   a[9] = (int) Math.round(width + (x*angcos) - (y*angsin));
   a[10] = (int) Math.round(dheight-(x*angsin)-(y*angcos));
   a[11] = (int) Math.round(dwidth-x);
   a[12] = y;
   return a;
 }
 public int[] get_angles() {
   int a[] = super.get_angles();
   a[0] = 6;
   a[4] = 1020;
   a[5] = 780;
   a[6] = 900;
   return a;
 }
}

class p31m extends ehex {

 public p31m(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p31m";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(dwidth,0,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight,dwidth,0);
/*
   g.drawLine(dwidth*2,dheight,
      ((int) Math.round(dwidth*(1+angcos))),4*dheight/3);
g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight*2,
      ((int) Math.round(dwidth*(1+angcos))),4*dheight/3);
g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight*2,dwidth*2,dheight);
*/ 
 
 }

 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 12;
   a[7] = (int) Math.round(width-(x*angcos)-(y*angsin));
   a[8] = (int) Math.round(dheight+(y*angcos)-(x*angsin));
   a[9] = (int) Math.round(dwidth-(x*angcos)+(y*angsin));
   a[10] = (int) Math.round(y*angcos + x*angsin);
   a[11] = x+width;
   a[12] = dheight-y;
   return a;
 }  

 public int[] get_angles() {
   int a[] = super.get_angles();
   a[0] = 6;
   a[4] = 570;
   a[5] = 480;
   a[6] = 720;
   return a;
 }
}

class p6 extends ehex {

 public p6(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p6";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,0,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);
   g.drawLine(width/2,height,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);

/* 
   g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight,
      ((int) Math.round(dwidth*(1+angcos))),dheight*4/3);
g.drawLine(5*width/2,height*3,
      ((int) Math.round(dwidth*(1+angcos))),dheight*4/3);
*/
 }

 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 12;
   a[7] = (int) Math.round(width+(x*angcos)+(y*angsin));
   a[8] = (int) Math.round(dheight+(y*angcos)-(x*angsin));
   a[9] = (int) Math.round((x*angcos)-(y*angsin));
   a[10] = (int) Math.round(y*angcos + x*angsin);
   a[11] = width-x;
   a[12] = dheight-y;
   return a;
 }  

 public int[] get_angles() {
   int a[] = super.get_angles();
   a[0] = 6;
   a[4] = 60;
   a[5] = 300;
   a[6] = 180;
   return a;
 }
}

class p6mm extends p6 {

 public p6mm(int sz, JPanel pnl, JComponent cards) {
   super(sz, pnl, cards);
   name="p6mm";
 }

 public void draw_frame_inside(Graphics g) {
   g.drawLine(((int) Math.round(dwidth*(1+angcos)))-dwidth,0,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);
   g.drawLine(0,0,
              ((int) Math.round(dwidth*(1+angcos)))-dwidth,dheight/3);

/* 
   g.drawLine(((int) Math.round(dwidth*(1+angcos))),dheight,
      ((int) Math.round(dwidth*(1+angcos))),dheight*4/3);
g.drawLine(dwidth,dheight,
      ((int) Math.round(dwidth*(1+angcos))),dheight*4/3);
*/ 
 }

 public int[] translate_points(int x, int y) {
   int a[] = super.translate_points(x,y);
   a[0] = 24;
   a[13] = (int) Math.round(width-(x*angcos)-(y*angsin));
   a[14] = (int) Math.round(dheight+(y*angcos)-(x*angsin));
   a[15] = (int) Math.round(dwidth-(x*angcos)+(y*angsin));
   a[16] = (int) Math.round(y*angcos + x*angsin);
   a[17] = x+width;
   a[18] = dheight-y;
   a[19] = (int) Math.round((x*angcos) + y*angsin);
   a[20] = (int) Math.round(-(y*angcos) + x*angsin);
   a[21] = (int) Math.round(width + (x*angcos) - (y*angsin));
   a[22] = (int) Math.round(dheight-(x*angsin)-(y*angcos));
   a[23] = (int) Math.round(dwidth-x);
   a[24] = y;
   return a;
 }

 public int[] get_angles() {
   int a[] = super.get_angles();
   a[0] = 12;
   a[7] = 660;
   a[8] = 420;
   a[9] = 720;
   a[10] = 480;
   a[11] = 600;
   a[12] = 360;
   return a;
 }
}
