import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JToggleButton;



public class ToolButton extends JToggleButton implements ItemListener {
	ButtonPainter painter;
	ButtonReceiver receiver;
	
	public ToolButton(ButtonPainter painter, ButtonReceiver receiver) {
		super();
		this.painter=painter;
		this.receiver=receiver;
		addItemListener(this);
	}
	
	public void paint(Graphics g) {
		super.paint(g);
		painter.paintButton(g, size().width, size().height);
	}
	
	public void itemStateChanged(ItemEvent e) {
		if (e.getStateChange()==ItemEvent.SELECTED)
			receiver.select(painter);
	}
}



