import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.ToolTipManager;

/* Escher - SaveImage.java
 * 
 * Author   : Nicolas Schoeni
 * Creation : 22 mars 2005
 * 
 * nicolas.schoeni@epfl.ch
 */

public class SaveImage {
	private JFrame frame;
	public int psx, psy;
	public int respx, respy;
	public ActionListener listener;
	private Pane pane;
	
	public SaveImage(int psx, int psy, ActionListener listener) {
		this.listener=listener;
		this.psx=psx;
		this.psy=psy;
		frame = new JFrame("Save image");
		//frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setContentPane((pane=new Pane(this)).jPanel);
		frame.setSize(400, 200);
	}
	public void show() {
		frame.setVisible(true);
		frame.pack();
		frame.show();
	}
	public void show(int psx, int psy) {
		this.psx=psx;
		this.psy=psy;
		pane.px.setValue(new Integer(psx*(int)pane.rx.getFloatValue()));
		pane.py.setValue(new Integer(psy*(int)pane.ry.getFloatValue()));
		show();
	}
	public void close() {
		frame.setVisible(false);
		frame.hide();
	}
	public static void main(String[] args) {
		new SaveImage(30, 20, null).show();
	}
}

class Pane extends HVPanel.v {
	public JRadioButton repeat, custom, def800, def1024, def1200;
	public EditField px, py, rx, ry;
	SaveImage saveImage;
	public Pane(SaveImage saveImage) {
		this.saveImage=saveImage;
		addComp(new JLabel("Please choose the output image size :"));
		addComp(new JLabel(" "));
		HVPanel.h p1 = new HVPanel.h();
		expand(false);
		
		p1.addButton(repeat=new JRadioButton("Pattern repeated"));
		p1.putExtraSpace();
		rx = p1.addIntFieldSpinner("x : ", " times", 2, 10);
		ry = p1.addIntFieldSpinner("   y : ", " times", 2, 10);
		addSubPane(p1);
		
		HVPanel.h p2 = new HVPanel.h();
		p2.addButton(custom=new JRadioButton("Custom size"));
		p2.putExtraSpace();
		px = p2.addIntField("x : ", " pixels", 4, saveImage.psx*10);
		py = p2.addIntField("   y : ", " pixels", 4, saveImage.psy*10);
		addSubPane(p2);

		addButton(def800=new JRadioButton("800x600 pixels"));
		addButton(def1024=new JRadioButton("1024x768 pixels"));
		addButton(def1200=new JRadioButton("1280x1024 pixels"));
		
		addComp(new JLabel(" "));
		HVPanel.h p3 = new HVPanel.h();
		p3.addButton(new JButton("Ok"));
		p3.addButton(new JButton("Cancel"));
		addSubPane(p3);
		
		ButtonGroup bg = new ButtonGroup();
		bg.add(repeat);
		bg.add(custom);
		bg.add(def800);
		bg.add(def1024);
		bg.add(def1200);
		def1024.setSelected(true);
	}
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("Ok")) {
			if (repeat.isSelected()) {
				saveImage.respx=(int)rx.getFloatValue()*saveImage.psx; saveImage.respy=(int)ry.getFloatValue()*saveImage.psy;
			}
			else if (custom.isSelected()) {
				saveImage.respx=(int)px.getFloatValue();
				saveImage.respy=(int)py.getFloatValue();
			} 
			else if (def800.isSelected()) {
				saveImage.respx=800;
				saveImage.respy=600;
			}
			else if (def1024.isSelected()) {
				saveImage.respx=1024;
				saveImage.respy=768;
			}
			else if (def1200.isSelected()) {
				saveImage.respx=1280;
				saveImage.respy=1024;
			}
			saveImage.close();
			if (saveImage.listener!=null) saveImage.listener.actionPerformed(new ActionEvent(saveImage, 0, "")); 
//			System.out.println("px="+saveImage.respx);
//			System.out.println("py="+saveImage.respy);
//			System.out.println("rx="+saveImage.resrx);
//			System.out.println("ry="+saveImage.resry);
		}
		else if (e.getActionCommand().equals("Cancel")) {
			saveImage.close();
		}
		else if (e.getSource()==rx) {
			px.setValue(new Integer(saveImage.psx*(int)rx.getFloatValue()));
			repeat.setSelected(true);
		}
		else if (e.getSource()==ry) {
			py.setValue(new Integer(saveImage.psy*(int)ry.getFloatValue()));
			repeat.setSelected(true);
		}
		else if (e.getSource()==px) {
			custom.setSelected(true);
		}
		else if (e.getSource()==py) {
			custom.setSelected(true);
		}
	}
}

