//: com:bruceeckel:swing:Console.java
// Outil pour excuter des dmos Swing depuis
// la console, aussi bien applets que JFrames.
import javax.swing.*;
import java.awt.event.*;

public class Console {
  // Cre une chane de titre  partir du nom de la classe :
  public static String title(Object o) {
  String t = o.getClass().toString();
   // Enlever le mot "class":
   if(t.indexOf("class") != -1)
    t = t.substring(6);
   return t;
}
  public static void setupClosing(JFrame frame) {
   // La solution JDK 1.2 Solution avec une 
   // classe interne anonyme :
  frame.addWindowListener(new WindowAdapter() {
    public void windowClosing(WindowEvent e) {
      System.exit(0);
    }
  });
   // La solution amelioree en JDK 1.3 :
   // frame.setDefaultCloseOperation(
   //     EXIT_ON_CLOSE);
}
  public static void run(JFrame frame, int width, int height) {
	  setupClosing(frame);
	  frame.setSize(width, height);
	  frame.setVisible(true);
}
  public static JFrame run(JApplet applet, String name, int width, int height) {
	  JFrame frame = new JFrame(name);
	  setupClosing(frame);
	  frame.getContentPane().add(applet);
	  frame.setSize(width, height);
	  applet.init();
	  applet.start();
	  frame.setVisible(true);
	  return frame;
  }
  public static JFrame run(JApplet applet, int width, int height) {
  	return run(applet, title(applet), width, height);
	}
  public static JFrame run(JPanel panel, String name, int width, int height) {
	  JFrame frame = new JFrame(name);
	  setupClosing(frame);
	  frame.getContentPane().add(panel);
	  frame.setSize(width, height);
	  frame.setVisible(true);
	  return frame;
  }
  
  public static JFrame run(JPanel panel, int width, int height) {
  	return run(panel, title(panel), width, height);
  }
  
  
} ///:~
