
function dy = kramxy(t,y)

global g kbt vv deltax deltav nstep

y = reshape(y,nstep,nstep);

% Kernel of the Kramers differential equation (discrete derivatives with
% periodic boundary conditions are computed with the help of the circshift
% operation
dy = ...
     - vv .* (circshift(y,[0 -1]) - circshift(y,[0 1]))./2./deltax ...
     + g .* (circshift(vv .* y,-1) - circshift(vv .* y,1))./2./deltav ...
     + g .* kbt .* (- 2 .* y + circshift(y,1) + circshift(y,-1))./deltav^2;

dy = reshape(dy,nstep^2,1);
