
global g kbt vv deltax deltav nstep

% Parameters (absolute units with mass = 1)

g = 0.2; % Damping constant
kbt = 10.0; % Boltzmann constant times the temperature
nstep = 128;      %number of steps in space
xsize = 200.0;   % Size of the real-space simulation domain (nm)
vsize = 60.0;   % Size of the velocity-space simulation domain (nm)
deltax = xsize / nstep;
deltav = vsize / nstep;

% Define the time grid
tmax = 10;
nstept = 100;
tt = (0:nstept-1).*tmax./nstept;

% Define the real- and velocity-space grids
x = -xsize/2 + (0:nstep-1) .* deltax;
v = -vsize/2 + (0:nstep-1) .* deltav;


% 2-dimensional array with velocity on the lines
vv = v' * ones(1,nstep);

% 2-dimensional array of x^2+v^2
xv = (v').^2 * ones(1,nstep) + ones(nstep,1) * x.^2;

% Initial condition
zzz = exp(-xv./2./2^2);
zzz = reshape(zzz,nstep^2,1);

% Integrate Kramers equation

[t,p] = ode45(@kramxv,tt,zzz);

