clear all

% parameters for schroedinger equation 
ht = 6.5822*10^(-16);      % hbar (eV s)
nstep = 2048;	           % number of grid points
niter = 10000;
size  = 4096.0;            % size of the problem (nm)
sigma = 0.0005;               % potential amplitude (eV)
xi    = 2.0;              % potential correlation length (nm)
mexc  = 0.25;              % exciton mass in electron mass units
sigmap = 8;               % Gauss width of initial wavepacket (nm)
x0    = 0;               % position of initial wavepacket (nm)

deltax = size / nstep;     % step size

T      = 0.0378 / (mexc * deltax^2);  % hopping constant for numerical Schroedinger equation (eV)

% generate random white-noise potential
wnpot = sigma * randn(1,nstep); % white-noise potential, to be convoluted with exciton relative wave function
exc1s = zeros(1,nstep);         % exciton relative wave function, normalized in order to get the final potential amplitude equal to sigma
x     = zeros(1,nstep);         % array of positions on grid

% compute exciton relative wave function
v = 1:nstep;
x = deltax * (v-nstep/2-1);
exc1s = exp(-abs(x)/xi) * sqrt(sqrt(2/pi/xi^2));
%exc1s = exp(-x^2/xi^2) * sqrt(sqrt(2/pi/xi^2));

% convolution of white-noise and exciton wave function
wnpot = fft(wnpot);
exc1s = fft(exc1s);
pot = real(ifft(wnpot.*exc1s)) .* sqrt(deltax);
%load pot pot;

psi = exp(-(x-x0).*(x-x0)./2./sigmap^2) ./ sqrt(sqrt(pi) .* sigmap);

%psi = psi ./ sqrt(sum(psi.^*conj(psi)).*deltax);

psi1 = psi + i ./ 4 .* (circshift(psi,[0 1]) + circshift(psi,[0 -1]) - (2 + pot ./ T) .* psi);

subplot(2,1,1)
h = plot(x,psi .* conj(psi),'r','linewidth',2);
hold on
axis ([-deltax.*nstep/2 deltax.*nstep/2 2*min(pot) 5*max(pot)])
%pot = zeros(1,nstep);
plot(x,pot)
set(h,'EraseMode','xor')
set(gca,'fontsize',14)
xlabel('position (nm)','fontsize',14)
ylabel('energy (eV)','fontsize',14)

ene = -sum(psi .* T .* (circshift(psi,[0 1]) + circshift(psi,[0 -1]) - (2 + pot ./ T) .* psi))*deltax;

lloc = zeros(1,niter);

subplot(2,1,2)
g = plot(lloc,'linewidth',2);
%hold on
axis([0 niter 0 size ./ 2])
set(g,'EraseMode','xor','linewidth',2)
set(gca,'fontsize',14)
xlabel('time step','fontsize',14)
ylabel('localization length (nm)','fontsize',14)

k = waitforbuttonpress;

M = moviein(niter/100);

for n = 1:niter
    drawnow
    psi2 = psi + i ./ 2.1 .* (circshift(psi1,[0 1]) + circshift(psi1,[0 -1]) - (2 + pot ./ T) .* psi1);
    psi = psi1;
    psi1 = psi2;
    lloc(n) = 1/(sum((psi1.*conj(psi1)).^2)*deltax);
    if mod(n-1,100) == 0
        set(h,'XData',x,'YData',psi1 .* conj(psi1),'linewidth',2)
        subplot(2,1,2)
        set(g,'YData',lloc)
        subplot(2,1,1)
        M((n-1)/100+1) = getframe(gcf);
    end
end

movie2avi(M,'prova.avi')

clear all
