clear all

% parameters for schroedinger equation 
ht = 6.5822*10^(-16);      % hbar (eV s)
nstep = 4096;	           % number of grid points
niter = 4000;
size  = 24000.0;            % size of the problem (nm)
sigma = 0.0001 .* ones(1,25);               % potential amplitude (eV)
mexc  = 1;              % exciton mass in electron mass units
sigmap = 30;              % Gauss width of initial wavepacket (nm)
xi    = 20 .* rand(1,25);              % thickness first barrier (nm)
xb    = cumsum(80 .* (rand(1,25)+0.5));             %distance of the two barriers (nm)
x0    = -1000;               % position of initial wavepacket (nm)
q0    = 4 / sigmap;              % wavevector of initial wavepacket (nm^-1)

deltax = size / nstep;     % step size

T      = 0.0378 / (mexc * deltax^2);  % hopping constant for numerical Schroedinger equation (eV)

% generate barrier potential
x     = zeros(1,nstep);         % array of positions on grid
v     = (1:nstep);
x = deltax * (v-nstep/2-1);
pot   = zeros(1,nstep);
for j=1:25
pot   = pot + ((x > xb(j)) & (x < xb(j) + xi(j))) .* sigma(j);
end
%pot    = sigma .* exp(-x.^2/2/xi.^2);

psi = exp(-(x-x0).*(x-x0)./2./sigmap^2 + i.*q0.*x) ./ sqrt(sqrt(pi) .* sigmap);
%psi = psi ./ sqrt(sum(psi.*conj(psi)).*deltax);
psi1 = psi + i ./ 4 .* (circshift(psi,[0 1]) + circshift(psi,[0 -1]) - (2 + pot ./ T) .* psi);
temp = psi .* conj(psi);
mmm  = max(temp);

%h = plot(x,temp ./ mmm .* max(pot),'r');
h = plot(x,temp./4,'r');
hold on
axis ([-deltax.*nstep/2 deltax.*nstep/2 min(pot) 1.5*max(pot)])
area(x,pot)
set(h,'EraseMode','xor','linewidth',2)
set(gca,'fontsize',14)
xlabel('position (nm)','fontsize',14)
ylabel('energy (eV)','fontsize',14)
%text(3500,0.00058,'m=m_0','fontsize',14)
l = legend('|\psi|^2','V(x)');
legend('boxoff')
set(l,'fontsize',14)

ene = -sum(conj(psi) .* T .* (circshift(psi,[0 1]) + circshift(psi,[0 -1]) - (2 + pot ./ T) .* psi))*deltax;

lloc = zeros(1,niter);

k = waitforbuttonpress;

for n = 1:niter
%    n
    psi2 = psi + i ./ 2.1 .* (circshift(psi1,[0 1]) + circshift(psi1,[0 -1]) - (2 + pot ./ T) .* psi1);
    psi = psi1;
    psi1 = psi2;
%    lloc(n) = 1/(sum((psi1.*conj(psi1)).^2)*deltax);
    if mod(n-1,20) == 0
        temp = psi1 .* conj(psi1);
        mmm = max(temp);
%        set(h,'XData',x,'YData',temp ./ mmm .* max(pot))
        set(h,'XData',x,'YData',temp./4)
        drawnow
     %   M((n-1)/10+1) = getframe;
    end
end
