%% filename = "discovor.cls"
%% derived from AMAM 2017 templates
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{discovor}[2021/12/01 DisCoVor Conference LaTeX class]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\if@compatibility\else
	\DeclareOption{a4paper}
	{\setlength\paperheight {297mm}%
		\setlength\paperwidth  {210mm}}
\fi
\if@compatibility
	\renewcommand\@ptsize{0}
\else
	\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
	\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\if@compatibility\else
	\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
	\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility\else
	\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
	\AtEndOfPackage{%
		\renewcommand\@openbib@code{%
			\advance\leftmargin\bibindent
			\itemindent -\bibindent
			\listparindent \itemindent
			\parsep \z@
		}%
		\renewcommand\newblock{\par}}%
}
\ExecuteOptions{a4paper,10pt,oneside,onecolumn,final}
\ProcessOptions
\input{size1\@ptsize.clo}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\if@twoside
	\def\ps@headings{%
	\let\@oddfoot\@empty\let\@evenfoot\@empty
	\def\@evenhead{\thepage\hfil\slshape\leftmark}%
	\def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
	\let\@mkboth\markboth
	\def\sectionmark##1{%
	\markboth {\MakeUppercase{%
			\ifnum \c@secnumdepth >\z@
				\thesection\quad
			\fi
			##1}}{}}%
	\def\subsectionmark##1{%
	\markright {%
		\ifnum \c@secnumdepth >\@ne
			\thesubsection\quad
		\fi
		##1}}}
\else
	\def\ps@headings{%
	\let\@oddfoot\@empty
	\def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
	\let\@mkboth\markboth
	\def\sectionmark##1{%
	\markright {\MakeUppercase{%
			\ifnum \c@secnumdepth >\m@ne
				\thesection\quad
			\fi
			##1}}}}
\fi
\def\ps@myheadings{%
	\let\@oddfoot\@empty\let\@evenfoot\@empty
	\def\@evenhead{\thepage\hfil\slshape\leftmark}%
	\def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
	\let\@mkboth\@gobbletwo
	\let\sectionmark\@gobble
	\let\subsectionmark\@gobble
}
\if@titlepage
	\newcommand\maketitle{\begin{titlepage}%
			\let\footnotesize\small
			\let\footnoterule\relax
			\let \footnote \thanks
			\null\vfil
			\vskip 20\p@
			\begin{center}%
				{\LARGE \@title \par}%
				\vskip 3em%
					{\large
						\lineskip .75em%
						\begin{tabular}[t]{c}%
							\@author
						\end{tabular}\par}%
				\vskip 1.5em%
					{\large \@date \par}%
			\end{center}\par
			\@thanks
			\vfil\null
		\end{titlepage}%
		\setcounter{footnote}{0}%
		\global\let\thanks\relax
		\global\let\maketitle\relax
		\global\let\@thanks\@empty
		\global\let\@author\@empty
		\global\let\@date\@empty
		\global\let\@title\@empty
		\global\let\title\relax
		\global\let\author\relax
		\global\let\date\relax
		\global\let\and\relax
	}
\else
	\newcommand\maketitle{\par
	\begingroup
	\renewcommand\thefootnote{\@fnsymbol\c@footnote}%
	\def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
	\long\def\@makefntext##1{\parindent 1em\noindent
	\hb@xt@1.8em{%
	\hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
	\if@twocolumn
		\ifnum \col@number=\@ne
			\@maketitle
		\else
			\twocolumn[\@maketitle]%
		\fi
	\else
		\newpage
		\global\@topnum\z@   % Prevents figures from going at top of page.
		\@maketitle
	\fi
	\thispagestyle{plain}\@thanks
	\endgroup
	\setcounter{footnote}{0}%
	\global\let\thanks\relax
	\global\let\maketitle\relax
	\global\let\@maketitle\relax
	\global\let\@thanks\@empty
	\global\let\@author\@empty
	\global\let\@date\@empty
	\global\let\@title\@empty
	\global\let\title\relax
	\global\let\author\relax
	\global\let\date\relax
	\global\let\and\relax
	}
	\def\@maketitle{%
		\newpage
		\null
		\vskip 2em%
		\begin{center}%
			\let \footnote \thanks
			{\LARGE \@title \par}%
			\vskip 1.5em%
				{\large
					\lineskip .5em%
					\begin{tabular}[t]{c}%
						\@author
					\end{tabular}\par}%
			\vskip 1em%
				{\large \@date}%
		\end{center}%
		\par
		\vskip 1.5em}
\fi
\setcounter{secnumdepth}{2}
\newcounter {section}
\newcounter {subsection}[section]
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\newcommand\section{\@startsection {section}{1}{\z@}%
  {-3.5ex \@plus -1ex \@minus -.2ex}%
  {2.3ex \@plus.2ex}%
  {\normalfont\Large\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
	{-3.25ex\@plus -1ex \@minus -.2ex}%
	{1.5ex \@plus .2ex}%
	{\normalfont\large\bfseries}}
\if@twocolumn
	\setlength\leftmargini  {2em}
\else
	\setlength\leftmargini  {2.5em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
	\setlength\leftmarginv  {.5em}
	\setlength\leftmarginvi {.5em}
\else
	\setlength\leftmarginv  {1em}
	\setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
{\list{}{\labelwidth\z@ \itemindent-\leftmargin
		\let\makelabel\descriptionlabel}}
{\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
	\normalfont\bfseries #1}
\newenvironment{quotation}
{\list{}{\listparindent 1.5em%
		\itemindent    \listparindent
		\rightmargin   \leftmargin
		\parsep        \z@ \@plus\p@}%
	\item\relax}
{\endlist}
\newenvironment{quote}
{\list{}{\rightmargin\leftmargin}%
	\item\relax}
{\endlist}
\if@compatibility
	\newenvironment{titlepage}
	{%
		\if@twocolumn
			\@restonecoltrue\onecolumn
		\else
			\@restonecolfalse\newpage
		\fi
		\thispagestyle{empty}%
		\setcounter{page}\z@
	}%
	{\if@restonecol\twocolumn \else \newpage \fi
	}
\else
	\newenvironment{titlepage}
	{%
		\if@twocolumn
			\@restonecoltrue\onecolumn
		\else
			\@restonecolfalse\newpage
		\fi
		\thispagestyle{empty}%
		\setcounter{page}\@ne
	}%
	{\if@restonecol\twocolumn \else \newpage \fi
		\if@twoside\else
			\setcounter{page}\@ne
		\fi
	}
\fi

\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand \theequation {\@arabic\c@equation}
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
{\@float{figure}}
{\end@float}
\newenvironment{figure*}
{\@dblfloat{figure}}
{\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
{\@float{table}}
{\end@float}
\newenvironment{table*}
{\@dblfloat{table}}
{\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
	\vskip\abovecaptionskip
	\sbox\@tempboxa{#1: #2}%
	\ifdim \wd\@tempboxa >\hsize
		#1: #2\par
	\else
		\global \@minipagefalse
		\hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
	\fi
	\vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}

\newcommand*\l@section[2]{%
	\ifnum \c@tocdepth >\z@
		\addpenalty\@secpenalty
		\addvspace{1.0em \@plus\p@}%
		\setlength\@tempdima{1.5em}%
		\begingroup
		\parindent \z@ \rightskip \@pnumwidth
		\parfillskip -\@pnumwidth
		\leavevmode \bfseries
		\advance\leftskip\@tempdima
		\hskip -\leftskip
		#1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
		\endgroup
	\fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
{\section*{\refname
		\@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
	\list{\@biblabel{\@arabic\c@enumiv}}%
	{\settowidth\labelwidth{\@biblabel{#1}}%
		\leftmargin\labelwidth
		\advance\leftmargin\labelsep
		\@openbib@code
		\usecounter{enumiv}%
		\footnotesize\let\p@enumiv\@empty
		\renewcommand\theenumiv{\@arabic\c@enumiv}}%
	\sloppy
	\clubpenalty4000
	\@clubpenalty \clubpenalty
	\widowpenalty4000%
	\sfcode`\.\@m}
{\def\@noitemerr
	{\@latex@warning{Empty `thebibliography' environment}}%
	\endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\renewcommand\footnoterule{%
	\kern-3\p@
	\hrule\@width.4\columnwidth
	\kern2.6\p@}
\newcommand\@makefntext[1]{%
\parindent 1em%
\noindent
\hb@xt@1.8em{\hss\@makefnmark}#1}
\newcommand\refname{References}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\today{}
\edef\today{\ifcase\month\or
		January\or February\or March\or April\or May\or June\or
		July\or August\or September\or October\or November\or December\fi
	\space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{empty}
\pagenumbering{arabic}
\raggedbottom
\twocolumn
\sloppy
\flushbottom
\textheight 244mm
\textwidth 178mm
\columnsep 10mm
\parindent 0pt
\parskip 1em plus .1em minus .2em
\oddsidemargin -9.4mm
\evensidemargin -9.4mm
\topmargin -12mm
\def\maketitle{\par
	\begingroup
	\def\@makefnmark{\hbox{$^{\@thefnmark}$\hss}}
	\if@twocolumn
		\twocolumn[\@maketitle]
	\else \newpage
		\global\@topnum\z@ \@maketitle \fi\pagestyle{myheadings}\@thanks
	\endgroup
	\setcounter{footnote}{0}
	\let\maketitle\relax
	\let\@maketitle\relax
	\gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\thanks\relax}
\def\@maketitle{\newpage
	\null \vskip 0.3em
	\begin{center}
		{\LARGE\bf \@title \par} \vskip 1.5em {\large \lineskip .5em
				\begin{tabular}[t]{c}\@author
				\end{tabular}\par}
	\end{center}
	\par
	\vskip 1.5em}

\def\@startsection#1#2#3#4#5#6#7{\if@noskipsec \leavevmode \fi
	\par \@tempskipa #4\relax
	\@afterindenttrue
	\ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \@afterindentfalse\fi
	\addtolength{\@tempskipa}{-\parskip}
	\if@nobreak \everypar{}\else
		\addpenalty{\@secpenalty}\addvspace{\@tempskipa}\fi
	\@ifstar
	{\@ssect{#1}{#2}{#3}{#4}{#5}{#6}{#7}}
	{\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}{#7}}}}

\def\@sect#1#2#3#4#5#6#7[#8]#9{
	\ifnum #2>\c@secnumdepth
		\def\@svsec{}
	\else
		\ifnum #2> 2 % if it is subsubsection, paragraph  ...
			\refstepcounter{#1}\edef\@svsec{{\csname the#1\endcsname}\hskip .5em }
		\else        % if it is section or subsection, put "." after number
			\refstepcounter{#1}\edef\@svsec{{\csname the#1\endcsname}\hskip .5em }
		\fi
	\fi
	\@tempskipa #5\relax
	\ifdim \@tempskipa>\z@
		\begingroup #6\relax
		\ifnum #2 > 1
			\@hangfrom{\hskip #3\relax}{\@svsec\interlinepenalty \@M #8#7\par}
		\else
			\setbox1=\hbox{\@svsec #8#7}
			\ifdim \wd1>\columnwidth
				{\centering\@svsec \interlinepenalty \@M #8#7\par}
			\else
				\vskip\parskip\centerline{\@svsec\interlinepenalty\@M #8#7}\par
			\fi
		\fi
		\endgroup
		\csname #1mark\endcsname{#8}\addcontentsline
		{toc}{#1}{\ifnum #2>\c@secnumdepth \else
				\protect\numberline{\csname the#1\endcsname}\fi
			#8}
	\else
		\def\@svsechd{#6\hskip #3\@svsec #9#7\csname #1mark\endcsname
			{#8}\addcontentsline {toc}{#1}{\ifnum #2>\c@secnumdepth \else
					\protect\numberline{\csname the#1\endcsname}\fi
				#8}}
	\fi
	\@xsect{#5}}

\def\@ssect#1#2#3#4#5#6#7#8{\@tempskipa #5\relax
	\ifdim \@tempskipa>\z@
		\begingroup #6\relax
		\ifnum #2 > 1
			\@hangfrom{\hskip #3}{\interlinepenalty\@M #8#7\par}
		\else
			\setbox1=\hbox{#8#7}
			\ifdim \wd1>\columnwidth
				{\centering#8#7\par}
			\else
				\vskip\parskip\centerline{#8#7}\par
			\fi
		\fi
		\endgroup
	\else
		\def\@svsechd{#6\hskip #3\relax #8#7}
	\fi
	\@xsect{#5}}

\def\@xsect#1{\@tempskipa #1\relax
	\ifdim \@tempskipa>\z@
		\par \nobreak
		\addtolength{\@tempskipa}{-\parskip}
		\vskip \@tempskipa
		\@afterheading
	\else \global\@nobreakfalse \global\@noskipsectrue
		\everypar{\if@noskipsec \global\@noskipsecfalse
				\clubpenalty\@M \hskip -\parindent
				\begingroup \@svsechd \endgroup \unskip
				\hskip -#1
			\else \clubpenalty \@clubpenalty
				\everypar{}\fi}\fi\ignorespaces}

\def\section{\@startsection{section}{1}{\z@}
  {3.5ex plus 0.5ex minus 0.5ex}{2ex plus 0.3ex}{\bf}{}}
\def\subsection{\@startsection{subsection}{2}{\z@}{3.0ex plus
		.3ex minus .1ex}{0.01ex plus .0ex}{\bf}{}}

\def\thebibliography#1{\section*
	{References\@mkboth
		{References}{References}}\parskip 0pt \list
	{[\arabic{enumi}]\hfill}{\labelwidth 7mm \leftmargin\labelwidth
		\itemindent 9mm \itemsep 0pt
		\advance\leftmargin -7mm
		\usecounter{enumi}}
	\def\newblock{\hskip .11em plus .33em minus .07em}
	\sloppy\clubpenalty4000\widowpenalty4000
	\sfcode`\.=1000\relax}
\let\endthebibliography=\endlist

\def\ps@myheadings{\let\@mkboth\@gobbletwo
	\def\@oddhead{}\def\@oddfoot{\hfil
		\@footernote\ \qquad p. \thepage}
	\def\@evenhead{}\def\@evenfoot{
		p. \thepage\qquad  \@footernote\ \hfil }
}

%%% Redefines captions
\newlength{\captionindent}
\long\def\@makecaption#1#2{
	\vskip 10pt
	\setbox\@tempboxa\hbox{{\bf #1:} \rm #2}
	\ifdim \wd\@tempboxa >\hsize
		\setbox\@tempboxa\hbox{\bf#1:~}
		\setlength\captionindent{\wd\@tempboxa}
		\parbox[t]{\hsize}{\small \hangindent \captionindent \hangafter=1%
			\unhbox\@tempboxa#2}
	\else \hbox to\hsize{\hfil\box\@tempboxa\hfil}
	\fi
}

%%% used a tex at the foot of the article
\def\footernote#1{\def\@footernote{#1}}
\footernote{}

% set up default pagestyle
% \pagestyle{empty}
\usepackage{fancyhdr}
\setlength{\headheight}{15.2pt}
\pagestyle{fancy}
\fancyhead[c]{
\hrule\vspace{0.4ex}
\fontsize{8}{8}\scshape\selectfont
first direct in-person colloquium on vortex dominated flows (discovor) $\ \cdot\ $ villars-sur-ollon, switzerland $\ \cdot\ $ may 17-20, 2022}
\fancyhead[l]{}
\fancyhead[r]{}
\fancyfoot{}

%% make itemsep narrower
\def\@normalsize{\@setsize\normalsize{11.9pt}\xpt\@xpt
	\abovedisplayskip 10pt plus2pt minus5pt
	\belowdisplayskip \abovedisplayskip
	\abovedisplayshortskip \z@ plus3pt
	\belowdisplayshortskip 6pt plus3pt minus3pt
	\def\@listi{\leftmargin\leftmargini
		\topsep -\parskip \addtolength{\topsep}{0.5em}
		\parsep 1pt plus 1pt minus 1pt
		\itemsep 2pt plus 1pt minus 1pt
	}}

\usepackage{palatino}
\usepackage{mathptmx}               % Times font for text and maths
\usepackage{cite}                   % bibliography citations package
\usepackage[tableposition=top,figureposition=bottom,labelfont={bf},skip=5pt]{caption}

\twocolumn \sloppy \flushbottom
\endinput
