
function [eM1, eM2, eM3]=permute_e(nc,M)
%generates the bit error pattern e for a given codewordlength nc
%up to the maximium error number M

%% Permutation of 1 bit error
eM1=logical(eye(nc));


%% Permutation of 2 bit error
eM2=[];
if M>1
%MeM2=round(factorial(nc)/(factorial(nc-2)*factorial(2)));
MeM2=(nc*(nc-1))/2;
eM2=[1 1 zeros(1,nc-2); NaN(MeM2-1,nc)];
z=1;
for ko=0:nc-3
    for ki=2:nc-1-ko
        z=z+1;
        eM2(z,:)=0;
        eM2(z,ko+1)=1;
        eM2(z,ki+ko)=0;
        eM2(z,ki+ko+1)=1;
    end
    z=z+1;
    eM2(z,:)=0;
    eM2(z,ko+2)=1;
    eM2(z,ko+3)=1;
end
eM2=logical(eM2);
end

%% Permutation of 3 bit error
eM3=[];
if M>2
    % MeM3=factorial(nc)/(factorial(nc-3)*factorial(3));
    MeM3=(nc*(nc-1)*(nc-2))/6;
    
    eM3=false(MeM3,nc);
    arg=0;
    for ko=0:nc-3
        for km=0:nc-3
            if nc-2-km-ko<1; break; end
            e_sub=logical([zeros(nc-2-km-ko,ko) ones(nc-2-km-ko,1)...
                zeros(nc-2-km-ko,km) ones(nc-2-km-ko,1),eye(nc-2-km-ko)]);
            arg=(1:size(e_sub,1))+max(arg);
            eM3(arg,:)=logical(e_sub);
        end
    end
end
