function [x_decode,x_llr_new, count] = hamm_soft_out(HT,e_sort,s_pdf,x_llr)
%%#eml
% calculates the soft-output x_llr_new from the soft-input x_llr

Nframes=size(x_llr,1);
nc=size(x_llr,2);

x_llr(x_llr==0)=0.000000001;

%% Memory allocation
x_p_new=NaN(1,nc);
x_llr_new=x_llr;

x_p0=exp(abs(x_llr))./(1+exp(abs(x_llr)));

x_code_r=(sign(-x_llr)+1)/2;
x_decode=x_code_r;
count=0;
%% Decoding, old version (tested, slow)
x_decode=x_code_r;
for k=1:Nframes
    %% Syndrom calculation
    syn_b=mod(x_code_r(k,:)*HT,2);
    if sum(syn_b)~=0
        count=1;
        %syn_d=bi2de(syn_b,[],'left-msb'); % too slow
        syn_b = syn_b(end:-1:1);
        pow2vector = 2.^(0:1:(size(syn_b,2)-1));
        syn_d = syn_b*pow2vector';
        
        %find start and end in s_sort for syn_b
        start=sum(s_pdf(1:syn_d-1))+1;
        ende=sum(s_pdf(1:syn_d));
        stepsize=ende-start+1; % number of error patterns for syndrome
        e_work=e_sort(start:ende,:);
        
        %multiply row-wise and find minimum, decode to minimum
        e_llr_prod=bem_repmat(abs(x_llr(k,:)),stepsize).*e_work;
        [~,idx_llr_min]=min(sum(abs(e_llr_prod),2));
        x_decode(k,:)=mod(x_code_r(k,:)+e_sort(start+idx_llr_min-1,:),2);
        
        % x_p0 probabilit que bit soit juste
        % x_p probabilit que bit (flipp) soit juste, pour chaque pattern
        x_p=abs(e_work-bem_repmat(x_p0(k,:),stepsize));
        % P: probabilit qu'un des errors patterns ait eu lieu
        P=prod(x_p,2).';
        
        % Normalize Probability Pnorm
        Psum=sum(P);
        Pnorm=P./Psum;
        if Psum==0
            Pnorm(:)=0.000001;
        end
        
        % Limit too high propabilities
        if max(Psum)>(1-1E-25)
            Pnorm=Pnorm*(1-1E-25);
        end
        
        for k4=1:nc % bit par bit du codeword
            wert=mod(x_code_r(k,k4)+e_work(:,k4),2);
            x_p_new(k4)=1-sum(wert.*Pnorm.');
        end
        % calculate new LLRs
        x_llr_new(k,:)=log(x_p_new./(1-x_p_new));
    end
    
    
    % Limit infinit LLRs max of input
    Threshold=1*max(max(abs(x_llr)))+randn(1)/10;
    x_llr_new(k,x_llr_new(k,:)>Threshold)=Threshold;
    Threshold=Threshold+randn(1)/10;
    x_llr_new(k,x_llr_new(k,:)<-Threshold)=-Threshold;
end
x_llr_new=real(x_llr_new);

