function par = gen2par (gen)

  [gr, gc] = size (gen);

  if (gr > gc)
    error ('gen2par: GEN must be a generator matrix in standard form');
  end

  if (isequal (gen(:,1:gr), eye (gr)))
    par = [gen(:,gr+1:gc)', eye(gc-gr)];
  elseif (isequal (gen(:,gc-gr+1:gc), eye (gr)))
    par = [eye(gc-gr), gen(:,1:gc-gr)'];
  else
    error ('gen2par: GEN must be a generator matrix in standard form');
  end

end

