function G=bem_hammgen(Kc)
% function that generates the generator matrix G for a given number of
% parity bits Kc, where Kc has to be between 3 and 7

kc=2^(Kc)-1-Kc;

I=eye(kc);

if Kc==1
    P=[1;1;1;1];
    kc = 4;
    I = eye(kc);
end

if Kc==3
    P=[1,1,0;0,1,1;1,1,1;1,0,1;];
end

if Kc==4
    P=[1,1,0,0;0,1,1,0;0,0,1,1;1,1,0,1;1,0,1,0;0,1,0,1;1,1,1,0;0,1,1,1;1,1,1,1;1,0,1,1;1,0,0,1;];
end

if Kc==5
    P=[1,0,1,0,0;0,1,0,1,0;0,0,1,0,1;1,0,1,1,0;0,1,0,1,1;1,0,0,0,1;1,1,1,0,0;0,1,1,1,0;0,0,1,1,1;1,0,1,1,1;1,1,1,1,1;1,1,0,1,1;1,1,0,0,1;1,1,0,0,0;0,1,1,0,0;0,0,1,1,0;0,0,0,1,1;1,0,1,0,1;1,1,1,1,0;0,1,1,1,1;1,0,0,1,1;1,1,1,0,1;1,1,0,1,0;0,1,1,0,1;1,0,0,1,0;0,1,0,0,1;];
end

if Kc==6
    P=[1,1,0,0,0,0;0,1,1,0,0,0;0,0,1,1,0,0;0,0,0,1,1,0;0,0,0,0,1,1;1,1,0,0,0,1;1,0,1,0,0,0;0,1,0,1,0,0;0,0,1,0,1,0;0,0,0,1,0,1;1,1,0,0,1,0;0,1,1,0,0,1;1,1,1,1,0,0;0,1,1,1,1,0;0,0,1,1,1,1;1,1,0,1,1,1;1,0,1,0,1,1;1,0,0,1,0,1;1,0,0,0,1,0;0,1,0,0,0,1;1,1,1,0,0,0;0,1,1,1,0,0;0,0,1,1,1,0;0,0,0,1,1,1;1,1,0,0,1,1;1,0,1,0,0,1;1,0,0,1,0,0;0,1,0,0,1,0;0,0,1,0,0,1;1,1,0,1,0,0;0,1,1,0,1,0;0,0,1,1,0,1;1,1,0,1,1,0;0,1,1,0,1,1;1,1,1,1,0,1;1,0,1,1,1,0;0,1,0,1,1,1;1,1,1,0,1,1;1,0,1,1,0,1;1,0,0,1,1,0;0,1,0,0,1,1;1,1,1,0,0,1;1,0,1,1,0,0;0,1,0,1,1,0;0,0,1,0,1,1;1,1,0,1,0,1;1,0,1,0,1,0;0,1,0,1,0,1;1,1,1,0,1,0;0,1,1,1,0,1;1,1,1,1,1,0;0,1,1,1,1,1;1,1,1,1,1,1;1,0,1,1,1,1;1,0,0,1,1,1;1,0,0,0,1,1;1,0,0,0,0,1;];
end

if Kc==7
    P=[1,0,0,1,0,0,0;0,1,0,0,1,0,0;0,0,1,0,0,1,0;0,0,0,1,0,0,1;1,0,0,1,1,0,0;0,1,0,0,1,1,0;0,0,1,0,0,1,1;1,0,0,0,0,0,1;1,1,0,1,0,0,0;0,1,1,0,1,0,0;0,0,1,1,0,1,0;0,0,0,1,1,0,1;1,0,0,1,1,1,0;0,1,0,0,1,1,1;1,0,1,1,0,1,1;1,1,0,0,1,0,1;1,1,1,1,0,1,0;0,1,1,1,1,0,1;1,0,1,0,1,1,0;0,1,0,1,0,1,1;1,0,1,1,1,0,1;1,1,0,0,1,1,0;0,1,1,0,0,1,1;1,0,1,0,0,0,1;1,1,0,0,0,0,0;0,1,1,0,0,0,0;0,0,1,1,0,0,0;0,0,0,1,1,0,0;0,0,0,0,1,1,0;0,0,0,0,0,1,1;1,0,0,1,0,0,1;1,1,0,1,1,0,0;0,1,1,0,1,1,0;0,0,1,1,0,1,1;1,0,0,0,1,0,1;1,1,0,1,0,1,0;0,1,1,0,1,0,1;1,0,1,0,0,1,0;0,1,0,1,0,0,1;1,0,1,1,1,0,0;0,1,0,1,1,1,0;0,0,1,0,1,1,1;1,0,0,0,0,1,1;1,1,0,1,0,0,1;1,1,1,1,1,0,0;0,1,1,1,1,1,0;0,0,1,1,1,1,1;1,0,0,0,1,1,1;1,1,0,1,0,1,1;1,1,1,1,1,0,1;1,1,1,0,1,1,0;0,1,1,1,0,1,1;1,0,1,0,1,0,1;1,1,0,0,0,1,0;0,1,1,0,0,0,1;1,0,1,0,0,0,0;0,1,0,1,0,0,0;0,0,1,0,1,0,0;0,0,0,1,0,1,0;0,0,0,0,1,0,1;1,0,0,1,0,1,0;0,1,0,0,1,0,1;1,0,1,1,0,1,0;0,1,0,1,1,0,1;1,0,1,1,1,1,0;0,1,0,1,1,1,1;1,0,1,1,1,1,1;1,1,0,0,1,1,1;1,1,1,1,0,1,1;1,1,1,0,1,0,1;1,1,1,0,0,1,0;0,1,1,1,0,0,1;1,0,1,0,1,0,0;0,1,0,1,0,1,0;0,0,1,0,1,0,1;1,0,0,0,0,1,0;0,1,0,0,0,0,1;1,0,1,1,0,0,0;0,1,0,1,1,0,0;0,0,1,0,1,1,0;0,0,0,1,0,1,1;1,0,0,1,1,0,1;1,1,0,1,1,1,0;0,1,1,0,1,1,1;1,0,1,0,0,1,1;1,1,0,0,0,0,1;1,1,1,1,0,0,0;0,1,1,1,1,0,0;0,0,1,1,1,1,0;0,0,0,1,1,1,1;1,0,0,1,1,1,1;1,1,0,1,1,1,1;1,1,1,1,1,1,1;1,1,1,0,1,1,1;1,1,1,0,0,1,1;1,1,1,0,0,0,1;1,1,1,0,0,0,0;0,1,1,1,0,0,0;0,0,1,1,1,0,0;0,0,0,1,1,1,0;0,0,0,0,1,1,1;1,0,0,1,0,1,1;1,1,0,1,1,0,1;1,1,1,1,1,1,0;0,1,1,1,1,1,1;1,0,1,0,1,1,1;1,1,0,0,0,1,1;1,1,1,1,0,0,1;1,1,1,0,1,0,0;0,1,1,1,0,1,0;0,0,1,1,1,0,1;1,0,0,0,1,1,0;0,1,0,0,0,1,1;1,0,1,1,0,0,1;1,1,0,0,1,0,0;0,1,1,0,0,1,0;0,0,1,1,0,0,1;1,0,0,0,1,0,0;0,1,0,0,0,1,0;0,0,1,0,0,0,1;];
end

G=[I P];