%% Demonstration of Soft-Hamming-Decoding based on Sphere-Decoding
rng(1)

clear;
Kc=3;           %Number of Parity bits
Nframes=1;      %Number of Frames
M=2;            %maximium bit error number M (Size of Sphere)
%M=1 means hard decision
%M=2 means soft decision with up to 2 bit errors
%M=3 means soft decision with up to 3 bit errors

ExtHammCode=0;  % 1 for extended Hamming-Code

%K_loop for more runs at higher SNR
SNRdB=[-4.5]; %0:1:7; 
K_loop=round((SNRdB-min(SNRdB)+3).^4.8);
K_loop = 1;

%% G: Generator Matrix, H: Paritycheck Matrix
G=bem_hammgen(Kc);

% Change Generator Matrix to extended Hamming Code
if ExtHammCode==1
    G=extHammG(G);
end

kc=size(G,1);               % Number of information bits
nc=size(G,2); Kc=nc-kc;     % Code word length

Rc=(kc)/(nc);               % Code rate Rc
EbN0=SNRdB-10*log10(Rc);    % Eb/N0

H = gen2par(G);             % generate H from G
HT=H.';                     % Transpose

%% Permutation of 1,2 and 3 bit errors
[e1, e2, e3]=permute_e(nc,M);
e=[e1;e2;e3];

%% syndrom calculation
syn=NaN(size(e,1),Kc);
for k=1:size(e,1)
    syn(k,:)=mod(e(k,:)*HT,2);
end

%% sort rows of syndroms associated error pattern e
[s_sort,s_idx] = sortrows(syn);     % sort syn to s_sort
e_sort=e(s_idx,:);                  % sort e to e_sort in the same way as syn

e_sort=e_sort(sum(s_sort,2)>0,:);   % delete zero rows
s_sort=s_sort(sum(s_sort,2)>0,:);   % delete zero rows

% s_de=bi2de(s_sort,[],'left-msb'); % Communication Toolbox function
s_de=bem_bi2de(s_sort);             % calculate decimal values from s_sort

s_pdf=hist(s_de,1:2^Kc-1);          % calculate which value occurs how often
%s_pdf(s_pdf==0)=[];

%% Loops for BER calculation
tic
sigma = sqrt(10.^(-SNRdB./10));         % standard diviation of noise
BER_dec_mean=zeros(1,length(SNRdB));    % mean of BER for coded system
BER_mean=zeros(1,length(SNRdB));        % mean of BER for uncoded system
for zzz=1:length(SNRdB)
    %disp(num2str(zzz))
    for kkk=1:K_loop(zzz)
        %% random bits
        x_msg=round(rand(Nframes,kc))
        
        %% channel coding
        x_code=mod(x_msg*G,2)
        
        %% Modulation and Noise
        x_mod = -(x_code-0.5)*2+1i*1E-99;
        noi=1/sqrt(2)*(randn(Nframes,nc)+1i*randn(Nframes,nc))*sigma(zzz);
        x_r=x_mod+noi;
        
        %% Demodulation
        x_llr = real(x_r)*4/sigma(zzz).^2  % Calculate Log-Likelihood Ratios
        x_code_r=(sign(-x_llr)+1)/2;        % Received bit stream
        
        %% BER uncoded
        bit_err=abs(x_code-x_code_r);
        BER=sum(bit_err(:))/(Nframes*nc);
        BER_mean(zzz)=BER_mean(zzz)+BER;
        
        %% Decoding
        [x_decode,x_llr_new] = hamm_soft_out(HT,e_sort,s_pdf,x_llr)
        %[x_decode] = hamm_soft_really_fast(HT,e_sort,s_sort,x_llr,Kc);
        
        %% BER coded
        dec_err=abs(x_code-x_decode);
        BER_dec=sum(dec_err(:))/(Nframes*nc);
        BER_dec_mean(zzz)=BER_dec_mean(zzz)+BER_dec;
    end
    BER_mean(zzz)=BER_mean(zzz)/K_loop(zzz);
    BER_dec_mean(zzz)=BER_dec_mean(zzz)/K_loop(zzz);
    
    disp(['Eb/N0=' num2str(EbN0(zzz)) ...
        '; BER_uncoded=' num2str(BER_mean(zzz)) ...
        '; BER_coded=' num2str(BER_dec_mean(zzz))]);
end
toc

DN='displayname';
Co='Color';
Ma='Marker';
if length(SNRdB)>1
    figure;
    %figure(99);hold off
    semilogy(SNRdB,BER_mean,Co,[0 0 0],Ma,'o',DN,'uncoded');
    hold on; grid on;
    semilogy(EbN0,BER_dec_mean,Co,[0 0 0],Ma,'.',...
        DN,[num2str(nc) ',' num2str(kc) '-Hamming code, ' 'M=' num2str(M)]);
    xlabel('E_b/N_0 in dB')
    xlim([0 9])
    ylabel('BER')
    legend show
end