%% AUTHORS: Mathieu Xhonneux (UCLouvain), Orion Afisiadis (EPFL)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function param_MC_MU(RunID)

if nargin < 1 || isempty(RunID)
    RunID = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Spreading factor
TxRx.sf = 7;

% Signal to Interference Ratio (SIR)
TxRx.Pi = -1.5; % in dB

% Oversampling factor
TxRx.os_factor = 16;

% Channel Coding
TxRx.CR = 3; % 0-4, Note that "0" will deactivate the whole channel encoding
TxRx.PPM = 4 + TxRx.CR; % Codeword length
TxRx.HammingCode.Rate = 4 / TxRx.PPM; % Code rate

% Packetlength (only payload). Should be an integer factor of PPM
TxRx.F = TxRx.PPM*10; % number of colliding symbols
TxRx.nr_codewords = TxRx.F * (TxRx.sf/TxRx.PPM);

% Reduced Rate or not
TxRx.reducedRate = 0; % only 0 is supported
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% == Interleaving pattern                                
TxRx.Interleave.Enable  = 1;  % 1: enable, 0: disable

% == Gray coding
TxRx.Gray.Enable = 1;         % 1: enable, 0: disable
TxRx.Gray.Reverse = 1;        % 1: reverse Gray, 0: normal Gray

% CFO value of the synchronized user (CFO sync. user)
TxRx.lambda = 0.00;          % in range [-0.5, 0.5], default: 0, user is synchronized
TxRx.fs    = 250e3;          % sampling freq of the transmitter
TxRx.cfo = TxRx.lambda*TxRx.fs/(2^TxRx.sf); 

% CFO value of the asynchronous user (CFO async. user)
TxRx.lambda_interf = 0.00; % in range [-0.5, 0.5], NaN : random value
TxRx.fs_interf = 250e3;          
TxRx.cfo_interf = TxRx.lambda_interf*TxRx.fs_interf/(2^TxRx.sf); 

% Phase offset
TxRx.phase_offset_interf = 1;   % 1: Random phase offset for async. user, 0: No phase offset
TxRx.phase_offset_user = 1;     % 1: Random phase offset for  sync. user, 0: No phase offset

% Relative intra-symbol timing offset between users
TxRx.timing_offset = 16.0*TxRx.os_factor; % -1 : random, else in the range [0 (os_factor*2^sf)-1]
TxRx.timing_error_est = 0;                % error on estimation of tau, in samples, default: 0

% Relative inter-symbol timing offset between users
TxRx.sym_delay = 0;                       % default: 0

% Simulation runs
TxRx.n_packets = 1000;  % number of packets per SNR level
TxRx.n_iterations = 2;  % number of iterations of sync. user

%%%%% Incompatibility checks
if rem(TxRx.F,TxRx.PPM) ~= 0
    error('Number of LoRa symbols in the frame should be an integer factor of PPM');
end
%%%%%

TxRx.maxErr = TxRx.n_packets;

% SNR range
TxRx.SNRs  = -14:1:-3;

% Results saving names
TxRx.optSimName = '';
TxRx.basename = sprintf('MC_SF%d_F%d_Pi%.2f_tau%.2f_CFOu%.2f_CFOi%.2f_CR%d_NI%d',TxRx.sf, TxRx.F, TxRx.Pi, TxRx.timing_offset / TxRx.os_factor, TxRx.lambda, TxRx.lambda_interf, TxRx.CR, TxRx.n_iterations);

% == Execute simulation ===============================

% Monte-Carlo
main_MC_MU(RunID,TxRx);
