function [ out ] = LoRa_interleaver_Or(in,TxRx)
%INTERLEAVER Summary of this function goes here
%   I change the way the k gets values in the for loop, where k
%   corresponds to the blocks (k = 0 for he first block, k - 1 for the second block etc)

if (~TxRx.Interleave.Enable)             % bypass interleaving function
    out = in;
    return
end

PPM = TxRx.PPM;

% Choose sf-2 in reduced mode 
if TxRx.reducedRate == 1
    sf = TxRx.sf - 2;
else
    sf = TxRx.sf;
end

nr_codewords = TxRx.nr_codewords;

U = zeros(PPM,sf);
%from diagonals to lines
for k=0:nr_codewords/sf - 1 % for each block
    T=in(1+k*sf:(k+1)*sf,:);
    for i=0:PPM-1
        for j=0:sf-1            
            U(i+1,j+1)=T(mod(i-(j+1),sf)+1,1+i);
        end
    end
    out(1+k*PPM:(k+1)*PPM,:)=U;
end

% In reduced Rate add the two dummy columns
if TxRx.reducedRate == 1
    out = [out zeros(length(out),2)];
end

end

