function [out] = LoRa_deinterleaver_Or(in,TxRx)

if (~TxRx.Interleave.Enable)             % bypass deinterleaving function
    out = in;
    return
end

% In reduced mode choose sf-2 and delete the last two columns
if TxRx.reducedRate == 1
    sf = TxRx.sf - 2;
    in = in(:,1:sf);
else
    sf = TxRx.sf;
end

PPM = TxRx.PPM;
nr_codewords = TxRx.nr_codewords;

U = zeros(sf,PPM);
%from diagonals to lines
for k=0:nr_codewords/sf - 1    %for each block   DOUBLE-CHECK!!!
    T=in(1+k*PPM:(k+1)*PPM,:);
    for i=0:PPM-1
        for j=0:sf-1            
            U(mod(i-(j+1),sf)+1,1+i)=T(i+1,j+1);
        end
    end
    out(1+k*sf:(k+1)*sf,:)=U;
end

end

