function gray = nongray2gray(bin, TxRx)

% Description: This function converts a nongray number to its equivalent gray code representation.
%
% Call Syntax: [output_variables] = function_name(input_variables)
%
% Input Arguments:
%	Name: bin
%	Type: matrix
%	Description: each row is a real positive number

% Output Arguments:
%	Name: gray
%	Type: matrix
%	Description: gray coded of input matrix (each row is a number)
%
% Creation Date: 9/17/2005
% Author : Arjun Srinivasan Rangamani

% 12.09.17  Orion&Reza   Modified (enable/disable mode supported)
%*************************************************************************
if (~TxRx.Gray.Enable)
   gray = bin;
   return
end

% % shift all the gray mapping by -1 according to RFM-95
% dec = double2dec(bin);
% dec = mod(dec-1, 2^TxRx.sf);
% bin = double(dec2bin(dec)=='1');

len = size(bin,2);
gray = zeros(size(bin));


for row = 1:size(bin,1)
    temp = bin(row,:);
    
    if len > 1
        
       for col  = len:-1:2            
            if (temp(col-1)) == 1
                gray(row,col) = 1 - (temp(col));
            else
                gray(row,col) = (temp(col));
            end            
            gray(row,1) = (temp(1));
        end
        
    else       
        gray(row,len) = (temp);        
    end
    
end