function [dec, bin] = gray2nongray(gray, TxRx)

% Description: This function converts a gray coded string to its equivalent non-gray decimal/binary representation.
%
% Input Arguments:
%	Name: gray
%	Description: gray: each row represents a gray coded bit stream


% Output Arguments:
%	Name: dec, bin
%	Description: dec: vector containing decimal representation of nongray input matrix
%                bin: matrix containing binary representation of nongray input matrix
%
% Creation Date: 08/07/2005
% Author : Arjun Srinivasan Rangamani

% 12.09.17  Orion&Reza   Modified (bin/dec output supported)
%*************************************************************************
if (~TxRx.Gray.Enable)
   bin = gray;
   dec = bin2dec(num2str(gray));
   return
end

s1 = size(gray,1);  %num of rows in input vector
s2 = size(gray,2);  %num of columns in the input vector
dec = zeros(s1,1);  %size of the o/p decimal number sequence
bintmp = (zeros(1,s2));
bin = (zeros(s1,s2));


%gray to binary conversion
for j1 = 1:1:s1 
    for j2 = s2:-1:2
        temp = mod(sum(gray(j1,1:j2-1)),2);
        if temp == 1
            bintmp(j2) = (1 - gray(j1,j2));
        else
            bintmp(j2) = (gray(j1,j2));
        end
    end    
    bintmp(1) = (gray(j1,1));
    
    bin(j1,:) = bintmp;
%     dec(j1,1) = bin2dec(num2str(bintmp));
end
dec = double2dec(bin);

% % shift all the nongray results by 1 according to RFM-95
% dec = mod(dec+1, 2^TxRx.sf);
% bin = double(dec2bin(dec)=='1');

