% Adding the carrier frequency offset (baseband equivalent)

function [y_cfo] = add_cfo_packet(TxRx, y, cfo)
if ( cfo == 0)
    y_cfo = y;
else
    ylen = numel(y);
    n     = 0:ylen-1;
    t     = n./(TxRx.fs*TxRx.os_factor);
    cfo_term     = exp(1j*2*pi*cfo*t.');  % This is the exponential term containing the offset
    y_vec = y(:);
    % Multiply with the cfo term
    y_cfo = y_vec.*cfo_term;
    % Reshape to matrix
    %[length(y_cfo) 2^TxRx.sf*TxRx.os_factor*TxRx.F]
    y_cfo = reshape(y_cfo, [2^TxRx.sf*TxRx.os_factor, TxRx.F+2]);   % Reshape
    
end