function [c] = Hamming_enc_Or(data, TxRx, G)
% Hamming_enc is a Hamming encoder
% Input is a X*4 matrix corresponding to the info bits
% Output is an X*8 matrix.

% Generator Matrix
      
if (TxRx.HammingCode.Rate==1)
    c = data;
elseif (TxRx.HammingCode.Rate==4/8 || TxRx.HammingCode.Rate==4/7|| TxRx.HammingCode.Rate==4/6 || TxRx.HammingCode.Rate==4/5)
    c = mod(data*G, 2);
else
    error('code rate not supported');
end

