function [c_hat] = Hamming_dec_Or(r, TxRx,H)
% Hamming decoder
% Input is an 8*X matrix
% Output is a 4*X matrix corresponding to the corrected data (MSB left)
 
 if (TxRx.HammingCode.Rate==1 || TxRx.HammingCode.Rate==4/5 || TxRx.HammingCode.Rate==4/6)
     c_hat = r;
     return
 elseif (TxRx.HammingCode.Rate==4/7 || TxRx.HammingCode.Rate==4/8)
     s = mod(H(1:TxRx.CR,1:TxRx.PPM)*r', 2)';   % syndrome vector, LSB left
 else
    error('coding rate not supported');
 end


H_temp = repmat(H(1:TxRx.CR,1:TxRx.PPM),[1 1 TxRx.nr_codewords]);  % H is repeated TxRx.nr_codewords times so that it can be "checked" by all syndromes
s_temp = reshape(s',TxRx.CR,1,TxRx.nr_codewords);                  % Reshape needed for bsxfun

pos_matrix = squeeze(~any(bsxfun(@xor, H_temp, s_temp)));    % Check if each one of the syndromes corresponds to a column of H. If yes, then this position is marked as "1" in pos_matrix
r_temp = r';                                                 % Transpose r so that each column corresponds to a received codeword.

if (TxRx.HammingCode.Rate==4/8)
    % Do not try to correct the codewords with an even parity check!
    flip = mod(sum(r,2),2);    
    pos_matrix(:,flip==0) = 0;
end

r_temp(pos_matrix == 1) = ~r_temp(pos_matrix == 1);          % Correct the bit position of only the words that were detected as wrong AND correctable (the syndrome was not all-zero AND corresponded to a column of H)
r = r_temp';                                                 % Corrected messages
    
% The whole estimated codeword
c_hat = r;