#include <stdlib.h>
#include "malloc.h"

typedef struct
{
	char *start;
	char *end;
	char *ptr;
} HEAP;

extern char _sram_start[];
extern char _sram_end[];
extern char _edram_start[];
extern char _edram_end[];

static HEAP sram_heap = {(char *) &_sram_start, (char *) &_sram_end, NULL};
static HEAP edram_heap = {(char *) &_edram_start, (char *) &_edram_end, NULL};

static void *heap_malloc(HEAP *heap, unsigned int s)
{
	char *base;

	if (!heap->ptr)
		heap->ptr = heap->start;

	base = heap->ptr;
	heap->ptr += s;

	if (heap->ptr <= heap->end + 1)
		return base;
	else
		return NULL;
}

static unsigned int heap_get_size(HEAP *heap)
{
	return heap->ptr ? (heap->ptr - heap->start) : 0;
}

static void heap_reset(HEAP *heap)
{
	heap->ptr = NULL;
}

void *malloc_sram(unsigned int s)
{
	return heap_malloc(&sram_heap, s);
}

void *malloc_edram(unsigned int s)
{
	return heap_malloc(&edram_heap, s);
}

void malloc_reset()
{
	heap_reset(&sram_heap);
	heap_reset(&edram_heap);
}

unsigned int malloc_get_sram_size()
{
	return heap_get_size(&sram_heap);
}

unsigned int malloc_get_edram_size()
{
	return heap_get_size(&edram_heap);
}
