#pragma once
#include "xil_io.h"
#include "xparameters.h"

#define MEM_BASE XPAR_EDRAM_0_SLMB_BASEADDR
#define REG_BASE (XPAR_EDRAM_0_SPLB_BASEADDR + 0x00000)
#define PRAM_BASE (XPAR_EDRAM_0_SPLB_BASEADDR + 0x10000)
#define EVRAM_BASE (XPAR_EDRAM_0_SPLB_BASEADDR + 0x20000)

#define SET_CTRL(value) Xil_Out32(REG_BASE, value)

#define CTRL_RST (1 << 0)
#define CTRL_TEN (1 << 1)
#define CTRL_SEN (1 << 2)
#define CTRL_GEN (1 << 3)
#define CTRL_RFDIST (1 << 4)

#define GET_RFINT(value) Xil_In32(REG_BASE + 4)
#define SET_RFINT(value) Xil_Out32(REG_BASE + 4, value)

#define SET_RFSKIP(value) Xil_Out32(REG_BASE + 8, value)
#define SET_MODSEL(value) Xil_Out32(REG_BASE + 36, value)

#define GET_SIMTS() Xil_In32(REG_BASE + 12)
#define GET_READ_COUNTER() Xil_In32(REG_BASE + 16)
#define GET_WRITE_COUNTER() Xil_In32(REG_BASE + 20)
#define GET_REFRESH_COUNTER() Xil_In32(REG_BASE + 24)
#define GET_FLIP_COUNTER() Xil_In32(REG_BASE + 28)
#define GET_STALL_COUNTER() Xil_In32(REG_BASE + 32)

#define PRAM_SET(row, ptr, n) Xil_Out32(PRAM_BASE + (row)*4, ((ptr) << XPAR_EDRAM_0_NEVENTS_LOG) | (n))
#define EVRAM_SET(row, tdiff, act, bit) Xil_Out32(EVRAM_BASE + (row)*4, ((((tdiff) << XPAR_EDRAM_0_ACTSIZE) | (act)) << XPAR_EDRAM_0_WORDSIZE_LOG) | (bit))

#define ACTION_NONE 0
#define ACTION_DRT  1
#define ACTION_DRT0 2
#define ACTION_DRT1 3

#define EDRAM_RESET() SET_CTRL(CTRL_RST);
#define EDRAM_START() SET_CTRL(CTRL_TEN | CTRL_GEN | CTRL_RFDIST)
#define EDRAM_STOP() SET_CTRL(0)
