
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/edram_v1_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  ipgui::add_param $IPINST -name "ACTSIZE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "ARRAYS_LOG" -parent ${Page_0}
  ipgui::add_param $IPINST -name "DEBUG" -parent ${Page_0}
  ipgui::add_param $IPINST -name "EVRAM_INITFILE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "MEMARRAY_MODEL" -parent ${Page_0} -widget comboBox
  ipgui::add_param $IPINST -name "MOD_MODEL" -parent ${Page_0} -widget comboBox
  ipgui::add_param $IPINST -name "NEVENTS_LOG" -parent ${Page_0}
  ipgui::add_param $IPINST -name "PRAM_INITFILE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "READWRITE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "ROWS_LOG" -parent ${Page_0}
  ipgui::add_param $IPINST -name "SKIPSIZE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TDIFFSIZE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "TIMERSIZE" -parent ${Page_0}
  ipgui::add_param $IPINST -name "WORDSIZE_LOG" -parent ${Page_0}


}

proc update_PARAM_VALUE.C_CAXI_DWIDTH { PARAM_VALUE.C_CAXI_DWIDTH PARAM_VALUE.C_CAXI_DWIDTH_LOG } {
	# Procedure called to update C_CAXI_DWIDTH when any of the dependent parameters in the arguments change
	
	set C_CAXI_DWIDTH ${PARAM_VALUE.C_CAXI_DWIDTH}
	set C_CAXI_DWIDTH_LOG ${PARAM_VALUE.C_CAXI_DWIDTH_LOG}
	set values(C_CAXI_DWIDTH_LOG) [get_property value $C_CAXI_DWIDTH_LOG]
	set_property value [gen_USERPARAMETER_C_CAXI_DWIDTH_VALUE $values(C_CAXI_DWIDTH_LOG)] $C_CAXI_DWIDTH
}

proc validate_PARAM_VALUE.C_CAXI_DWIDTH { PARAM_VALUE.C_CAXI_DWIDTH } {
	# Procedure called to validate C_CAXI_DWIDTH
	return true
}

proc update_PARAM_VALUE.C_MAXI_AWIDTH { PARAM_VALUE.C_MAXI_AWIDTH PARAM_VALUE.ARRAYS_LOG PARAM_VALUE.ROWS_LOG PARAM_VALUE.WORDSIZE_LOG } {
	# Procedure called to update C_MAXI_AWIDTH when any of the dependent parameters in the arguments change
	
	set C_MAXI_AWIDTH ${PARAM_VALUE.C_MAXI_AWIDTH}
	set ARRAYS_LOG ${PARAM_VALUE.ARRAYS_LOG}
	set ROWS_LOG ${PARAM_VALUE.ROWS_LOG}
	set WORDSIZE_LOG ${PARAM_VALUE.WORDSIZE_LOG}
	set values(ARRAYS_LOG) [get_property value $ARRAYS_LOG]
	set values(ROWS_LOG) [get_property value $ROWS_LOG]
	set values(WORDSIZE_LOG) [get_property value $WORDSIZE_LOG]
	set_property value [gen_USERPARAMETER_C_MAXI_AWIDTH_VALUE $values(ARRAYS_LOG) $values(ROWS_LOG) $values(WORDSIZE_LOG)] $C_MAXI_AWIDTH
}

proc validate_PARAM_VALUE.C_MAXI_AWIDTH { PARAM_VALUE.C_MAXI_AWIDTH } {
	# Procedure called to validate C_MAXI_AWIDTH
	return true
}

proc update_PARAM_VALUE.C_MAXI_DWIDTH { PARAM_VALUE.C_MAXI_DWIDTH PARAM_VALUE.C_MAXI_DWIDTH_LOG } {
	# Procedure called to update C_MAXI_DWIDTH when any of the dependent parameters in the arguments change
	
	set C_MAXI_DWIDTH ${PARAM_VALUE.C_MAXI_DWIDTH}
	set C_MAXI_DWIDTH_LOG ${PARAM_VALUE.C_MAXI_DWIDTH_LOG}
	set values(C_MAXI_DWIDTH_LOG) [get_property value $C_MAXI_DWIDTH_LOG]
	set_property value [gen_USERPARAMETER_C_MAXI_DWIDTH_VALUE $values(C_MAXI_DWIDTH_LOG)] $C_MAXI_DWIDTH
}

proc validate_PARAM_VALUE.C_MAXI_DWIDTH { PARAM_VALUE.C_MAXI_DWIDTH } {
	# Procedure called to validate C_MAXI_DWIDTH
	return true
}


proc update_MODELPARAM_VALUE.C_MAXI_AWIDTH { MODELPARAM_VALUE.C_MAXI_AWIDTH PARAM_VALUE.C_MAXI_AWIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_MAXI_AWIDTH}] ${MODELPARAM_VALUE.C_MAXI_AWIDTH}
}

proc update_MODELPARAM_VALUE.C_MAXI_DWIDTH { MODELPARAM_VALUE.C_MAXI_DWIDTH PARAM_VALUE.C_MAXI_DWIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_MAXI_DWIDTH}] ${MODELPARAM_VALUE.C_MAXI_DWIDTH}
}

proc update_MODELPARAM_VALUE.C_MAXI_DWIDTH_LOG { MODELPARAM_VALUE.C_MAXI_DWIDTH_LOG PARAM_VALUE.C_MAXI_DWIDTH_LOG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_MAXI_DWIDTH_LOG}] ${MODELPARAM_VALUE.C_MAXI_DWIDTH_LOG}
}

proc update_MODELPARAM_VALUE.C_CAXI_AWIDTH { MODELPARAM_VALUE.C_CAXI_AWIDTH PARAM_VALUE.C_CAXI_AWIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_CAXI_AWIDTH}] ${MODELPARAM_VALUE.C_CAXI_AWIDTH}
}

proc update_MODELPARAM_VALUE.C_CAXI_DWIDTH { MODELPARAM_VALUE.C_CAXI_DWIDTH PARAM_VALUE.C_CAXI_DWIDTH } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_CAXI_DWIDTH}] ${MODELPARAM_VALUE.C_CAXI_DWIDTH}
}

proc update_MODELPARAM_VALUE.C_CAXI_DWIDTH_LOG { MODELPARAM_VALUE.C_CAXI_DWIDTH_LOG PARAM_VALUE.C_CAXI_DWIDTH_LOG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.C_CAXI_DWIDTH_LOG}] ${MODELPARAM_VALUE.C_CAXI_DWIDTH_LOG}
}

proc update_MODELPARAM_VALUE.WORDSIZE_LOG { MODELPARAM_VALUE.WORDSIZE_LOG PARAM_VALUE.WORDSIZE_LOG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.WORDSIZE_LOG}] ${MODELPARAM_VALUE.WORDSIZE_LOG}
}

proc update_MODELPARAM_VALUE.ARRAYS_LOG { MODELPARAM_VALUE.ARRAYS_LOG PARAM_VALUE.ARRAYS_LOG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.ARRAYS_LOG}] ${MODELPARAM_VALUE.ARRAYS_LOG}
}

proc update_MODELPARAM_VALUE.ROWS_LOG { MODELPARAM_VALUE.ROWS_LOG PARAM_VALUE.ROWS_LOG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.ROWS_LOG}] ${MODELPARAM_VALUE.ROWS_LOG}
}

proc update_MODELPARAM_VALUE.TIMERSIZE { MODELPARAM_VALUE.TIMERSIZE PARAM_VALUE.TIMERSIZE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TIMERSIZE}] ${MODELPARAM_VALUE.TIMERSIZE}
}

proc update_MODELPARAM_VALUE.TDIFFSIZE { MODELPARAM_VALUE.TDIFFSIZE PARAM_VALUE.TDIFFSIZE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.TDIFFSIZE}] ${MODELPARAM_VALUE.TDIFFSIZE}
}

proc update_MODELPARAM_VALUE.ACTSIZE { MODELPARAM_VALUE.ACTSIZE PARAM_VALUE.ACTSIZE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.ACTSIZE}] ${MODELPARAM_VALUE.ACTSIZE}
}

proc update_MODELPARAM_VALUE.SKIPSIZE { MODELPARAM_VALUE.SKIPSIZE PARAM_VALUE.SKIPSIZE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SKIPSIZE}] ${MODELPARAM_VALUE.SKIPSIZE}
}

proc update_MODELPARAM_VALUE.READWRITE { MODELPARAM_VALUE.READWRITE PARAM_VALUE.READWRITE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.READWRITE}] ${MODELPARAM_VALUE.READWRITE}
}

proc update_MODELPARAM_VALUE.MEMARRAY_MODEL { MODELPARAM_VALUE.MEMARRAY_MODEL PARAM_VALUE.MEMARRAY_MODEL } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.MEMARRAY_MODEL}] ${MODELPARAM_VALUE.MEMARRAY_MODEL}
}

proc update_MODELPARAM_VALUE.MOD_MODEL { MODELPARAM_VALUE.MOD_MODEL PARAM_VALUE.MOD_MODEL } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.MOD_MODEL}] ${MODELPARAM_VALUE.MOD_MODEL}
}

proc update_MODELPARAM_VALUE.NEVENTS_LOG { MODELPARAM_VALUE.NEVENTS_LOG PARAM_VALUE.NEVENTS_LOG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.NEVENTS_LOG}] ${MODELPARAM_VALUE.NEVENTS_LOG}
}

proc update_MODELPARAM_VALUE.PRAM_INITFILE { MODELPARAM_VALUE.PRAM_INITFILE PARAM_VALUE.PRAM_INITFILE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.PRAM_INITFILE}] ${MODELPARAM_VALUE.PRAM_INITFILE}
}

proc update_MODELPARAM_VALUE.EVRAM_INITFILE { MODELPARAM_VALUE.EVRAM_INITFILE PARAM_VALUE.EVRAM_INITFILE } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.EVRAM_INITFILE}] ${MODELPARAM_VALUE.EVRAM_INITFILE}
}

proc update_MODELPARAM_VALUE.DEBUG { MODELPARAM_VALUE.DEBUG PARAM_VALUE.DEBUG } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.DEBUG}] ${MODELPARAM_VALUE.DEBUG}
}

