library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity timer is
    generic(
        TIMERSIZE : natural
    );
    port(
        clk : in  std_logic;
        rst : in  std_logic;
        en  : in  std_logic;
        ts  : out std_logic_vector(TIMERSIZE - 1 downto 0)
    );
end entity timer;

architecture rtl of timer is
    signal timer : unsigned(TIMERSIZE - 1 downto 0);
begin
    process(clk, rst) is
    begin
        if rst = '1' then
            timer <= (others => '0');
        elsif rising_edge(clk) then
            if en = '1' then
                timer <= timer + 1;
            end if;
        end if;
    end process;

    ts <= std_logic_vector(timer);
end architecture rtl;
