library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_textio.all;
use std.textio.all;

entity mod_simple is
    generic(
        WORDSIZE_LOG : natural;
        ROWS_LOG     : natural;
        TDIFFSIZE    : natural;
        DEBUG        : boolean := false
    );
    port(
        clk      : in  std_logic;
        rst      : in  std_logic;

        -- Modifier port
        en       : in  std_logic;
        addr     : in  std_logic_vector(ROWS_LOG - 1 downto 0);
        tdiff    : in  std_logic_vector(TDIFFSIZE - 1 downto 0);
        data_in  : in  std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        data_out : out std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        ack      : out std_logic;
        ready    : out std_logic
    );
end entity mod_simple;

architecture rtl of mod_simple is
begin
    process(clk, rst) is
        variable debug_buf : line;
    begin
        if rst = '1' then
            data_out <= (others => 'X');
            ack      <= '0';
        elsif rising_edge(clk) then
            data_out <= (others => 'X');
            ack      <= '0';

            if en = '1' then
                if DEBUG then
                    write(debug_buf, string'("[MOD ] modify 0x"));
                    hwrite(debug_buf, data_in);
                    write(debug_buf, string'(" addr=0x"));
                    hwrite(debug_buf, addr);
                    write(debug_buf, string'(" tdiff="));
                    write(debug_buf, to_integer(unsigned(tdiff)));
                    writeline(output, debug_buf);
                end if;

                data_out <= data_in;
                ack      <= '1';
            end if;
        end if;
    end process;

    ready <= '1';

end architecture rtl;
