library ieee;
use ieee.std_logic_1164.all;

entity memstall is
    generic(
        WORDSIZE_LOG : natural;
        ROWS_LOG     : natural
    );
    port(
        -- Slave port
        s_raddr : in  std_logic_vector(ROWS_LOG - 1 downto 0);
        s_ren   : in  std_logic;
        s_rdata : out std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        s_rack  : out std_logic;
        s_waddr : in  std_logic_vector(ROWS_LOG - 1 downto 0);
        s_wen   : in  std_logic;
        s_wdata : in  std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        s_wack  : out std_logic;

        -- Master port
        m_raddr : out std_logic_vector(ROWS_LOG - 1 downto 0);
        m_ren   : out std_logic;
        m_rdata : in  std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        m_rack  : in  std_logic;
        m_waddr : out std_logic_vector(ROWS_LOG - 1 downto 0);
        m_wen   : out std_logic;
        m_wdata : out std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        m_wack  : in  std_logic;

        -- Control input port
        en      :     std_logic
    );
end entity memstall;

architecture rtl of memstall is
begin
    m_ren   <= s_ren and en;
    m_wen   <= s_wen and en;
    m_raddr <= s_raddr when en = '1' else (others => 'X');
    m_waddr <= s_waddr when en = '1' else (others => 'X');
    m_wdata <= s_wdata when en = '1' else (others => 'X');

    s_rack  <= m_rack;
    s_wack  <= m_wack;
    s_rdata <= m_rdata;
end architecture rtl;
