library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use std.textio.all;

entity memarray_bram is
    generic(
        WORDSIZE_LOG : natural;
        ROWS_LOG     : natural;
        DEBUG        : boolean := false
    );
    port(
        clk   : in  std_logic;
        rst   : in  std_logic;

        -- Slave port
        raddr : in  std_logic_vector(ROWS_LOG - 1 downto 0);
        ren   : in  std_logic;
        rdata : out std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        rack  : out std_logic;
        waddr : in  std_logic_vector(ROWS_LOG - 1 downto 0);
        wen   : in  std_logic;
        wdata : in  std_logic_vector(2 ** WORDSIZE_LOG - 1 downto 0);
        wack  : out std_logic;
        ready : out std_logic
    );
end entity memarray_bram;

architecture rtl of memarray_bram is
    constant WORDSIZE : natural := 2 ** WORDSIZE_LOG;
begin
    BRAM : entity work.bram
        generic map(
            DWIDTH   => WORDSIZE,
            AWIDTH   => ROWS_LOG,
            INITFILE => ""
        )
        port map(
            clk   => clk,
            rst   => rst,
            raddr => raddr,
            ren   => ren,
            rdata => rdata,
            waddr => waddr,
            wen   => wen,
            wdata => wdata
        );

    process(clk, rst) is
        variable debug_buf : line;
    begin
        if rst = '1' then
            rack <= '0';
            wack <= '0';
        elsif rising_edge(clk) then
            if DEBUG and ren = '1' and not is_X(raddr) then
                write(debug_buf, string'("[MARR] read word "));
                write(debug_buf, to_integer(unsigned(raddr)));
                writeline(output, debug_buf);
            end if;
            if DEBUG and wen = '1' and not is_X(waddr) then
                write(debug_buf, string'("[MARR] write word "));
                write(debug_buf, to_integer(unsigned(waddr)));
                writeline(output, debug_buf);
            end if;

            rack <= ren;
            wack <= wen;
        end if;
    end process;

    ready <= '1';

end architecture rtl;
