library ieee;
use ieee.std_logic_1164.all;

entity mem_slave_simple is
    generic(
        AWIDTH     : natural;
        DWIDTH_LOG : natural;

        MEM_AWIDTH : natural;
        MEM_DWIDTH : natural
    );
    port(
        clk     : in  std_logic;
        rst     : in  std_logic;

        -- input port
        en      : in  std_logic;
        rnw     : in  std_logic;
        addr    : in  std_logic_vector(AWIDTH - 1 downto 0);
        wdata   : in  std_logic_vector(2 ** DWIDTH_LOG - 1 downto 0);
        be      : in  std_logic_vector(2 ** DWIDTH_LOG / 8 - 1 downto 0);
        rdata   : out std_logic_vector(2 ** DWIDTH_LOG - 1 downto 0);
        ack     : out std_logic;

        -- Master port
        m_raddr : out std_logic_vector(MEM_AWIDTH - 1 downto 0);
        m_ren   : out std_logic;
        m_rdata : in  std_logic_vector(MEM_DWIDTH - 1 downto 0);
        m_waddr : out std_logic_vector(MEM_AWIDTH - 1 downto 0);
        m_wen   : out std_logic;
        m_wdata : out std_logic_vector(MEM_DWIDTH - 1 downto 0)
    );
end mem_slave_simple;

architecture imp of mem_slave_simple is
    signal en_int, ack_int : std_logic;
    signal mem_row         : std_logic_vector(MEM_AWIDTH - 1 downto 0);
begin
    en_int <= en and not ack_int;

    process(clk, rst) is
    begin
        if rst = '1' then
            ack_int <= '0';
        elsif rising_edge(clk) then
            ack_int <= en_int;
            if rnw = '0' then
                assert be = (be'range => '1') report "Byte enable signal not supported" severity error;
            end if;
        end if;
    end process;

    mem_row <= addr(MEM_AWIDTH + DWIDTH_LOG - 3 - 1 downto DWIDTH_LOG - 3);
    m_raddr <= mem_row;
    m_waddr <= mem_row;

    m_wdata <= wdata(m_wdata'range);

    m_ren <= en_int and rnw;
    m_wen <= en_int and not rnw;

    ack <= ack_int;

    process(m_rdata) is
    begin
        rdata                <= (others => '0');
        rdata(m_rdata'range) <= m_rdata;
    end process;

end architecture imp;
