library ieee;
use ieee.std_logic_1164.all;

entity mem_crossing is
    generic(
        C_IPIC_AWIDTH : integer;
        C_IPIC_DWIDTH : integer
    );
    port(
        clk      : in  std_logic;
        rst      : in  std_logic;

        s_clk_en : in  std_logic;

        -- Slave port
        s_en     : in  std_logic;
        s_rnw    : in  std_logic;
        s_addr   : in  std_logic_vector(C_IPIC_AWIDTH - 1 downto 0);
        s_wdata  : in  std_logic_vector(C_IPIC_DWIDTH - 1 downto 0);
        s_be     : in  std_logic_vector(C_IPIC_DWIDTH / 8 - 1 downto 0);
        s_rdata  : out std_logic_vector(C_IPIC_DWIDTH - 1 downto 0);
        s_ack    : out std_logic;

        -- Master port
        m_en     : out std_logic;
        m_rnw    : out std_logic;
        m_addr   : out std_logic_vector(C_IPIC_AWIDTH - 1 downto 0);
        m_wdata  : out std_logic_vector(C_IPIC_DWIDTH - 1 downto 0);
        m_be     : out std_logic_vector(C_IPIC_DWIDTH / 8 - 1 downto 0);
        m_rdata  : in  std_logic_vector(C_IPIC_DWIDTH - 1 downto 0);
        m_ack    : in  std_logic
    );
end entity mem_crossing;

architecture rtl of mem_crossing is
    signal ack_reg, ack_next     : std_logic;
    signal rdata_reg, rdata_next : std_logic_vector(C_IPIC_DWIDTH - 1 downto 0);
begin
    process(clk, rst) is
    begin
        if rst = '1' then
            ack_reg   <= '0';
            rdata_reg <= (others => 'X');
        elsif rising_edge(clk) then
            ack_reg   <= ack_next;
            rdata_reg <= rdata_next;
        end if;
    end process;

    process(ack_reg, rdata_reg, s_clk_en, s_en, s_rnw, s_addr, s_wdata, s_be, m_ack, m_rdata) is
    begin
        ack_next   <= ack_reg;
        rdata_next <= rdata_reg;

        m_en    <= s_en;
        m_rnw   <= s_rnw;
        m_addr  <= s_addr;
        m_wdata <= s_wdata;
        m_be    <= s_be;
        s_ack   <= ack_reg;
        s_rdata <= rdata_reg;

        if m_ack = '1' then
            s_ack      <= m_ack;
            ack_next   <= m_ack;
            s_rdata    <= m_rdata;
            rdata_next <= m_rdata;
        end if;

        if s_clk_en = '1' then
            ack_next   <= '0';
            rdata_next <= (others => 'X');
        elsif ack_reg = '1' or m_ack = '1' then
            m_en    <= '0';
            m_rnw   <= 'X';
            m_addr  <= (others => 'X');
            m_wdata <= (others => 'X');
            m_be    <= (others => 'X');
        end if;
    end process;

end architecture rtl;
