library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_textio.all;
use std.textio.all;

entity bram is
    generic(
        DWIDTH   : natural;
        AWIDTH   : natural;
        INITFILE : string := ""
    );
    port(
        clk   : in  std_logic;
        rst   : in  std_logic;
        raddr : in  std_logic_vector(AWIDTH - 1 downto 0);
        ren   : in  std_logic;
        rdata : out std_logic_vector(DWIDTH - 1 downto 0);
        waddr : in  std_logic_vector(AWIDTH - 1 downto 0);
        wen   : in  std_logic;
        wdata : in  std_logic_vector(DWIDTH - 1 downto 0)
    );
end entity bram;

architecture imp of bram is
    type ram_type is array (0 to 2**AWIDTH - 1) of std_logic_vector(DWIDTH - 1 downto 0);

    impure function fromFile(fn : in string) return ram_type is
        file f        : text open read_mode is fn;
        variable l    : line;
        variable data : ram_type;
    begin
        for i in data'range loop
            readline(f, l);
            read(l, data(i));
        end loop;
        return data;
    end function;

    impure function fromFileOpt(fn : in string) return ram_type is
    begin
        if fn /= "" and fn /= "null" then
            return fromFile(fn);
        else
            return (ram_type'range => (DWIDTH - 1 downto 0 => 'X'));
        end if;
    end function;

    signal ram : ram_type := fromFileOpt(INITFILE);
begin
    process(clk)
    begin
        if rising_edge(clk) then
            rdata <= (others => 'X');
            if rst = '0' then
                if ren = '1' then
                    rdata <= ram(to_integer(unsigned(raddr)));
                end if;
                if wen = '1' then
                    ram(to_integer(unsigned(waddr))) <= wdata;
                end if;
            end if;
        end if;
    end process;
end architecture imp;
