# Vivado Project Description

This describes the Vivado project available in _hw_.

## Block Design

The MicroBlaze system is found in the block design _base_mb_. It follows the
standard MicroBlaze example project, but with a few changes.

The blocks can be configured by right-click -> _Customize_.

The memory utilization on the FPGA is currently above 90%, so the SRAM / eDRAM
cannot be increased.

### Clocking Wizard
* Clock Frequency: 40 MHz.

### MicroBlaze
* All floating point extensions were enabled

### SRAM
* Size: 512KB

### UART
* Baud rate: 115200

### eDRAM
* This block was added and connected to the AXI bus
* Its generics can be configured in the _Customize_ GUI.
* Size: 1MB.

### Clock Gating
* Most blocks in the system are clock gated, except MDM, UART, eDRAM.
* The gated clock originates from the eDRAM block.

## Steps after Configuration Changes
* Re-synthesize the design and re-create the bitstream
* Export the hardware definition for the BSP using _File -> Export -> Hardware_.

## Board support package (BSP)
To use the peripherals from software, a board support package (BSP) is needed.
It can be found in _sw/bsp_. First, the hardware definitions have
to be exported from Vivado (this is
done automatically in the _create_project.tcl_ script. The BSP can then be built
by running `make` inside _sw/bsp_ (This is called automatically from
all other Makefiles).

The BSP can be configured by editing _sw/bsp/system.mss_. It has
then to be rebuilt by running `make veryclean` and `make`.

### Stdout
By default, printf prints to the seperate UART port. If you want to print to the
MDM console instead, you will see the output directly when running `make run`
inside a project directory (Warning: Slow and buffered!). To enable this, change
`stdout` parameter in `system.mss` from `axi_uartlite_0` to `mdm_1`.
