library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_misc.all;
library work;
use work.polar_config.all;
--use work.helper_functions.all;

entity bubbleSorter is
port(
	DataInxDI			: in Metric_2L;
	InvalsxDI			: in std_logic_vector(0 to 2*L-1);
	MinxDO 				: out Metric_L;
	outvalFxDO		: out std_logic_vector(0 to L-1);
	IndxDO				: out Sel_L
);
end;

architecture arch of bubbleSorter is

	signal allMetricsxD				: MetricStage_2L;
	signal allIndicesxD				: IndexStage_2L;
	signal allOutvalsxD				: OutvalStage_2L;

begin

	-- Perform bitonic sort
	bitonicSort_memless: process(DataInxDI,allMetricsxD,allIndicesxD,allOutvalsxD)
	begin

		-- Assign input to stage 0
		for ii in 0 to 2*L-1 loop
			allMetricsxD(0)(ii) <= DataInxDI(ii);
		end loop;

		for ii in 0 to L-1 loop
			allIndicesxD(0)(2*ii) <= ii;
			allIndicesxD(0)(2*ii+1) <= ii;
			allOutvalsxD(0)(2*ii) <= InvalsxDI(2*ii);
			allOutvalsxD(0)(2*ii+1) <= InvalsxDI(2*ii+1);
		end loop;

		for ii in 0 to SorterStages-1 loop
			-- Default assignment
			for jj in 0 to 2*L-1 loop
				allMetricsxD(ii+1)(jj) <= allMetricsxD(ii)(jj);
				allIndicesxD(ii+1)(jj) <= allIndicesxD(ii)(jj);
				allOutvalsxD(ii+1)(jj) <= allOutvalsxD(ii)(jj);
			end loop;
			-- Conditional assignments
			for jj in ii/2 to L-1 loop
				if( ii mod 2 = 1 ) then
					if( jj <= L-ii/2 ) then -- exclude last ii/2 elements
						if( allMetricsxD(ii)(2*jj) > allMetricsxD(ii)(2*jj+1) ) then
							allMetricsxD(ii+1)(2*jj) <= allMetricsxD(ii)(2*jj+1);
							allMetricsxD(ii+1)(2*jj+1) <= allMetricsxD(ii)(2*jj);
							allIndicesxD(ii+1)(2*jj) <= allIndicesxD(ii)(2*jj+1);
							allIndicesxD(ii+1)(2*jj+1) <= allIndicesxD(ii)(2*jj);
							allOutvalsxD(ii+1)(2*jj) <= allOutvalsxD(ii)(2*jj+1);
							allOutvalsxD(ii+1)(2*jj+1) <= allOutvalsxD(ii)(2*jj);
						end if;
					end if;
				else
					if( jj < L-1-ii/2 ) then -- exclude last 1+ii/2 elements
						if( allMetricsxD(ii)(2*jj+1) > allMetricsxD(ii)(2*jj+2)) then
							allMetricsxD(ii+1)(2*jj+1) <= allMetricsxD(ii)(2*jj+2);
							allMetricsxD(ii+1)(2*jj+2) <= allMetricsxD(ii)(2*jj+1);
							allIndicesxD(ii+1)(2*jj+1) <= allIndicesxD(ii)(2*jj+2);
							allIndicesxD(ii+1)(2*jj+2) <= allIndicesxD(ii)(2*jj+1);
							allOutvalsxD(ii+1)(2*jj+1) <= allOutvalsxD(ii)(2*jj+2);
							allOutvalsxD(ii+1)(2*jj+2) <= allOutvalsxD(ii)(2*jj+1);
						end if;
					end if;
				end if;
			end loop;
		end loop;

	end process;

	-- Get output from last stage
	assignOutput_memless: process(allMetricsxD,allIndicesxD,allOutvalsxD)
	begin
		for ii in 0 to L-1 loop
			MinxDO(ii) <= allMetricsxD(SorterStages)(ii);
			IndxDO(ii) <= allIndicesxD(SorterStages)(ii);
			outvalFxDO(ii) <= allOutvalsxD(SorterStages)(ii);
		end loop;
	end process;

	
end;
