library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
library work;
use work.polar_config.all;

entity radix2LSorter is
port(
	DataInxDI		: in Metric_2L;
	outvalFxDI	: in std_logic_vector(0 to 2*L-1);
	MinxDO 			: out Metric_L;
	outvalFxDO	: out std_logic_vector(0 to L-1);
	IndxDO			: out Sel_L
);
end;

architecture arch of radix2LSorter is

	-- One hot encoding for each minimum
	signal minOneHotxD		: OneHot_L;
	-- Matrix holding comparator results
	signal compxD			: Comp_2L;

begin

	-- Compare all inputs with all inputs
	comp_all_memless: process(DataInxDI)
	begin

		-- Default assignment
		compxD <= (others=>(others=>'0'));
		for ii in 0 to 2*L-1 loop
			for jj in ii+1 to 2*L-1 loop
				if( DataInxDI(ii) <= DataInxDI(jj) ) then
					compxD(ii)(jj) <= '1';
					compxD(jj)(ii) <= '0';
				else
					compxD(ii)(jj) <= '0';
					compxD(jj)(ii) <= '1';
				end if;
			end loop;
		end loop;
	
	end process;

	find_min_memless: process(DataInxDI, minOneHotxD, compxD)

		variable tempComp		: std_logic;
		variable maskVec, extMaskVec	: std_logic_vector(0 to 2*L-1) := (others=>'0');
		variable tempBit, tempBit2	: std_logic;

	begin

		-- Default assignments
		minOneHotxD <= (others=>(others=>'0'));

		for jj in 0 to L-1 loop
			-- First minimum
			if( jj = 0 ) then
				for ii in 0 to 2*L-1 loop
					tempComp := '1';
					for kk in 0 to 2*L-1 loop
						if( kk /= ii ) then
							tempComp := tempComp and compxD(ii)(kk);
						end if;
					end loop;
					minOneHotxD(jj)(ii) <= tempComp;
				end loop;
			-- Rest of minima
			else
				-- Prepare internal masks
				for ii in 0 to 2*L-1 loop
					maskVec(ii) := '0';
					for kk in 0 to jj-1 loop
						maskVec(ii) := maskVec(ii) or minOneHotxD(kk)(ii);
					end loop;
				end loop;
				-- Prepare external mask
				for ii in 0 to 2*L-1 loop
					extMaskVec(ii) := '1';
					for kk in 0 to jj-1 loop
						extMaskVec(ii) := extMaskVec(ii) and (not minOneHotxD(kk)(ii));
					end loop;
				end loop;
				-- Get one hot encoding
				for ii in 0 to 2*L-1 loop
					tempComp := '1';
					for kk in 0 to 2*L-1 loop
						if( kk /= ii ) then
							tempComp := tempComp and (compxD(ii)(kk) or maskVec(kk));
						end if;
					end loop;
					tempComp := tempComp and extMaskVec(ii);
					minOneHotxD(jj)(ii) <= tempComp;
				end loop;
			end if;
		end loop;

		-- Create Min outputs
		for jj in 0 to L-1 loop
			for ii in 0 to MP-1 loop
				tempBit := '0';
				for kk in 0 to 2*L-1 loop	
					tempBit := tempBit or (DataInxDI(kk)(ii) and minOneHotxD(jj)(kk));
				end loop;
				MinxDO(jj)(ii) <= tempBit;
			end loop;
		end loop;

		-- Create index outputs
		for ii in 0 to L-1 loop
			for kk in 0 to 2*L-1 loop
				if( minOneHotxD(ii)(kk) = '1' ) then
					outvalFxDO(ii) <= outvalFxDI(kk);
				end if;
			end loop;
		end loop;

		-- Default assignment
		IndxDO <= (others=>0);
		-- Create index outputs
		for ii in 0 to L-1 loop
			for kk in 0 to L-1 loop
				if( (minOneHotxD(ii)(2*kk) or minOneHotxD(ii)(2*kk+1)) = '1' ) then
					IndxDO(ii) <= kk;
				end if;
			end loop;
		end loop;

	end process;

end;
