library ieee;
use ieee.std_logic_1164.all;
library work;

package polar_config is

	-- Decoder parameters
	-- List size
	constant L : integer := 4;    
	constant LOG_L : integer := 2;  

	-- Fixed pint bit-widths
	-- Metric
	constant MP : integer := 8;

	-- Pointer memory types
	type Sel_L is array(0 to L-1) of integer range 0 to L-1;
	type Sel_2L is array(0 to 2*L-1) of integer range 0 to 2*L-1;

	-- Metrics
	subtype Metric is std_logic_vector(MP-1 downto 0);
	type Metric_L is array(0 to L-1) of Metric;
	type Metric_2L is array(0 to 2*L-1) of Metric;

	-- Sorter types
	constant SorterStages : integer := (LOG_L+2)*(LOG_L+1)/2;
	subtype StageCounter is integer range 0 to SorterStages;
	type MetricStage_2L is array (0 to SorterStages) of Metric_2L;
	type IndexStage_2L is array (0 to SorterStages) of Sel_2L;
	type OutvalStage_2L is array (0 to SorterStages) of std_logic_vector(0 to 2*L-1);
	type StageCount is array (0 to SorterStages-1) of integer range 0 to SorterStages;

end package;

package body polar_config is
end package body;
