library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_misc.all;
library work;
use work.polar_config.all;
use work.helper_functions.all;

entity bitonicSorterPruned is
port(
	DataInxDI			: in Metric_2L;
	InvalsxDI			: in std_logic_vector(0 to 2*L-1);
	MinxDO 				: out Metric_L;
	outvalFxDO		: out std_logic_vector(0 to L-1);
	IndxDO				: out Sel_L
);
end;

architecture arch of bitonicSorterPruned is

	signal allMetricsxD				: MetricStage_2L;
	signal allIndicesxD				: IndexStage_2L;
	signal allOutvalsxD				: OutvalStage_2L;

begin

	-- Perform bitonic sort
	bitonicSort_memless: process(DataInxDI,InvalsxDI,allMetricsxD,allIndicesxD,allOutvalsxD)
	begin

		-- Assign input to stage 0
		for ii in 0 to 2*L-1 loop
			allMetricsxD(0)(ii) <= DataInxDI(ii);
		end loop;

		for ii in 0 to L-1 loop
			allIndicesxD(0)(2*ii) <= ii;
			allIndicesxD(0)(2*ii+1) <= ii;
			allOutvalsxD(0)(2*ii) <= InvalsxDI(2*ii);
			allOutvalsxD(0)(2*ii+1) <= InvalsxDI(2*ii+1);
		end loop;

		-- Sorting network
		for ii in 1 to (LOG_L+1)-1 loop
			for jj in 0 to ii loop
				-- First sorter substage within each stage has special structure
				if( jj = 0 ) then
					for kk in 0 to L/(2**ii)-1 loop
						for ll in 0 to 2**ii-1 loop
							-- Swap inputs or not, based on comparison
							if( kk*2**(ii+1)+ll /= 0 and (kk+1)*2**(ii+1) - (ll+1) /= 2*L-1 ) then
								if( allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll) > allMetricsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1)) ) then
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
								else
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
								end if;
							else
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii+1)+ll) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii+1)+ll);
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)((kk+1)*2**(ii+1) - (ll+1)) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)((kk+1)*2**(ii+1) - (ll+1));
							end if;
						end loop;
					end loop;
				-- Remaining sorters have similar structure
				else
					for kk in 0 to L/2**(ii-jj)-1 loop
						for ll in 0 to 2**(ii-jj)-1 loop
							-- Swap inputs or not, based on comparison
							if( kk*2**(ii-jj+1)+ll /= 0 and kk*2**(ii-jj+1)+ll+2**(ii-jj) /= 2*L-1 and ( ii < LOG_L or (kk*2**(ii-jj+1)+ll < L and kk*2**(ii-jj+1)+ll+2**(ii-jj) < L )) ) then
								if( allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll) > allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) ) then
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
								else
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
									allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
									allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
									allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
								end if;
							else 
								allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
								allMetricsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allMetricsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
								allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
								allIndicesxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allIndicesxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
								allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll);
								allOutvalsxD(GETSTAGECOUNT(ii)+jj+1)(kk*2**(ii-jj+1)+ll+2**(ii-jj)) <= allOutvalsxD(GETSTAGECOUNT(ii)+jj)(kk*2**(ii-jj+1)+ll+2**(ii-jj));
							end if;
						end loop;
					end loop;
				end if;
			end loop;
		end loop;
	end process;

	-- Get output from last stage
	assignOutput_memless: process(allMetricsxD,allIndicesxD,allOutvalsxD)
	begin
		for ii in 0 to L-1 loop
			MinxDO(ii) <= allMetricsxD(SorterStages)(ii);
			IndxDO(ii) <= allIndicesxD(SorterStages)(ii);
			outvalFxDO(ii) <= allOutvalsxD(SorterStages)(ii);
		end loop;
	end process;

end;
