

Evangelos Alexiou
evangelos.alexiou@epfl.ch


Below are described different versions of the *amphoriskos* model that are provided for reproducibility and verification reasons.

- The *processed* version is obtained after Poisson surface reconstruction that is applied on the original model [1], as implemented in CloudCompare with default configurations and 1 samples per node using the default normal vectors. From the reconstructed mesh, 1x10^6 points was randomly sampled using the same software.
- The *reference* version is used in [2], and is obtained after voxelization applied on the *processed* point cloud using our script (i.e., fun_voxelize) with voxel depth equal to 10. The PLY output file was converted to PCD using PCL [3].


## References

[1] M. Bystricky, "Amphoriskos - Clean Point Cloud", 2019, Sketchfab, https://sketchfab.com/3d-models/amphoriskos-clean-point-cloud-85cba491e0a84ce58dc4a75715073ad2

[2] Alexiou, E., Viola, I., Borges, T., Fonseca, T., De Queiroz, R., & Ebrahimi, T. (2019). A comprehensive study of the rate-distortion performance in MPEG point cloud compression. APSIPA Transactions on Signal and Information Processing, 8, E27. doi:10.1017/ATSIP.2019.20

[3] R. B. Rusu and S. Cousins, "3D is here: Point Cloud Library (PCL)," 2011 IEEE International Conference on Robotics and Automation, Shanghai, 2011, pp. 1-4. doi: 10.1109/ICRA.2011.5980567
