

Evangelos Alexiou
evangelos.alexiou@epfl.ch


# M-PCCD: MPEG Point Cloud Compression Dataset


The emerging MPEG point cloud codecs (V-PCC and G-PCC variants) are assessed, and best practices for rate allocation are investigated [1]. For this purpose, three experiments are conducted. In the first experiment, a rigorous evaluation of the codecs is performed, adopting test conditions dictated by experts of the group on a carefully selected set of models, using both subjective and objective quality assessment methodologies. In the other two experiments, different rate allocation schemes for geometry-only and geometry-plus-color encoding are subjectively evaluated, in order to draw conclusions on the best-performing approaches in terms of perceived quality for a given bit rate.

In this [webpage](https://www.epfl.ch/labs/mmspg/downloads/quality-assessment-for-point-cloud-compression/), we make publicly available quality scores associated with the stimuli under assessment for each experiment. For purposes of reproducibility, a content that is used while not being part of established point cloud repositories adopted by standardisation bodies, is re-distributed. Moreover, scripts are provided in order to generate the reference models and the rendering-related meta-data that are used in this study.


## Download

In the provided [URL link](https://www.epfl.ch/labs/mmspg/wp-content/uploads/2020/06/M-PCCD.zip) you can find the material under folders that follow corresponding naming convention. Specifically:

- In folder *contents*, you will find the re-distributed model amphoriskos, as prepared for our study, along with a README file with instructions on where to find and how to prepare the reference versions of the rest of the contents.
- In folder *scores*, you will find subjective and objective scores from the first experiment, and subjective votes from the second and the third experiments.
- In folder *scripts*, you will find the MATLAB functions that are used for voxelization (i.e., fun_voxelize), and computation of the size of each point per stimulus (i.e., fun_pointsize). The former script is used to prepare the reference models of the study (where needed), while the latter script is used to produce meta-data per stimulus that are required by our renderer.

The **Point cloud web renderer** that was developed and used for subjective and objective quality evaluation, can be downloaded from the following [GitHub repository](https://github.com/mmspg/point-cloud-web-renderer).

For more details, the reader can refer to [1].


## Conditions of use

If you wish to use any of the provided material in your research, we kindly ask you to cite [1].


## References

[1] Alexiou, E., Viola, I., Borges, T., Fonseca, T., De Queiroz, R., & Ebrahimi, T. (2019). A comprehensive study of the rate-distortion performance in MPEG point cloud compression. APSIPA Transactions on Signal and Information Processing, 8, E27. doi: 10.1017/ATSIP.2019.20
