"""This file contains all functions used in spectral approach."""

import numpy as np

def Fourierdx(u,q):
	"""Purpose: Compute q'th derivative of u using a Fourier spectral approach"""

	N = len(u)
	uhat = np.fft.fft(u)
	nvec = (1.0j*np.concatenate((np.arange(0.5*(N-1)+1),np.arange(-0.5*(N-1),0))))**q
	dudx = np.real(  np.fft.ifft(nvec*uhat) )
	return dudx

def FourierVanishHypVisc(u,s,k,N,L):
	"""Purpose: Apply vanishing viscosity as a filter"""

	# Set parameters in vanishing viscosity model
	theta = 0.9*(2.0*s-1.0)/(2.0*s)
	mN = int(np.floor((L/(2.0*np.pi)*N)**theta))
	C = 0.5*(2.0*np.pi/L)**(2.0*s)

	# Define vanishing viscosity by a filter function
	qhat = np.zeros(N+1)
	qhat[mN:N+1] = 1- (mN/np.arange(mN,N+1).astype(float))**((2.0*s-1.0)/theta)
	sigma = np.exp(-C*N*k*(np.arange(N+1).astype(float)/N)**(2.0*s)*qhat)
	nvec = np.concatenate((sigma, np.flipud(sigma[1:])))

	Fu = np.real( np.fft.ifft(nvec*np.fft.fft(u)) )
	return Fu



