"""Driver script for solving the 1D Maxwell equations using a ENO scheme"""

import numpy as np
import matplotlib.pyplot as plt
from MaxwellEno import *
from MaxwellIC import CavityExact
from Legendre import LegendreGQ

# Order of the method
m = 2

# Set problem parameters
L = 2.0
CFL = 0.9
FinalTime = np.pi/2
N = 256
h = L/N

epl = 1.0
mul = 1.0
epr = 2.25
mur = 1.0

# Define domain, materials and initial conditions
x = np.linspace(-1.0,1.0,N+1)
NGQ = 16
xGQ, wGQ = LegendreGQ(NGQ)

EM = np.zeros((2,N+1))

for i in range(NGQ+1):
	EMh, ep, mu = CavityExact(x+xGQ[i]*h/2,epl,epr,mul,mur,0.0)
	EM += wGQ[i]*EMh

EM /= 2

# Solve Problem
EM = MaxwellENO1D(x,EM,ep,mu,h,m,CFL,FinalTime)

# Plot
plt.plot(x,EM[0,:])
plt.title("Solution E at time {}".format(FinalTime))
plt.show()