"""Driver script for solving the 1D linear wave equation using a monotone scheme"""

import numpy as np
import matplotlib.pyplot as plt
from LinwaveIC import *
from LinwaveMonotone import *

# Set problem parameters
L = 2.0
CFL = 0.9
FinalTime = 4.0
N = 2048
h = L/N

# Define domain and initial conditions
x = np.linspace(-1.0, 1.0, N+1)
u = wavetest(x,0.5,-0.7,0.005,10,np.log(2)/(36*0.005**2))

# Solve problem
u = LinwaveM1D(x,u,h,CFL,FinalTime)

# Plot
plt.plot(x,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()