"""Driver script for solving the 2D KPP equation using a monotone scheme"""

import numpy as np
import matplotlib.pyplot as plt
from KPPWeno import *

# Order of the method 
m = 2

# Set problem parameters
CFL = 0.9
FinalTime = 1.0
Nx = 99
Ny = 99
hx = 4.0/Nx
hy = 4.0/Ny

# Define domain and initial conditions
_x = np.linspace(-2.0,2.0,Nx+1)
_y = np.linspace(-2.5,1.5,Ny+1)
x,y = np.meshgrid(_x,_y)
u = np.pi/4 + 13*np.pi/4*(np.sqrt(x**2+y**2)<=1.0);

# Solve problem
u = KPPWENO2D(x,y,u,hx,hy,m,CFL,FinalTime)

# Plot
plt.contour(x,y,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()