"""
This file contains all the basic implementations of functions to compute
quantities for the specific case of the KPP equations.
"""

import numpy as np

## 2D ##
###################################################################################
def KPPFlux2Dx(u):
    """Purpose: Evaluate x-component of flux for 2D KPP"""

    return np.sin(u)

def KPPFlux2Dy(u):
    """Purpose: Evaluate y-component of flux for 2D KPP"""

    return np.cos(u)

def KPPJac2Dx(u):
    """Purpose: Evaluate x-component of flux for Jacobian 2D KPP"""

    return np.cos(u)


def KPPJac2Dy(u):
    """Purpose: Evaluate y-component of flux for Jacobian 2D KPP"""

    return -np.sin(u)

def KPPxLF(u,v,maxvel):
    """Purpose: Evaluate Lax Friedrich numerical flux for x component of KPP equation"""
    fu = np.sin(u)
    fv = np.sin(v)

    flux = 0.5*(fu+fv) - 0.5*maxvel*(v-u)
    return flux

def KPPyLF(u,v,maxvel):
    """Purpose: Evaluate Lax Friedrich numerical flux for x component of KPP equation"""
    fu = np.cos(u)
    fv = np.cos(v)

    flux = 0.5*(fu+fv) - 0.5*maxvel*(v-u)
    return flux