"""Driver script for solving the 2D Euler equations using a WENO scheme"""

import numpy as np
import matplotlib.pyplot as plt
from EulerWeno import *
from EulerIC import *
from Legendre import LegendreGQ

# Order of the method
m = 2

# Set general problem parameters
CFL = 0.5
gamma = 1.4

# Set parameters for isentropic vortex
# Lx = 10.0
# Ly = 10.0
# Nx = 64
# Ny = 64
# hx = Lx/Nx
# hy = Ly/Ny
# FinalTime = 1.0
# Set up Legendre quadrature grid for cell average
# NGQ = 10
# xGQ,wGQ = LegendreGQ(NGQ)
# xQ1 = 0.5*hx*xGQ
# yQ1 = 0.5*hy*xGQ
# xQ,yQ = np.meshgrid(xQ1,yQ1)
# Define domain and initial conditions
# xv = np.linspace(-5.0,5.0,Nx+1)
# yv = np.linspace(-5.0,5.0,Ny+1)
# x,y = np.meshgrid(xv,yv)
# q = np.zeros((4,Ny+1,Nx+1))
# x0 = 0.0
# y0 = 0.0
# u0 = 1.0
# v0 = 0.0
# beta = 5.0
# for j in range(Nx+1):
# 	for i in range(Ny+1):
# 		xL = xQ + xv[j]
# 		yL = yQ + yv[i]
# 		qL = IsentropicVortex2D(xL,x0,u0,yL,y0,v0,gamma,beta,0.0)
# 		q[0,i,j] = 0.25*np.dot( wGQ, np.dot(qL[0,:,:], wGQ) )
# 		q[1,i,j] = 0.25*np.dot( wGQ, np.dot(qL[1,:,:], wGQ) )
# 		q[2,i,j] = 0.25*np.dot( wGQ, np.dot(qL[2,:,:], wGQ) )
# 		q[3,i,j] = 0.25*np.dot( wGQ, np.dot(qL[3,:,:], wGQ) )

# Define domain and initial conditions for 2D Riemann problem
Lx = 1.0
Ly = 1.0
Nx = 49
Ny = 49
hx = Lx/Nx
hy = Ly/Ny
RiemannProbCase = 4

xv = np.linspace(0.0,1.0,Nx+1)
yv = np.linspace(0.0,1.0,Ny+1)
x,y = np.meshgrid(xv,yv)
q,FinalTime = Riemann2D(x,y,gamma,RiemannProbCase)

# Solve problem
q = EulerWENO2D(x,y,q,hx,hy,m,gamma,CFL,FinalTime)

# Plot
plt.contour(x,y,q[0,:,:])
plt.title("Solution rho at time {}".format(FinalTime))
plt.show()

